/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.MultiCharQuoteHandler;
import com.intellij.codeInsight.editorActions.TypedHandler;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlFromClause;
import com.intellij.sql.psi.SqlInsertStatement;
import com.intellij.sql.psi.SqlJoinConditionClause;
import com.intellij.sql.psi.SqlJoinExpression;
import com.intellij.sql.psi.SqlReferenceList;
import com.intellij.sql.psi.SqlTableColumnsList;
import com.intellij.sql.psi.SqlWhereClause;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlTypedHandler
extends TypedHandlerDelegate {
    @NotNull
    public TypedHandlerDelegate.Result checkAutoPopup(char c2, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            SqlTypedHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            SqlTypedHandler.$$$reportNull$$$0(1);
        }
        if (file == null) {
            SqlTypedHandler.$$$reportNull$$$0(2);
        }
        if (!(file instanceof SqlFile)) {
            TypedHandlerDelegate.Result result2 = super.checkAutoPopup(c2, project, editor, file);
            if (result2 == null) {
                SqlTypedHandler.$$$reportNull$$$0(3);
            }
            return result2;
        }
        if (c2 == ' ' || c2 == '(') {
            PsiElement at;
            int offset = editor.getCaretModel().getOffset();
            PsiElement psiElement = at = offset > 0 ? file.findElementAt(offset - 1) : null;
            if (SqlTypedHandler.goodFor(at, c2)) {
                AutoPopupController.getInstance((Project)project).autoPopupMemberLookup(editor, null);
                TypedHandlerDelegate.Result result3 = TypedHandlerDelegate.Result.STOP;
                if (result3 == null) {
                    SqlTypedHandler.$$$reportNull$$$0(4);
                }
                return result3;
            }
        }
        TypedHandlerDelegate.Result result4 = super.checkAutoPopup(c2, project, editor, file);
        if (result4 == null) {
            SqlTypedHandler.$$$reportNull$$$0(5);
        }
        return result4;
    }

    @NotNull
    public TypedHandlerDelegate.Result charTyped(char c2, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        char cPrev;
        if (project == null) {
            SqlTypedHandler.$$$reportNull$$$0(6);
        }
        if (editor == null) {
            SqlTypedHandler.$$$reportNull$$$0(7);
        }
        if (file == null) {
            SqlTypedHandler.$$$reportNull$$$0(8);
        }
        if (!(file instanceof SqlFile)) {
            TypedHandlerDelegate.Result result2 = TypedHandlerDelegate.Result.CONTINUE;
            if (result2 == null) {
                SqlTypedHandler.$$$reportNull$$$0(9);
            }
            return result2;
        }
        CodeInsightSettings settings = CodeInsightSettings.getInstance();
        int offset = editor.getCaretModel().getOffset();
        char c3 = cPrev = offset >= 2 ? editor.getDocument().getCharsSequence().charAt(offset - 2) : (char)'\u0000';
        if (c2 == '\'' || c2 == '\"' || c2 == '`') {
            TypedHandlerDelegate.Result result3 = TypedHandlerDelegate.Result.CONTINUE;
            if (result3 == null) {
                SqlTypedHandler.$$$reportNull$$$0(10);
            }
            return result3;
        }
        if ((c2 == '$' || cPrev == '\'') && settings.AUTOINSERT_PAIR_QUOTE) {
            TypedHandlerDelegate.Result result4 = SqlTypedHandler.handleCustomQuote(offset, editor, file);
            if (result4 == null) {
                SqlTypedHandler.$$$reportNull$$$0(11);
            }
            return result4;
        }
        if (c2 == '(') {
            TypedHandlerDelegate.Result result5 = TypedHandlerDelegate.Result.STOP;
            if (result5 == null) {
                SqlTypedHandler.$$$reportNull$$$0(12);
            }
            return result5;
        }
        TypedHandlerDelegate.Result result6 = TypedHandlerDelegate.Result.CONTINUE;
        if (result6 == null) {
            SqlTypedHandler.$$$reportNull$$$0(13);
        }
        return result6;
    }

    private static TypedHandlerDelegate.Result handleCustomQuote(int offset, @NotNull Editor editor, @NotNull PsiFile file) {
        MultiCharQuoteHandler quoteHandler;
        if (editor == null) {
            SqlTypedHandler.$$$reportNull$$$0(14);
        }
        if (file == null) {
            SqlTypedHandler.$$$reportNull$$$0(15);
        }
        if ((quoteHandler = (MultiCharQuoteHandler)ObjectUtils.tryCast((Object)TypedHandler.getQuoteHandler((PsiFile)file, (Editor)editor), MultiCharQuoteHandler.class)) == null) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        EditorHighlighter highlighter = ((EditorEx)editor).getHighlighter();
        CharSequence closingQuote = quoteHandler.getClosingQuote(highlighter.createIterator(offset), offset);
        if (closingQuote == null) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        if (!quoteHandler.hasNonClosedLiteral(editor, highlighter.createIterator(offset - 1), offset - 1)) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        Document document = editor.getDocument();
        if (offset == document.getTextLength() || !Character.isUnicodeIdentifierPart(document.getCharsSequence().charAt(offset))) {
            document.insertString(offset, closingQuote);
            return TypedHandlerDelegate.Result.STOP;
        }
        return TypedHandlerDelegate.Result.CONTINUE;
    }

    @NotNull
    public TypedHandlerDelegate.Result beforeCharTyped(char c2, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file, @NotNull FileType fileType) {
        if (project == null) {
            SqlTypedHandler.$$$reportNull$$$0(16);
        }
        if (editor == null) {
            SqlTypedHandler.$$$reportNull$$$0(17);
        }
        if (file == null) {
            SqlTypedHandler.$$$reportNull$$$0(18);
        }
        if (fileType == null) {
            SqlTypedHandler.$$$reportNull$$$0(19);
        }
        if (!(file instanceof SqlFile)) {
            TypedHandlerDelegate.Result result2 = super.beforeCharTyped(c2, project, editor, file, fileType);
            if (result2 == null) {
                SqlTypedHandler.$$$reportNull$$$0(20);
            }
            return result2;
        }
        if (c2 == ']') {
            SqlLanguageDialectEx dialect = SqlImplUtil.getSqlDialectSafe((PsiElement)file);
            boolean transactFamily = dialect.getDbms().isTransactSql();
            int offset = editor.getCaretModel().getOffset();
            String text2 = editor.getDocument().getText();
            if (transactFamily && offset < text2.length() && c2 == text2.charAt(offset)) {
                EditorModificationUtil.moveCaretRelatively((Editor)editor, (int)1);
                TypedHandlerDelegate.Result result3 = TypedHandlerDelegate.Result.STOP;
                if (result3 == null) {
                    SqlTypedHandler.$$$reportNull$$$0(21);
                }
                return result3;
            }
        }
        TypedHandlerDelegate.Result result4 = super.beforeCharTyped(c2, project, editor, file, fileType);
        if (result4 == null) {
            SqlTypedHandler.$$$reportNull$$$0(22);
        }
        return result4;
    }

    private static boolean goodFor(@Nullable PsiElement element2, char c2) {
        PsiElement prev;
        if (!(element2 instanceof LeafPsiElement)) {
            return false;
        }
        IElementType type = ((LeafPsiElement)element2).getElementType();
        PsiElement parent2 = element2.getParent();
        if (c2 == ' ') {
            if (type == SqlCommonKeywords.SQL_WHERE && parent2 instanceof SqlWhereClause) {
                return true;
            }
            if (type == SqlCommonKeywords.SQL_FROM && parent2 instanceof SqlFromClause) {
                return true;
            }
            if (type == SqlCommonKeywords.SQL_ON && parent2 instanceof SqlJoinConditionClause) {
                return true;
            }
            if (type == SqlCommonKeywords.SQL_JOIN && parent2 instanceof SqlJoinExpression) {
                return true;
            }
        }
        return c2 == '(' && PsiTreeUtil.getParentOfType((PsiElement)(prev = PsiTreeUtil.prevVisibleLeaf((PsiElement)element2)), SqlTableColumnsList.class) != null && PsiTreeUtil.getParentOfType((PsiElement)prev, SqlInsertStatement.class) != null && PsiTreeUtil.getParentOfType((PsiElement)prev, SqlReferenceList.class) == null && PsiTreeUtil.getParentOfType((PsiElement)element2, SqlReferenceList.class) == null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 20: 
            case 21: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 20: 
            case 21: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 7: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 8: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 20: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/SqlTypedHandler";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/SqlTypedHandler";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "checkAutoPopup";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "charTyped";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "beforeCharTyped";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkAutoPopup";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 20: 
            case 21: 
            case 22: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "charTyped";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "handleCustomQuote";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "beforeCharTyped";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 20: 
            case 21: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

