/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.ui;

import com.intellij.codeInsight.folding.impl.actions.ExpandAllToLevel1Action;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DbUIUtil;
import com.intellij.database.util.SearchPath;
import com.intellij.database.view.DatabaseDialogsHelper;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.editor.ex.FoldingListener;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.HideableDecorator;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlPreviewPanel
extends JPanel {
    private final EditorTextField myPreviewEditor;
    private final EventDispatcher<OpenInConsoleListener> myDispatcher;
    private final HideableDecorator myDecorator;

    private SqlPreviewPanel(@NotNull Project project, @NotNull DbDataSource dataSource, @Nullable SearchPath searchPath, @NotNull String query, @NotNull String propertyKey, boolean isViewer) {
        if (project == null) {
            SqlPreviewPanel.$$$reportNull$$$0(0);
        }
        if (dataSource == null) {
            SqlPreviewPanel.$$$reportNull$$$0(1);
        }
        if (query == null) {
            SqlPreviewPanel.$$$reportNull$$$0(2);
        }
        if (propertyKey == null) {
            SqlPreviewPanel.$$$reportNull$$$0(3);
        }
        super(new BorderLayout());
        this.myDispatcher = EventDispatcher.create(OpenInConsoleListener.class);
        this.myPreviewEditor = DatabaseDialogsHelper.createLanguageEditorArea(project, dataSource, searchPath, query, isViewer);
        final String expansionProperty = propertyKey + ".previewExpanded";
        boolean isExpanded = PropertiesComponent.getInstance().getBoolean(expansionProperty, true);
        JComponent open = DbUIUtil.createToolbar(new DefaultActionGroup(this.createActions(dataSource)));
        ((ActionToolbarImpl)open).setMiniMode(true);
        this.myDecorator = new HideableDecorator(this, "S&QL Preview", true, open){

            protected void on() {
                super.on();
                this.storeState();
            }

            protected void off() {
                super.off();
                this.storeState();
            }

            private void storeState() {
                PropertiesComponent.getInstance().setValue(expansionProperty, this.isExpanded());
            }
        };
        this.myDecorator.setContentComponent((JComponent)this.myPreviewEditor);
        this.myDecorator.setOn(isExpanded);
    }

    public SqlPreviewPanel(@NotNull Project project, @NotNull DbDataSource dataSource, @Nullable SearchPath searchPath, @NotNull String query, @NotNull String propertyKey, boolean isViewer, final @NotNull Runnable closeDialog) {
        if (project == null) {
            SqlPreviewPanel.$$$reportNull$$$0(4);
        }
        if (dataSource == null) {
            SqlPreviewPanel.$$$reportNull$$$0(5);
        }
        if (query == null) {
            SqlPreviewPanel.$$$reportNull$$$0(6);
        }
        if (propertyKey == null) {
            SqlPreviewPanel.$$$reportNull$$$0(7);
        }
        if (closeDialog == null) {
            SqlPreviewPanel.$$$reportNull$$$0(8);
        }
        this(project, dataSource, searchPath, query, propertyKey, isViewer);
        this.subscribeOpenInConsole(new OpenInConsoleListener(){

            @Override
            public void open() {
                closeDialog.run();
            }
        });
    }

    public void subscribeOpenInConsole(@NotNull OpenInConsoleListener listener) {
        if (listener == null) {
            SqlPreviewPanel.$$$reportNull$$$0(9);
        }
        this.myDispatcher.addListener((EventListener)listener);
    }

    public void setTitle(@NotNull String title) {
        if (title == null) {
            SqlPreviewPanel.$$$reportNull$$$0(10);
        }
        this.myDecorator.setTitle(title);
    }

    @NotNull
    public List<AnAction> createActions(final @NotNull DbDataSource delegate) {
        if (delegate == null) {
            SqlPreviewPanel.$$$reportNull$$$0(11);
        }
        ArrayList arrayList = ContainerUtil.newArrayList((Object[])new AnAction[]{new DumbAwareAction(null, "Open query in console", AllIcons.Actions.MoveTo2){

            public void actionPerformed(@NotNull AnActionEvent e) {
                String query;
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (DbUIUtil.openInConsole(delegate, (DbElement)delegate, query = SqlPreviewPanel.this.getQuery(), true) == null) {
                    DbUIUtil.openInConsole(delegate, (DbElement)delegate, query, false);
                }
                ((OpenInConsoleListener)SqlPreviewPanel.this.myDispatcher.getMulticaster()).open();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/view/ui/SqlPreviewPanel$3", "actionPerformed"));
            }
        }});
        if (arrayList == null) {
            SqlPreviewPanel.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    public String getQuery() {
        return this.myPreviewEditor.getText();
    }

    public void setQuery(@NotNull String query) {
        if (query == null) {
            SqlPreviewPanel.$$$reportNull$$$0(13);
        }
        this.myPreviewEditor.setText(query);
        new UiNotifyConnector.Once((Component)this.myPreviewEditor, new Activatable(){

            public void showNotify() {
                Editor editor = SqlPreviewPanel.this.myPreviewEditor.getEditor();
                if (editor == null) {
                    return;
                }
                ScrollingModel model = editor.getScrollingModel();
                model.disableAnimation();
                model.scrollVertically(0);
                model.enableAnimation();
            }

            public void hideNotify() {
            }
        });
    }

    @NotNull
    public HideableDecorator getHideableDecorator() {
        HideableDecorator hideableDecorator = this.myDecorator;
        if (hideableDecorator == null) {
            SqlPreviewPanel.$$$reportNull$$$0(14);
        }
        return hideableDecorator;
    }

    public void foldToStatements() {
        this.myPreviewEditor.addSettingsProvider(editor -> {
            FoldingModelEx model = editor.getFoldingModel();
            final Disposable disposable = Disposer.newDisposable();
            Disposer.register((Disposable)((EditorImpl)editor).getDisposable(), (Disposable)disposable);
            model.addListener(new FoldingListener(){

                public void onFoldRegionStateChange(@NotNull FoldRegion region) {
                    if (region == null) {
                        5.$$$reportNull$$$0(0);
                    }
                }

                public void onFoldProcessingEnd() {
                    Disposer.dispose((Disposable)disposable);
                    TransactionGuard.getInstance().submitTransactionLater(Disposer.newDisposable(), () -> new ExpandAllToLevel1Action().getHandler().execute((Editor)editor, null, null));
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "region", "com/intellij/database/view/ui/SqlPreviewPanel$5", "onFoldRegionStateChange"));
                }
            }, disposable);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 2: 
            case 6: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "query";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyKey";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closeDialog";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/ui/SqlPreviewPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/ui/SqlPreviewPanel";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getHideableDecorator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "subscribeOpenInConsole";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setTitle";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createActions";
                break;
            }
            case 12: 
            case 14: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setQuery";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface OpenInConsoleListener
    extends EventListener {
        public void open();
    }
}

