/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.editors;

import com.intellij.database.run.ui.grid.editors.BoundaryValueResolver;
import com.intellij.database.run.ui.grid.editors.DateAndTimeFormatterDelegate;
import com.intellij.database.run.ui.grid.editors.Formatter;
import java.text.ParseException;
import java.text.ParsePosition;
import java.time.DateTimeException;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQuery;
import org.jetbrains.annotations.NotNull;

public class DateAndTimeFormatter<T, V extends TemporalAccessor>
implements Formatter {
    private final DateTimeFormatter myFormatter;
    private final String myPattern;
    private final DateAndTimeFormatterDelegate<T, V> myDelegate;
    private final BoundaryValueResolver myBoundaryValuesResolver;

    public DateAndTimeFormatter(@NotNull String pattern, @NotNull DateTimeFormatter formatter, @NotNull DateAndTimeFormatterDelegate<T, V> delegate) {
        if (pattern == null) {
            DateAndTimeFormatter.$$$reportNull$$$0(0);
        }
        if (formatter == null) {
            DateAndTimeFormatter.$$$reportNull$$$0(1);
        }
        if (delegate == null) {
            DateAndTimeFormatter.$$$reportNull$$$0(2);
        }
        this(pattern, formatter, delegate, BoundaryValueResolver.ALWAYS_NULL);
    }

    public DateAndTimeFormatter(@NotNull String pattern, @NotNull DateTimeFormatter formatter, @NotNull DateAndTimeFormatterDelegate<T, V> delegate, @NotNull BoundaryValueResolver resolver) {
        if (pattern == null) {
            DateAndTimeFormatter.$$$reportNull$$$0(3);
        }
        if (formatter == null) {
            DateAndTimeFormatter.$$$reportNull$$$0(4);
        }
        if (delegate == null) {
            DateAndTimeFormatter.$$$reportNull$$$0(5);
        }
        if (resolver == null) {
            DateAndTimeFormatter.$$$reportNull$$$0(6);
        }
        this.myPattern = pattern;
        this.myFormatter = formatter;
        this.myDelegate = delegate;
        this.myBoundaryValuesResolver = resolver;
    }

    @Override
    public Object parse(@NotNull String value) throws ParseException {
        Object boundary;
        if (value == null) {
            DateAndTimeFormatter.$$$reportNull$$$0(7);
        }
        if ((boundary = this.myBoundaryValuesResolver.createFromInfinityString(value)) != null) {
            return boundary;
        }
        try {
            V temporal = this.parseInternal(value, this.myDelegate.getQueries());
            T result2 = this.myDelegate.createFromTemporal(temporal);
            String boundaryString = this.myBoundaryValuesResolver.resolve(result2);
            return boundaryString != null ? this.myBoundaryValuesResolver.createFromInfinityString(boundaryString) : result2;
        }
        catch (DateTimeParseException e) {
            throw new ParseException(value, e.getErrorIndex());
        }
    }

    private V parseInternal(String value, TemporalQuery<V> ... queries) {
        for (TemporalQuery<V> query : queries) {
            try {
                return (V)((TemporalAccessor)this.myFormatter.parse((CharSequence)value, query));
            }
            catch (DateTimeException dateTimeException) {
            }
        }
        throw new DateTimeParseException(value + "can't be parsed", value, 0);
    }

    @Override
    public Object parse(@NotNull String value, @NotNull ParsePosition position) {
        if (value == null) {
            DateAndTimeFormatter.$$$reportNull$$$0(8);
        }
        if (position == null) {
            DateAndTimeFormatter.$$$reportNull$$$0(9);
        }
        try {
            return this.parse(value);
        }
        catch (ParseException e) {
            position.setErrorIndex(e.getErrorOffset());
            return null;
        }
    }

    @Override
    public String format(@NotNull Object value) {
        String boundary;
        if (value == null) {
            DateAndTimeFormatter.$$$reportNull$$$0(10);
        }
        if ((boundary = this.myBoundaryValuesResolver.resolve(value)) != null) {
            return boundary;
        }
        V temporalAccessor = this.myDelegate.toTemporalAccessor(value);
        return this.myFormatter.format((TemporalAccessor)temporalAccessor);
    }

    public TemporalAccessor getTemporalAccessor(@NotNull Object value) {
        if (value == null) {
            DateAndTimeFormatter.$$$reportNull$$$0(11);
        }
        return this.myDelegate.toTemporalAccessor(value);
    }

    public String toString() {
        return this.myPattern;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formatter";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolver";
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/run/ui/grid/editors/DateAndTimeFormatter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "parse";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "format";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "getTemporalAccessor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

