/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.Dbms;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.SelectionModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.JdbcUtil;
import com.intellij.ide.actions.SmartPopupActionGroup;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.awt.datatransfer.DataFlavor;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColumnFiltersGroup
extends ActionGroup
implements DumbAware {
    private static final FilterTemplate[] NULL_FILTER_TEMPLATES = new FilterTemplate[]{new NullFilterTemplate(false), new NullFilterTemplate(true)};
    private static final FilterTemplate[] FILTER_TEMPLATES = new FilterTemplate[]{new FilterTemplate("="), new FilterTemplate("<>"), new FilterTemplate(">"), new FilterTemplate("<"), new LikeFilterTemplate(false), new LikeFilterTemplate(true)};

    public void update(@NotNull AnActionEvent e) {
        DataGrid dataGrid;
        if (e == null) {
            ColumnFiltersGroup.$$$reportNull$$$0(0);
        }
        boolean enabled = (dataGrid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY)) != null && dataGrid.isFilteringSupported();
        e.getPresentation().setEnabledAndVisible(enabled);
    }

    @NotNull
    public AnAction[] getChildren(@Nullable AnActionEvent e) {
        DataGrid dataGrid;
        DataGrid dataGrid2 = dataGrid = e == null ? null : (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY);
        if (dataGrid == null) {
            if (EMPTY_ARRAY == null) {
                ColumnFiltersGroup.$$$reportNull$$$0(1);
            }
            return EMPTY_ARRAY;
        }
        SelectionModel selectionModel = dataGrid.getSelectionModel();
        if (selectionModel.getSelectedColumnCount() != 1 || selectionModel.getSelectedRowCount() != 1) {
            if (EMPTY_ARRAY == null) {
                ColumnFiltersGroup.$$$reportNull$$$0(2);
            }
            return EMPTY_ARRAY;
        }
        GridModel model = dataGrid.getDataModel(DataAccessType.DATABASE_DATA);
        DataConsumer.Row row = (DataConsumer.Row)model.getRow(selectionModel.getSelectedRow());
        DataConsumer.Column column2 = (DataConsumer.Column)model.getColumn(selectionModel.getSelectedColumn());
        if (row == null || column2 == null) {
            if (EMPTY_ARRAY == null) {
                ColumnFiltersGroup.$$$reportNull$$$0(3);
            }
            return EMPTY_ARRAY;
        }
        ArrayList<AnAction> children2 = new ArrayList<AnAction>();
        ColumnFiltersGroup.addActions(children2, dataGrid, row, column2);
        children2.add((AnAction)new Separator());
        ColumnFiltersGroup.addGroupedByOperatorActions(children2, dataGrid, row, column2);
        AnAction[] anActionArray = children2.toArray(AnAction.EMPTY_ARRAY);
        if (anActionArray == null) {
            ColumnFiltersGroup.$$$reportNull$$$0(4);
        }
        return anActionArray;
    }

    private static void addActions(@NotNull List<AnAction> actions, @NotNull DataGrid grid, @NotNull DataConsumer.Row row, @NotNull DataConsumer.Column column2) {
        if (actions == null) {
            ColumnFiltersGroup.$$$reportNull$$$0(5);
        }
        if (grid == null) {
            ColumnFiltersGroup.$$$reportNull$$$0(6);
        }
        if (row == null) {
            ColumnFiltersGroup.$$$reportNull$$$0(7);
        }
        if (column2 == null) {
            ColumnFiltersGroup.$$$reportNull$$$0(8);
        }
        for (FilterTemplate template : NULL_FILTER_TEMPLATES) {
            ContainerUtil.addIfNotNull(actions, (Object)((Object)ColumnFiltersGroup.createFilterAction(template, grid, new GridOperand(grid, row, column2), column2)));
        }
    }

    private static void addGroupedByOperatorActions(@NotNull List<AnAction> result2, @NotNull DataGrid grid, @NotNull DataConsumer.Row row, @NotNull DataConsumer.Column column2) {
        if (result2 == null) {
            ColumnFiltersGroup.$$$reportNull$$$0(9);
        }
        if (grid == null) {
            ColumnFiltersGroup.$$$reportNull$$$0(10);
        }
        if (row == null) {
            ColumnFiltersGroup.$$$reportNull$$$0(11);
        }
        if (column2 == null) {
            ColumnFiltersGroup.$$$reportNull$$$0(12);
        }
        for (FilterTemplate template : FILTER_TEMPLATES) {
            ArrayList actions = new ArrayList();
            ColumnFilterAction placeholderAction = ColumnFiltersGroup.createFilterAction(template, grid, PlaceholderOperand.INSTANCE, column2);
            if (placeholderAction == null) continue;
            GridOperand cellOperand = new GridOperand(grid, row, column2);
            ClipboardOperand clipboardOperand = new ClipboardOperand();
            boolean equalOperands = StringUtil.equals((CharSequence)cellOperand.getValue(), (CharSequence)clipboardOperand.getValue());
            ColumnFilterAction cellAction = ColumnFiltersGroup.createFilterAction(template, grid, cellOperand, column2);
            ColumnFilterAction clipboardAction = equalOperands ? null : ColumnFiltersGroup.createFilterAction(template, grid, clipboardOperand, column2);
            String name2 = StringUtil.escapeMnemonics((String)ColumnFiltersGroup.appendColumnWithOperator(grid, column2, template).getStatement());
            SmartPopupActionGroup group2 = new SmartPopupActionGroup();
            group2.getTemplatePresentation().setText(name2);
            ContainerUtil.addIfNotNull(actions, (Object)((Object)cellAction));
            ContainerUtil.addIfNotNull(actions, (Object)((Object)clipboardAction));
            ContainerUtil.addIfNotNull(actions, (Object)((Object)placeholderAction));
            group2.addAll(actions);
            result2.add((AnAction)group2);
        }
    }

    @NotNull
    private static DdlBuilder appendColumnWithOperator(@NotNull DataGrid grid, @NotNull DataConsumer.Column column2, @NotNull FilterTemplate template) {
        if (grid == null) {
            ColumnFiltersGroup.$$$reportNull$$$0(13);
        }
        if (column2 == null) {
            ColumnFiltersGroup.$$$reportNull$$$0(14);
        }
        if (template == null) {
            ColumnFiltersGroup.$$$reportNull$$$0(15);
        }
        DdlBuilder ddlBuilder = DbImplUtil.createBuilderForUIExec(DataGridUtil.getDatabaseDialect(grid), (DasObject)DataGridUtil.getDatabaseTable(grid)).identifier(column2.name).space().plain(template.getOperator());
        if (ddlBuilder == null) {
            ColumnFiltersGroup.$$$reportNull$$$0(16);
        }
        return ddlBuilder;
    }

    @Nullable
    private static ColumnFilterAction createFilterAction(@NotNull FilterTemplate template, @NotNull DataGrid grid, @NotNull Operand operand, @NotNull DataConsumer.Column column2) {
        PreparedColumnFilterExpression preparedExpression;
        if (template == null) {
            ColumnFiltersGroup.$$$reportNull$$$0(17);
        }
        if (grid == null) {
            ColumnFiltersGroup.$$$reportNull$$$0(18);
        }
        if (operand == null) {
            ColumnFiltersGroup.$$$reportNull$$$0(19);
        }
        if (column2 == null) {
            ColumnFiltersGroup.$$$reportNull$$$0(20);
        }
        return (preparedExpression = template.prepare(grid, column2, operand)) == null ? null : new ColumnFilterAction(preparedExpression);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/actions/ColumnFiltersGroup";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 6: 
            case 10: 
            case 13: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
            case 8: 
            case 12: 
            case 14: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/actions/ColumnFiltersGroup";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "appendColumnWithOperator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 16: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addActions";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addGroupedByOperatorActions";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "appendColumnWithOperator";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createFilterAction";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ColumnFilterAction
    extends DumbAwareAction {
        private final PreparedColumnFilterExpression myPreparedExpression;

        private ColumnFilterAction(@NotNull PreparedColumnFilterExpression expression) {
            if (expression == null) {
                ColumnFilterAction.$$$reportNull$$$0(0);
            }
            super(expression.getPresentableText());
            this.myPreparedExpression = expression;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            DataGrid dataGrid;
            if (e == null) {
                ColumnFilterAction.$$$reportNull$$$0(1);
            }
            if ((dataGrid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY)) == null) {
                return;
            }
            int completionOffset = this.myPreparedExpression.getCompletionOffset();
            dataGrid.setFilterText(this.myPreparedExpression.getText(), completionOffset);
            if (completionOffset == -1) {
                dataGrid.applyFilter();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/run/actions/ColumnFiltersGroup$ColumnFilterAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PreparedColumnFilterExpression {
        private final String myText;
        private final String myPresentableText;
        private final int myCompletionOffset;

        PreparedColumnFilterExpression(@NotNull String fullText2, @NotNull String presentableText, int completionOffset) {
            if (fullText2 == null) {
                PreparedColumnFilterExpression.$$$reportNull$$$0(0);
            }
            if (presentableText == null) {
                PreparedColumnFilterExpression.$$$reportNull$$$0(1);
            }
            this.myText = fullText2;
            this.myPresentableText = presentableText;
            this.myCompletionOffset = completionOffset;
        }

        @NotNull
        public String getText() {
            String string = this.myText;
            if (string == null) {
                PreparedColumnFilterExpression.$$$reportNull$$$0(2);
            }
            return string;
        }

        public int getCompletionOffset() {
            return this.myCompletionOffset;
        }

        @NotNull
        public String getPresentableText() {
            String string = this.myPresentableText;
            if (string == null) {
                PreparedColumnFilterExpression.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fullText";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentableText";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/actions/ColumnFiltersGroup$PreparedColumnFilterExpression";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/actions/ColumnFiltersGroup$PreparedColumnFilterExpression";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentableText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class NullFilterTemplate
    extends FilterTemplate {
        NullFilterTemplate(boolean isNotNull) {
            super("IS" + (isNotNull ? " NOT" : ""));
        }

        @Override
        @Nullable
        protected String getValueLiteral(@NotNull DataGrid grid, @NotNull DataConsumer.Column column2, @Nullable String value) {
            if (grid == null) {
                NullFilterTemplate.$$$reportNull$$$0(0);
            }
            if (column2 == null) {
                NullFilterTemplate.$$$reportNull$$$0(1);
            }
            return "NULL";
        }

        @Override
        protected boolean isAvailableFor(@NotNull Operand operand, @NotNull DataConsumer.Column column2) {
            if (operand == null) {
                NullFilterTemplate.$$$reportNull$$$0(2);
            }
            if (column2 == null) {
                NullFilterTemplate.$$$reportNull$$$0(3);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "grid";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "column";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "operand";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/run/actions/ColumnFiltersGroup$NullFilterTemplate";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getValueLiteral";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isAvailableFor";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class LikeFilterTemplate
    extends FilterTemplate {
        LikeFilterTemplate(boolean isNotLike) {
            super((isNotLike ? "NOT " : "") + "LIKE", "'%", "%'");
        }

        @Override
        @Nullable
        protected String getValueLiteral(@NotNull DataGrid grid, @NotNull DataConsumer.Column column2, @Nullable String value) {
            if (grid == null) {
                LikeFilterTemplate.$$$reportNull$$$0(0);
            }
            if (column2 == null) {
                LikeFilterTemplate.$$$reportNull$$$0(1);
            }
            if (value == null) {
                return null;
            }
            return DbSqlUtil.toStringLiteral(value, DataGridUtil.getDbms(grid), true, "%", "%");
        }

        @Override
        protected boolean isAvailableFor(@NotNull Operand operand, @NotNull DataConsumer.Column column2) {
            if (operand == null) {
                LikeFilterTemplate.$$$reportNull$$$0(2);
            }
            if (column2 == null) {
                LikeFilterTemplate.$$$reportNull$$$0(3);
            }
            return super.isAvailableFor(operand, column2) && JdbcUtil.isStringType((int)column2.type);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "grid";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "column";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "operand";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/run/actions/ColumnFiltersGroup$LikeFilterTemplate";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getValueLiteral";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isAvailableFor";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class FilterTemplate {
        private final String myOperator;
        private final String myEmptyValuePrefix;
        private final String myEmptyValueSuffix;

        FilterTemplate(@NotNull String operator) {
            if (operator == null) {
                FilterTemplate.$$$reportNull$$$0(0);
            }
            this(operator, "", "");
        }

        FilterTemplate(@NotNull String operator, @NotNull String emptyValuePrefix, @NotNull String emptyValueSuffix) {
            if (operator == null) {
                FilterTemplate.$$$reportNull$$$0(1);
            }
            if (emptyValuePrefix == null) {
                FilterTemplate.$$$reportNull$$$0(2);
            }
            if (emptyValueSuffix == null) {
                FilterTemplate.$$$reportNull$$$0(3);
            }
            this.myOperator = operator;
            this.myEmptyValuePrefix = emptyValuePrefix;
            this.myEmptyValueSuffix = emptyValueSuffix;
        }

        @Nullable
        public PreparedColumnFilterExpression prepare(@NotNull DataGrid grid, @NotNull DataConsumer.Column column2, @NotNull Operand operand) {
            if (grid == null) {
                FilterTemplate.$$$reportNull$$$0(4);
            }
            if (column2 == null) {
                FilterTemplate.$$$reportNull$$$0(5);
            }
            if (operand == null) {
                FilterTemplate.$$$reportNull$$$0(6);
            }
            if (!this.isAvailableFor(operand, column2)) {
                return null;
            }
            String statementBeginning = ColumnFiltersGroup.appendColumnWithOperator(grid, column2, this).space().getStatement();
            StringBuilder presentableTextBuilder = new StringBuilder(statementBeginning);
            StringBuilder textBuilder = new StringBuilder(statementBeginning);
            int completionOffset = -1;
            String valueLiteral = this.getValueLiteral(grid, column2, operand.getValue());
            if (valueLiteral != null) {
                textBuilder.append(valueLiteral);
                presentableTextBuilder.append(StringUtil.trimMiddle((String)valueLiteral, (int)50));
            } else {
                textBuilder.append(this.myEmptyValuePrefix);
                completionOffset = textBuilder.length();
                textBuilder.append(this.myEmptyValueSuffix);
                presentableTextBuilder.append(this.myEmptyValuePrefix).append("...").append(this.myEmptyValueSuffix);
            }
            String filterExpressionText = textBuilder.toString();
            if (filterExpressionText.contains("\n")) {
                return null;
            }
            String presentableText = StringUtil.escapeMnemonics((String)presentableTextBuilder.toString());
            return new PreparedColumnFilterExpression(filterExpressionText, presentableText, completionOffset);
        }

        @NotNull
        public String getOperator() {
            String string = this.myOperator;
            if (string == null) {
                FilterTemplate.$$$reportNull$$$0(7);
            }
            return string;
        }

        @Nullable(value="null means the value is yet to be entered")
        protected @Nullable(value="null means the value is yet to be entered") String getValueLiteral(@NotNull DataGrid grid, @NotNull DataConsumer.Column column2, @Nullable String value) {
            if (grid == null) {
                FilterTemplate.$$$reportNull$$$0(8);
            }
            if (column2 == null) {
                FilterTemplate.$$$reportNull$$$0(9);
            }
            if (value == null) {
                return null;
            }
            boolean shouldQuote = !JdbcUtil.isNumberType((int)column2.type);
            Dbms dbms = DataGridUtil.getDbms(grid);
            if (dbms.isMysql() && column2.type == -7) {
                shouldQuote = false;
            }
            return shouldQuote ? DbSqlUtil.toStringLiteral(value, dbms) : value;
        }

        protected boolean isAvailableFor(@NotNull Operand op, @NotNull DataConsumer.Column column2) {
            if (op == null) {
                FilterTemplate.$$$reportNull$$$0(10);
            }
            if (column2 == null) {
                FilterTemplate.$$$reportNull$$$0(11);
            }
            return op.isValid();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "operator";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "emptyValuePrefix";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "emptyValueSuffix";
                    break;
                }
                case 4: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "grid";
                    break;
                }
                case 5: 
                case 9: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "column";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "operand";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/actions/ColumnFiltersGroup$FilterTemplate";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "op";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/actions/ColumnFiltersGroup$FilterTemplate";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOperator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "prepare";
                    break;
                }
                case 7: {
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "getValueLiteral";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "isAvailableFor";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ClipboardOperand
    implements Operand {
        private ClipboardOperand() {
        }

        @Override
        @Nullable
        public String getValue() {
            return ClipboardOperand.getContent();
        }

        @Override
        public boolean isValid() {
            return ClipboardOperand.getContent() != null;
        }

        @Nullable
        private static String getContent() {
            return StringUtil.nullize((String)((String)CopyPasteManager.getInstance().getContents(DataFlavor.stringFlavor)));
        }
    }

    private static class GridOperand
    implements Operand {
        private final DataGrid myGrid;
        private final DataConsumer.Row myRow;
        private final DataConsumer.Column myColumn;

        GridOperand(@NotNull DataGrid grid, @NotNull DataConsumer.Row row, @NotNull DataConsumer.Column column2) {
            if (grid == null) {
                GridOperand.$$$reportNull$$$0(0);
            }
            if (row == null) {
                GridOperand.$$$reportNull$$$0(1);
            }
            if (column2 == null) {
                GridOperand.$$$reportNull$$$0(2);
            }
            this.myGrid = grid;
            this.myRow = row;
            this.myColumn = column2;
        }

        @Override
        @Nullable
        public String getValue() {
            return this.myGrid.getObjectFormatter().getPlainValue(this.myColumn, this.myRow, DataGridUtil.getDbms(this.myGrid));
        }

        @Override
        public boolean isValid() {
            return this.myColumn.getValue(this.myRow) != null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "grid";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "row";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "column";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/run/actions/ColumnFiltersGroup$GridOperand";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PlaceholderOperand
    implements Operand {
        static final Operand INSTANCE = new PlaceholderOperand();

        private PlaceholderOperand() {
        }

        @Override
        @Nullable
        public String getValue() {
            return null;
        }

        @Override
        public boolean isValid() {
            return true;
        }
    }

    private static interface Operand {
        @Nullable
        public String getValue();

        public boolean isValid();
    }
}

