/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.extensions;

import com.intellij.database.DatabasePluginId;
import com.intellij.ide.extensionResources.ExtensionsRootType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.JBIterable;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtractorScripts {
    private static final String SCRIPT_DIR = "data/extractors";
    private static final Pattern FILE_PATTERN = Pattern.compile("(.+?)(?:\\.(\\w+))?\\.\\w+");

    private ExtractorScripts() {
    }

    @Nullable
    public static File getScriptsDirectory() {
        return ExtractorScripts.getScriptDirectoryImpl(true);
    }

    @NotNull
    public static List<File> getScriptFiles() {
        File directory = ExtractorScripts.getScriptDirectoryImpl(false);
        List list = JBIterable.of((Object[])(directory == null ? null : directory.listFiles())).filter(ExtensionsRootType.regularFileFilter()).filter(o -> FILE_PATTERN.matcher(o.getName()).matches()).toList();
        if (list == null) {
            ExtractorScripts.$$$reportNull$$$0(0);
        }
        return list;
    }

    @Nullable
    public static File findScript(String name2) {
        try {
            return ExtensionsRootType.getInstance().findResource(DatabasePluginId.get(), "data/extractors/" + name2);
        }
        catch (IOException e) {
            return null;
        }
    }

    @NotNull
    public static String getOutputFileExtension(@NotNull File script) {
        if (script == null) {
            ExtractorScripts.$$$reportNull$$$0(1);
        }
        String string = ExtractorScripts.getNamePart(script.getName(), 2, "txt");
        if (string == null) {
            ExtractorScripts.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    private static String getNamePart(String name2, int namePart, String def) {
        String string;
        Matcher matcher = FILE_PATTERN.matcher(name2);
        try {
            string = matcher.matches() ? StringUtil.notNullize((String)matcher.group(namePart), (String)def) : def;
        }
        catch (Exception ignore) {
            String string2 = def;
            if (string2 == null) {
                ExtractorScripts.$$$reportNull$$$0(4);
            }
            return string2;
        }
        if (string == null) {
            ExtractorScripts.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    private static File getScriptDirectoryImpl(boolean createIfMissing) {
        try {
            return ExtensionsRootType.getInstance().findResourceDirectory(DatabasePluginId.get(), SCRIPT_DIR, createIfMissing);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/extensions/ExtractorScripts";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "script";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getScriptFiles";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/extensions/ExtractorScripts";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputFileExtension";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamePart";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getOutputFileExtension";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

