/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.sqlite.introspector;

import java.util.List;
import org.jetbrains.dekaf.core.Layouts;
import org.jetbrains.dekaf.core.RowLayout;
import org.jetbrains.dekaf.sql.Scriptum;
import org.jetbrains.dekaf.sql.SqlQuery;

public final class SqliteIntroQueries {
    static final SqliteIntroQueries QUERIES = new SqliteIntroQueries();
    private final Scriptum myScriptum = Scriptum.of(SqliteIntroQueries.class);
    public final SqlQuery<List<SchemaInfo>> listSchemas = this.myScriptum.query("ListSchemas", Layouts.listOf((RowLayout)Layouts.structOf(SchemaInfo.class)));
    final SqlQuery<List<CollationInfo>> listCollations = this.myScriptum.query("ListCollations", Layouts.listOf((RowLayout)Layouts.structOf(CollationInfo.class)));
    public final SqlQuery<List<MajorInfo>> retrieveMajors = this.myScriptum.query("RetrieveMajors", Layouts.listOf((RowLayout)Layouts.structOf(MajorInfo.class)));
    public final SqlQuery<List<MajorInfo>> retrieveTempMajors = this.myScriptum.query("RetrieveTempMajors", Layouts.listOf((RowLayout)Layouts.structOf(MajorInfo.class)));
    public final SqlQuery<List<SourceInfo>> retrieveSources = this.myScriptum.query("RetrieveSources", Layouts.listOf((RowLayout)Layouts.structOf(SourceInfo.class)));
    public final SqlQuery<List<SourceInfo>> retrieveTempSources = this.myScriptum.query("RetrieveTempSources", Layouts.listOf((RowLayout)Layouts.structOf(SourceInfo.class)));
    final SqlQuery<List<ColumnInfo>> listColumns = this.myScriptum.query("ListColumns", Layouts.listOf((RowLayout)Layouts.structOf(ColumnInfo.class)));
    final SqlQuery<List<IndexInfo>> listIndices = this.myScriptum.query("ListIndices", Layouts.listOf((RowLayout)Layouts.structOf(IndexInfo.class)));
    final SqlQuery<List<IndexColumnInfo>> listIndexColumns = this.myScriptum.query("listIndexColumns", Layouts.listOf((RowLayout)Layouts.structOf(IndexColumnInfo.class)));
    final SqlQuery<List<ForeignKeyInfo>> listForeignKeys = this.myScriptum.query("ListForeignKeys", Layouts.listOf((RowLayout)Layouts.structOf(ForeignKeyInfo.class)));

    public static String quote(String s) {
        return "\"" + s.replace("\"", "\"\"") + "\"";
    }

    static final class ForeignKeyInfo {
        Integer id;
        Integer seq;
        String table;
        String from;
        String to;
        String on_update;
        String on_delete;
        String match;

        ForeignKeyInfo() {
        }
    }

    static final class IndexColumnInfo {
        Integer seqno;
        Integer cid;
        String name;
        Integer desc;
        String coll;
        Integer key;

        IndexColumnInfo() {
        }
    }

    static final class IndexInfo {
        Integer seq;
        String name;
        Integer unique;
        String origin;
        Integer partial;

        IndexInfo() {
        }
    }

    static final class ColumnInfo {
        Integer cid;
        String name;
        String type;
        Integer notnull;
        String dflt_value;
        Integer pk;

        ColumnInfo() {
        }
    }

    public static final class SourceInfo {
        public String type;
        public String name;
        public String tbl_name;
        public Integer rootpage;
        public String sql;
    }

    public static final class MajorInfo {
        public String type;
        public String name;
        public String tbl_name;
        public Integer rootpage;
    }

    static final class CollationInfo {
        Integer seq;
        String name;

        CollationInfo() {
        }
    }

    public static final class SchemaInfo {
        Integer seq;
        public String name;
        String file;
    }
}

