/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.sqlite;

import com.intellij.database.data.types.ConversionPoint;
import com.intellij.database.data.types.DomainRegistry;
import com.intellij.database.data.types.domain.BinaryDomain;
import com.intellij.database.data.types.domain.BooleanDomain;
import com.intellij.database.data.types.domain.FloatDomain;
import com.intellij.database.data.types.domain.FractionDomain;
import com.intellij.database.data.types.domain.IntegerDomain;
import com.intellij.database.data.types.domain.OperationSupport;
import com.intellij.database.data.types.domain.PhysicalDomainType;
import com.intellij.database.data.types.domain.SimpleDomain;
import com.intellij.database.data.types.domain.TextDomain;

public class SqliteDomains
extends DomainRegistry {
    private static final int MAX_CHAR = 20;
    private static final int MAX_NCHAR = 55;
    private static final int MAX_VARCHAR = 255;

    public SqliteDomains() {
        this.add(new IntegerDomain("integer", ConversionPoint.NUMBER, -2.147483648E9, 2.147483647E9));
        this.add(new IntegerDomain("int", ConversionPoint.NUMBER, -2.147483648E9, 2.147483647E9));
        this.add(new IntegerDomain("bigint", ConversionPoint.NUMBER, -9.223372036854776E18, 9.223372036854776E18));
        this.add(new IntegerDomain("int8", ConversionPoint.NUMBER, -9.223372036854776E18, 9.223372036854776E18));
        this.add(new BooleanDomain("boolean", ConversionPoint.BOOLEAN_NUMBER));
        this.add(new IntegerDomain("smallint", ConversionPoint.NUMBER, -32768.0, 32767.0));
        this.add(new IntegerDomain("int2", ConversionPoint.NUMBER, -32768.0, 32767.0));
        this.add(new IntegerDomain("tinyint", ConversionPoint.NUMBER, -128.0, 127.0));
        this.add(new FloatDomain("double precision", ConversionPoint.DOUBLE_PRECISION, -1.7976931348623157E308, Double.MAX_VALUE));
        this.add(new FloatDomain("double", ConversionPoint.DOUBLE_PRECISION, -1.7976931348623157E308, Double.MAX_VALUE));
        this.add(new FloatDomain("float", ConversionPoint.SINGLE_PRECISION, -3.4028234663852886E38, 3.4028234663852886E38));
        this.add(new FloatDomain("real", ConversionPoint.SINGLE_PRECISION, -3.4028234663852886E38, 3.4028234663852886E38));
        this.add(new TextDomain("text", ConversionPoint.TEXT, 0L, Integer.MAX_VALUE, false));
        this.add(new TextDomain("clob", ConversionPoint.TEXT, 0L, Integer.MAX_VALUE, false));
        this.add(new SimpleDomain("date", ConversionPoint.TEXT_DATE, PhysicalDomainType.DATE, OperationSupport.SUPPORTS_LIKE));
        this.add(new FractionDomain("datetime", ConversionPoint.TEXT_TIMESTAMP, PhysicalDomainType.TIMESTAMP, 0, -1, false, OperationSupport.SUPPORTS_LIKE));
        this.add(new BinaryDomain("blob", ConversionPoint.BLOB_TEXT, PhysicalDomainType.BINARY, Integer.MAX_VALUE, -1L, false, OperationSupport.SUPPORTS_LIKE));
        this.add(new TextDomain("char", ConversionPoint.CHAR, 20L, 1L, true));
        this.add(new TextDomain("character", ConversionPoint.CHAR, 20L, 1L, true));
        this.add(new TextDomain("nchar", ConversionPoint.NCHAR, 55L));
        this.add(new TextDomain("varchar", ConversionPoint.VARCHAR, 255L));
        this.add(new TextDomain("nvarchar", ConversionPoint.NVARCHAR, 255L));
        this.add(new FloatDomain("numeric", ConversionPoint.NUMBER, -1.7976931348623157E308, Double.MAX_VALUE));
    }
}

