/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.model;

import com.intellij.database.dialects.oracle.model.OraBody;
import com.intellij.database.dialects.oracle.model.OraObjectType;
import com.intellij.database.dialects.oracle.model.OraSchema;
import com.intellij.database.model.NameValueConsumer;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.SingletonFamily;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.database.model.properties.SourceError;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface OraObjectTypeBody
extends OraBody {
    @Nullable
    default public OraObjectType getObjectType() {
        return this.getParent();
    }

    @Override
    @Nullable
    public OraObjectType getParent();

    @Override
    @Nullable
    default public OraObjectType getMajorObject() {
        return this.getObjectType();
    }

    default public @Nullable SingletonFamily<@NotNull ? extends OraObjectTypeBody> getParentFamily() {
        return null;
    }

    @Override
    @Nullable
    public OraSchema getSchema();

    @Override
    @NotNull
    default public List<ObjectKind> getFamilyKinds() {
        List<ObjectKind> list = Collections.emptyList();
        if (list == null) {
            OraObjectTypeBody.$$$reportNull$$$0(0);
        }
        return list;
    }

    @Override
    @NotNull
    default public List<? extends ModFamily<? extends BasicModElement>> getFamilies() {
        List list = Collections.emptyList();
        if (list == null) {
            OraObjectTypeBody.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    @NotNull
    public List<SourceError> getErrors();

    @Override
    @NotNull
    public Set<Long> getDependsOnIds();

    @Override
    default public void exportProperties(@NotNull NameValueConsumer<String> consumer2) {
        Date modifiedTimestamp;
        Date createdTimestamp;
        Set<Long> dependsOnIds;
        boolean obfuscated;
        boolean invalid;
        int sourceTextLength;
        boolean outdated;
        long objectId;
        if (consumer2 == null) {
            OraObjectTypeBody.$$$reportNull$$$0(2);
        }
        if ((objectId = this.getObjectId()) != Long.MIN_VALUE) {
            consumer2.accept("ObjectId", PropertyConverter.export(objectId));
        }
        if (outdated = this.isOutdated()) {
            consumer2.accept("Outdated", PropertyConverter.export(outdated));
        }
        if ((sourceTextLength = this.getSourceTextLength()) != 0) {
            consumer2.accept("SourceTextLength", PropertyConverter.export(sourceTextLength));
        }
        if (invalid = this.isInvalid()) {
            consumer2.accept("Invalid", PropertyConverter.export(invalid));
        }
        if (obfuscated = this.isObfuscated()) {
            consumer2.accept("Obfuscated", PropertyConverter.export(obfuscated));
        }
        if (!(dependsOnIds = this.getDependsOnIds()).isEmpty()) {
            consumer2.accept("DependsOnIds", PropertyConverter.exportSetOfLong(dependsOnIds));
        }
        if ((createdTimestamp = this.getCreatedTimestamp()) != null) {
            consumer2.accept("CreatedTimestamp", PropertyConverter.export(createdTimestamp));
        }
        if ((modifiedTimestamp = this.getModifiedTimestamp()) != null) {
            consumer2.accept("ModifiedTimestamp", PropertyConverter.export(modifiedTimestamp));
        }
    }

    @Override
    @NotNull
    default public List<String> getPropertyNames() {
        List<String> list = Arrays.asList("ObjectId", "Outdated", "SourceTextLength", "Errors", "Invalid", "Obfuscated", "DependsOnIds", "CreatedTimestamp", "ModifiedTimestamp", "Comment");
        if (list == null) {
            OraObjectTypeBody.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Override
    public void setErrors(@NotNull List<SourceError> var1);

    @Override
    default public void setErrors(SourceError ... errors) {
        this.setErrors(Arrays.asList(errors));
    }

    @Override
    public void setDependsOnIds(@NotNull Set<Long> var1);

    @Override
    default public void importProperties(@NotNull Map<String, String> _properties) {
        if (_properties == null) {
            OraObjectTypeBody.$$$reportNull$$$0(4);
        }
        String objectId = _properties.get("ObjectId");
        String outdated = _properties.get("Outdated");
        String sourceTextLength = _properties.get("SourceTextLength");
        String invalid = _properties.get("Invalid");
        String obfuscated = _properties.get("Obfuscated");
        String dependsOnIds = _properties.get("DependsOnIds");
        String createdTimestamp = _properties.get("CreatedTimestamp");
        String modifiedTimestamp = _properties.get("ModifiedTimestamp");
        this.setObjectId(objectId != null ? PropertyConverter.importLong(objectId) : Long.MIN_VALUE);
        this.setOutdated(outdated != null ? PropertyConverter.importBoolean(outdated) : false);
        this.setSourceTextLength(sourceTextLength != null ? PropertyConverter.importInt(sourceTextLength) : 0);
        this.setInvalid(invalid != null ? PropertyConverter.importBoolean(invalid) : false);
        this.setObfuscated(obfuscated != null ? PropertyConverter.importBoolean(obfuscated) : false);
        this.setDependsOnIds(dependsOnIds != null ? PropertyConverter.importSetOfLong(dependsOnIds) : Collections.emptySet());
        this.setCreatedTimestamp(createdTimestamp != null ? PropertyConverter.importDate(createdTimestamp) : null);
        this.setModifiedTimestamp(modifiedTimestamp != null ? PropertyConverter.importDate(modifiedTimestamp) : null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/oracle/model/OraObjectTypeBody";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_properties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyKinds";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilies";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/oracle/model/OraObjectTypeBody";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyNames";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "exportProperties";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "importProperties";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

