/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.h2.ui;

import com.intellij.database.dataSource.url.DataInterchange;
import com.intellij.database.dataSource.url.TypesRegistry;
import com.intellij.database.dataSource.url.ui.TextParamEditor;
import com.intellij.database.util.DbUIUtil;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class H2PathParamEditor
extends TextParamEditor {
    private static final String MV_STORE = "MV_STORE";
    private Boolean myMvStore;
    private static final String MV_EXT = ".mv.db";
    private static final String PAGE_EXT = ".h2.db";
    private static final String[] EXTS = new String[]{".mv.db", ".h2.db"};

    public H2PathParamEditor(@NotNull DataInterchange interchange, @NotNull String caption) {
        if (interchange == null) {
            H2PathParamEditor.$$$reportNull$$$0(0);
        }
        if (caption == null) {
            H2PathParamEditor.$$$reportNull$$$0(1);
        }
        super(interchange, caption, TypesRegistry.ParamEditor.FieldSize.LARGE, TypesRegistry.getSelectDbAction(true));
    }

    @NotNull
    private String getDbPath() {
        String string = ((JBTextField)this.getEditorComponent()).getText();
        if (string == null) {
            H2PathParamEditor.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @NotNull
    public String getText() {
        String string = H2PathParamEditor.toDriver(this.getDbPath());
        if (string == null) {
            H2PathParamEditor.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    protected void fireChanged() {
        this.getInterchange().putProperty(MV_STORE, this.getDbPath().endsWith(MV_EXT) ? null : "false");
        super.fireChanged();
    }

    @Override
    public void setText(@NotNull String text2) {
        if (text2 == null) {
            H2PathParamEditor.$$$reportNull$$$0(4);
        }
        if (text2.endsWith(MV_EXT) || text2.endsWith(PAGE_EXT)) {
            this.validatePath();
        } else {
            text2 = text2 + (this.isMvStore() ? MV_EXT : PAGE_EXT);
        }
        ((JBTextField)this.getEditorComponent()).setText(text2);
    }

    private void validatePath() {
        DbUIUtil.invokeLater(() -> {
            this.getInterchange().forceUpdateProperty("path");
            this.getInterchange().forceUpdateProperty(MV_STORE);
        });
    }

    private boolean isMvStore() {
        return !"false".equals(this.getInterchange().getProperty(MV_STORE));
    }

    @NotNull
    private static String toDriver(@NotNull String path) {
        if (path == null) {
            H2PathParamEditor.$$$reportNull$$$0(5);
        }
        for (String ext : EXTS) {
            if (!path.endsWith(ext)) continue;
            String string = path.substring(0, path.length() - ext.length());
            if (string == null) {
                H2PathParamEditor.$$$reportNull$$$0(6);
            }
            return string;
        }
        String string = path;
        if (string == null) {
            H2PathParamEditor.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interchange";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caption";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/h2/ui/H2PathParamEditor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/h2/ui/H2PathParamEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbPath";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "toDriver";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setText";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "toDriver";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class Factory
    implements TypesRegistry.TypeDescriptorFactory {
        Factory() {
        }

        @Override
        public void createTypeDescriptor(@NotNull Consumer<? super TypesRegistry.TypeDescriptor> consumer2) {
            if (consumer2 == null) {
                Factory.$$$reportNull$$$0(0);
            }
            consumer2.consume((Object)new TypesRegistry.BaseTypeDescriptor("h2_db_file", "(?!//)[^;?&]+?|/", "File"){

                @Override
                @NotNull
                protected TypesRegistry.ParamEditor createFieldImpl(@NotNull String caption, @Nullable String configuration, @NotNull DataInterchange interchange) {
                    if (caption == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (interchange == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    H2PathParamEditor h2PathParamEditor = new H2PathParamEditor(interchange, 1.formatFieldCaption(caption));
                    if (h2PathParamEditor == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return h2PathParamEditor;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 2: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 2: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "caption";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "interchange";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/database/dialects/h2/ui/H2PathParamEditor$Factory$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/database/dialects/h2/ui/H2PathParamEditor$Factory$1";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[1] = "createFieldImpl";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "createFieldImpl";
                            break;
                        }
                        case 2: {
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 2: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/database/dialects/h2/ui/H2PathParamEditor$Factory", "createTypeDescriptor"));
        }
    }
}

