/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.exasol.model;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.exasol.model.ExaConnection;
import com.intellij.database.dialects.exasol.model.ExaDatabase;
import com.intellij.database.dialects.exasol.model.ExaMixinRoot;
import com.intellij.database.dialects.exasol.model.ExaRole;
import com.intellij.database.dialects.exasol.model.ExaUser;
import com.intellij.database.model.NameValueConsumer;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModMultiDatabaseRoot;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.database.util.Casing;
import com.intellij.database.util.Version;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public interface ExaRoot
extends ExaMixinRoot,
BasicModMultiDatabaseRoot {
    @Override
    @NotNull
    public @NotNull ModNamingFamily<@NotNull ? extends ExaDatabase> getDatabases();

    @NotNull
    public @NotNull ModNamingFamily<@NotNull ? extends ExaUser> getUsers();

    @NotNull
    public @NotNull ModNamingFamily<@NotNull ? extends ExaRole> getRoles();

    @NotNull
    public @NotNull ModNamingFamily<@NotNull ? extends ExaConnection> getConnections();

    @Override
    @NotNull
    default public List<ObjectKind> getFamilyKinds() {
        List<ObjectKind> list = Arrays.asList(ObjectKind.DATABASE, ObjectKind.USER, ObjectKind.ROLE, ObjectKind.CONNECTION);
        if (list == null) {
            ExaRoot.$$$reportNull$$$0(0);
        }
        return list;
    }

    @Override
    @NotNull
    default public List<? extends ModFamily<? extends BasicModElement>> getFamilies() {
        List<ModFamily> list = Arrays.asList(this.getDatabases(), this.getUsers(), this.getRoles(), this.getConnections());
        if (list == null) {
            ExaRoot.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    default public void exportProperties(@NotNull NameValueConsumer<String> consumer2) {
        Dbms dbms;
        Version serverVersion;
        boolean outdated;
        if (consumer2 == null) {
            ExaRoot.$$$reportNull$$$0(2);
        }
        if (outdated = this.isOutdated()) {
            consumer2.accept("Outdated", PropertyConverter.export(outdated));
        }
        if ((serverVersion = this.getServerVersion()) != null) {
            consumer2.accept("ServerVersion", PropertyConverter.export(serverVersion));
        }
        if ((dbms = this.getDbms()) != null && dbms != Dbms.EXASOL) {
            consumer2.accept("Dbms", PropertyConverter.export(dbms));
        }
    }

    @Override
    @NotNull
    default public List<String> getPropertyNames() {
        List<String> list = Arrays.asList("Outdated", "ServerVersion", "Dbms");
        if (list == null) {
            ExaRoot.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Override
    default public Casing getDefaultCasing() {
        return BasicNamespace.UPPER_CASING;
    }

    @Override
    public void setServerVersion(Version var1);

    @Override
    default public void importProperties(@NotNull Map<String, String> _properties) {
        if (_properties == null) {
            ExaRoot.$$$reportNull$$$0(4);
        }
        String outdated = _properties.get("Outdated");
        String serverVersion = _properties.get("ServerVersion");
        String dbms = _properties.get("Dbms");
        this.setOutdated(outdated != null ? PropertyConverter.importBoolean(outdated) : false);
        this.setServerVersion(serverVersion != null ? PropertyConverter.importVersion(serverVersion) : null);
        this.setDbms(dbms != null ? PropertyConverter.importDbms(dbms) : Dbms.EXASOL);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/exasol/model/ExaRoot";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_properties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyKinds";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilies";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/exasol/model/ExaRoot";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyNames";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "exportProperties";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "importProperties";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

