/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.debugger;

import com.intellij.database.DbmsExtension;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.debugger.SqlDebugController;
import com.intellij.database.debugger.SqlDebuggerFacade;
import com.intellij.database.model.DasDataSource;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.runners.AsyncProgramRunner;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.text.UniqueNameGenerator;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class SqlDebugRunner
extends AsyncProgramRunner {
    static final DbmsExtension<SqlDebuggerFacade> FACADE_EP = new DbmsExtension("com.intellij.database.debuggerFacade");
    @NotNull
    private final SqlDebuggerFacade myFacade;
    @NotNull
    private final SqlDebugController myController;

    public static SqlDebugAvailability checkDebuggerAvailability(@NotNull DasDataSource dataSource) {
        if (dataSource == null) {
            SqlDebugRunner.$$$reportNull$$$0(0);
        }
        if (!Registry.is((String)"database.debug.enable")) {
            return SqlDebugAvailability.DEBUGGER_ABSENT;
        }
        if (!(dataSource instanceof LocalDataSource)) {
            return SqlDebugAvailability.DEBUGGER_ABSENT;
        }
        LocalDataSource ds = (LocalDataSource)dataSource;
        SqlDebuggerFacade facade = (SqlDebuggerFacade)FACADE_EP.forDbms(ds.getDbms());
        if (facade == null) {
            return SqlDebugAvailability.DEBUGGER_ABSENT;
        }
        return facade.canDebug(ds) ? SqlDebugAvailability.DEBUGGER_ENABLED : SqlDebugAvailability.DEBUGGER_DISABLED;
    }

    @NotNull
    public static SqlDebugController startDebugProcess(@NotNull Project project, @NotNull LocalDataSource dataSource, @NotNull VirtualFile virtualFile, int firstLineNr, final @NotNull String title) {
        if (project == null) {
            SqlDebugRunner.$$$reportNull$$$0(1);
        }
        if (dataSource == null) {
            SqlDebugRunner.$$$reportNull$$$0(2);
        }
        if (virtualFile == null) {
            SqlDebugRunner.$$$reportNull$$$0(3);
        }
        if (title == null) {
            SqlDebugRunner.$$$reportNull$$$0(4);
        }
        SqlDebuggerFacade facade = (SqlDebuggerFacade)FACADE_EP.forDbms(dataSource.getDbms());
        SqlDebugController controller = facade.createController(project, dataSource, virtualFile, firstLineNr);
        Set existingTitles = JBIterable.from((Iterable)ExecutionManager.getInstance((Project)project).getContentManager().getAllDescriptors()).map(o -> o.getDisplayName()).toSet();
        final Icon icon = dataSource.getIcon(0);
        String uniqueTitle = UniqueNameGenerator.generateUniqueName((String)title, (String)"", (String)"", (String)" (", (String)")", o -> !existingTitles.contains(o));
        try {
            RunProfile profile = new RunProfile(){

                public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment environment) {
                    if (executor == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (environment == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return new RunProfileState(){

                        @Nullable
                        public ExecutionResult execute(Executor executor, @NotNull ProgramRunner runner) {
                            if (runner == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            return null;
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runner", "com/intellij/database/debugger/SqlDebugRunner$1$1", "execute"));
                        }
                    };
                }

                @NotNull
                public String getName() {
                    String string = title;
                    if (string == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return string;
                }

                @Nullable
                public Icon getIcon() {
                    return icon;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 2: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 2: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "executor";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "environment";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/database/debugger/SqlDebugRunner$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/database/debugger/SqlDebugRunner$1";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getName";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "getState";
                            break;
                        }
                        case 2: {
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 2: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            };
            new ExecutionEnvironmentBuilder(project, DefaultDebugExecutor.getDebugExecutorInstance()).runner((ProgramRunner)new SqlDebugRunner(facade, controller)).runProfile(profile).buildAndExecute();
        }
        catch (ExecutionException e) {
            ExecutionUtil.handleExecutionError((Project)project, (String)DefaultDebugExecutor.getDebugExecutorInstance().getToolWindowId(), (String)uniqueTitle, (Throwable)e);
        }
        SqlDebugController sqlDebugController = controller;
        if (sqlDebugController == null) {
            SqlDebugRunner.$$$reportNull$$$0(5);
        }
        return sqlDebugController;
    }

    SqlDebugRunner(@NotNull SqlDebuggerFacade facade, @NotNull SqlDebugController controller) {
        if (facade == null) {
            SqlDebugRunner.$$$reportNull$$$0(6);
        }
        if (controller == null) {
            SqlDebugRunner.$$$reportNull$$$0(7);
        }
        this.myFacade = facade;
        this.myController = controller;
    }

    @NotNull
    protected Promise<RunContentDescriptor> execute(@NotNull ExecutionEnvironment environment, @NotNull RunProfileState state2) throws ExecutionException {
        if (environment == null) {
            SqlDebugRunner.$$$reportNull$$$0(8);
        }
        if (state2 == null) {
            SqlDebugRunner.$$$reportNull$$$0(9);
        }
        Project project = environment.getProject();
        XDebuggerManager debuggerManager = XDebuggerManager.getInstance((Project)project);
        XDebugProcessStarter debugProcessStarter = this.myController.getStarter();
        XDebugSession session2 = debuggerManager.startSession(environment, debugProcessStarter);
        Promise promise = Promises.resolvedPromise((Object)session2.getRunContentDescriptor());
        if (promise == null) {
            SqlDebugRunner.$$$reportNull$$$0(10);
        }
        return promise;
    }

    @NotNull
    public String getRunnerId() {
        String string = ((Object)((Object)this)).getClass().getName();
        if (string == null) {
            SqlDebugRunner.$$$reportNull$$$0(11);
        }
        return string;
    }

    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        if (executorId == null) {
            SqlDebugRunner.$$$reportNull$$$0(12);
        }
        if (profile == null) {
            SqlDebugRunner.$$$reportNull$$$0(13);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 5: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/debugger/SqlDebugRunner";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facade";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controller";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executorId";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/debugger/SqlDebugRunner";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "startDebugProcess";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "execute";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunnerId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkDebuggerAvailability";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "startDebugProcess";
                break;
            }
            case 5: 
            case 10: 
            case 11: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "canRun";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum SqlDebugAvailability {
        DEBUGGER_ABSENT,
        DEBUGGER_DISABLED,
        DEBUGGER_ENABLED;

    }
}

