/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.url.ui;

import com.intellij.credentialStore.OneTimeString;
import com.intellij.database.DatabaseMessages;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabasePasswordField;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.url.template.UrlEditorModelBase;
import com.intellij.database.dataSource.url.ui.ParamEditorBase;
import com.intellij.database.dataSource.url.ui.PasswordStorageComponent;
import com.intellij.database.dataSource.url.ui.UrlPropertiesPanel;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.util.DbImplUtil;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBPasswordField;
import com.intellij.ui.components.JBTextField;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseAuthPanel {
    private final LocalDataSource myDataSource;
    private final DatabaseCredentials myCredentials;
    private JCheckBox myDomainAuthCheckBox;
    private JBTextField myUserField;
    private DatabasePasswordField myPasswordField;
    private JComponent myAuthPanel;
    private JComponent myCredentialsPanel;
    private PasswordStorageComponent myPasswordStorage;

    public DatabaseAuthPanel(LocalDataSource dataSource, DatabaseCredentials credentials, boolean standalone) {
        this.myDataSource = dataSource;
        this.myCredentials = credentials;
        this.createAuthBox(standalone);
    }

    public void hidePassword() {
        this.myPasswordField.moveToStorage();
    }

    public void passwordChanged() {
        this.myPasswordField.changedInStorage();
    }

    public void setUser(@NotNull String username) {
        if (username == null) {
            DatabaseAuthPanel.$$$reportNull$$$0(0);
        }
        this.myUserField.setText(username);
    }

    public void setPassword(@Nullable String password) {
        this.myPasswordField.setPassword(password);
    }

    protected boolean isAuthSupported() {
        return true;
    }

    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myAuthPanel;
        if (jComponent == null) {
            DatabaseAuthPanel.$$$reportNull$$$0(1);
        }
        return jComponent;
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        JBPasswordField jBPasswordField = this.myPasswordField.getComponent();
        if (jBPasswordField == null) {
            DatabaseAuthPanel.$$$reportNull$$$0(2);
        }
        return jBPasswordField;
    }

    @Nullable
    public String getUserName() {
        return this.isAuthSupported() ? this.myUserField.getText() : null;
    }

    public boolean isPasswordChanged() {
        return this.myPasswordField.isModified();
    }

    @Nullable
    public OneTimeString getPassword() {
        if (!this.isAuthSupported()) {
            return null;
        }
        char[] password = this.myPasswordField.getPassword();
        return password == null ? null : new OneTimeString(password);
    }

    public void addListeners(DocumentListener fieldsListener, final UrlEditorModelBase.StateChangeListener domainAuthListener) {
        this.myUserField.getDocument().addDocumentListener(fieldsListener);
        this.myPasswordField.getComponent().getDocument().addDocumentListener(fieldsListener);
        this.myDomainAuthCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                domainAuthListener.stateChanged(null);
            }
        });
    }

    private void createAuthBox(boolean standalone) {
        this.myDomainAuthCheckBox = new JBCheckBox(DatabaseMessages.message((String)"use.windows.domain.authentication", (Object[])new Object[0]));
        this.myUserField = new JBTextField();
        this.myPasswordField = new DatabasePasswordField(this.myCredentials, this.myDataSource){

            @Override
            @Nullable
            protected OneTimeString extractPassword(@NotNull DatabaseCredentials credentials, @NotNull DasDataSource dataSource) {
                if (credentials == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (dataSource == null) {
                    2.$$$reportNull$$$0(1);
                }
                return credentials.getPassword(dataSource);
            }

            @Override
            protected void setPassword(@NotNull DatabaseCredentials credentials, @NotNull DasDataSource dataSource, @Nullable OneTimeString password) {
                if (credentials == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (dataSource == null) {
                    2.$$$reportNull$$$0(3);
                }
                credentials.setPassword(dataSource, password);
            }

            @Override
            protected LocalDataSource getActualTarget() {
                LocalDataSource copy = DatabaseAuthPanel.this.myDataSource.copy(true);
                copy.setPasswordStorage(DatabaseAuthPanel.this.myPasswordStorage.getStorage());
                return copy;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "credentials";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "dataSource";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/database/dataSource/url/ui/DatabaseAuthPanel$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extractPassword";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "setPassword";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        this.myPasswordStorage = new PasswordStorageComponent();
        this.myAuthPanel = new JPanel();
        this.createCredentialsPanel(standalone);
        this.validateAuthPanel(DbImplUtil.supportsDomainAuth(this.myDataSource.getDatabaseDriver()));
        this.myDomainAuthCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean selected = DatabaseAuthPanel.this.myDomainAuthCheckBox.isSelected();
                UIUtil.setEnabled((Component)DatabaseAuthPanel.this.myCredentialsPanel, (!selected ? 1 : 0) != 0, (boolean)true);
            }
        });
    }

    private void validateAuthPanel(boolean domainAuth) {
        int rowCount;
        GridLayoutManager l = (GridLayoutManager)ObjectUtils.tryCast((Object)this.myAuthPanel.getLayout(), GridLayoutManager.class);
        int n = rowCount = domainAuth ? 2 : 1;
        if (l != null && l.getRowCount() == rowCount) {
            return;
        }
        this.myAuthPanel.remove(this.myDomainAuthCheckBox);
        this.myAuthPanel.remove(this.myCredentialsPanel);
        this.myAuthPanel.setLayout((LayoutManager)new GridLayoutManager(rowCount, 6));
        if (domainAuth) {
            this.myAuthPanel.add((Component)this.myDomainAuthCheckBox, UrlPropertiesPanel.createAlignedConstraints(0, 1, 5, 10));
        }
        this.myAuthPanel.add((Component)this.myCredentialsPanel, UrlPropertiesPanel.createSimpleConstraints(rowCount - 1, 0, 6));
    }

    private void createCredentialsPanel(boolean standalone) {
        this.myCredentialsPanel = new JPanel((LayoutManager)new GridLayoutManager(2, 6));
        int span = 3;
        JBLabel userLabel = new JBLabel("User:");
        this.myCredentialsPanel.add((Component)userLabel, UrlPropertiesPanel.createLabelConstraints(0, 0, userLabel.getPreferredSize().getWidth()));
        this.myCredentialsPanel.add((Component)this.myUserField, UrlPropertiesPanel.createSimpleConstraints(0, 1, span));
        JBLabel passwordLabel = new JBLabel("Password:");
        this.myCredentialsPanel.add((Component)passwordLabel, UrlPropertiesPanel.createLabelConstraints(1, 0, passwordLabel.getPreferredSize().getWidth()));
        this.myCredentialsPanel.add((Component)this.myPasswordField.getComponent(), UrlPropertiesPanel.createSimpleConstraints(1, 1, span));
        JBLabel rememberLabel = new JBLabel("Save:");
        rememberLabel.setBorder(UrlPropertiesPanel.innerLabelBorder());
        this.myCredentialsPanel.add((Component)rememberLabel, UrlPropertiesPanel.createLabelConstraints(1, 4, rememberLabel.getPreferredSize().getWidth()));
        this.myCredentialsPanel.add((Component)this.myPasswordStorage.getComponent(), UrlPropertiesPanel.createSimpleConstraints(1, 5, 1));
    }

    public void save(@NotNull LocalDataSource dataSource, boolean copyCredentials) {
        if (dataSource == null) {
            DatabaseAuthPanel.$$$reportNull$$$0(3);
        }
        dataSource.setPasswordStorage(this.myPasswordStorage.getStorage());
        dataSource.setUsername(this.getUserName());
        if (copyCredentials) {
            this.myPasswordField.save(dataSource);
        }
        dataSource.setDomainAuthentication(this.myDomainAuthCheckBox.isEnabled() && this.myDomainAuthCheckBox.isSelected());
    }

    public void reset(@NotNull LocalDataSource dataSource, boolean resetCredentials) {
        if (dataSource == null) {
            DatabaseAuthPanel.$$$reportNull$$$0(4);
        }
        this.setPasswordStorage(dataSource.getPasswordStorage());
        this.myUserField.setText(dataSource.getUsername());
        if (resetCredentials) {
            this.myPasswordField.setPassword(null);
        }
        this.myDomainAuthCheckBox.setSelected(dataSource.isDomainAuthentication());
        this.validateDriver(dataSource.getDatabaseDriver());
    }

    public void validateDriver(DatabaseDriver driver) {
        boolean domainAuth = DbImplUtil.supportsDomainAuth(driver);
        this.myDomainAuthCheckBox.setEnabled(domainAuth);
        this.myDomainAuthCheckBox.setVisible(domainAuth);
        this.validateAuthPanel(domainAuth);
    }

    public void setActive(boolean active) {
        this.myUserField.setBackground(ParamEditorBase.getBackground(active));
        this.myPasswordField.getComponent().setBackground(ParamEditorBase.getBackground(active));
    }

    public char[] getVisiblePassword() {
        return this.myPasswordField.getPasswordOpt();
    }

    public void setPasswordStorage(@NotNull LocalDataSource.Storage storage) {
        if (storage == null) {
            DatabaseAuthPanel.$$$reportNull$$$0(5);
        }
        this.myPasswordStorage.setPasswordStorage(storage);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "username";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/url/ui/DatabaseAuthPanel";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/url/ui/DatabaseAuthPanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredFocusedComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setUser";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "save";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setPasswordStorage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

