/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.credentialStore.OneTimeString;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.dataSource.AsyncUtil;
import com.intellij.database.dataSource.DataSourceSshPanel;
import com.intellij.database.dataSource.DataSourceSshTunnelConfiguration;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.model.DasDataSource;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.AuthType;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteCredentialsHolder;
import com.intellij.ssh.AuthFailSshTransportException;
import com.intellij.ssh.ConnectionBuilder;
import com.intellij.ssh.RemoteCredentialsUtil;
import com.intellij.ssh.SshSession;
import com.intellij.ssh.SshTransportException;
import com.intellij.ssh.config.ConfigRepository;
import com.intellij.ssh.config.OpenSSHClientConfig;
import com.intellij.ssh.config.OpenSSHConfigService;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.net.NetUtils;
import com.intellij.util.ui.JBUI;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseSshTunnelEstablisher {
    private static final Logger LOG = Logger.getInstance(DatabaseSshTunnelEstablisher.class);
    static Function<DataSourceSshPanel, Boolean> ourSshInterceptor = null;
    static final int DEF_PORT = 22;
    static final String DEF_KEY_FILE = "~/.ssh/id_rsa";
    private final Project myProject;
    private final LocalDataSource myDataSource;
    private final DatabaseCredentials myCredentialsStore;

    public static void setCredentialsInterceptor(Function<DataSourceSshPanel, Boolean> di) {
        ourSshInterceptor = di;
    }

    private DatabaseSshTunnelEstablisher(@NotNull Project project, @NotNull LocalDataSource dataSource, @NotNull DatabaseCredentials credentialsStore) {
        if (project == null) {
            DatabaseSshTunnelEstablisher.$$$reportNull$$$0(0);
        }
        if (dataSource == null) {
            DatabaseSshTunnelEstablisher.$$$reportNull$$$0(1);
        }
        if (credentialsStore == null) {
            DatabaseSshTunnelEstablisher.$$$reportNull$$$0(2);
        }
        this.myProject = project;
        this.myDataSource = dataSource;
        this.myCredentialsStore = credentialsStore;
    }

    @Nullable
    public static Pair<SshSession, Integer> createTunnelSync(@NotNull Project project, @NotNull LocalDataSource dataSource, @NotNull DatabaseCredentials credentialsStore) throws SshTransportException {
        if (project == null) {
            DatabaseSshTunnelEstablisher.$$$reportNull$$$0(3);
        }
        if (dataSource == null) {
            DatabaseSshTunnelEstablisher.$$$reportNull$$$0(4);
        }
        if (credentialsStore == null) {
            DatabaseSshTunnelEstablisher.$$$reportNull$$$0(5);
        }
        try {
            return DatabaseSshTunnelEstablisher.createTunnel(project, dataSource, credentialsStore).toCompletableFuture().get();
        }
        catch (InterruptedException e) {
            throw new ProcessCanceledException();
        }
        catch (ExecutionException e) {
            if (AsyncUtil.isCancellation(e)) {
                throw new ProcessCanceledException();
            }
            Throwable ue = AsyncUtil.unwrap(e);
            if (ue instanceof SshTransportException) {
                throw (SshTransportException)ue;
            }
            ExceptionUtil.rethrowAllAsUnchecked((Throwable)ue);
            return null;
        }
    }

    @NotNull
    public static CompletionStage<Pair<SshSession, Integer>> createTunnel(@NotNull Project project, @NotNull LocalDataSource dataSource, @NotNull DatabaseCredentials credentialsStore) {
        if (project == null) {
            DatabaseSshTunnelEstablisher.$$$reportNull$$$0(6);
        }
        if (dataSource == null) {
            DatabaseSshTunnelEstablisher.$$$reportNull$$$0(7);
        }
        if (credentialsStore == null) {
            DatabaseSshTunnelEstablisher.$$$reportNull$$$0(8);
        }
        CompletionStage<Pair<SshSession, Integer>> completionStage = new DatabaseSshTunnelEstablisher(project, dataSource, credentialsStore).createTunnel();
        if (completionStage == null) {
            DatabaseSshTunnelEstablisher.$$$reportNull$$$0(9);
        }
        return completionStage;
    }

    @NotNull
    public CompletionStage<Pair<SshSession, Integer>> createTunnel() {
        Pair.NonNull<String, String> hostPort;
        DataSourceSshTunnelConfiguration ssh = this.myDataSource.getSshConfiguration();
        if (ssh == null || !ssh.isEnabled()) {
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            if (completableFuture == null) {
                DatabaseSshTunnelEstablisher.$$$reportNull$$$0(10);
            }
            return completableFuture;
        }
        String connectionUrl = this.myDataSource.getUrl();
        DatabaseDriver driver = this.myDataSource.getDatabaseDriver();
        Pair.NonNull<String, String> nonNull = hostPort = connectionUrl == null || driver == null ? null : JdbcUrlParserUtil.extractHostPort(driver.getJDBCUrlParsers(), connectionUrl, null);
        if (hostPort == null) {
            throw new UnsupportedOperationException("Unable to find host/port in URL");
        }
        CompletionStage<Pair<SshSession, Integer>> completionStage = AsyncUtil.thenComposeAsync(DatabaseSshTunnelEstablisher.getInitialSshCredentials(this.myProject, this.myCredentialsStore, this.myDataSource, true), config -> this.createSshSessionWithRetries(config == null ? null : (DataSourceSshTunnelConfiguration)config.first, config == null ? null : (OneTimeString)config.second), AsyncUtil.POOL_EXECUTOR).thenApply(session2 -> {
            if (session2 == null) {
                return null;
            }
            int localPort = this.getAddLocalPortTunnel((Pair<String, String>)hostPort, ((DataSourceSshTunnelConfiguration)session2.first).getAuthType() == AuthType.OPEN_SSH, StringUtil.nullize((String)((DataSourceSshTunnelConfiguration)session2.first).getLocalPort()), (SshSession)session2.second);
            return Pair.create((Object)session2.second, (Object)localPort);
        });
        if (completionStage == null) {
            DatabaseSshTunnelEstablisher.$$$reportNull$$$0(11);
        }
        return completionStage;
    }

    private int getAddLocalPortTunnel(@NotNull Pair<String, String> hostPort, boolean reuseExisting, @Nullable String requiredLocal, @NotNull SshSession session2) {
        if (hostPort == null) {
            DatabaseSshTunnelEstablisher.$$$reportNull$$$0(12);
        }
        if (session2 == null) {
            DatabaseSshTunnelEstablisher.$$$reportNull$$$0(13);
        }
        int existingPort = reuseExisting ? this.findExistingPort(hostPort, requiredLocal, session2) : -1;
        return existingPort != -1 ? existingPort : this.getNewTunnelPort(hostPort, requiredLocal, session2);
    }

    private int getNewTunnelPort(@NotNull Pair<String, String> hostPort, @Nullable String requiredLocal, @NotNull SshSession session2) {
        if (hostPort == null) {
            DatabaseSshTunnelEstablisher.$$$reportNull$$$0(14);
        }
        if (session2 == null) {
            DatabaseSshTunnelEstablisher.$$$reportNull$$$0(15);
        }
        int localPort = this.findLocalPort(requiredLocal);
        session2.addLocalTunnel(localPort, (String)hostPort.first, StringUtil.parseInt((String)((String)hostPort.second), (int)-1));
        LOG.info("SSH tunnel created: " + localPort + ":" + (String)hostPort.first + ":" + (String)hostPort.second);
        return localPort;
    }

    private int findLocalPort(@Nullable String requiredLocal) {
        if (requiredLocal != null) {
            int localPort = StringUtil.parseInt((String)requiredLocal, (int)-1);
            if (localPort != -1) {
                return localPort;
            }
            throw new SshTransportException("Requested local port is not an integer: " + requiredLocal);
        }
        try {
            return NetUtils.findAvailableSocketPort();
        }
        catch (IOException e) {
            throw new SshTransportException("Free port not found", (Throwable)e);
        }
    }

    private int findExistingPort(@NotNull Pair<String, String> hostPort, @Nullable String requiredLocal, @NotNull SshSession session2) {
        String existing;
        if (hostPort == null) {
            DatabaseSshTunnelEstablisher.$$$reportNull$$$0(16);
        }
        if (session2 == null) {
            DatabaseSshTunnelEstablisher.$$$reportNull$$$0(17);
        }
        if ((existing = this.findExistingForwarding(hostPort, requiredLocal, session2)) != null) {
            int localPort = StringUtil.parseInt((String)existing.substring(0, existing.indexOf(58)), (int)-1);
            if (localPort == -1) {
                throw new RuntimeException("Failed to parse forwarding: " + existing);
            }
            LOG.info("SSH tunnel reused: " + existing);
            return localPort;
        }
        return -1;
    }

    private String findExistingForwarding(@NotNull Pair<String, String> hostPort, @Nullable String requiredLocal, @NotNull SshSession session2) {
        if (hostPort == null) {
            DatabaseSshTunnelEstablisher.$$$reportNull$$$0(18);
        }
        if (session2 == null) {
            DatabaseSshTunnelEstablisher.$$$reportNull$$$0(19);
        }
        session2.applyPortForwardings();
        List existing = session2.getPortForwardingList();
        String term = StringUtil.notNullize((String)requiredLocal) + ":" + (String)hostPort.first + ":" + (String)hostPort.second;
        return (String)ContainerUtil.find((Iterable)existing, (Condition)(requiredLocal == null ? o -> o.endsWith(term) : o -> o.equals(term)));
    }

    @NotNull
    private @NotNull CompletionStage<Pair<@NotNull DataSourceSshTunnelConfiguration, @NotNull SshSession>> createSshSessionWithRetries(@Nullable DataSourceSshTunnelConfiguration ssh, @Nullable OneTimeString secret) {
        CompletableFuture<Pair<DataSourceSshTunnelConfiguration, SshSession>> completableFuture;
        if (ssh == null || !ssh.isEnabled()) {
            CompletableFuture<Object> completableFuture2 = CompletableFuture.completedFuture(null);
            if (completableFuture2 == null) {
                DatabaseSshTunnelEstablisher.$$$reportNull$$$0(20);
            }
            return completableFuture2;
        }
        try {
            completableFuture = CompletableFuture.completedFuture(Pair.create((Object)ssh, (Object)DatabaseSshTunnelEstablisher.createSshSession(ssh, secret)));
        }
        catch (Throwable e) {
            if (!DatabaseSshTunnelEstablisher.isAuthFailure(e)) {
                CompletableFuture<Pair<DataSourceSshTunnelConfiguration, SshSession>> completableFuture3 = AsyncUtil.exceptional(e);
                if (completableFuture3 == null) {
                    DatabaseSshTunnelEstablisher.$$$reportNull$$$0(22);
                }
                return completableFuture3;
            }
            CompletionStage<Pair<DataSourceSshTunnelConfiguration, SshSession>> completionStage = AsyncUtil.thenComposeAsync(DatabaseSshTunnelEstablisher.askSshCredentialsWhenFailed(this.myProject, this.myCredentialsStore, this.myDataSource, "<html>" + e.getMessage() + "</html>", true), config -> this.createSshSessionWithRetries(config == null ? null : (DataSourceSshTunnelConfiguration)config.first, config == null ? null : (OneTimeString)config.second), AsyncUtil.POOL_EXECUTOR);
            if (completionStage == null) {
                DatabaseSshTunnelEstablisher.$$$reportNull$$$0(23);
            }
            return completionStage;
        }
        if (completableFuture == null) {
            DatabaseSshTunnelEstablisher.$$$reportNull$$$0(21);
        }
        return completableFuture;
    }

    private static boolean isAuthFailure(Throwable e) {
        if (e instanceof SshTransportException) {
            if (e instanceof AuthFailSshTransportException) {
                return true;
            }
            String message2 = e.getMessage();
            if (message2 == null) {
                return false;
            }
            if ("Auth cancel".equals(message2)) {
                return true;
            }
            if (message2.contains("Too many authentication failures")) {
                return true;
            }
        }
        return false;
    }

    @NotNull
    private static SshSession createSshSession(@NotNull DataSourceSshTunnelConfiguration ssh, @Nullable OneTimeString secret) {
        if (ssh == null) {
            DatabaseSshTunnelEstablisher.$$$reportNull$$$0(24);
        }
        RemoteCredentialsHolder holder = new RemoteCredentialsHolder();
        holder.setHost(ssh.getProxyHost());
        holder.setPort(StringUtil.parseInt((String)ssh.getProxyPort(), (int)22));
        holder.setUserName(ssh.getUser());
        AuthType type = ssh.getAuthType();
        holder.setAuthType(type);
        switch (type) {
            case PASSWORD: {
                holder.setPassword(secret == null ? null : secret.toString(true));
                break;
            }
            case KEY_PAIR: {
                holder.setPrivateKeyFile(DatabaseSshTunnelEstablisher.tildeExpandFilename(StringUtil.notNullize((String)StringUtil.nullize((String)ssh.getPrivateKeyPath()), (String)DEF_KEY_FILE)));
                holder.setPassphrase(secret == null ? null : secret.toString(true));
                break;
            }
            case OPEN_SSH: {
                OpenSSHClientConfig openSSHConfig = OpenSSHConfigService.getInstance().getConfig();
                if (openSSHConfig == null) break;
                OpenSSHClientConfig.HostConfig hostConfig = openSSHConfig.getConfig(ssh.getProxyHost());
                if (StringUtil.isEmptyOrSpaces((String)ssh.getProxyPort())) {
                    DatabaseSshTunnelEstablisher.usePortFromOpenSSHConfig(holder, (ConfigRepository.Config)hostConfig);
                }
                if (!StringUtil.isEmptyOrSpaces((String)ssh.getUser())) break;
                DatabaseSshTunnelEstablisher.useUserFromOpenSSHConfig(holder, (ConfigRepository.Config)hostConfig);
                break;
            }
        }
        ConnectionBuilder builder = RemoteCredentialsUtil.connectionBuilder((RemoteCredentials)holder);
        SshSession sshSession = builder.connect();
        if (sshSession == null) {
            DatabaseSshTunnelEstablisher.$$$reportNull$$$0(25);
        }
        return sshSession;
    }

    @NotNull
    public static String tildeExpandFilename(@NotNull String path) {
        if (path == null) {
            DatabaseSshTunnelEstablisher.$$$reportNull$$$0(26);
        }
        if ((path = path.trim()).startsWith("~")) {
            String string = SystemProperties.getUserHome() + path.substring(1);
            if (string == null) {
                DatabaseSshTunnelEstablisher.$$$reportNull$$$0(27);
            }
            return string;
        }
        String string = path;
        if (string == null) {
            DatabaseSshTunnelEstablisher.$$$reportNull$$$0(28);
        }
        return string;
    }

    private static void usePortFromOpenSSHConfig(@NotNull RemoteCredentialsHolder holder, @NotNull ConfigRepository.Config hostConfig) {
        int port;
        if (holder == null) {
            DatabaseSshTunnelEstablisher.$$$reportNull$$$0(29);
        }
        if (hostConfig == null) {
            DatabaseSshTunnelEstablisher.$$$reportNull$$$0(30);
        }
        if ((port = hostConfig.getPort()) != -1) {
            LOG.info("Use " + port + " port from OpenSSH configuration file");
            holder.setPort(port);
        }
    }

    private static void useUserFromOpenSSHConfig(@NotNull RemoteCredentialsHolder holder, @NotNull ConfigRepository.Config hostConfig) {
        String user;
        if (holder == null) {
            DatabaseSshTunnelEstablisher.$$$reportNull$$$0(31);
        }
        if (hostConfig == null) {
            DatabaseSshTunnelEstablisher.$$$reportNull$$$0(32);
        }
        if (StringUtil.isNotEmpty((String)(user = hostConfig.getUser()))) {
            LOG.info("Use \"" + user + "\" user from OpenSSH configuration file");
            holder.setUserName(user);
        }
    }

    @NotNull
    static CompletionStage<Pair<DataSourceSshTunnelConfiguration, OneTimeString>> askSshCredentialsWhenFailed(@NotNull Project project, @NotNull DatabaseCredentials dc, @NotNull LocalDataSource dataSource, @NotNull String message2, boolean error2) {
        if (project == null) {
            DatabaseSshTunnelEstablisher.$$$reportNull$$$0(33);
        }
        if (dc == null) {
            DatabaseSshTunnelEstablisher.$$$reportNull$$$0(34);
        }
        if (dataSource == null) {
            DatabaseSshTunnelEstablisher.$$$reportNull$$$0(35);
        }
        if (message2 == null) {
            DatabaseSshTunnelEstablisher.$$$reportNull$$$0(36);
        }
        if (project.isDefault()) {
            CompletableFuture<Pair<DataSourceSshTunnelConfiguration, OneTimeString>> completableFuture = AsyncUtil.cancelled();
            if (completableFuture == null) {
                DatabaseSshTunnelEstablisher.$$$reportNull$$$0(37);
            }
            return completableFuture;
        }
        DataSourceSshTunnelConfiguration ssh = dataSource.getSshConfiguration();
        if (ssh == null || !ssh.isEnabled()) {
            CompletableFuture<Pair<DataSourceSshTunnelConfiguration, OneTimeString>> completableFuture = AsyncUtil.cancelled();
            if (completableFuture == null) {
                DatabaseSshTunnelEstablisher.$$$reportNull$$$0(38);
            }
            return completableFuture;
        }
        Pair<DataSourceSshTunnelConfiguration, OneTimeString> p1 = DatabaseSshTunnelEstablisher.getSshAuth(dc, dataSource);
        CompletableFuture<Pair<DataSourceSshTunnelConfiguration, OneTimeString>> completableFuture = DatabaseCredentials.showCredentialsDialog(() -> {
            Pair<DataSourceSshTunnelConfiguration, OneTimeString> p2 = DatabaseSshTunnelEstablisher.getSshAuth(dc, dataSource);
            if (!Comparing.equal((Object)p1, p2)) {
                return p2;
            }
            Disposable disposable = Disposer.newDisposable();
            try {
                boolean ok;
                DataSourceSshPanel sshPanel = new DataSourceSshPanel(project, dataSource, dc, disposable);
                sshPanel.reset(dataSource, false);
                if (p1 == null || p1.second == null) {
                    AuthType authType = sshPanel.getAuthType();
                    if (authType == AuthType.PASSWORD) {
                        sshPanel.setPassword("");
                    }
                    if (authType == AuthType.KEY_PAIR) {
                        sshPanel.setPassphrase("");
                    }
                }
                if (ourSshInterceptor == null) {
                    sshPanel.getComponent().setBorder((Border)JBUI.Borders.emptyTop((int)4));
                    DialogBuilder builder = DatabaseCredentials.prepareDialog(project, (error2 ? MessageType.ERROR : MessageType.WARNING).getDefaultIcon(), sshPanel.getComponent(), "Opening tunnel for '" + dataSource.getName() + "'...", message2);
                    builder.setPreferredFocusComponent(sshPanel.getPreferredFocusedComponent());
                    ok = builder.show() == 0;
                } else {
                    ok = (Boolean)ourSshInterceptor.fun((Object)sshPanel);
                }
                if (!ok) {
                    throw new ProcessCanceledException();
                }
                sshPanel.saveData(dataSource, true);
                DataSourceSshTunnelConfiguration config = sshPanel.createSshConfig();
                if (config == null || !config.isEnabled()) {
                    Pair pair = null;
                    return pair;
                }
                AuthType type = config.getAuthType();
                Pair pair = Pair.create((Object)config, (Object)(type == AuthType.PASSWORD ? sshPanel.getPassword() : (type == AuthType.KEY_PAIR ? sshPanel.getPassphrase() : null)));
                return pair;
            }
            finally {
                Disposer.dispose((Disposable)disposable);
            }
        });
        if (completableFuture == null) {
            DatabaseSshTunnelEstablisher.$$$reportNull$$$0(39);
        }
        return completableFuture;
    }

    public static CompletionStage<Pair<DataSourceSshTunnelConfiguration, OneTimeString>> askNoSshCredentials(@NotNull Project project, @NotNull DatabaseCredentials credentialsStore, @NotNull LocalDataSource dataSource) {
        if (project == null) {
            DatabaseSshTunnelEstablisher.$$$reportNull$$$0(40);
        }
        if (credentialsStore == null) {
            DatabaseSshTunnelEstablisher.$$$reportNull$$$0(41);
        }
        if (dataSource == null) {
            DatabaseSshTunnelEstablisher.$$$reportNull$$$0(42);
        }
        return DatabaseSshTunnelEstablisher.askSshCredentialsWhenFailed(project, credentialsStore, dataSource, "<html>Please provide SSH credentials.</html>", false);
    }

    public static CompletionStage<Pair<DataSourceSshTunnelConfiguration, OneTimeString>> getInitialSshCredentials(@NotNull Project project, @NotNull DatabaseCredentials credentialsStore, @NotNull LocalDataSource dataSource, boolean askPassword) {
        DataSourceSshTunnelConfiguration ssh;
        if (project == null) {
            DatabaseSshTunnelEstablisher.$$$reportNull$$$0(43);
        }
        if (credentialsStore == null) {
            DatabaseSshTunnelEstablisher.$$$reportNull$$$0(44);
        }
        if (dataSource == null) {
            DatabaseSshTunnelEstablisher.$$$reportNull$$$0(45);
        }
        LocalDataSource.Storage storage = LocalDataSource.Storage.orMem((ssh = dataSource.getSshConfiguration()) == null ? null : ssh.getPasswordStorage());
        return DatabaseCredentials.getInitialCredentialsImpl(storage, askPassword, () -> DatabaseSshTunnelEstablisher.getSshAuthAsync(credentialsStore.strict(), dataSource), th -> th == null ? DatabaseSshTunnelEstablisher.askNoSshCredentials(project, credentialsStore, dataSource) : DatabaseSshTunnelEstablisher.askSshCredentialsWhenFailed(project, credentialsStore, dataSource, th.getMessage(), true), c2 -> c2 == null || ((DataSourceSshTunnelConfiguration)c2.first).getAuthType() != AuthType.OPEN_SSH && c2.second == null);
    }

    @Nullable
    private static Pair<DataSourceSshTunnelConfiguration, OneTimeString> getSshAuth(@NotNull DatabaseCredentials dc, @NotNull LocalDataSource dataSource) {
        DataSourceSshTunnelConfiguration ssh;
        if (dc == null) {
            DatabaseSshTunnelEstablisher.$$$reportNull$$$0(46);
        }
        if (dataSource == null) {
            DatabaseSshTunnelEstablisher.$$$reportNull$$$0(47);
        }
        if ((ssh = dataSource.getSshConfiguration()) == null || !ssh.isEnabled()) {
            return null;
        }
        AuthType type = ssh.getAuthType();
        return Pair.create((Object)ssh, (Object)(type == AuthType.KEY_PAIR ? dc.getSshPassphrase(dataSource) : (type == AuthType.PASSWORD ? dc.getSshPassword(dataSource) : null)));
    }

    public static CompletionStage<Pair<DataSourceSshTunnelConfiguration, OneTimeString>> getSshAuthAsync(@NotNull DatabaseCredentials credentialsStore, @NotNull DasDataSource info) {
        LocalDataSource dataSource;
        DataSourceSshTunnelConfiguration ssh;
        if (credentialsStore == null) {
            DatabaseSshTunnelEstablisher.$$$reportNull$$$0(48);
        }
        if (info == null) {
            DatabaseSshTunnelEstablisher.$$$reportNull$$$0(49);
        }
        DataSourceSshTunnelConfiguration dataSourceSshTunnelConfiguration = ssh = (dataSource = (LocalDataSource)ObjectUtils.tryCast((Object)info, LocalDataSource.class)) == null ? null : dataSource.getSshConfiguration();
        if (ssh == null) {
            return CompletableFuture.completedFuture(null);
        }
        AuthType auth = ssh.getAuthType();
        if (auth != AuthType.PASSWORD && auth != AuthType.KEY_PAIR) {
            return CompletableFuture.completedFuture(Pair.create((Object)ssh, null));
        }
        return AsyncUtil.supplyAsync(() -> CompletableFuture.completedFuture(DatabaseSshTunnelEstablisher.getSshAuth(credentialsStore, dataSource)), AsyncUtil.POOL_EXECUTOR);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 27: 
            case 28: 
            case 37: 
            case 38: 
            case 39: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 27: 
            case 28: 
            case 37: 
            case 38: 
            case 39: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 35: 
            case 42: 
            case 45: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 41: 
            case 44: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "credentialsStore";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 27: 
            case 28: 
            case 37: 
            case 38: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/DatabaseSshTunnelEstablisher";
                break;
            }
            case 12: 
            case 14: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostPort";
                break;
            }
            case 13: 
            case 15: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ssh";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostConfig";
                break;
            }
            case 34: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dc";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/DatabaseSshTunnelEstablisher";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createTunnel";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "createSshSessionWithRetries";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "createSshSession";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "tildeExpandFilename";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "askSshCredentialsWhenFailed";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createTunnelSync";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createTunnel";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 27: 
            case 28: 
            case 37: 
            case 38: 
            case 39: {
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getAddLocalPortTunnel";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getNewTunnelPort";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findExistingPort";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findExistingForwarding";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "createSshSession";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "tildeExpandFilename";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "usePortFromOpenSSHConfig";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "useUserFromOpenSSHConfig";
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "askSshCredentialsWhenFailed";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "askNoSshCredentials";
                break;
            }
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getInitialSshCredentials";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getSshAuth";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getSshAuthAsync";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 27: 
            case 28: 
            case 37: 
            case 38: 
            case 39: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

