/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseDriverImpl;
import com.intellij.database.dataSource.DatabaseDriverManagerImpl;
import com.intellij.facet.frameworks.LibrariesDownloadConnectionService;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.util.Consumer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.download.DownloadableFileDescription;
import com.intellij.util.download.DownloadableFileService;
import com.intellij.util.download.DownloadableFileSetDescription;
import com.intellij.util.download.FileDownloader;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.text.VersionComparatorUtil;
import com.intellij.util.ui.classpath.SimpleClasspathElement;
import com.intellij.util.ui.classpath.SimpleClasspathElementFactory;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseArtifactManager {
    private static final Logger LOG = Logger.getInstance(DatabaseArtifactManager.class);
    public static final String VERSION_LATEST = "latest";
    private static final String MYSQL_5_VERSION_LATEST = "latest.mysql.5";
    private static final String LATEST_DISPLAY_TEXT = "Latest";
    private static final String MYSQL_5_DRIVER_ID = "mysql";
    private static final String MYSQL_5_ARTIFACT = "MySQL Connector/J";
    private static final String MYSQL_8_ARTIFACT_ID = "MySQL Connector/J 8";
    private static final String ARTIFACTS_XML = "jdbc-drivers.xml";
    private static final DatabaseArtifactManager INSTANCE = new DatabaseArtifactManager();
    private static final int UPDATE_LIST_TIMEOUT_MS = 86400000;
    private volatile DatabaseArtifactList myArtifactList = DatabaseArtifactList.EMPTY;
    private final EventDispatcher<ArtifactListener> myDispatcher = EventDispatcher.create(ArtifactListener.class);
    private boolean myLoaded = true;
    private Long myLastUpdate = null;
    private final Object myFileLock = new Object();
    private final Object myLock = new Object();

    public static DatabaseArtifactManager getInstance() {
        return INSTANCE;
    }

    public static DatabaseArtifactList getArtifacts() {
        return DatabaseArtifactManager.getInstance().getArtifactList();
    }

    private DatabaseArtifactManager() {
        Application app = ApplicationManager.getApplication();
        if (app.isUnitTestMode()) {
            this.loadArtifacts(false);
            return;
        }
        File file = DatabaseArtifactManager.getLocalArtifactListPath();
        app.executeOnPooledThread(() -> this.loadArtifacts(file.exists()));
    }

    private void loadArtifacts(boolean localOnly) {
        if (!localOnly) {
            this.loadArtifactsList();
        }
        this.loadLocalArtifactsList();
    }

    @NotNull
    public DatabaseArtifactList getArtifactList() {
        this.checkForUpdates();
        DatabaseArtifactList databaseArtifactList = this.myArtifactList;
        if (databaseArtifactList == null) {
            DatabaseArtifactManager.$$$reportNull$$$0(0);
        }
        return databaseArtifactList;
    }

    public static boolean isLatest(@Nullable String version) {
        return VERSION_LATEST.equals(version);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkForUpdates() {
        boolean notLoaded;
        boolean outdated;
        Application app = ApplicationManager.getApplication();
        if (app == null || app.isUnitTestMode()) {
            return;
        }
        Object object = this.myLock;
        synchronized (object) {
            outdated = this.isOutdated();
            if (outdated) {
                this.setLastUpdate(System.currentTimeMillis());
            }
            notLoaded = !outdated && !this.myLoaded;
            this.myLoaded = true;
        }
        if (outdated) {
            this.updateLists();
        } else if (notLoaded) {
            this.initLocal();
            this.listLoaded();
        }
    }

    private void initLocal() {
        try {
            ApplicationManager.getApplication().executeOnPooledThread(() -> this.loadLocalArtifactsList()).get();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (ExecutionException e) {
            LOG.error((Throwable)e);
        }
    }

    private void updateLists() {
        this.setLastUpdate(System.currentTimeMillis());
        new Task.Backgroundable(null, "Update Database Drivers List", false){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                indicator.setText("Loading database drivers list...");
                DatabaseArtifactManager.this.loadRemoteArtifactList();
                DatabaseArtifactManager.this.initLocal();
                DatabaseArtifactManager.this.listLoaded();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/dataSource/DatabaseArtifactManager$1", "run"));
            }
        }.queue();
    }

    private void listLoaded() {
        ApplicationManager.getApplication().invokeLater(() -> this.fireChanged(null, null));
    }

    private boolean isOutdated() {
        if (this.myLastUpdate == null) {
            File path = DatabaseArtifactManager.getLocalArtifactListPath();
            if (path.exists()) {
                this.myLastUpdate = path.lastModified();
            } else {
                return true;
            }
        }
        return System.currentTimeMillis() - this.myLastUpdate > 86400000L;
    }

    private void loadRemoteArtifactList() {
        this.loadArtifactsList();
        this.loadLocalArtifactsList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadLocalArtifactsList() {
        File listFile = DatabaseArtifactManager.getLocalArtifactListPath();
        DatabaseArtifactList list = new DatabaseArtifactList(new URL[0]);
        Exception wentWrong = null;
        boolean remoteLoadFailed = false;
        Object object = this.myFileLock;
        synchronized (object) {
            if (listFile.exists()) {
                try {
                    list.loadList(listFile.toURI().toURL());
                }
                catch (Exception e) {
                    wentWrong = e;
                }
                remoteLoadFailed = list.getArtifacts().isEmpty();
            }
            for (URL builtin : DatabaseArtifactManager.getBuiltinArtifactLists()) {
                try {
                    list.loadList(builtin);
                }
                catch (Exception e) {
                    LOG.warn("Unable to load " + builtin.toString(), (Throwable)e);
                }
            }
        }
        if (remoteLoadFailed) {
            LOG.warn("Unable to load " + listFile.getName() + ". Will delete", (Throwable)wentWrong);
            FileUtil.delete((File)listFile);
            object = this.myLock;
            synchronized (object) {
                this.myLoaded = false;
                this.setLastUpdate(System.currentTimeMillis() - 86400000L + 300000L);
            }
        }
        this.myArtifactList = list;
        TransactionGuard.submitTransaction((Disposable)ApplicationManager.getApplication(), () -> this.fireChanged(null, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setLastUpdate(Long lastUpdate) {
        Object object = this.myLock;
        synchronized (object) {
            this.myLastUpdate = lastUpdate;
        }
    }

    private void loadArtifactsList() {
        File file = DatabaseArtifactManager.getLocalArtifactListPath();
        boolean tests = ApplicationManager.getApplication().isUnitTestMode();
        if (!tests) {
            this.loadProvidedArtifactList(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadProvidedArtifactList(File file) {
        String remoteUrl = DatabaseArtifactManager.createVersionsUrl();
        if (remoteUrl != null) {
            try {
                byte[] text2 = HttpRequests.request((String)remoteUrl).readBytes(ProgressIndicatorProvider.getGlobalProgressIndicator());
                Object object = this.myFileLock;
                synchronized (object) {
                    FileUtil.writeToFile((File)file, (byte[])text2);
                }
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
            }
        }
    }

    public static List<URL> getBuiltinArtifactLists() {
        return DatabaseDriverManagerImpl.ConfigUrlBean.getUrls(DatabaseArtifactList.CONFIG_EP.getExtensionsIfPointIsRegistered());
    }

    @Nullable
    private static String createVersionsUrl() {
        String serviceUrl = LibrariesDownloadConnectionService.getInstance().getServiceUrl();
        return StringUtil.isNotEmpty((String)serviceUrl) ? serviceUrl + "/jdbc-drivers/" : null;
    }

    @NotNull
    private static File getLocalArtifactListPath() {
        File file = new File(DatabaseDriverImpl.getDownloadPath(), ARTIFACTS_XML);
        if (file == null) {
            DatabaseArtifactManager.$$$reportNull$$$0(1);
        }
        return file;
    }

    public void addListener(@NotNull ArtifactListener listener, @Nullable Disposable parent2) {
        if (listener == null) {
            DatabaseArtifactManager.$$$reportNull$$$0(2);
        }
        if (parent2 != null) {
            this.myDispatcher.addListener((EventListener)listener, parent2);
        } else {
            this.myDispatcher.addListener((EventListener)listener);
        }
    }

    private void fireChanged(@Nullable String name2, @Nullable String version) {
        ((ArtifactListener)this.myDispatcher.getMulticaster()).artifactChanged(name2, version);
    }

    @NotNull
    private static File getArtifactDir(@NotNull String name2, @NotNull String version) {
        if (name2 == null) {
            DatabaseArtifactManager.$$$reportNull$$$0(3);
        }
        if (version == null) {
            DatabaseArtifactManager.$$$reportNull$$$0(4);
        }
        File file = new File(new File(DatabaseDriverImpl.getDownloadPath(), name2), version);
        if (file == null) {
            DatabaseArtifactManager.$$$reportNull$$$0(5);
        }
        return file;
    }

    public void downloadArtifact(@NotNull String name2, @NotNull String version, @Nullable Consumer<? super DownloadableFileSetDescription> onFinish) throws IOException {
        DownloadableFileSetDescription download;
        if (name2 == null) {
            DatabaseArtifactManager.$$$reportNull$$$0(6);
        }
        if (version == null) {
            DatabaseArtifactManager.$$$reportNull$$$0(7);
        }
        if ((download = this.myArtifactList.getArtifact(name2, version)) == null) {
            return;
        }
        this.myArtifactList.downloadArtifact(download);
        ApplicationManager.getApplication().invokeLater(() -> {
            if (onFinish != null) {
                onFinish.consume((Object)download);
            }
            this.fireChanged(name2, download.getVersionString());
        });
    }

    @NotNull
    public static List<SimpleClasspathElement> getClasspathElements(@NotNull String name2, @NotNull String version) {
        File[] files;
        if (name2 == null) {
            DatabaseArtifactManager.$$$reportNull$$$0(8);
        }
        if (version == null) {
            DatabaseArtifactManager.$$$reportNull$$$0(9);
        }
        if (VERSION_LATEST.equals(version)) {
            throw new AssertionError((Object)"Should be concrete version");
        }
        File dir = DatabaseArtifactManager.getArtifactDir(name2, version);
        File[] fileArray = files = dir.exists() ? dir.listFiles() : null;
        if (files == null) {
            List<SimpleClasspathElement> list = Collections.emptyList();
            if (list == null) {
                DatabaseArtifactManager.$$$reportNull$$$0(10);
            }
            return list;
        }
        String[] urls = new String[files.length];
        for (int i2 = 0; i2 < files.length; ++i2) {
            urls[i2] = VfsUtilCore.pathToUrl((String)files[i2].getPath());
        }
        List list = SimpleClasspathElementFactory.createElements((String[])urls);
        if (list == null) {
            DatabaseArtifactManager.$$$reportNull$$$0(11);
        }
        return list;
    }

    @NotNull
    private static List<String> artifactVersions(@NotNull String artifact) {
        if (artifact == null) {
            DatabaseArtifactManager.$$$reportNull$$$0(12);
        }
        List list = JBIterable.from(DatabaseArtifactManager.getArtifacts().getArtifacts(artifact)).map(DownloadableFileSetDescription::getVersionString).toList();
        if (list == null) {
            DatabaseArtifactManager.$$$reportNull$$$0(13);
        }
        return list;
    }

    @NotNull
    private static String trueKey(@NotNull String key2) {
        if (key2 == null) {
            DatabaseArtifactManager.$$$reportNull$$$0(14);
        }
        String string = StringUtil.equals((CharSequence)MYSQL_8_ARTIFACT_ID, (CharSequence)key2) ? MYSQL_5_ARTIFACT : key2;
        if (string == null) {
            DatabaseArtifactManager.$$$reportNull$$$0(15);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 14: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 14: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/DatabaseArtifactManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 3: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getArtifactList";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalArtifactListPath";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/DatabaseArtifactManager";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getArtifactDir";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getClasspathElements";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "artifactVersions";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "trueKey";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getArtifactDir";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "downloadArtifact";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getClasspathElements";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "artifactVersions";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "trueKey";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 14: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MySQLArtifactDriverPair
    extends SimpleArtifactDriverPair {
        private final DatabaseDriver myDriver;

        MySQLArtifactDriverPair(@NotNull MultiVersionArtifact artifact, @NotNull DatabaseDriver driver) {
            if (artifact == null) {
                MySQLArtifactDriverPair.$$$reportNull$$$0(0);
            }
            if (driver == null) {
                MySQLArtifactDriverPair.$$$reportNull$$$0(1);
            }
            super(artifact);
            this.myDriver = driver;
        }

        @Override
        @NotNull
        public String getName() {
            String string = DatabaseArtifactManager.MYSQL_5_DRIVER_ID.equals(this.myDriver.getId()) ? this.myArtifact.getName() : DatabaseArtifactManager.MYSQL_8_ARTIFACT_ID;
            if (string == null) {
                MySQLArtifactDriverPair.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        @Nullable
        public String latestVersion() {
            if (DatabaseArtifactManager.MYSQL_5_DRIVER_ID.equals(this.myDriver.getId())) {
                return super.latestVersion();
            }
            String latest8 = DatabaseArtifactManager.getArtifacts().getActualVersion(DatabaseArtifactManager.MYSQL_8_ARTIFACT_ID);
            return latest8 == null ? super.latestVersion() : latest8;
        }

        @Override
        @NotNull
        public List<ArtifactVersion> getVersions() {
            List list = JBIterable.from(super.getVersions()).filter(it2 -> it2.isSuitable(this.myDriver)).toList();
            if (list == null) {
                MySQLArtifactDriverPair.$$$reportNull$$$0(3);
            }
            return list;
        }

        @Override
        @Nullable
        public String getExactVersion(@NotNull String text2) {
            if (text2 == null) {
                MySQLArtifactDriverPair.$$$reportNull$$$0(4);
            }
            if (DatabaseArtifactManager.MYSQL_5_VERSION_LATEST.equals(text2)) {
                ArtifactVersion first2 = (ArtifactVersion)ContainerUtil.getFirstItem((List)ContainerUtil.filter(this.digitVersions(), v2 -> StringUtil.startsWith((CharSequence)v2.text, (CharSequence)"5")));
                return first2 == null ? null : first2.text;
            }
            return super.getExactVersion(text2);
        }

        @Override
        @NotNull
        protected List<ArtifactVersion> digitVersions() {
            List list = JBIterable.from((Iterable)ContainerUtil.map((Collection)DatabaseArtifactManager.artifactVersions(DatabaseArtifactManager.MYSQL_8_ARTIFACT_ID), a -> new MySQL8Version(this, (String)a, (String)a, false))).filter(ArtifactVersion.class).append((Iterable)ContainerUtil.map(super.digitVersions(), it2 -> new MySQL5Version((ArtifactVersion)it2))).toList();
            if (list == null) {
                MySQLArtifactDriverPair.$$$reportNull$$$0(5);
            }
            return list;
        }

        @Override
        @NotNull
        protected JBIterable<ArtifactVersion> latestVersions() {
            JBIterable jBIterable = JBIterable.of((Object[])new ArtifactVersion[]{new MySQL8Version(this, DatabaseArtifactManager.VERSION_LATEST, DatabaseArtifactManager.LATEST_DISPLAY_TEXT, true), new MySQL5LatestVersion(this)});
            if (jBIterable == null) {
                MySQLArtifactDriverPair.$$$reportNull$$$0(6);
            }
            return jBIterable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "artifact";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "driver";
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/DatabaseArtifactManager$MySQLArtifactDriverPair";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/DatabaseArtifactManager$MySQLArtifactDriverPair";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVersions";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "digitVersions";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "latestVersions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 6: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getExactVersion";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class SimpleArtifactDriverPair
    implements ArtifactWithDriver {
        protected final MultiVersionArtifact myArtifact;

        SimpleArtifactDriverPair(@NotNull MultiVersionArtifact artifact) {
            if (artifact == null) {
                SimpleArtifactDriverPair.$$$reportNull$$$0(0);
            }
            this.myArtifact = artifact;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myArtifact.getName();
            if (string == null) {
                SimpleArtifactDriverPair.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        @NotNull
        public MultiVersionArtifact composite() {
            MultiVersionArtifact multiVersionArtifact = this.myArtifact;
            if (multiVersionArtifact == null) {
                SimpleArtifactDriverPair.$$$reportNull$$$0(2);
            }
            return multiVersionArtifact;
        }

        @Override
        @Nullable
        public String latestVersion() {
            return DatabaseArtifactManager.getArtifacts().getActualVersion(this.myArtifact.getName());
        }

        @Override
        @NotNull
        public List<ArtifactVersion> getVersions() {
            List list = this.latestVersions().append(this.digitVersions()).toList();
            if (list == null) {
                SimpleArtifactDriverPair.$$$reportNull$$$0(3);
            }
            return list;
        }

        @NotNull
        protected List<ArtifactVersion> digitVersions() {
            List list = ContainerUtil.map((Collection)DatabaseArtifactManager.artifactVersions(this.myArtifact.getName()), v2 -> new ArtifactVersion(this, (String)v2, (String)v2, false));
            if (list == null) {
                SimpleArtifactDriverPair.$$$reportNull$$$0(4);
            }
            return list;
        }

        @NotNull
        protected JBIterable<ArtifactVersion> latestVersions() {
            JBIterable jBIterable = JBIterable.of((Object)new ArtifactVersion(this, DatabaseArtifactManager.VERSION_LATEST, DatabaseArtifactManager.LATEST_DISPLAY_TEXT, true));
            if (jBIterable == null) {
                SimpleArtifactDriverPair.$$$reportNull$$$0(5);
            }
            return jBIterable;
        }

        @Nullable
        public String getExactVersion(@NotNull String text2) {
            if (text2 == null) {
                SimpleArtifactDriverPair.$$$reportNull$$$0(6);
            }
            if (DatabaseArtifactManager.isLatest(text2)) {
                ArtifactVersion version = (ArtifactVersion)ContainerUtil.getFirstItem(this.digitVersions());
                return version == null ? null : version.text;
            }
            return text2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "artifact";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/DatabaseArtifactManager$SimpleArtifactDriverPair";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/DatabaseArtifactManager$SimpleArtifactDriverPair";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "composite";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVersions";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "digitVersions";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "latestVersions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getExactVersion";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MySQLCompositeArtifact
    extends MultiVersionArtifact {
        MySQLCompositeArtifact(@NotNull String name2) {
            if (name2 == null) {
                MySQLCompositeArtifact.$$$reportNull$$$0(0);
            }
            super(name2);
        }

        @Override
        @NotNull
        public String getNameAt(@NotNull String version) {
            if (version == null) {
                MySQLCompositeArtifact.$$$reportNull$$$0(1);
            }
            String string = DatabaseArtifactManager.isLatest(version) || StringUtil.startsWith((CharSequence)version, (CharSequence)"8") ? DatabaseArtifactManager.MYSQL_8_ARTIFACT_ID : super.getNameAt(version);
            if (string == null) {
                MySQLCompositeArtifact.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        @NotNull
        public ArtifactWithDriver coupleWith(@NotNull DatabaseDriver driver) {
            if (driver == null) {
                MySQLCompositeArtifact.$$$reportNull$$$0(3);
            }
            MySQLArtifactDriverPair mySQLArtifactDriverPair = new MySQLArtifactDriverPair(this, driver);
            if (mySQLArtifactDriverPair == null) {
                MySQLCompositeArtifact.$$$reportNull$$$0(4);
            }
            return mySQLArtifactDriverPair;
        }

        @Override
        @Nullable
        public CompositeArtifact findSelfIn(@NotNull List<CompositeArtifact> artifacts) {
            if (artifacts == null) {
                MySQLCompositeArtifact.$$$reportNull$$$0(5);
            }
            return (CompositeArtifact)ContainerUtil.find(artifacts, it2 -> it2 instanceof MySQLCompositeArtifact);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "version";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/DatabaseArtifactManager$MySQLCompositeArtifact";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "driver";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "artifacts";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/DatabaseArtifactManager$MySQLCompositeArtifact";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNameAt";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "coupleWith";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getNameAt";
                    break;
                }
                case 2: 
                case 4: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "coupleWith";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "findSelfIn";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MultiVersionArtifact
    implements CompositeArtifact {
        protected final String myName;

        MultiVersionArtifact(@NotNull String name2) {
            if (name2 == null) {
                MultiVersionArtifact.$$$reportNull$$$0(0);
            }
            this.myName = name2;
        }

        @Override
        @NotNull
        public String getNameAt(@NotNull String version) {
            if (version == null) {
                MultiVersionArtifact.$$$reportNull$$$0(1);
            }
            String string = this.getName();
            if (string == null) {
                MultiVersionArtifact.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        @NotNull
        public ArtifactWithDriver coupleWith(@NotNull DatabaseDriver driver) {
            if (driver == null) {
                MultiVersionArtifact.$$$reportNull$$$0(3);
            }
            SimpleArtifactDriverPair simpleArtifactDriverPair = new SimpleArtifactDriverPair(this);
            if (simpleArtifactDriverPair == null) {
                MultiVersionArtifact.$$$reportNull$$$0(4);
            }
            return simpleArtifactDriverPair;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                MultiVersionArtifact.$$$reportNull$$$0(5);
            }
            return string;
        }

        @Override
        @Nullable
        public CompositeArtifact findSelfIn(@NotNull List<CompositeArtifact> artifacts) {
            if (artifacts == null) {
                MultiVersionArtifact.$$$reportNull$$$0(6);
            }
            return (CompositeArtifact)ContainerUtil.find(artifacts, (Object)this);
        }

        public int hashCode() {
            return Objects.hash(this.myName);
        }

        public boolean equals(Object obj2) {
            if (!(obj2 instanceof MultiVersionArtifact)) {
                return false;
            }
            MultiVersionArtifact another = (MultiVersionArtifact)obj2;
            return Comparing.equal((String)this.myName, (String)another.myName);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "version";
                    break;
                }
                case 2: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/DatabaseArtifactManager$MultiVersionArtifact";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "driver";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "artifacts";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/DatabaseArtifactManager$MultiVersionArtifact";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNameAt";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "coupleWith";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getNameAt";
                    break;
                }
                case 2: 
                case 4: 
                case 5: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "coupleWith";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "findSelfIn";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MySQL5LatestVersion
    extends MySQL5Version {
        MySQL5LatestVersion(@NotNull MySQLArtifactDriverPair artifact) {
            if (artifact == null) {
                MySQL5LatestVersion.$$$reportNull$$$0(0);
            }
            super(artifact, DatabaseArtifactManager.MYSQL_5_VERSION_LATEST, "Latest 5", true);
        }

        @Override
        @NotNull
        public String displayText() {
            String string = DatabaseArtifactManager.MYSQL_5_DRIVER_ID.equals(((MySQLArtifactDriverPair)this.myPair).myDriver.getId()) ? DatabaseArtifactManager.LATEST_DISPLAY_TEXT : super.displayText();
            if (string == null) {
                MySQL5LatestVersion.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "artifact";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/DatabaseArtifactManager$MySQL5LatestVersion";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/DatabaseArtifactManager$MySQL5LatestVersion";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "displayText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MySQL8Version
    extends ArtifactVersion {
        MySQL8Version(@NotNull SimpleArtifactDriverPair artifact, @NotNull String text2, @NotNull String displayText, boolean isLatest) {
            if (artifact == null) {
                MySQL8Version.$$$reportNull$$$0(0);
            }
            if (text2 == null) {
                MySQL8Version.$$$reportNull$$$0(1);
            }
            if (displayText == null) {
                MySQL8Version.$$$reportNull$$$0(2);
            }
            super(artifact, text2, displayText, isLatest);
        }

        @Override
        public boolean isSuitable(@Nullable DatabaseDriver driver) {
            return driver == null || !DatabaseArtifactManager.MYSQL_5_DRIVER_ID.equals(driver.getId());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "artifact";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "text";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "displayText";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/dataSource/DatabaseArtifactManager$MySQL8Version";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MySQL5Version
    extends ArtifactVersion {
        MySQL5Version(@NotNull ArtifactVersion version) {
            if (version == null) {
                MySQL5Version.$$$reportNull$$$0(0);
            }
            this((MySQLArtifactDriverPair)version.myPair, version.text, version.myDisplayText, version.myLatest);
        }

        MySQL5Version(@NotNull MySQLArtifactDriverPair artifact, @NotNull String text2, @NotNull String displayText, boolean isLatest) {
            if (artifact == null) {
                MySQL5Version.$$$reportNull$$$0(1);
            }
            if (text2 == null) {
                MySQL5Version.$$$reportNull$$$0(2);
            }
            if (displayText == null) {
                MySQL5Version.$$$reportNull$$$0(3);
            }
            super(artifact, text2, displayText, isLatest);
        }

        @Override
        public boolean isLatest() {
            return this.myLatest && DatabaseArtifactManager.MYSQL_5_DRIVER_ID.equals(((MySQLArtifactDriverPair)this.myPair).myDriver.getId());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "version";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "artifact";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "text";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "displayText";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/dataSource/DatabaseArtifactManager$MySQL5Version";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class ArtifactVersion {
        public final String text;
        protected final SimpleArtifactDriverPair myPair;
        private final String myDisplayText;
        protected boolean myLatest;

        private ArtifactVersion(@NotNull SimpleArtifactDriverPair pair, @NotNull String text2, @NotNull String displayText, boolean isLatest) {
            if (pair == null) {
                ArtifactVersion.$$$reportNull$$$0(0);
            }
            if (text2 == null) {
                ArtifactVersion.$$$reportNull$$$0(1);
            }
            if (displayText == null) {
                ArtifactVersion.$$$reportNull$$$0(2);
            }
            this.myPair = pair;
            this.myLatest = isLatest;
            this.myDisplayText = displayText;
            this.text = text2;
        }

        @NotNull
        public CompositeArtifact getArtifact() {
            MultiVersionArtifact multiVersionArtifact = this.myPair.composite();
            if (multiVersionArtifact == null) {
                ArtifactVersion.$$$reportNull$$$0(3);
            }
            return multiVersionArtifact;
        }

        public boolean isSuitable(@NotNull DatabaseDriver driver) {
            if (driver == null) {
                ArtifactVersion.$$$reportNull$$$0(4);
            }
            return true;
        }

        public boolean isLatest() {
            return this.myLatest;
        }

        @NotNull
        public String displayText() {
            String string = this.myDisplayText;
            if (string == null) {
                ArtifactVersion.$$$reportNull$$$0(5);
            }
            return string;
        }

        @Nullable
        public String getExactVersion() {
            return this.myPair.getExactVersion(this.text);
        }

        @NotNull
        public String getExactName() {
            String string = this.myPair.composite().getNameAt(this.text);
            if (string == null) {
                ArtifactVersion.$$$reportNull$$$0(6);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 5: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 5: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pair";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "displayText";
                    break;
                }
                case 3: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/DatabaseArtifactManager$ArtifactVersion";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "driver";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/DatabaseArtifactManager$ArtifactVersion";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getArtifact";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "displayText";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getExactName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 5: 
                case 6: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "isSuitable";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 5: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static interface ArtifactWithDriver
    extends VirtualArtifact {
        @NotNull
        public CompositeArtifact composite();

        @NotNull
        public List<ArtifactVersion> getVersions();

        @Nullable
        public String latestVersion();
    }

    public static interface CompositeArtifact
    extends VirtualArtifact {
        @NotNull
        public ArtifactWithDriver coupleWith(@NotNull DatabaseDriver var1);

        @NotNull
        public String getNameAt(@NotNull String var1);

        @Nullable
        public CompositeArtifact findSelfIn(@NotNull List<CompositeArtifact> var1);
    }

    public static interface VirtualArtifact {
        @NotNull
        public String getName();
    }

    public static class DatabaseArtifactList {
        public static final DatabaseArtifactList EMPTY = new DatabaseArtifactList(new URL[0]);
        private final MultiMap<String, DownloadableFileSetDescription> myArtifacts;
        public static final ExtensionPointName<DatabaseDriverManagerImpl.ConfigUrlBean> CONFIG_EP = ExtensionPointName.create((String)"com.intellij.database.artifactsConfig");

        public DatabaseArtifactList(URL ... urls) {
            if (urls == null) {
                DatabaseArtifactList.$$$reportNull$$$0(0);
            }
            this.myArtifacts = new MultiMap<String, DownloadableFileSetDescription>(){

                @NotNull
                protected Collection<DownloadableFileSetDescription> createCollection() {
                    TreeSet<DownloadableFileSetDescription> treeSet = new TreeSet<DownloadableFileSetDescription>((d1, d2) -> -VersionComparatorUtil.compare((String)d1.getVersionString(), (String)d2.getVersionString()));
                    if (treeSet == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return treeSet;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseArtifactManager$DatabaseArtifactList$1", "createCollection"));
                }
            };
            for (URL url : urls) {
                this.loadList(url);
            }
        }

        @Nullable
        private DownloadableFileSetDescription getArtifactLatest(@NotNull String name2) {
            if (name2 == null) {
                DatabaseArtifactList.$$$reportNull$$$0(1);
            }
            return DatabaseArtifactList.latest(this.getArtifacts(name2));
        }

        @Nullable
        public DownloadableFileSetDescription getArtifact(@NotNull String name2, @NotNull String version) {
            if (name2 == null) {
                DatabaseArtifactList.$$$reportNull$$$0(2);
            }
            if (version == null) {
                DatabaseArtifactList.$$$reportNull$$$0(3);
            }
            if (DatabaseArtifactManager.isLatest(version)) {
                return this.getArtifactLatest(name2);
            }
            for (DownloadableFileSetDescription description : this.getArtifacts(name2)) {
                if (!version.equals(description.getVersionString())) continue;
                return description;
            }
            return null;
        }

        @NotNull
        public Collection<DownloadableFileSetDescription> getArtifacts(@NotNull String name2) {
            if (name2 == null) {
                DatabaseArtifactList.$$$reportNull$$$0(4);
            }
            Collection collection = this.myArtifacts.get((Object)name2);
            if (collection == null) {
                DatabaseArtifactList.$$$reportNull$$$0(5);
            }
            return collection;
        }

        @Nullable
        private static <T> T latest(@Nullable Collection<T> col) {
            return (T)ContainerUtil.getFirstItem(col);
        }

        @NotNull
        public List<DownloadableFileSetDescription> getArtifacts() {
            ArrayList<DownloadableFileSetDescription> arrayList = new ArrayList<DownloadableFileSetDescription>(this.myArtifacts.values());
            if (arrayList == null) {
                DatabaseArtifactList.$$$reportNull$$$0(6);
            }
            return arrayList;
        }

        @NotNull
        public List<CompositeArtifact> getCompositeArtifacts() {
            List list = JBIterable.from((Iterable)this.myArtifacts.keySet()).unique(x$0 -> DatabaseArtifactManager.trueKey(x$0)).map(a -> this.getCompositeArtifact((String)a)).toList();
            if (list == null) {
                DatabaseArtifactList.$$$reportNull$$$0(7);
            }
            return list;
        }

        @NotNull
        public CompositeArtifact getCompositeArtifact(@NotNull String artifact) {
            if (artifact == null) {
                DatabaseArtifactList.$$$reportNull$$$0(8);
            }
            String trueArtifact = DatabaseArtifactManager.trueKey(artifact);
            MultiVersionArtifact multiVersionArtifact = artifact.startsWith(DatabaseArtifactManager.MYSQL_5_ARTIFACT) ? new MySQLCompositeArtifact(trueArtifact) : new MultiVersionArtifact(trueArtifact);
            if (multiVersionArtifact == null) {
                DatabaseArtifactList.$$$reportNull$$$0(9);
            }
            return multiVersionArtifact;
        }

        @Nullable
        public String getActualVersion(@NotNull String name2) {
            DownloadableFileSetDescription artifact;
            if (name2 == null) {
                DatabaseArtifactList.$$$reportNull$$$0(10);
            }
            return (artifact = this.getArtifactLatest(name2)) == null ? null : artifact.getVersionString();
        }

        public boolean isValid(@NotNull String name2, @NotNull String version) {
            DownloadableFileSetDescription desc;
            if (name2 == null) {
                DatabaseArtifactList.$$$reportNull$$$0(11);
            }
            if (version == null) {
                DatabaseArtifactList.$$$reportNull$$$0(12);
            }
            if ((desc = this.getArtifact(name2, version)) != null) {
                return DatabaseArtifactList.isValidFileList(name2, desc);
            }
            return DatabaseArtifactManager.getArtifactDir(name2, version).exists();
        }

        public boolean isFreshFiles(@NotNull String name2, @NotNull String version, @NotNull Set<String> fileNames) {
            DownloadableFileSetDescription desc;
            if (name2 == null) {
                DatabaseArtifactList.$$$reportNull$$$0(13);
            }
            if (version == null) {
                DatabaseArtifactList.$$$reportNull$$$0(14);
            }
            if (fileNames == null) {
                DatabaseArtifactList.$$$reportNull$$$0(15);
            }
            return (desc = this.getArtifact(name2, version)) == null || DatabaseArtifactList.isAllDownloaded(desc, fileNames);
        }

        public static boolean isValidFileList(@NotNull String name2, @NotNull DownloadableFileSetDescription desc) {
            File dir;
            if (name2 == null) {
                DatabaseArtifactList.$$$reportNull$$$0(16);
            }
            if (desc == null) {
                DatabaseArtifactList.$$$reportNull$$$0(17);
            }
            if (!(dir = DatabaseArtifactManager.getArtifactDir(name2, desc.getVersionString())).exists()) {
                return false;
            }
            return DatabaseArtifactList.isAllDownloaded(desc, JBIterable.of((Object[])dir.listFiles()).map(o -> o.getName()).toSet());
        }

        private static boolean isAllDownloaded(@NotNull DownloadableFileSetDescription desc, Set<String> existing) {
            if (desc == null) {
                DatabaseArtifactList.$$$reportNull$$$0(18);
            }
            for (DownloadableFileDescription file : desc.getFiles()) {
                if (file.getDefaultFileName().endsWith(".txt") || existing.contains(file.getDefaultFileName())) continue;
                return false;
            }
            return true;
        }

        public void downloadArtifact(@NotNull DownloadableFileSetDescription download) throws IOException {
            if (download == null) {
                DatabaseArtifactList.$$$reportNull$$$0(19);
            }
            File dir = DatabaseArtifactManager.getArtifactDir(download.getName(), download.getVersionString());
            FileDownloader downloader = DownloadableFileService.getInstance().createDownloader(download);
            downloader.download(dir);
        }

        private void loadList(@NotNull URL url) {
            if (url == null) {
                DatabaseArtifactList.$$$reportNull$$$0(20);
            }
            List versions = DownloadableFileService.getInstance().createFileSetVersions(null, new URL[]{url}).fetchVersions();
            for (DownloadableFileSetDescription version : versions) {
                if (!SystemInfo.isWindows) {
                    version.getFiles().removeIf(d2 -> d2.getPresentableFileName().contains("win"));
                }
                this.myArtifacts.putValue((Object)version.getName(), (Object)version);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 9: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 9: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "urls";
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 10: 
                case 11: 
                case 13: 
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 3: 
                case 12: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "version";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/DatabaseArtifactManager$DatabaseArtifactList";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "artifact";
                    break;
                }
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileNames";
                    break;
                }
                case 17: 
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "desc";
                    break;
                }
                case 19: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "download";
                    break;
                }
                case 20: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "url";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/DatabaseArtifactManager$DatabaseArtifactList";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getArtifacts";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCompositeArtifacts";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCompositeArtifact";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getArtifactLatest";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getArtifact";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getArtifacts";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 9: {
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "getCompositeArtifact";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "getActualVersion";
                    break;
                }
                case 11: 
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "isValid";
                    break;
                }
                case 13: 
                case 14: 
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "isFreshFiles";
                    break;
                }
                case 16: 
                case 17: {
                    objectArray = objectArray;
                    objectArray[2] = "isValidFileList";
                    break;
                }
                case 18: {
                    objectArray = objectArray;
                    objectArray[2] = "isAllDownloaded";
                    break;
                }
                case 19: {
                    objectArray = objectArray;
                    objectArray[2] = "downloadArtifact";
                    break;
                }
                case 20: {
                    objectArray = objectArray;
                    objectArray[2] = "loadList";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 9: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static interface ArtifactListener
    extends EventListener {
        public void artifactChanged(String var1, String var2);
    }
}

