/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console;

import com.intellij.database.console.DataSourceInfoTool;
import com.intellij.database.console.DatabaseServiceViewDeleteElementProvider;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.client.DatabaseSessionClientWithFile;
import com.intellij.database.console.client.SessionClientHolder;
import com.intellij.database.console.client.VisibleDatabaseSessionClient;
import com.intellij.database.console.session.DatabaseClientLogView;
import com.intellij.database.console.session.DatabaseLogView;
import com.intellij.database.console.session.DatabaseLogViewService;
import com.intellij.database.console.session.DatabaseSession;
import com.intellij.database.console.session.DatabaseSessionLogView;
import com.intellij.database.console.session.DatabaseSessionManager;
import com.intellij.database.console.session.DatabaseSessionManagerListener;
import com.intellij.database.console.session.DatabaseSessionStateListener;
import com.intellij.database.console.session.SessionsUtil;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbDataSourceImpl;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPresentation;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbUIUtil;
import com.intellij.database.vfs.DatabaseElementVirtualFileImpl;
import com.intellij.database.view.DatabaseColorManager;
import com.intellij.database.view.DatabaseStructure;
import com.intellij.database.view.DatabaseView;
import com.intellij.database.view.DatabaseViewOptions;
import com.intellij.execution.services.ServiceEventListener;
import com.intellij.execution.services.ServiceViewAlwaysEnabledContributor;
import com.intellij.execution.services.ServiceViewDescriptor;
import com.intellij.execution.services.ServiceViewFileEditorContributor;
import com.intellij.execution.services.ServiceViewGroupingContributor;
import com.intellij.execution.services.ServiceViewManager;
import com.intellij.execution.services.ServiceViewNonActivatingDescriptor;
import com.intellij.execution.services.ServiceViewOptions;
import com.intellij.execution.services.ServiceViewProvidingContributor;
import com.intellij.execution.services.SimpleServiceViewDescriptor;
import com.intellij.ide.DataManager;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ColoredItem;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.Gray;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TextIcon;
import com.intellij.ui.content.Content;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import icons.DatabaseIcons;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class DatabaseServiceViewContributor
implements ServiceViewGroupingContributor<SessionContributor, PsiElement>,
ServiceViewFileEditorContributor<SessionContributor>,
Comparator<SessionContributor>,
ServiceViewAlwaysEnabledContributor {
    private static final ServiceViewDescriptor CONTRIBUTOR_DESCRIPTOR = new DatabaseContributorDescriptor();
    private static final Alarm ourStateChangedAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);

    public static void listenSessions() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        MessageBusConnection connection2 = ApplicationManager.getApplication().getMessageBus().connect();
        connection2.subscribe(DatabaseSessionManager.getTopic(), (Object)new SessionsListener());
        connection2.subscribe(DatabaseSession.getTopic(), (Object)new SessionStateListener());
    }

    public static void refreshView(@NotNull Project project) {
        if (project == null) {
            DatabaseServiceViewContributor.$$$reportNull$$$0(0);
        }
        DbUIUtil.invokeLaterIfNeeded(() -> {
            ServiceEventListener listener = DatabaseServiceViewContributor.listener(project);
            listener.handle(ServiceEventListener.ServiceEvent.createEvent((ServiceEventListener.EventType)ServiceEventListener.EventType.RESET, (Object)ObjectUtils.NULL, DatabaseServiceViewContributor.class));
        });
    }

    @NotNull
    public ServiceViewDescriptor getViewDescriptor() {
        ServiceViewDescriptor serviceViewDescriptor = CONTRIBUTOR_DESCRIPTOR;
        if (serviceViewDescriptor == null) {
            DatabaseServiceViewContributor.$$$reportNull$$$0(1);
        }
        return serviceViewDescriptor;
    }

    @NotNull
    public List<SessionContributor> getServices(@NotNull Project project) {
        if (project == null) {
            DatabaseServiceViewContributor.$$$reportNull$$$0(2);
        }
        List list = ContainerUtil.map(DatabaseSessionManager.getSessions(project), SessionContributor::new);
        if (list == null) {
            DatabaseServiceViewContributor.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    public ServiceViewDescriptor getServiceDescriptor(@NotNull SessionContributor service) {
        if (service == null) {
            DatabaseServiceViewContributor.$$$reportNull$$$0(4);
        }
        SessionViewDescriptor sessionViewDescriptor = new SessionViewDescriptor(service.asService());
        if (sessionViewDescriptor == null) {
            DatabaseServiceViewContributor.$$$reportNull$$$0(5);
        }
        return sessionViewDescriptor;
    }

    @Override
    public int compare(SessionContributor o1, SessionContributor o2) {
        DatabaseSession session1 = o1.asService();
        DatabaseSession session2 = o2.asService();
        List<DatabaseSession> sessions = DatabaseSessionManager.getSessions(session1.getProject());
        return sessions.indexOf(session1) - sessions.indexOf(session2);
    }

    @NotNull
    public List<PsiElement> getGroups(@NotNull SessionContributor service) {
        if (service == null) {
            DatabaseServiceViewContributor.$$$reportNull$$$0(6);
        }
        DatabaseSession session2 = service.asService();
        Project project = session2.getProject();
        ArrayList<DbDataSource> result2 = new ArrayList<DbDataSource>();
        DatabaseViewOptions viewOptions = DatabaseView.getDatabaseView(project).getViewOptions();
        DbDataSource group2 = DbImplUtil.getDbDataSource(project, (DasDataSource)session2.getTarget());
        while (group2 != null && !(group2 instanceof DatabaseStructure.DbRootGroup)) {
            result2.add(group2);
            group2 = DatabaseStructure.getParentImpl((PsiElement)group2, viewOptions);
        }
        List list = ContainerUtil.reverse(result2);
        if (list == null) {
            DatabaseServiceViewContributor.$$$reportNull$$$0(7);
        }
        return list;
    }

    @NotNull
    public synchronized ServiceViewDescriptor getGroupDescriptor(@NotNull PsiElement group2) {
        if (group2 == null) {
            DatabaseServiceViewContributor.$$$reportNull$$$0(8);
        }
        Object object = group2 instanceof DbDataSource ? new DbDataSourceViewDescriptor((DbDataSource)group2) : new GroupViewDescriptor(group2);
        if (object == null) {
            DatabaseServiceViewContributor.$$$reportNull$$$0(9);
        }
        return object;
    }

    public SessionContributor findService(@NotNull Project project, @NotNull FileEditor editor) {
        DatabaseSessionClientWithFile client;
        if (project == null) {
            DatabaseServiceViewContributor.$$$reportNull$$$0(10);
        }
        if (editor == null) {
            DatabaseServiceViewContributor.$$$reportNull$$$0(11);
        }
        return (client = DatabaseServiceViewContributor.findClient(project, editor)) == null ? null : new SessionContributor((DatabaseSession)client.getSession());
    }

    @NotNull
    public static Promise<Void> selectNode(@NotNull Project project, @NotNull VisibleDatabaseSessionClient client, boolean activate, boolean requestFocus) {
        if (project == null) {
            DatabaseServiceViewContributor.$$$reportNull$$$0(12);
        }
        if (client == null) {
            DatabaseServiceViewContributor.$$$reportNull$$$0(13);
        }
        if (ServiceManager.getServiceIfCreated((Project)project, ServiceViewManager.class) == null) {
            Promise promise = Promises.rejectedPromise();
            if (promise == null) {
                DatabaseServiceViewContributor.$$$reportNull$$$0(14);
            }
            return promise;
        }
        Promise promise = ServiceViewManager.getInstance((Project)project).select((Object)client, DatabaseServiceViewContributor.class, activate, requestFocus);
        if (promise == null) {
            DatabaseServiceViewContributor.$$$reportNull$$$0(15);
        }
        return promise;
    }

    @NotNull
    public static Promise<Void> selectNode(@NotNull Project project, @NotNull DatabaseSession session2, boolean activate, boolean requestFocus) {
        if (project == null) {
            DatabaseServiceViewContributor.$$$reportNull$$$0(16);
        }
        if (session2 == null) {
            DatabaseServiceViewContributor.$$$reportNull$$$0(17);
        }
        if (ServiceManager.getServiceIfCreated((Project)project, ServiceViewManager.class) == null) {
            Promise promise = Promises.rejectedPromise();
            if (promise == null) {
                DatabaseServiceViewContributor.$$$reportNull$$$0(18);
            }
            return promise;
        }
        Promise promise = ServiceViewManager.getInstance((Project)project).select((Object)session2, DatabaseServiceViewContributor.class, activate, requestFocus);
        if (promise == null) {
            DatabaseServiceViewContributor.$$$reportNull$$$0(19);
        }
        return promise;
    }

    @NotNull
    private static ServiceEventListener listener(@NotNull DatabaseSession session2) {
        if (session2 == null) {
            DatabaseServiceViewContributor.$$$reportNull$$$0(20);
        }
        ServiceEventListener serviceEventListener = DatabaseServiceViewContributor.listener(session2.getProject());
        if (serviceEventListener == null) {
            DatabaseServiceViewContributor.$$$reportNull$$$0(21);
        }
        return serviceEventListener;
    }

    @NotNull
    private static ServiceEventListener listener(@NotNull Project project) {
        if (project == null) {
            DatabaseServiceViewContributor.$$$reportNull$$$0(22);
        }
        ServiceEventListener serviceEventListener = project.isDisposed() ? InactiveListener.INSTANCE : (ServiceEventListener)project.getMessageBus().syncPublisher(ServiceEventListener.TOPIC);
        if (serviceEventListener == null) {
            DatabaseServiceViewContributor.$$$reportNull$$$0(23);
        }
        return serviceEventListener;
    }

    @Nullable
    private static DatabaseSessionClientWithFile findClient(@NotNull Project project, @NotNull FileEditor editor) {
        FileEditorManagerEx manager;
        VirtualFile virtualFile;
        if (project == null) {
            DatabaseServiceViewContributor.$$$reportNull$$$0(24);
        }
        if (editor == null) {
            DatabaseServiceViewContributor.$$$reportNull$$$0(25);
        }
        return (virtualFile = (manager = FileEditorManagerEx.getInstanceEx((Project)project)).getFile(editor)) == null ? null : DatabaseEditorHelper.findClient(virtualFile, (FileEditorManager)manager);
    }

    @NotNull
    private static String formatDuration(boolean inProgress, long time) {
        long timeToFormat = inProgress && time > 3000L ? time / 1000L * 1000L : time;
        String string = StringUtil.formatDuration((long)timeToFormat);
        if (string == null) {
            DatabaseServiceViewContributor.$$$reportNull$$$0(26);
        }
        return string;
    }

    private static void sessionOpened(@NotNull DatabaseSession session2) {
        if (session2 == null) {
            DatabaseServiceViewContributor.$$$reportNull$$$0(27);
        }
        if (session2.isInternal()) {
            return;
        }
        DbUIUtil.invokeLaterIfNeeded(() -> {
            SessionContributor target2 = new SessionContributor(session2);
            ServiceEventListener.ServiceEvent event = ServiceEventListener.ServiceEvent.createServiceAddedEvent((Object)target2, DatabaseServiceViewContributor.class, null);
            DatabaseServiceViewContributor.listener(session2).handle(event);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 21: 
            case 23: 
            case 26: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 21: 
            case 23: 
            case 26: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 21: 
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/console/DatabaseServiceViewContributor";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 11: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "client";
                break;
            }
            case 17: 
            case 20: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/console/DatabaseServiceViewContributor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getViewDescriptor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getServices";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getServiceDescriptor";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroups";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDescriptor";
                break;
            }
            case 14: 
            case 15: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "selectNode";
                break;
            }
            case 21: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "listener";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "formatDuration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "refreshView";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 21: 
            case 23: 
            case 26: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getServices";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getServiceDescriptor";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getGroups";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getGroupDescriptor";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findService";
                break;
            }
            case 12: 
            case 13: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "selectNode";
                break;
            }
            case 20: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "listener";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "findClient";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "sessionOpened";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 21: 
            case 23: 
            case 26: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class InactiveListener
    implements ServiceEventListener {
        static final ServiceEventListener INSTANCE = new InactiveListener();

        private InactiveListener() {
        }

        public void handle(@NotNull ServiceEventListener.ServiceEvent event) {
            if (event == null) {
                InactiveListener.$$$reportNull$$$0(0);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/database/console/DatabaseServiceViewContributor$InactiveListener", "handle"));
        }
    }

    private static class TransactionControlAction
    extends DefaultActionGroup {
        private static AnAction ourInstance;
        private final AnAction myDelegate;
        private final TextIcon myIcon;

        TransactionControlAction() {
            this.setPopup(true);
            this.myDelegate = ActionManager.getInstance().getAction("Console.Transaction.TxSettings");
            this.myIcon = new TextIcon("Tx", UIUtil.getLabelForeground(), Gray.TRANSPARENT, 0);
            this.myIcon.setFont(UIUtil.getToolbarFont());
            Presentation presentation = this.getTemplatePresentation();
            presentation.setIcon((Icon)this.myIcon);
            presentation.setDescription(this.myDelegate.getTemplatePresentation().getDescription());
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                TransactionControlAction.$$$reportNull$$$0(0);
            }
            this.myDelegate.update(e);
            Presentation presentation = e.getPresentation();
            if (!presentation.isVisible()) {
                return;
            }
            if (ActionPlaces.isPopupPlace((String)e.getPlace())) {
                presentation.setIcon(null);
                return;
            }
            presentation.setIcon((Icon)this.myIcon);
        }

        public boolean canBePerformed(@NotNull DataContext context) {
            if (context == null) {
                TransactionControlAction.$$$reportNull$$$0(1);
            }
            AnActionEvent event = AnActionEvent.createFromDataContext((String)"toolbar", null, (DataContext)context);
            this.myDelegate.update(event);
            return event.getPresentation().isEnabled();
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                TransactionControlAction.$$$reportNull$$$0(2);
            }
            this.myDelegate.actionPerformed(e);
        }

        @NotNull
        private static AnAction getInstance() {
            if (ourInstance == null) {
                ourInstance = new TransactionControlAction();
            }
            AnAction anAction = ourInstance;
            if (anAction == null) {
                TransactionControlAction.$$$reportNull$$$0(3);
            }
            return anAction;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/console/DatabaseServiceViewContributor$TransactionControlAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/console/DatabaseServiceViewContributor$TransactionControlAction";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInstance";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "canBePerformed";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class SessionStateListener
    implements DatabaseSessionStateListener {
        private SessionStateListener() {
        }

        @Override
        public void renamed(@NotNull DatabaseSession session2) {
            if (session2 == null) {
                SessionStateListener.$$$reportNull$$$0(0);
            }
            SessionStateListener.changed(session2);
        }

        @Override
        public void connected(@NotNull DatabaseSession session2) {
            if (session2 == null) {
                SessionStateListener.$$$reportNull$$$0(1);
            }
            SessionStateListener.changed(session2);
        }

        @Override
        public void disconnected(@NotNull DatabaseSession session2) {
            if (session2 == null) {
                SessionStateListener.$$$reportNull$$$0(2);
            }
            SessionStateListener.changed(session2);
        }

        @Override
        public void stateChanged(@NotNull DatabaseSessionStateListener.ChangeEvent event) {
            if (event == null) {
                SessionStateListener.$$$reportNull$$$0(3);
            }
            if (event.getType() == DatabaseSessionStateListener.ChangeEvent.EventType.STARTED) {
                ourStateChangedAlarm.addRequest(() -> SessionStateListener.changed(event.getSession()), 1000L);
                return;
            }
            if (event.getType() == DatabaseSessionStateListener.ChangeEvent.EventType.PUBLISHED) {
                DatabaseServiceViewContributor.sessionOpened(event.getSession());
                return;
            }
            SessionStateListener.changed(event.getSession());
        }

        private static void changed(@NotNull DatabaseSession session2) {
            if (session2 == null) {
                SessionStateListener.$$$reportNull$$$0(4);
            }
            DbUIUtil.invokeLaterIfNeeded(() -> {
                ServiceEventListener.ServiceEvent event = ServiceEventListener.ServiceEvent.createEvent((ServiceEventListener.EventType)ServiceEventListener.EventType.SERVICE_CHANGED, (Object)session2, DatabaseServiceViewContributor.class);
                DatabaseServiceViewContributor.listener(session2).handle(event);
            });
        }

        @Override
        public void clientAttached(@NotNull VisibleDatabaseSessionClient client) {
            if (client == null) {
                SessionStateListener.$$$reportNull$$$0(5);
            }
            if (!(client instanceof DatabaseSessionClientWithFile)) {
                return;
            }
            DbUIUtil.invokeLaterIfNeeded(() -> {
                DatabaseSession session2 = (DatabaseSession)client.getSession();
                ServiceEventListener listener = DatabaseServiceViewContributor.listener(session2);
                if (listener == InactiveListener.INSTANCE) {
                    return;
                }
                ServiceEventListener.ServiceEvent event = ServiceEventListener.ServiceEvent.createServiceAddedEvent((Object)client, DatabaseServiceViewContributor.class, (Object)session2);
                listener.handle(event);
                DatabaseServiceViewContributor.selectNode(session2.getProject(), client, false, true);
            });
        }

        @Override
        public void clientDetached(@NotNull VisibleDatabaseSessionClient client) {
            if (client == null) {
                SessionStateListener.$$$reportNull$$$0(6);
            }
            if (!(client instanceof DatabaseSessionClientWithFile)) {
                return;
            }
            DbUIUtil.invokeLaterIfNeeded(() -> {
                ServiceEventListener.ServiceEvent event = ServiceEventListener.ServiceEvent.createEvent((ServiceEventListener.EventType)ServiceEventListener.EventType.SERVICE_REMOVED, (Object)client, DatabaseServiceViewContributor.class);
                DatabaseServiceViewContributor.listener((DatabaseSession)client.getSession()).handle(event);
            });
        }

        @Override
        public void clientReattached(@NotNull VisibleDatabaseSessionClient client, @NotNull DatabaseSession from, @NotNull DatabaseSession to) {
            if (client == null) {
                SessionStateListener.$$$reportNull$$$0(7);
            }
            if (from == null) {
                SessionStateListener.$$$reportNull$$$0(8);
            }
            if (to == null) {
                SessionStateListener.$$$reportNull$$$0(9);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "session";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "client";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "from";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "to";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/console/DatabaseServiceViewContributor$SessionStateListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "renamed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "connected";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "disconnected";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "stateChanged";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "changed";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "clientAttached";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "clientDetached";
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "clientReattached";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class SessionsListener
    implements DatabaseSessionManagerListener {
        private SessionsListener() {
        }

        @Override
        public void sessionOpened(@NotNull DatabaseSession session2) {
            if (session2 == null) {
                SessionsListener.$$$reportNull$$$0(0);
            }
            DatabaseServiceViewContributor.sessionOpened(session2);
        }

        @Override
        public void sessionClosed(@NotNull DatabaseSession session2) {
            if (session2 == null) {
                SessionsListener.$$$reportNull$$$0(1);
            }
            DbUIUtil.invokeLaterIfNeeded(() -> {
                ServiceEventListener.ServiceEvent event = ServiceEventListener.ServiceEvent.createEvent((ServiceEventListener.EventType)ServiceEventListener.EventType.SERVICE_REMOVED, (Object)session2, DatabaseServiceViewContributor.class);
                DatabaseServiceViewContributor.listener(session2).handle(event);
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "session";
            objectArray2[1] = "com/intellij/database/console/DatabaseServiceViewContributor$SessionsListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "sessionOpened";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "sessionClosed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ClientViewDescriptor
    extends BaseViewDescriptor
    implements Navigatable {
        private final DatabaseSessionClientWithFile myClient;

        ClientViewDescriptor(@NotNull DatabaseSessionClientWithFile client) {
            if (client == null) {
                ClientViewDescriptor.$$$reportNull$$$0(0);
            }
            this.myClient = client;
        }

        @Override
        @Nullable
        protected Icon getIcon() {
            DatabaseSession session2 = (DatabaseSession)this.myClient.getSession();
            DatabaseSession.State state2 = session2.getState();
            DatabaseSession.State.Work work2 = state2.getWorkFor(this.myClient);
            return work2 != null && work2.getState() != DatabaseSession.State.WorkState.FINISHED && SessionsUtil.needToShowProgress(session2) ? AnimatedIcon.Default.INSTANCE : this.myClient.getIcon();
        }

        @Override
        protected boolean isValid() {
            return this.myClient.isValid();
        }

        @Override
        @Nullable
        protected DatabaseLogView<?> getViewIfAny() {
            return DatabaseLogViewService.getViewIfAny(this.myClient);
        }

        @Override
        @NotNull
        protected String getName() {
            String string = this.myClient.getTitle();
            if (string == null) {
                ClientViewDescriptor.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        @Nullable
        protected String getDescriptionText() {
            DatabaseSession session2 = (DatabaseSession)this.myClient.getSession();
            DatabaseSession.State state2 = session2.getState();
            DatabaseSession.State.Work work2 = state2.getWorkFor(this.myClient);
            if (work2 == null || !SessionsUtil.needToShowTimeSpent(session2)) {
                return null;
            }
            long time = work2.getTimeSpentMs();
            if (time <= 0L) {
                return null;
            }
            DatabaseSession.State.WorkState workState = work2.getState();
            return workState != DatabaseSession.State.WorkState.SUBMITTED ? DatabaseServiceViewContributor.formatDuration(workState == DatabaseSession.State.WorkState.RUNNING, time) : this.getIdleMessage();
        }

        @NotNull
        public ItemPresentation getContentPresentation() {
            PresentationData result2 = new PresentationData();
            result2.setPresentableText(JdbcConsole.getTitle(this.getSession().getProject(), this.getVirtualFile()));
            result2.setIcon(this.getIcon());
            PresentationData presentationData = result2;
            if (presentationData == null) {
                ClientViewDescriptor.$$$reportNull$$$0(2);
            }
            return presentationData;
        }

        public void navigate(boolean requestFocus) {
            VirtualFile virtualFile = this.getVirtualFile();
            Project project = this.getSession().getProject();
            FileEditorManager manager = FileEditorManager.getInstance((Project)project);
            TransactionGuard.submitTransaction((Disposable)project, () -> manager.openFile(virtualFile, requestFocus, true));
        }

        public boolean canNavigateToSource() {
            return this.getVirtualFile().isValid();
        }

        public boolean canNavigate() {
            return this.canNavigateToSource();
        }

        @Nullable
        public Navigatable getNavigatable() {
            return this;
        }

        @Nullable
        private String getIdleMessage() {
            DatabaseSession.State state2 = ((DatabaseSession)this.myClient.getSession()).getState();
            List<DatabaseSession.State.Work> work2 = state2.getWork();
            return ContainerUtil.exists(work2, w -> w.getState() == DatabaseSession.State.WorkState.RUNNING) ? "waiting" : null;
        }

        @Override
        @NotNull
        DatabaseSession getSession() {
            DatabaseSession databaseSession = (DatabaseSession)this.myClient.getSession();
            if (databaseSession == null) {
                ClientViewDescriptor.$$$reportNull$$$0(3);
            }
            return databaseSession;
        }

        @Nullable
        public Runnable getRemover() {
            Project project = ((DatabaseSession)this.myClient.getSession()).getProject();
            return DatabaseServiceViewDeleteElementProvider.RemoveHelper.CLIENT.canRemove(project, this.myClient) ? () -> {
                if (DatabaseServiceViewDeleteElementProvider.RemoveHelper.CLIENT.canRemove(project, this.myClient)) {
                    DatabaseServiceViewDeleteElementProvider.RemoveHelper.CLIENT.remove(project, this.myClient);
                }
            } : null;
        }

        @Nullable
        public ActionGroup getPopupActions() {
            DefaultActionGroup actions = this.getToolbarActions();
            actions.addSeparator();
            ActionManager actionManager = ActionManager.getInstance();
            actions.add(actionManager.getAction("Console.Jdbc.ChooseSession"));
            actions.add(actionManager.getAction("Session.Client.Detach"));
            return actions;
        }

        @Override
        @NotNull
        protected DatabaseLogView<?> getView() {
            DatabaseClientLogView databaseClientLogView = this.myClient.getView();
            if (databaseClientLogView == null) {
                ClientViewDescriptor.$$$reportNull$$$0(4);
            }
            return databaseClientLogView;
        }

        @Override
        @NotNull
        public DataProvider getDataProvider() {
            DataProvider provider = super.getDataProvider();
            DataProvider dataProvider2 = dataId -> SessionClientHolder.CLIENT_KEY.is(dataId) ? this.myClient : (CommonDataKeys.VIRTUAL_FILE.is(dataId) ? this.getVirtualFile() : (provider == null ? null : provider.getData(dataId)));
            if (dataProvider2 == null) {
                ClientViewDescriptor.$$$reportNull$$$0(5);
            }
            return dataProvider2;
        }

        @NotNull
        private VirtualFile getVirtualFile() {
            VirtualFile virtualFile = this.myClient.getVirtualFile();
            if (virtualFile == null) {
                ClientViewDescriptor.$$$reportNull$$$0(6);
            }
            return virtualFile;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "client";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/console/DatabaseServiceViewContributor$ClientViewDescriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/console/DatabaseServiceViewContributor$ClientViewDescriptor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContentPresentation";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSession";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getView";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDataProvider";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVirtualFile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class DbDataSourceViewDescriptor
    implements ServiceViewDescriptor,
    ColoredItem {
        private final DbDataSource myDataSource;
        private DataSourceInfoTool myInfoTool;

        DbDataSourceViewDescriptor(@NotNull DbDataSource dataSource) {
            if (dataSource == null) {
                DbDataSourceViewDescriptor.$$$reportNull$$$0(0);
            }
            this.myDataSource = dataSource;
        }

        @Nullable
        public Color getColor() {
            return DatabaseColorManager.getColor((DbElement)this.myDataSource);
        }

        @Nullable
        public Runnable getRemover() {
            return DatabaseServiceViewDeleteElementProvider.RemoveHelper.DATA_SOURCE.canRemove(this.myDataSource.getProject(), this.myDataSource) ? () -> {
                if (DatabaseServiceViewDeleteElementProvider.RemoveHelper.DATA_SOURCE.canRemove(this.myDataSource.getProject(), this.myDataSource)) {
                    DatabaseServiceViewDeleteElementProvider.RemoveHelper.DATA_SOURCE.remove(this.myDataSource.getProject(), this.myDataSource);
                }
            } : null;
        }

        public JComponent getContentComponent() {
            if (this.myInfoTool == null) {
                DbDataSourceImpl dataSource = (DbDataSourceImpl)((Object)ObjectUtils.tryCast((Object)this.myDataSource, DbDataSourceImpl.class));
                this.myInfoTool = dataSource == null ? null : new DataSourceInfoTool(dataSource);
            }
            return this.myInfoTool == null ? null : this.myInfoTool.getPrimaryPane();
        }

        @NotNull
        public DefaultActionGroup getToolbarActions() {
            DefaultActionGroup group2 = new DefaultActionGroup();
            ActionManager manager = ActionManager.getInstance();
            group2.add(manager.getAction("Jdbc.OpenConsole.Any"));
            group2.add(manager.getAction("DatabaseView.PropertiesAction"));
            group2.add(manager.getAction("DatabaseView.CloseConnectionAction"));
            DefaultActionGroup defaultActionGroup = group2;
            if (defaultActionGroup == null) {
                DbDataSourceViewDescriptor.$$$reportNull$$$0(1);
            }
            return defaultActionGroup;
        }

        @Nullable
        public ActionGroup getPopupActions() {
            DefaultActionGroup actions = this.getToolbarActions();
            actions.addSeparator();
            actions.add(ActionManager.getInstance().getAction("Session.CloseAll"));
            return actions;
        }

        @NotNull
        public ItemPresentation getPresentation() {
            PresentationData data = new PresentationData();
            data.setIcon(this.myDataSource.getIcon());
            data.setPresentableText(this.myDataSource.getName());
            PresentationData presentationData = data;
            if (presentationData == null) {
                DbDataSourceViewDescriptor.$$$reportNull$$$0(2);
            }
            return presentationData;
        }

        public DataProvider getDataProvider() {
            return key2 -> {
                PsiElement[] psiElementArray;
                if (LangDataKeys.PSI_ELEMENT_ARRAY.is(key2)) {
                    PsiElement[] psiElementArray2 = new PsiElement[1];
                    psiElementArray = psiElementArray2;
                    psiElementArray2[0] = this.myDataSource;
                } else {
                    psiElementArray = null;
                }
                return psiElementArray;
            };
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataSource";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/console/DatabaseServiceViewContributor$DbDataSourceViewDescriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/console/DatabaseServiceViewContributor$DbDataSourceViewDescriptor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getToolbarActions";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class GroupViewDescriptor
    implements ServiceViewDescriptor {
        private final PsiElement myElement;
        private final ItemPresentation myPresentation;

        GroupViewDescriptor(@NotNull PsiElement element2) {
            if (element2 == null) {
                GroupViewDescriptor.$$$reportNull$$$0(0);
            }
            this.myElement = element2;
            this.myPresentation = new GroupPresentation();
        }

        @NotNull
        public ItemPresentation getPresentation() {
            ItemPresentation itemPresentation = this.myPresentation;
            if (itemPresentation == null) {
                GroupViewDescriptor.$$$reportNull$$$0(1);
            }
            return itemPresentation;
        }

        public DataProvider getDataProvider() {
            return key2 -> {
                PsiElement[] psiElementArray;
                if (LangDataKeys.PSI_ELEMENT_ARRAY.is(key2)) {
                    PsiElement[] psiElementArray2 = new PsiElement[1];
                    psiElementArray = psiElementArray2;
                    psiElementArray2[0] = this.myElement;
                } else {
                    psiElementArray = null;
                }
                return psiElementArray;
            };
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/console/DatabaseServiceViewContributor$GroupViewDescriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/console/DatabaseServiceViewContributor$GroupViewDescriptor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private class GroupPresentation
        implements ItemPresentation {
            private GroupPresentation() {
            }

            @Nullable
            public String getPresentableText() {
                return GroupViewDescriptor.this.myElement instanceof DbElement ? DbPresentation.getPresentableName((DasObject)((DbElement)GroupViewDescriptor.this.myElement), true) : (GroupViewDescriptor.this.myElement instanceof PsiNamedElement ? ((PsiNamedElement)GroupViewDescriptor.this.myElement).getName() : null);
            }

            @Nullable
            public String getLocationString() {
                return null;
            }

            @Nullable
            public Icon getIcon(boolean unused) {
                return GroupViewDescriptor.this.myElement.getIcon(0);
            }
        }
    }

    private static class SessionViewDescriptor
    extends BaseViewDescriptor {
        private final DatabaseSession mySession;

        SessionViewDescriptor(@NotNull DatabaseSession session2) {
            if (session2 == null) {
                SessionViewDescriptor.$$$reportNull$$$0(0);
            }
            this.mySession = session2;
        }

        @Override
        @NotNull
        DatabaseSession getSession() {
            DatabaseSession databaseSession = this.mySession;
            if (databaseSession == null) {
                SessionViewDescriptor.$$$reportNull$$$0(1);
            }
            return databaseSession;
        }

        @Nullable
        public ActionGroup getPopupActions() {
            DefaultActionGroup actions = this.getToolbarActions();
            actions.addSeparator();
            actions.add(ActionManager.getInstance().getAction("Session.Rename"));
            actions.add(ActionManager.getInstance().getAction("Session.Close"));
            return actions;
        }

        @Override
        protected boolean isValid() {
            return this.mySession.isValid();
        }

        @Override
        @NotNull
        protected Icon getIcon() {
            Icon icon = DatabaseSession.getIcon(this.mySession);
            if (icon == null) {
                SessionViewDescriptor.$$$reportNull$$$0(2);
            }
            return icon;
        }

        @Override
        @NotNull
        protected String getName() {
            String string = this.mySession.getTitle();
            if (string == null) {
                SessionViewDescriptor.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Override
        @Nullable
        protected String getDescriptionText() {
            if (!SessionsUtil.needToShowTimeSpent(this.mySession)) {
                return null;
            }
            DatabaseSession.State state2 = this.mySession.getState();
            long time = state2.getTimeSpentMs();
            if (time <= 0L) {
                return null;
            }
            return DatabaseServiceViewContributor.formatDuration(!state2.isIdle(), time);
        }

        @NotNull
        public ItemPresentation getCustomPresentation(@NotNull ServiceViewOptions options) {
            if (options == null) {
                SessionViewDescriptor.$$$reportNull$$$0(4);
            }
            if (options.isGroupByServiceGroups()) {
                PresentationData presentationData = this.getPresentation();
                if (presentationData == null) {
                    SessionViewDescriptor.$$$reportNull$$$0(5);
                }
                return presentationData;
            }
            PresentationData data = new PresentationData();
            data.setIcon(this.getIcon());
            data.addText(this.getName() + " ", SimpleTextAttributes.REGULAR_ATTRIBUTES);
            data.addText("[" + ((LocalDataSource)this.getSession().getTarget()).getName() + "]", SimpleTextAttributes.GRAY_ATTRIBUTES);
            data.setLocationString(this.getDescriptionText());
            PresentationData presentationData = data;
            if (presentationData == null) {
                SessionViewDescriptor.$$$reportNull$$$0(6);
            }
            return presentationData;
        }

        @Nullable
        public Runnable getRemover() {
            Project project = this.mySession.getProject();
            return DatabaseServiceViewDeleteElementProvider.RemoveHelper.SESSION.canRemove(project, this.mySession) ? () -> {
                if (DatabaseServiceViewDeleteElementProvider.RemoveHelper.SESSION.canRemove(project, this.mySession)) {
                    DatabaseServiceViewDeleteElementProvider.RemoveHelper.SESSION.remove(project, this.mySession);
                }
            } : null;
        }

        @NotNull
        public ItemPresentation getContentPresentation() {
            String suffix = DatabaseElementVirtualFileImpl.getDataSourceText(this.getDataSource(), null);
            PresentationData result2 = new PresentationData();
            result2.setPresentableText(this.mySession.getTitle() + suffix);
            result2.setIcon(this.getIcon());
            PresentationData presentationData = result2;
            if (presentationData == null) {
                SessionViewDescriptor.$$$reportNull$$$0(7);
            }
            return presentationData;
        }

        @Override
        @Nullable
        protected DatabaseLogView<?> getViewIfAny() {
            return DatabaseLogViewService.getViewIfAny(this.mySession);
        }

        @NotNull
        protected DatabaseSessionLogView getView() {
            DatabaseSessionLogView databaseSessionLogView = (DatabaseSessionLogView)this.mySession.getView();
            if (databaseSessionLogView == null) {
                SessionViewDescriptor.$$$reportNull$$$0(8);
            }
            return databaseSessionLogView;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "session";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/console/DatabaseServiceViewContributor$SessionViewDescriptor";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "options";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/console/DatabaseServiceViewContributor$SessionViewDescriptor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSession";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIcon";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCustomPresentation";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContentPresentation";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getView";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getCustomPresentation";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static abstract class BaseViewDescriptor
    implements ServiceViewDescriptor,
    ColoredItem {
        private DatabaseLogView<?> myView;

        private BaseViewDescriptor() {
        }

        @Nullable
        public JComponent getContentComponent() {
            if (this.isValid()) {
                return this.getOrCacheView().getContent().getComponent();
            }
            DatabaseLogView<?> maybe = this.getViewIfAny();
            return maybe == null ? null : maybe.getContent().getComponent();
        }

        @NotNull
        public DefaultActionGroup getToolbarActions() {
            DefaultActionGroup group2 = new DefaultActionGroup();
            group2.add(TransactionControlAction.getInstance());
            group2.add(ActionManager.getInstance().getAction("Console.Jdbc.Common"));
            DatabaseLogView<?> view2 = this.getViewIfAny();
            if (view2 == null) {
                DefaultActionGroup defaultActionGroup = group2;
                if (defaultActionGroup == null) {
                    BaseViewDescriptor.$$$reportNull$$$0(0);
                }
                return defaultActionGroup;
            }
            group2.addSeparator();
            List<AnAction> leftToolbarActions = view2.getActions();
            for (AnAction action2 : leftToolbarActions) {
                group2.add(action2);
            }
            DefaultActionGroup defaultActionGroup = group2;
            if (defaultActionGroup == null) {
                BaseViewDescriptor.$$$reportNull$$$0(1);
            }
            return defaultActionGroup;
        }

        @NotNull
        public PresentationData getPresentation() {
            PresentationData pData = new PresentationData();
            pData.setPresentableText(this.getName());
            pData.setLocationString(this.getDescriptionText());
            pData.setIcon(this.getIcon());
            PresentationData presentationData = pData;
            if (presentationData == null) {
                BaseViewDescriptor.$$$reportNull$$$0(2);
            }
            return presentationData;
        }

        @Nullable
        public DataProvider getDataProvider() {
            DatabaseLogView<?> any = this.getViewIfAny();
            if (any == null) {
                return null;
            }
            Content content = any.getContent();
            DataContext context = DataManager.getInstance().getDataContext((Component)content.getComponent());
            return arg_0 -> ((DataContext)context).getData(arg_0);
        }

        @NotNull
        private DatabaseLogView<?> getOrCacheView() {
            if (this.myView == null) {
                this.myView = this.getView();
            }
            DatabaseLogView<?> databaseLogView = this.myView;
            if (databaseLogView == null) {
                BaseViewDescriptor.$$$reportNull$$$0(3);
            }
            return databaseLogView;
        }

        @Nullable
        public Color getColor() {
            return DatabaseColorManager.getColor((DbElement)this.getDataSource());
        }

        @Nullable
        protected final DbDataSource getDataSource() {
            DatabaseSession session2 = this.getSession();
            return DbImplUtil.getDbDataSource(session2.getProject(), (DasDataSource)session2.getTarget());
        }

        protected abstract boolean isValid();

        @NotNull
        protected abstract String getName();

        @Nullable
        protected abstract String getDescriptionText();

        @Nullable
        protected abstract DatabaseLogView<?> getViewIfAny();

        @NotNull
        protected abstract DatabaseLogView<?> getView();

        @Nullable
        protected abstract Icon getIcon();

        @NotNull
        abstract DatabaseSession getSession();

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/database/console/DatabaseServiceViewContributor$BaseViewDescriptor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getToolbarActions";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentation";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOrCacheView";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    static class SessionContributor
    implements ServiceViewFileEditorContributor<DatabaseSessionClientWithFile>,
    ServiceViewProvidingContributor<DatabaseSessionClientWithFile, DatabaseSession>,
    Comparator<DatabaseSessionClientWithFile> {
        private final DatabaseSession mySession;

        SessionContributor(@NotNull DatabaseSession session2) {
            if (session2 == null) {
                SessionContributor.$$$reportNull$$$0(0);
            }
            this.mySession = session2;
        }

        @NotNull
        public DatabaseSession asService() {
            DatabaseSession databaseSession = this.mySession;
            if (databaseSession == null) {
                SessionContributor.$$$reportNull$$$0(1);
            }
            return databaseSession;
        }

        @NotNull
        public ServiceViewDescriptor getViewDescriptor() {
            SessionViewDescriptor sessionViewDescriptor = new SessionViewDescriptor(this.mySession);
            if (sessionViewDescriptor == null) {
                SessionContributor.$$$reportNull$$$0(2);
            }
            return sessionViewDescriptor;
        }

        @NotNull
        public List<DatabaseSessionClientWithFile> getServices(@NotNull Project project) {
            if (project == null) {
                SessionContributor.$$$reportNull$$$0(3);
            }
            ArrayList arrayList = ContainerUtil.newArrayList((Object[])this.mySession.getClientsWithFile());
            if (arrayList == null) {
                SessionContributor.$$$reportNull$$$0(4);
            }
            return arrayList;
        }

        @NotNull
        public ServiceViewDescriptor getServiceDescriptor(@NotNull DatabaseSessionClientWithFile service) {
            if (service == null) {
                SessionContributor.$$$reportNull$$$0(5);
            }
            ClientViewDescriptor clientViewDescriptor = new ClientViewDescriptor(service);
            if (clientViewDescriptor == null) {
                SessionContributor.$$$reportNull$$$0(6);
            }
            return clientViewDescriptor;
        }

        @Override
        public int compare(DatabaseSessionClientWithFile o1, DatabaseSessionClientWithFile o2) {
            Object[] clients = this.mySession.getClientsWithFile();
            return ArrayUtil.indexOf((Object[])clients, (Object)o1) - ArrayUtil.indexOf((Object[])clients, (Object)o2);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return this.mySession.equals(((SessionContributor)o).mySession);
        }

        public int hashCode() {
            return this.mySession.hashCode();
        }

        public DatabaseSessionClientWithFile findService(@NotNull Project project, @NotNull FileEditor editor) {
            if (project == null) {
                SessionContributor.$$$reportNull$$$0(7);
            }
            if (editor == null) {
                SessionContributor.$$$reportNull$$$0(8);
            }
            return DatabaseServiceViewContributor.findClient(project, editor);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "session";
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/console/DatabaseServiceViewContributor$SessionContributor";
                    break;
                }
                case 3: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "service";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/console/DatabaseServiceViewContributor$SessionContributor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "asService";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getViewDescriptor";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getServices";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getServiceDescriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 6: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getServices";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getServiceDescriptor";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "findService";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class DatabaseContributorDescriptor
    extends SimpleServiceViewDescriptor
    implements ServiceViewNonActivatingDescriptor {
        DatabaseContributorDescriptor() {
            super("Database", DatabaseIcons.Dbms);
        }

        @NotNull
        public DataProvider getDataProvider() {
            DataProvider dataProvider2 = id -> PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(id) ? DatabaseServiceViewDeleteElementProvider.INSTANCE : null;
            if (dataProvider2 == null) {
                DatabaseContributorDescriptor.$$$reportNull$$$0(0);
            }
            return dataProvider2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/DatabaseServiceViewContributor$DatabaseContributorDescriptor", "getDataProvider"));
        }
    }
}

