/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationScript.providers;

import com.intellij.configurationScript.BeanConstructorKt;
import com.intellij.configurationScript.IntellijConfigurationJsonSchemaProviderFactoryKt;
import com.intellij.configurationScript.schemaGenerators.RunConfigurationJsonSchemaGeneratorKt;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfigurationOptions;
import com.intellij.openapi.components.BaseState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.util.ReflectionUtil;
import gnu.trove.THashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.snakeyaml.engine.v1.nodes.MappingNode;
import org.snakeyaml.engine.v1.nodes.Node;
import org.snakeyaml.engine.v1.nodes.NodeTuple;
import org.snakeyaml.engine.v1.nodes.ScalarNode;
import org.snakeyaml.engine.v1.nodes.SequenceNode;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B=\u00126\u0010\u0002\u001a2\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\b\u0012\u0004\u0012\u00020\t0\u0003\u00a2\u0006\u0002\u0010\nJ\u0016\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0018\u0010\u0010\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J(\u0010\u0013\u001a\u00020\t2\u000e\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u0004H\u0002J\u0018\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u00192\u0006\u0010\u0007\u001a\u00020\u0004H\u0002R>\u0010\u0002\u001a2\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\b\u0012\u0004\u0012\u00020\t0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/configurationScript/providers/RunConfigurationListReader;", "", "processor", "Lkotlin/Function2;", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "Lkotlin/ParameterName;", "name", "factory", "state", "", "(Lkotlin/jvm/functions/Function2;)V", "read", "parentNode", "Lorg/snakeyaml/engine/v1/nodes/MappingNode;", "isTemplatesOnly", "", "readFactoryGroup", "type", "Lcom/intellij/execution/configurations/ConfigurationType;", "readRunConfiguration", "optionsClass", "Ljava/lang/Class;", "Lcom/intellij/openapi/components/BaseState;", "node", "readRunConfigurationGroup", "Lorg/snakeyaml/engine/v1/nodes/Node;", "intellij.configurationScript"})
public final class RunConfigurationListReader {
    private final Function2<ConfigurationFactory, Object, Unit> processor;

    /*
     * WARNING - void declaration
     */
    public final void read(@NotNull MappingNode parentNode, boolean isTemplatesOnly) {
        Intrinsics.checkParameterIsNotNull((Object)parentNode, (String)"parentNode");
        Map keyToType = null;
        Iterator<NodeTuple> iterator = parentNode.getValue().iterator();
        while (iterator.hasNext()) {
            ConfigurationType configurationType;
            ConfigurationType type$iv;
            NodeTuple tuple;
            NodeTuple nodeTuple = tuple = iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)nodeTuple, (String)"tuple");
            Node keyNode = nodeTuple.getKeyNode();
            if (!(keyNode instanceof ScalarNode)) {
                IntellijConfigurationJsonSchemaProviderFactoryKt.getLOG().warn("Unexpected keyNode type: " + keyNode);
                continue;
            }
            if (Intrinsics.areEqual((Object)((ScalarNode)keyNode).getValue(), (Object)"templates")) {
                if (!isTemplatesOnly) continue;
                Node node = tuple.getValueNode();
                if (!(node instanceof MappingNode)) {
                    node = null;
                }
                MappingNode mappingNode = (MappingNode)node;
                if (mappingNode == null) {
                    continue;
                }
                this.read(mappingNode, false);
                continue;
            }
            if (keyToType == null) {
                keyToType = (Map)new THashMap();
                boolean $i$f$processConfigurationTypes = false;
                ExtensionPointName extensionPointName = ConfigurationType.CONFIGURATION_TYPE_EP;
                Intrinsics.checkExpressionValueIsNotNull((Object)extensionPointName, (String)"ConfigurationType.CONFIGURATION_TYPE_EP");
                Iterator iterator2 = extensionPointName.getExtensionList().iterator();
                while (iterator2.hasNext()) {
                    void propertyName;
                    CharSequence propertyName$iv;
                    ConfigurationType configurationType2 = type$iv = (ConfigurationType)iterator2.next();
                    Intrinsics.checkExpressionValueIsNotNull((Object)configurationType2, (String)"type");
                    if (RunConfigurationJsonSchemaGeneratorKt.rcTypeIdToPropertyName(configurationType2) == null) {
                        continue;
                    }
                    ConfigurationFactory[] factories$iv = type$iv.getConfigurationFactories();
                    Intrinsics.checkExpressionValueIsNotNull((Object)factories$iv, (String)"factories");
                    ConfigurationFactory[] configurationFactoryArray = factories$iv;
                    boolean bl = false;
                    if (configurationFactoryArray.length == 0) {
                        IntellijConfigurationJsonSchemaProviderFactoryKt.getLOG().error("Configuration type \"" + type$iv.getDisplayName() + "\" is not valid: factory list is empty");
                        continue;
                    }
                    ConfigurationFactory[] configurationFactoryArray2 = factories$iv;
                    CharSequence charSequence = propertyName$iv;
                    ConfigurationType configurationType3 = type$iv;
                    boolean bl2 = false;
                    keyToType.put(propertyName.toString(), configurationType3);
                }
            }
            if ((configurationType = (ConfigurationType)keyToType.get(((ScalarNode)keyNode).getValue())) == null) {
                IntellijConfigurationJsonSchemaProviderFactoryKt.getLOG().warn("Unknown run configuration type: " + ((ScalarNode)keyNode).getValue());
                continue;
            }
            ConfigurationType factories = configurationType.getConfigurationFactories();
            Intrinsics.checkExpressionValueIsNotNull((Object)factories, (String)"factories");
            boolean bl = false;
            if (((ConfigurationType)type$iv).length == 0) continue;
            Node valueNode = tuple.getValueNode();
            if (((ConfigurationType)factories).length > 1) {
                if (!(valueNode instanceof MappingNode)) {
                    IntellijConfigurationJsonSchemaProviderFactoryKt.getLOG().warn("Unexpected valueNode type: " + valueNode);
                    continue;
                }
                this.readFactoryGroup((MappingNode)valueNode, configurationType);
                continue;
            }
            Node node = tuple.getValueNode();
            Intrinsics.checkExpressionValueIsNotNull((Object)node, (String)"tuple.valueNode");
            Object object = ArraysKt.first((Object[])factories);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"factories.first()");
            this.readRunConfigurationGroup(node, (ConfigurationFactory)object);
        }
    }

    private final void readFactoryGroup(MappingNode parentNode, ConfigurationType type) {
        Iterator<NodeTuple> iterator = parentNode.getValue().iterator();
        while (iterator.hasNext()) {
            ConfigurationFactory factory;
            Node keyNode;
            NodeTuple tuple;
            block4: {
                ConfigurationFactory configurationFactory;
                ConfigurationFactory[] configurationFactoryArray;
                NodeTuple nodeTuple = tuple = iterator.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)nodeTuple, (String)"tuple");
                keyNode = nodeTuple.getKeyNode();
                if (!(keyNode instanceof ScalarNode)) {
                    IntellijConfigurationJsonSchemaProviderFactoryKt.getLOG().warn("Unexpected keyNode type: " + keyNode);
                    continue;
                }
                String factoryKey = ((ScalarNode)keyNode).getValue();
                Intrinsics.checkExpressionValueIsNotNull((Object)type.getConfigurationFactories(), (String)"type.configurationFactories");
                boolean bl = false;
                ConfigurationFactory[] configurationFactoryArray2 = configurationFactoryArray;
                boolean bl2 = false;
                ConfigurationFactory[] configurationFactoryArray3 = configurationFactoryArray2;
                int n = configurationFactoryArray3.length;
                for (int i = 0; i < n; ++i) {
                    ConfigurationFactory configurationFactory2;
                    ConfigurationFactory factory2 = configurationFactory2 = configurationFactoryArray3[i];
                    boolean bl3 = false;
                    ConfigurationFactory configurationFactory3 = factory2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)configurationFactory3, (String)"factory");
                    if (!Intrinsics.areEqual((Object)factoryKey, (Object)RunConfigurationJsonSchemaGeneratorKt.rcFactoryIdToPropertyName(configurationFactory3))) continue;
                    configurationFactory = configurationFactory2;
                    break block4;
                }
                configurationFactory = factory = null;
            }
            if (factory == null) {
                IntellijConfigurationJsonSchemaProviderFactoryKt.getLOG().warn("Unknown run configuration factory: " + ((ScalarNode)keyNode).getValue());
                continue;
            }
            Node node = tuple.getValueNode();
            Intrinsics.checkExpressionValueIsNotNull((Object)node, (String)"tuple.valueNode");
            this.readRunConfigurationGroup(node, factory);
        }
    }

    private final void readRunConfigurationGroup(Node node, ConfigurationFactory factory) {
        Class<RunConfigurationOptions> optionsClass;
        Class<RunConfigurationOptions> clazz = factory.getOptionsClass();
        if (clazz == null) {
            clazz = optionsClass = RunConfigurationOptions.class;
        }
        if (node instanceof MappingNode) {
            Logger $this$runAndLogException$iv = IntellijConfigurationJsonSchemaProviderFactoryKt.getLOG();
            boolean $i$f$runAndLogException = false;
            try {
                boolean bl = false;
                this.readRunConfiguration(optionsClass, (MappingNode)node, factory);
            }
            catch (ProcessCanceledException e$iv) {
                throw (Throwable)e$iv;
            }
            catch (CancellationException e$iv) {
                throw (Throwable)e$iv;
            }
            catch (Throwable e$iv) {
                $this$runAndLogException$iv.error(e$iv);
            }
        } else if (node instanceof SequenceNode) {
            for (Node itemNode : ((SequenceNode)node).getValue()) {
                if (!(itemNode instanceof MappingNode)) continue;
                this.readRunConfiguration(optionsClass, (MappingNode)itemNode, factory);
            }
        }
    }

    private final void readRunConfiguration(Class<? extends BaseState> optionsClass, MappingNode node, ConfigurationFactory factory) {
        BaseState instance = (BaseState)ReflectionUtil.newInstance(optionsClass);
        if (instance instanceof RunConfigurationOptions) {
            ((RunConfigurationOptions)instance).setAllowRunningInParallel(factory.getSingletonPolicy().isAllowRunningInParallel());
        }
        this.processor.invoke((Object)factory, (Object)BeanConstructorKt.readIntoObject$default(instance, node, null, 4, null));
    }

    public RunConfigurationListReader(@NotNull Function2<? super ConfigurationFactory, Object, Unit> processor) {
        Intrinsics.checkParameterIsNotNull(processor, (String)"processor");
        this.processor = processor;
    }
}

