/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.mac;

import com.apple.eawt.Application;
import com.intellij.ide.DataManager;
import com.intellij.ide.actions.AboutAction;
import com.intellij.ide.actions.ShowSettingsAction;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.idea.IdeaApplication;
import com.intellij.jna.JnaLoader;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.keymap.impl.IdeKeyEventDispatcher;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.mac.foundation.Foundation;
import com.intellij.ui.mac.foundation.ID;
import com.sun.jna.Callback;
import com.sun.jna.Pointer;
import java.awt.Component;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public final class MacOSApplicationProvider {
    private static final Logger LOG = Logger.getInstance(MacOSApplicationProvider.class);

    private MacOSApplicationProvider() {
    }

    public static void initApplication() {
        if (SystemInfo.isMac) {
            try {
                Worker.initMacApplication();
            }
            catch (Throwable t) {
                LOG.warn(t);
            }
        }
    }

    private static class Worker {
        private static final AtomicBoolean ENABLED = new AtomicBoolean(true);
        private static Object UPDATE_CALLBACK_REF;

        private Worker() {
        }

        static void initMacApplication() {
            Application application = Application.getApplication();
            application.setAboutHandler(event -> AboutAction.perform(Worker.getProject(false)));
            application.setPreferencesHandler(event -> {
                Project project = Worker.getProject(true);
                Worker.submit("Preferences", () -> ShowSettingsAction.perform(project));
            });
            application.setQuitHandler((event, response) -> {
                Worker.submit("Quit", () -> ApplicationManager.getApplication().exit());
                response.cancelQuit();
            });
            application.setOpenFileHandler(event -> {
                List files2 = event.getFiles();
                if (files2.isEmpty()) {
                    return;
                }
                ApplicationEx app = ApplicationManagerEx.getApplicationEx();
                if (app != null && app.isLoaded()) {
                    Project project = Worker.getProject(false);
                    Worker.submit("OpenFile", () -> ProjectUtil.tryOpenFileList(project, files2, "MacMenu"));
                } else {
                    IdeaApplication.openFilesOnLoading(files2);
                }
            });
            if (JnaLoader.isLoaded()) {
                Worker.installAutoUpdateMenu();
            }
        }

        private static void installAutoUpdateMenu() {
            ID pool = Foundation.invoke((String)"NSAutoreleasePool", (String)"new", (Object[])new Object[0]);
            ID app = Foundation.invoke((String)"NSApplication", (String)"sharedApplication", (Object[])new Object[0]);
            ID menu2 = Foundation.invoke((ID)app, (Pointer)Foundation.createSelector((String)"menu"), (Object[])new Object[0]);
            ID item = Foundation.invoke((ID)menu2, (Pointer)Foundation.createSelector((String)"itemAtIndex:"), (Object[])new Object[]{0});
            ID appMenu = Foundation.invoke((ID)item, (Pointer)Foundation.createSelector((String)"submenu"), (Object[])new Object[0]);
            ID checkForUpdatesClass = Foundation.allocateObjcClassPair((ID)Foundation.getObjcClass((String)"NSMenuItem"), (String)"NSCheckForUpdates");
            Callback impl = new Callback(){

                public void callback(ID self, String selector) {
                    SwingUtilities.invokeLater(() -> {
                        ActionManager am = ActionManager.getInstance();
                        MouseEvent me = new MouseEvent(JOptionPane.getRootFrame(), 500, System.currentTimeMillis(), 0, 0, 0, 1, false);
                        am.tryToExecute(am.getAction("CheckForUpdate"), (InputEvent)me, null, null, false);
                    });
                }
            };
            UPDATE_CALLBACK_REF = impl;
            Foundation.addMethod((ID)checkForUpdatesClass, (Pointer)Foundation.createSelector((String)"checkForUpdates"), (Callback)impl, (String)"v");
            Foundation.registerObjcClassPair((ID)checkForUpdatesClass);
            ID checkForUpdates2 = Foundation.invoke((String)"NSCheckForUpdates", (String)"alloc", (Object[])new Object[0]);
            Foundation.invoke((ID)checkForUpdates2, (Pointer)Foundation.createSelector((String)"initWithTitle:action:keyEquivalent:"), (Object[])new Object[]{Foundation.nsString((String)"Check for Updates..."), Foundation.createSelector((String)"checkForUpdates"), Foundation.nsString((String)"")});
            Foundation.invoke((ID)checkForUpdates2, (Pointer)Foundation.createSelector((String)"setTarget:"), (Object[])new Object[]{checkForUpdates2});
            Foundation.invoke((ID)appMenu, (Pointer)Foundation.createSelector((String)"insertItem:atIndex:"), (Object[])new Object[]{checkForUpdates2, 1});
            Foundation.invoke((ID)checkForUpdates2, (Pointer)Foundation.createSelector((String)"release"), (Object[])new Object[0]);
            Foundation.invoke((ID)pool, (Pointer)Foundation.createSelector((String)"release"), (Object[])new Object[0]);
        }

        private static Project getProject(boolean useDefault) {
            Project project = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext());
            if (project == null) {
                LOG.debug("MacMenu: no project in data context");
                Project[] projects = ProjectManager.getInstance().getOpenProjects();
                Project project2 = project = projects.length > 0 ? projects[0] : null;
                if (project == null && useDefault) {
                    LOG.debug("MacMenu: use default project instead");
                    project = ProjectManager.getInstance().getDefaultProject();
                }
            }
            LOG.debug("MacMenu: project = ", new Object[]{project});
            return project;
        }

        private static void submit(@NotNull String name, @NotNull Runnable task2) {
            if (name == null) {
                Worker.$$$reportNull$$$0(0);
            }
            if (task2 == null) {
                Worker.$$$reportNull$$$0(1);
            }
            LOG.debug("MacMenu: on EDT = ", new Object[]{SwingUtilities.isEventDispatchThread(), "; ENABLED = ", ENABLED.get()});
            if (!ENABLED.get()) {
                LOG.debug("MacMenu: disabled");
            } else {
                Component component = IdeFocusManager.getGlobalInstance().getFocusOwner();
                if (component != null && IdeKeyEventDispatcher.isModalContext(component)) {
                    LOG.debug("MacMenu: component in modal context");
                } else {
                    ENABLED.set(false);
                    TransactionGuard.submitTransaction((Disposable)ApplicationManager.getApplication(), () -> {
                        try {
                            LOG.debug("MacMenu: init ", new Object[]{name});
                            task2.run();
                        }
                        catch (Throwable throwable) {
                            LOG.debug("MacMenu: done ", new Object[]{name});
                            ENABLED.set(true);
                            throw throwable;
                        }
                        LOG.debug("MacMenu: done ", new Object[]{name});
                        ENABLED.set(true);
                    });
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "name";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "task";
                    break;
                }
            }
            objectArray[1] = "com/intellij/ui/mac/MacOSApplicationProvider$Worker";
            objectArray[2] = "submit";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

