/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.util.ssh;

import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.configuration.ServerConfiguration;
import com.intellij.remoteServer.impl.configuration.RemoteServerImpl;
import com.intellij.remoteServer.runtime.ServerConnection;
import com.intellij.remoteServer.runtime.ServerConnectionManager;
import com.intellij.remoteServer.runtime.deployment.DeploymentLogManager;
import com.intellij.remoteServer.runtime.deployment.DeploymentTask;
import com.intellij.remoteServer.runtime.log.LoggingHandler;
import com.intellij.remoteServer.runtime.ui.RemoteServersView;
import com.intellij.remoteServer.util.CloudConnectionTask;
import com.intellij.remoteServer.util.CloudNotifier;
import com.intellij.remoteServer.util.CloudRuntimeTask;
import com.intellij.remoteServer.util.CloudServerRuntimeInstance;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.remoteServer.util.ssh.PublicSshKeyDialog;
import com.intellij.remoteServer.util.ssh.SshKeyAwareServerRuntime;
import com.intellij.ui.HyperlinkLabel;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;

public class SshKeyChecker {
    private static boolean isSshKeyErrorMessage(String errorMessage) {
        return errorMessage.contains("Could not read from remote repository") || errorMessage.contains("The remote end hung up unexpectedly");
    }

    public void checkServerError(String errorMessage, CloudNotifier notifier, Project project, CloudConnectionTask connectionTask) {
        if (SshKeyChecker.isSshKeyErrorMessage(errorMessage)) {
            new ServerHandler(notifier, project, connectionTask).handle(errorMessage);
        } else {
            notifier.showMessage(errorMessage, MessageType.ERROR);
        }
    }

    public void checkDeploymentError(String errorMessage, SshKeyAwareServerRuntime serverRuntime, DeploymentLogManager logManager, DeploymentTask deploymentTask) {
        if (SshKeyChecker.isSshKeyErrorMessage(errorMessage) && logManager != null) {
            new DeploymentHandler(serverRuntime, logManager.getMainLoggingHandler(), deploymentTask).handle();
        }
    }

    public <C extends ServerConfiguration> void setupUploadLabel(HyperlinkLabel label2, UnnamedConfigurable serverConfigurable, C serverConfiguration, ServerType<C> serverType) {
        new ConfigurableHandler<C>(label2, serverConfigurable, serverConfiguration, serverType);
    }

    private static abstract class HandlerBase {
        private HandlerBase() {
        }

        protected void chooseKey() {
            PublicSshKeyDialog dialog2 = new PublicSshKeyDialog(this.getProject());
            if (dialog2.showAndGet()) {
                this.uploadKey(dialog2.getSshKey());
            }
        }

        protected abstract void uploadKey(File var1);

        protected abstract Project getProject();
    }

    private static class ConfigurableHandler<C extends ServerConfiguration>
    extends HandlerBase
    implements HyperlinkListener {
        private final UnnamedConfigurable myServerConfigurable;
        private final C myServerConfiguration;
        private final ServerType<C> myServerType;
        private final HyperlinkLabel myLabel;

        ConfigurableHandler(HyperlinkLabel label2, UnnamedConfigurable serverConfigurable, C serverConfiguration, ServerType<C> serverType) {
            this.myServerConfigurable = serverConfigurable;
            this.myServerConfiguration = serverConfiguration;
            this.myServerType = serverType;
            label2.setHyperlinkText("Upload Public SSH Key");
            label2.addHyperlinkListener((HyperlinkListener)this);
            this.myLabel = label2;
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent e) {
            this.chooseKey();
        }

        @Override
        protected void uploadKey(final File sskKey) {
            try {
                this.myServerConfigurable.apply();
            }
            catch (ConfigurationException e) {
                Messages.showErrorDialog((String)("Cannot upload SSH key: " + e.getMessage()), (String)e.getTitle());
                return;
            }
            RemoteServerImpl<C> server = new RemoteServerImpl<C>("<temp server to upload ssh key>", this.myServerType, this.myServerConfiguration);
            CloudConnectionTask task2 = new CloudConnectionTask(null, "Uploading SSH key", server){

                @Override
                protected Object run(CloudServerRuntimeInstance serverRuntime) throws ServerRuntimeException {
                    ((SshKeyAwareServerRuntime)((Object)serverRuntime)).addSshKey(sskKey);
                    return null;
                }
            };
            task2.performSync();
            task2.showMessageDialog((JComponent)this.myLabel, "SSH key was uploaded", "Public SSH Key");
        }

        @Override
        protected Project getProject() {
            return null;
        }
    }

    private static class DeploymentHandler
    extends HandlerBase {
        private final SshKeyAwareServerRuntime myServerRuntime;
        private final DeploymentTask myDeploymentTask;
        private final LoggingHandler myLoggingHandler;

        private DeploymentHandler(SshKeyAwareServerRuntime serverRuntime, LoggingHandler loggingHandler, DeploymentTask deploymentTask) {
            this.myServerRuntime = serverRuntime;
            this.myDeploymentTask = deploymentTask;
            this.myLoggingHandler = loggingHandler;
        }

        @Override
        protected Project getProject() {
            return this.myDeploymentTask.getProject();
        }

        public void handle() {
            this.myLoggingHandler.print("You may need to ");
            this.myLoggingHandler.printHyperlink("upload SSH public key", new HyperlinkInfo(){

                public void navigate(Project project) {
                    this.chooseKey();
                }
            });
            this.myLoggingHandler.print("\n");
        }

        @Override
        protected void uploadKey(final File sskKey) {
            new CloudRuntimeTask(this.getProject(), "Uploading SSH key"){

                protected CloudServerRuntimeInstance getServerRuntime() {
                    return myServerRuntime.asCloudServerRuntime();
                }

                protected Object run(CloudServerRuntimeInstance serverRuntimeInstance) throws ServerRuntimeException {
                    myServerRuntime.addSshKey(sskKey);
                    myLoggingHandler.print("SSH key was uploaded, you may ");
                    myLoggingHandler.printHyperlink("redeploy", new HyperlinkInfo(){

                        public void navigate(Project project) {
                            this.redeploy();
                        }
                    });
                    myLoggingHandler.print("\n");
                    return null;
                }

                @Override
                protected void runtimeErrorOccurred(@NotNull String errorMessage) {
                    if (errorMessage == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    myLoggingHandler.print("Unable to upload SSH key: " + errorMessage + "\n");
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/intellij/remoteServer/util/ssh/SshKeyChecker$DeploymentHandler$2", "runtimeErrorOccurred"));
                }
            }.performSync();
        }

        private void redeploy() {
            ServerConnection connection = ServerConnectionManager.getInstance().getOrCreateConnection(this.myServerRuntime.getServer());
            RemoteServersView view = RemoteServersView.getInstance(this.myDeploymentTask.getProject());
            view.showServerConnection(connection);
            connection.deploy(this.myDeploymentTask, s -> view.showDeployment(connection, (String)s));
        }
    }

    private static class ServerHandler
    extends HandlerBase {
        private final CloudNotifier myNotifier;
        private final Project myProject;
        private final CloudConnectionTask myConnectionTask;
        private Notification myErrorNotification;

        ServerHandler(CloudNotifier notifier, Project project, CloudConnectionTask connectionTask) {
            this.myNotifier = notifier;
            this.myProject = project;
            this.myConnectionTask = connectionTask;
        }

        @Override
        public Project getProject() {
            return this.myProject;
        }

        public void handle(String errorMessage) {
            this.myNotifier.showMessage(errorMessage + "<br/>You may need to <a href=\"#\">upload SSH public key</a>", MessageType.ERROR, new NotificationListener(){

                public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                    if (notification == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (event == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    myErrorNotification = notification;
                    this.chooseKey();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "notification";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "event";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/remoteServer/util/ssh/SshKeyChecker$ServerHandler$1";
                    objectArray[2] = "hyperlinkUpdate";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }

        @Override
        protected void uploadKey(final File sskKey) {
            new CloudConnectionTask(this.myProject, "Uploading SSH key", this.myConnectionTask.getServer()){

                @Override
                protected Object run(CloudServerRuntimeInstance serverRuntime) throws ServerRuntimeException {
                    ((SshKeyAwareServerRuntime)((Object)serverRuntime)).addSshKey(sskKey);
                    myErrorNotification.expire();
                    myNotifier.showMessage("SSH key was uploaded, you may <a href=\"#\">reconnect</a>", MessageType.INFO, new NotificationListener(){

                        public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                            if (notification == null) {
                                ServerHandler.1.$$$reportNull$$$0(0);
                            }
                            if (event == null) {
                                ServerHandler.1.$$$reportNull$$$0(1);
                            }
                            notification.expire();
                            this.reconnect();
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            Object[] objectArray;
                            Object[] objectArray2 = new Object[3];
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[0] = "notification";
                                    break;
                                }
                                case 1: {
                                    objectArray = objectArray2;
                                    objectArray2[0] = "event";
                                    break;
                                }
                            }
                            objectArray[1] = "com/intellij/remoteServer/util/ssh/SshKeyChecker$ServerHandler$2$1";
                            objectArray[2] = "hyperlinkUpdate";
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                        }
                    });
                    return null;
                }

                @Override
                protected void runtimeErrorOccurred(@NotNull String errorMessage) {
                    if (errorMessage == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    myNotifier.showMessage(errorMessage, MessageType.ERROR);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/intellij/remoteServer/util/ssh/SshKeyChecker$ServerHandler$2", "runtimeErrorOccurred"));
                }
            }.performSync();
        }

        private void reconnect() {
            this.myConnectionTask.performAsync();
        }
    }
}

