/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.include;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.impl.include.FileIncludeInfo;
import com.intellij.psi.impl.include.FileIncludeInfoImpl;
import com.intellij.psi.impl.include.FileIncludeProvider;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.KeyDescriptor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class FileIncludeIndex
extends FileBasedIndexExtension<String, List<FileIncludeInfoImpl>> {
    public static final ID<String, List<FileIncludeInfoImpl>> INDEX_ID = ID.create((String)"fileIncludes");
    private static final int BASE_VERSION = 6;

    @NotNull
    public static List<FileIncludeInfo> getIncludes(@NotNull VirtualFile file2, @NotNull Project project) {
        if (file2 == null) {
            FileIncludeIndex.$$$reportNull$$$0(0);
        }
        if (project == null) {
            FileIncludeIndex.$$$reportNull$$$0(1);
        }
        Map data = FileBasedIndex.getInstance().getFileData(INDEX_ID, file2, project);
        List list2 = ContainerUtil.flatten(data.values());
        if (list2 == null) {
            FileIncludeIndex.$$$reportNull$$$0(2);
        }
        return list2;
    }

    @NotNull
    public static MultiMap<VirtualFile, FileIncludeInfoImpl> getIncludingFileCandidates(String fileName2, @NotNull GlobalSearchScope scope) {
        if (scope == null) {
            FileIncludeIndex.$$$reportNull$$$0(3);
        }
        MultiMap result2 = new MultiMap();
        FileBasedIndex.getInstance().processValues(INDEX_ID, (Object)fileName2, null, (file2, value) -> {
            result2.put((Object)file2, (Collection)value);
            return true;
        }, scope);
        MultiMap multiMap = result2;
        if (multiMap == null) {
            FileIncludeIndex.$$$reportNull$$$0(4);
        }
        return multiMap;
    }

    @NotNull
    public ID<String, List<FileIncludeInfoImpl>> getName() {
        ID<String, List<FileIncludeInfoImpl>> iD = INDEX_ID;
        if (iD == null) {
            FileIncludeIndex.$$$reportNull$$$0(5);
        }
        return iD;
    }

    @NotNull
    public DataIndexer<String, List<FileIncludeInfoImpl>, FileContent> getIndexer() {
        DataIndexer<String, List<FileIncludeInfoImpl>, FileContent> dataIndexer = new DataIndexer<String, List<FileIncludeInfoImpl>, FileContent>(){

            @NotNull
            public Map<String, List<FileIncludeInfoImpl>> map(@NotNull FileContent inputData) {
                if (inputData == null) {
                    1.$$$reportNull$$$0(0);
                }
                Map map2 = FactoryMap.create(key -> new ArrayList());
                for (FileIncludeProvider provider : Holder.myProviders) {
                    FileIncludeInfo[] infos;
                    if (!provider.acceptFile(inputData.getFile()) || (infos = provider.getIncludeInfos(inputData)).length == 0) continue;
                    for (FileIncludeInfo info : infos) {
                        FileIncludeInfoImpl impl = new FileIncludeInfoImpl(info.path, info.offset, info.runtimeOnly, provider.getId());
                        ((List)map2.get(info.fileName)).add(impl);
                    }
                }
                Map map3 = map2;
                if (map3 == null) {
                    1.$$$reportNull$$$0(1);
                }
                return map3;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "inputData";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/psi/impl/include/FileIncludeIndex$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/psi/impl/include/FileIncludeIndex$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "map";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "map";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        if (dataIndexer == null) {
            FileIncludeIndex.$$$reportNull$$$0(6);
        }
        return dataIndexer;
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
        if (enumeratorStringDescriptor == null) {
            FileIncludeIndex.$$$reportNull$$$0(7);
        }
        return enumeratorStringDescriptor;
    }

    @NotNull
    public DataExternalizer<List<FileIncludeInfoImpl>> getValueExternalizer() {
        DataExternalizer<List<FileIncludeInfoImpl>> dataExternalizer = new DataExternalizer<List<FileIncludeInfoImpl>>(){

            public void save(@NotNull DataOutput out, List<FileIncludeInfoImpl> value) throws IOException {
                if (out == null) {
                    2.$$$reportNull$$$0(0);
                }
                out.writeInt(value.size());
                for (FileIncludeInfoImpl info : value) {
                    IOUtil.writeUTF((DataOutput)out, (String)info.path);
                    out.writeInt(info.offset);
                    out.writeBoolean(info.runtimeOnly);
                    IOUtil.writeUTF((DataOutput)out, (String)info.providerId);
                }
            }

            public List<FileIncludeInfoImpl> read(@NotNull DataInput in) throws IOException {
                if (in == null) {
                    2.$$$reportNull$$$0(1);
                }
                int size = in.readInt();
                ArrayList<FileIncludeInfoImpl> infos = new ArrayList<FileIncludeInfoImpl>(size);
                for (int i = 0; i < size; ++i) {
                    infos.add(new FileIncludeInfoImpl(IOUtil.readUTF((DataInput)in), in.readInt(), in.readBoolean(), IOUtil.readUTF((DataInput)in)));
                }
                return infos;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "out";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "in";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/psi/impl/include/FileIncludeIndex$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "save";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "read";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (dataExternalizer == null) {
            FileIncludeIndex.$$$reportNull$$$0(8);
        }
        return dataExternalizer;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        FileBasedIndex.FileTypeSpecificInputFilter fileTypeSpecificInputFilter = new FileBasedIndex.FileTypeSpecificInputFilter(){

            public boolean acceptInput(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (file2.getFileSystem() == JarFileSystem.getInstance()) {
                    return false;
                }
                for (FileIncludeProvider provider : Holder.myProviders) {
                    if (!provider.acceptFile(file2)) continue;
                    return true;
                }
                return false;
            }

            public void registerFileTypesUsedForIndexing(@NotNull Consumer<FileType> fileTypeSink) {
                if (fileTypeSink == null) {
                    3.$$$reportNull$$$0(1);
                }
                for (FileIncludeProvider provider : Holder.myProviders) {
                    provider.registerFileTypesUsedForIndexing(fileTypeSink);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "fileTypeSink";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/psi/impl/include/FileIncludeIndex$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "acceptInput";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "registerFileTypesUsedForIndexing";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (fileTypeSpecificInputFilter == null) {
            FileIncludeIndex.$$$reportNull$$$0(9);
        }
        return fileTypeSpecificInputFilter;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    public int getVersion() {
        int version2 = 6;
        for (FileIncludeProvider provider : Holder.myProviders) {
            version2 = version2 * 31 + (provider.getVersion() ^ provider.getClass().getName().hashCode());
        }
        return version2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/include/FileIncludeIndex";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/include/FileIncludeIndex";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getIncludes";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getIncludingFileCandidates";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexer";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyDescriptor";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueExternalizer";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getIncludes";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getIncludingFileCandidates";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Holder {
        private static final List<FileIncludeProvider> myProviders = FileIncludeProvider.EP_NAME.getExtensionList();

        private Holder() {
        }
    }
}

