/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.impl.status.InlineProgressIndicator;
import com.intellij.openapi.wm.impl.status.ProgressButton;
import com.intellij.ui.TransparentPanel;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.jetbrains.annotations.NotNull;

public class PresentationModeProgressPanel {
    private final InlineProgressIndicator myProgress;
    private final JBIterable<ProgressButton> myEastButtons;
    private JLabel myText;
    private JProgressBar myProgressBar;
    private JLabel myText2;
    private JPanel myRootPanel;
    private JPanel myButtonPanel;

    public PresentationModeProgressPanel(InlineProgressIndicator progress) {
        this.myProgress = progress;
        this.$$$setupUI$$$();
        JBFont font = JBUI.Fonts.label((float)11.0f);
        this.myText.setFont((Font)font);
        this.myText2.setFont((Font)font);
        this.myText.setIcon((Icon)JBUI.scale((JBUI.JBIcon)EmptyIcon.create((int)1, (int)16)));
        this.myText2.setIcon((Icon)JBUI.scale((JBUI.JBIcon)EmptyIcon.create((int)1, (int)16)));
        this.myEastButtons = this.myProgress.createEastButtons();
        this.myButtonPanel.add(InlineProgressIndicator.createButtonPanel((Iterable<? extends JComponent>)this.myEastButtons.map(b -> b.button)));
        this.myRootPanel.setPreferredSize((Dimension)new JBDimension(250, 60));
        this.myProgressBar.setPreferredSize(new Dimension(JBUIScale.scale((int)250), this.myProgressBar.getPreferredSize().height));
    }

    @NotNull
    private static Color getTextForeground() {
        Color color = EditorColorsManager.getInstance().getGlobalScheme().getDefaultForeground();
        if (color == null) {
            PresentationModeProgressPanel.$$$reportNull$$$0(0);
        }
        return color;
    }

    void update() {
        Color color = PresentationModeProgressPanel.getTextForeground();
        this.myText.setForeground(color);
        this.myText2.setForeground(color);
        this.myProgressBar.setForeground(color);
        if (!StringUtil.equals((CharSequence)this.myText.getText(), (CharSequence)this.myProgress.getText())) {
            this.myText.setText(this.myProgress.getText());
        }
        if (!StringUtil.equals((CharSequence)this.myText2.getText(), (CharSequence)this.myProgress.getText2())) {
            this.myText2.setText(this.myProgress.getText2());
        }
        if ((this.myProgress.isIndeterminate() || this.myProgress.getFraction() == 0.0) != this.myProgressBar.isIndeterminate()) {
            this.myProgressBar.setIndeterminate(this.myProgress.isIndeterminate() || this.myProgress.getFraction() == 0.0);
            this.myProgressBar.revalidate();
        }
        if (!this.myProgressBar.isIndeterminate()) {
            this.myProgressBar.setValue((int)(this.myProgress.getFraction() * 99.0) + 1);
        }
        this.myEastButtons.forEach(b -> b.updateAction.run());
    }

    @NotNull
    public JComponent getProgressPanel() {
        JPanel jPanel = this.myRootPanel;
        if (jPanel == null) {
            PresentationModeProgressPanel.$$$reportNull$$$0(1);
        }
        return jPanel;
    }

    private void createUIComponents() {
        this.myRootPanel = new TransparentPanel(0.5f){

            public boolean isVisible() {
                UISettings ui = UISettings.getInstance();
                return ui.getPresentationMode() || !ui.getShowStatusBar() && Registry.is((String)"ide.show.progress.without.status.bar");
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/openapi/wm/impl/status/PresentationModeProgressPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextForeground";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getProgressPanel";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JLabel jLabel2;
        JPanel jPanel;
        JProgressBar jProgressBar;
        this.createUIComponents();
        JPanel jPanel2 = this.myRootPanel;
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.setOpaque(false);
        this.myProgressBar = jProgressBar = new JProgressBar();
        jProgressBar.setIndeterminate(true);
        jProgressBar.setOpaque(false);
        jPanel2.add((Component)jProgressBar, new GridConstraints(1, 0, 1, 1, 8, 0, 7, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(3, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myButtonPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel.setOpaque(false);
        jPanel2.add((Component)jPanel, new GridConstraints(1, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myText = jLabel2 = new JLabel();
        jLabel2.setAutoscrolls(true);
        jLabel2.setText("");
        jPanel2.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(209, -1), new Dimension(209, -1), new Dimension(209, -1)));
        this.myText2 = jLabel = new JLabel();
        jLabel.setText("");
        jPanel2.add((Component)jLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, new Dimension(209, -1), new Dimension(209, -1), new Dimension(209, -1)));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }
}

