/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.persistent;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.concurrency.JobSchedulerImpl;
import com.intellij.diagnostic.Activity;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectLocator;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.io.BufferExposingByteArrayInputStream;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.io.ByteArraySequence;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.InvalidVirtualFileAccessException;
import com.intellij.openapi.vfs.PersistentFSConstants;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.openapi.vfs.ex.temp.TempFileSystem;
import com.intellij.openapi.vfs.newvfs.ArchiveFileSystem;
import com.intellij.openapi.vfs.newvfs.AsyncEventSupport;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.ChildInfoImpl;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.VfsImplUtil;
import com.intellij.openapi.vfs.newvfs.events.ChildInfo;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.openapi.vfs.newvfs.impl.FakeVirtualFile;
import com.intellij.openapi.vfs.newvfs.impl.FileNameCache;
import com.intellij.openapi.vfs.newvfs.impl.StubVirtualFile;
import com.intellij.openapi.vfs.newvfs.impl.VfsData;
import com.intellij.openapi.vfs.newvfs.impl.VirtualDirectoryImpl;
import com.intellij.openapi.vfs.newvfs.impl.VirtualFileSystemEntry;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecords;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.BitUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PairConsumer;
import com.intellij.util.PairFunction;
import com.intellij.util.SmartList;
import com.intellij.util.UriUtil;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import com.intellij.util.containers.MostlySingularMultiMap;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.io.ReplicatorInputStream;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.CharSequenceHashingStrategy;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntHashSet;
import gnu.trove.TObjectHashingStrategy;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PersistentFSImpl
extends PersistentFS
implements Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vfs.newvfs.persistent.PersistentFS");
    private final Map<String, VirtualFileSystemEntry> myRoots;
    private final ConcurrentIntObjectMap<VirtualFileSystemEntry> myIdToDirCache;
    private final Object myInputLock;
    private final AtomicBoolean myShutDown;
    private final AtomicInteger myStructureModificationCount;
    private final BulkFileListener myPublisher;
    private final VfsData myVfsData;
    private static final int INNER_ARRAYS_THRESHOLD = 1024;

    public PersistentFSImpl(@NotNull MessageBus bus) {
        if (bus == null) {
            PersistentFSImpl.$$$reportNull$$$0(0);
        }
        this.myRoots = ConcurrentCollectionFactory.createMap(10, 0.4f, JobSchedulerImpl.getCPUCoresCount(), FileUtil.PATH_HASHING_STRATEGY);
        this.myIdToDirCache = ContainerUtil.createConcurrentIntObjectSoftValueMap();
        this.myInputLock = new Object();
        this.myShutDown = new AtomicBoolean(false);
        this.myStructureModificationCount = new AtomicInteger();
        this.myVfsData = new VfsData();
        ShutDownTracker.getInstance().registerShutdownTask(this::performShutdown);
        LowMemoryWatcher.register(this::clearIdCache, (Disposable)this);
        this.myPublisher = (BulkFileListener)bus.syncPublisher(VirtualFileManager.VFS_CHANGES);
        AsyncEventSupport.startListening();
        Activity activity = StartUpMeasurer.start((String)"PersistentFS#FSRecords.connect");
        FSRecords.connect();
        activity.end();
    }

    public void dispose() {
        this.performShutdown();
    }

    private void performShutdown() {
        if (this.myShutDown.compareAndSet(false, true)) {
            LOG.info("VFS dispose started");
            FSRecords.dispose();
            LOG.info("VFS dispose completed");
        }
    }

    public boolean areChildrenLoaded(@NotNull VirtualFile dir) {
        if (dir == null) {
            PersistentFSImpl.$$$reportNull$$$0(1);
        }
        return PersistentFSImpl.areChildrenLoaded(PersistentFSImpl.getFileId(dir));
    }

    public long getCreationTimestamp() {
        return FSRecords.getCreationTimestamp();
    }

    @NotNull
    public VirtualFileSystemEntry getOrCacheDir(int id, @NotNull VfsData.Segment segment, @NotNull VfsData.DirectoryData o, @NotNull VirtualDirectoryImpl parent) {
        VirtualFileSystemEntry dir;
        if (segment == null) {
            PersistentFSImpl.$$$reportNull$$$0(2);
        }
        if (o == null) {
            PersistentFSImpl.$$$reportNull$$$0(3);
        }
        if (parent == null) {
            PersistentFSImpl.$$$reportNull$$$0(4);
        }
        if ((dir = (VirtualFileSystemEntry)((Object)this.myIdToDirCache.get(id))) != null) {
            VirtualFileSystemEntry virtualFileSystemEntry = dir;
            if (virtualFileSystemEntry == null) {
                PersistentFSImpl.$$$reportNull$$$0(5);
            }
            return virtualFileSystemEntry;
        }
        dir = new VirtualDirectoryImpl(id, segment, o, parent, parent.getFileSystem());
        VirtualFileSystemEntry virtualFileSystemEntry = (VirtualFileSystemEntry)((Object)this.myIdToDirCache.cacheOrGet(id, (Object)dir));
        if (virtualFileSystemEntry == null) {
            PersistentFSImpl.$$$reportNull$$$0(6);
        }
        return virtualFileSystemEntry;
    }

    public VirtualFileSystemEntry getCachedDir(int id) {
        return (VirtualFileSystemEntry)((Object)this.myIdToDirCache.get(id));
    }

    @NotNull
    private static NewVirtualFileSystem getDelegate(@NotNull VirtualFile file2) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(7);
        }
        NewVirtualFileSystem newVirtualFileSystem = (NewVirtualFileSystem)file2.getFileSystem();
        if (newVirtualFileSystem == null) {
            PersistentFSImpl.$$$reportNull$$$0(8);
        }
        return newVirtualFileSystem;
    }

    public boolean wereChildrenAccessed(@NotNull VirtualFile dir) {
        if (dir == null) {
            PersistentFSImpl.$$$reportNull$$$0(9);
        }
        return FSRecords.wereChildrenAccessed(PersistentFSImpl.getFileId(dir));
    }

    @NotNull
    public String[] list(@NotNull VirtualFile file2) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(10);
        }
        Object[] nameIds = this.listAll(file2);
        String[] stringArray = (String[])ContainerUtil.map2Array((Object[])nameIds, String.class, id -> id.name.toString());
        if (stringArray == null) {
            PersistentFSImpl.$$$reportNull$$$0(11);
        }
        return stringArray;
    }

    @Override
    @NotNull
    public String[] listPersisted(@NotNull VirtualFile parent) {
        if (parent == null) {
            PersistentFSImpl.$$$reportNull$$$0(12);
        }
        String[] stringArray = PersistentFSImpl.listPersisted(FSRecords.list(PersistentFSImpl.getFileId(parent)));
        if (stringArray == null) {
            PersistentFSImpl.$$$reportNull$$$0(13);
        }
        return stringArray;
    }

    @NotNull
    private static String[] listPersisted(@NotNull int[] childrenIds) {
        if (childrenIds == null) {
            PersistentFSImpl.$$$reportNull$$$0(14);
        }
        String[] names2 = ArrayUtil.newStringArray((int)childrenIds.length);
        for (int i = 0; i < childrenIds.length; ++i) {
            names2[i] = FSRecords.getName(childrenIds[i]);
        }
        if (names2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(15);
        }
        return names2;
    }

    @NotNull
    private static FSRecords.NameId[] persistAllChildren(@NotNull VirtualFile file2, int id, @NotNull FSRecords.NameId[] current) {
        NewVirtualFileSystem fs;
        String[] delegateNames;
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(16);
        }
        if (current == null) {
            PersistentFSImpl.$$$reportNull$$$0(17);
        }
        if ((delegateNames = VfsUtil.filterNames((String[])(fs = PersistentFSImpl.replaceWithNativeFS(PersistentFSImpl.getDelegate(file2))).list(file2))).length == 0 && current.length > 0) {
            if (current == null) {
                PersistentFSImpl.$$$reportNull$$$0(18);
            }
            return current;
        }
        THashSet toAdd = new THashSet(Arrays.asList(delegateNames), FileUtil.PATH_HASHING_STRATEGY);
        for (FSRecords.NameId nameId : current) {
            toAdd.remove(nameId.name.toString());
        }
        TIntArrayList childrenIds = new TIntArrayList(current.length + toAdd.size());
        ArrayList<FSRecords.NameId> nameIds = new ArrayList<FSRecords.NameId>(current.length + toAdd.size());
        for (FSRecords.NameId nameId : current) {
            childrenIds.add(nameId.id);
            nameIds.add(nameId);
        }
        for (String newName : toAdd) {
            Pair<FileAttributes, String> childData = PersistentFSImpl.getChildData(fs, file2, newName, null, null);
            if (childData == null) continue;
            int childId = PersistentFSImpl.makeChildRecord(id, newName, childData, fs);
            childrenIds.add(childId);
            nameIds.add(new FSRecords.NameId(childId, FileNameCache.storeName(newName), newName));
        }
        nameIds.sort(Comparator.comparingInt(o -> o.id));
        FSRecords.updateList(id, childrenIds.toNativeArray());
        PersistentFSImpl.setChildrenCached(id);
        FSRecords.NameId[] nameIdArray = nameIds.toArray(FSRecords.NameId.EMPTY_ARRAY);
        if (nameIdArray == null) {
            PersistentFSImpl.$$$reportNull$$$0(19);
        }
        return nameIdArray;
    }

    private static void setChildrenCached(int id) {
        int flags = FSRecords.getFlags(id);
        FSRecords.setFlags(id, flags | 1, true);
    }

    @Override
    @NotNull
    public FSRecords.NameId[] listAll(@NotNull VirtualFile file2) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(20);
        }
        int id = PersistentFSImpl.getFileId(file2);
        FSRecords.NameId[] nameIds = FSRecords.listAll(id);
        if (!PersistentFSImpl.areChildrenLoaded(id)) {
            nameIds = PersistentFSImpl.persistAllChildren(file2, id, nameIds);
        }
        if (nameIds == null) {
            PersistentFSImpl.$$$reportNull$$$0(21);
        }
        return nameIds;
    }

    private static boolean areChildrenLoaded(int parentId) {
        return BitUtil.isSet((int)FSRecords.getFlags(parentId), (int)1);
    }

    @Nullable
    public DataInputStream readAttribute(@NotNull VirtualFile file2, @NotNull FileAttribute att) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(22);
        }
        if (att == null) {
            PersistentFSImpl.$$$reportNull$$$0(23);
        }
        return FSRecords.readAttributeWithLock(PersistentFSImpl.getFileId(file2), att);
    }

    @NotNull
    public DataOutputStream writeAttribute(@NotNull VirtualFile file2, @NotNull FileAttribute att) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(24);
        }
        if (att == null) {
            PersistentFSImpl.$$$reportNull$$$0(25);
        }
        com.intellij.util.io.DataOutputStream dataOutputStream = FSRecords.writeAttribute(PersistentFSImpl.getFileId(file2), att);
        if (dataOutputStream == null) {
            PersistentFSImpl.$$$reportNull$$$0(26);
        }
        return dataOutputStream;
    }

    @Nullable
    private static DataInputStream readContent(@NotNull VirtualFile file2) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(27);
        }
        return FSRecords.readContent(PersistentFSImpl.getFileId(file2));
    }

    @NotNull
    private static DataInputStream readContentById(int contentId) {
        DataInputStream dataInputStream = FSRecords.readContentById(contentId);
        if (dataInputStream == null) {
            PersistentFSImpl.$$$reportNull$$$0(28);
        }
        return dataInputStream;
    }

    @NotNull
    private static DataOutputStream writeContent(@NotNull VirtualFile file2, boolean readOnly) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(29);
        }
        com.intellij.util.io.DataOutputStream dataOutputStream = FSRecords.writeContent(PersistentFSImpl.getFileId(file2), readOnly);
        if (dataOutputStream == null) {
            PersistentFSImpl.$$$reportNull$$$0(30);
        }
        return dataOutputStream;
    }

    private static void writeContent(@NotNull VirtualFile file2, ByteArraySequence content2, boolean readOnly) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(31);
        }
        FSRecords.writeContent(PersistentFSImpl.getFileId(file2), content2, readOnly);
    }

    @Override
    public int storeUnlinkedContent(@NotNull byte[] bytes) {
        if (bytes == null) {
            PersistentFSImpl.$$$reportNull$$$0(32);
        }
        return FSRecords.storeUnlinkedContent(bytes);
    }

    public int getModificationCount(@NotNull VirtualFile file2) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(33);
        }
        return FSRecords.getModCount(PersistentFSImpl.getFileId(file2));
    }

    public int getModificationCount() {
        return FSRecords.getLocalModCount();
    }

    public int getStructureModificationCount() {
        return this.myStructureModificationCount.get();
    }

    public void incStructuralModificationCount() {
        this.myStructureModificationCount.incrementAndGet();
    }

    public int getFilesystemModificationCount() {
        return FSRecords.getModCount();
    }

    private static boolean writeAttributesToRecord(int id, int parentId, @NotNull CharSequence name, @NotNull NewVirtualFileSystem fs, @NotNull FileAttributes attributes, @Nullable String symlinkTarget) {
        if (name == null) {
            PersistentFSImpl.$$$reportNull$$$0(34);
        }
        if (fs == null) {
            PersistentFSImpl.$$$reportNull$$$0(35);
        }
        if (attributes == null) {
            PersistentFSImpl.$$$reportNull$$$0(36);
        }
        assert (id > 0) : id;
        if (name.length() != 0 ? PersistentFSImpl.namesEqual((VirtualFileSystem)fs, name, FSRecords.getNameSequence(id)) : PersistentFSImpl.areChildrenLoaded(id)) {
            return false;
        }
        FSRecords.writeAttributesToRecord(id, parentId, attributes, name.toString());
        if (attributes.isSymLink()) {
            FSRecords.storeSymlinkTarget(id, symlinkTarget);
        }
        return true;
    }

    @Override
    public int getFileAttributes(int id) {
        assert (id > 0);
        return FSRecords.getFlags(id);
    }

    public boolean isDirectory(@NotNull VirtualFile file2) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(37);
        }
        return PersistentFSImpl.isDirectory(this.getFileAttributes(PersistentFSImpl.getFileId(file2)));
    }

    private static boolean namesEqual(@NotNull VirtualFileSystem fs, @NotNull CharSequence n1, @NotNull CharSequence n2) {
        if (fs == null) {
            PersistentFSImpl.$$$reportNull$$$0(38);
        }
        if (n1 == null) {
            PersistentFSImpl.$$$reportNull$$$0(39);
        }
        if (n2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(40);
        }
        return Comparing.equal((CharSequence)n1, (CharSequence)n2, (boolean)fs.isCaseSensitive());
    }

    public boolean exists(@NotNull VirtualFile fileOrDirectory) {
        if (fileOrDirectory == null) {
            PersistentFSImpl.$$$reportNull$$$0(41);
        }
        return fileOrDirectory.exists();
    }

    public long getTimeStamp(@NotNull VirtualFile file2) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(42);
        }
        return FSRecords.getTimestamp(PersistentFSImpl.getFileId(file2));
    }

    public void setTimeStamp(@NotNull VirtualFile file2, long modStamp) throws IOException {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(43);
        }
        int id = PersistentFSImpl.getFileId(file2);
        FSRecords.setTimestamp(id, modStamp);
        PersistentFSImpl.getDelegate(file2).setTimeStamp(file2, modStamp);
    }

    private static int getFileId(@NotNull VirtualFile file2) {
        int id;
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(44);
        }
        if ((id = ((VirtualFileWithId)file2).getId()) <= 0) {
            throw new InvalidVirtualFileAccessException(file2);
        }
        return id;
    }

    public boolean isSymLink(@NotNull VirtualFile file2) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(45);
        }
        return PersistentFSImpl.isSymLink(this.getFileAttributes(PersistentFSImpl.getFileId(file2)));
    }

    public String resolveSymLink(@NotNull VirtualFile file2) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(46);
        }
        return FSRecords.readSymlinkTarget(PersistentFSImpl.getFileId(file2));
    }

    public boolean isWritable(@NotNull VirtualFile file2) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(47);
        }
        return !BitUtil.isSet((int)this.getFileAttributes(PersistentFSImpl.getFileId(file2)), (int)4);
    }

    @Override
    public boolean isHidden(@NotNull VirtualFile file2) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(48);
        }
        return BitUtil.isSet((int)this.getFileAttributes(PersistentFSImpl.getFileId(file2)), (int)64);
    }

    public void setWritable(@NotNull VirtualFile file2, boolean writableFlag) throws IOException {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(49);
        }
        PersistentFSImpl.getDelegate(file2).setWritable(file2, writableFlag);
        boolean oldWritable = this.isWritable(file2);
        if (oldWritable != writableFlag) {
            this.processEvent((VFileEvent)new VFilePropertyChangeEvent((Object)this, file2, "writable", (Object)oldWritable, (Object)writableFlag, false));
        }
    }

    @Override
    public int getId(@NotNull VirtualFile parent, @NotNull String childName, @NotNull NewVirtualFileSystem fs) {
        int parentId;
        int[] children2;
        int childId;
        if (parent == null) {
            PersistentFSImpl.$$$reportNull$$$0(50);
        }
        if (childName == null) {
            PersistentFSImpl.$$$reportNull$$$0(51);
        }
        if (fs == null) {
            PersistentFSImpl.$$$reportNull$$$0(52);
        }
        if ((childId = PersistentFSImpl.findExistingId(childName, children2 = FSRecords.list(parentId = PersistentFSImpl.getFileId(parent)), fs)) > 0) {
            return childId;
        }
        Pair<FileAttributes, String> childData = PersistentFSImpl.getChildData(fs, parent, childName, null, null);
        if (childData != null) {
            String oldChildName = childName;
            if ((childName = fs.getCanonicallyCasedName((VirtualFile)new FakeVirtualFile(parent, oldChildName))).isEmpty()) {
                return 0;
            }
            if (!childName.equals(oldChildName) && (childId = PersistentFSImpl.findExistingId(childName, children2, fs)) > 0) {
                return childId;
            }
            childId = PersistentFSImpl.makeChildRecord(parentId, childName, childData, fs);
            FSRecords.updateList(parentId, ArrayUtil.append((int[])children2, (int)childId));
            return childId;
        }
        return 0;
    }

    private static int findExistingId(@NotNull String childName, @NotNull int[] childIds, @NotNull NewVirtualFileSystem fs) {
        if (childName == null) {
            PersistentFSImpl.$$$reportNull$$$0(53);
        }
        if (childIds == null) {
            PersistentFSImpl.$$$reportNull$$$0(54);
        }
        if (fs == null) {
            PersistentFSImpl.$$$reportNull$$$0(55);
        }
        if (childIds.length > 0) {
            int nameId = FSRecords.getNameId(childName);
            int[] nArray = childIds;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                int childId = nArray[i];
                if (nameId != FSRecords.getNameId(childId)) continue;
                return childId;
            }
        }
        for (int childId : childIds) {
            if (!PersistentFSImpl.namesEqual((VirtualFileSystem)fs, childName, FSRecords.getNameSequence(childId))) continue;
            return childId;
        }
        return 0;
    }

    public long getLength(@NotNull VirtualFile file2) {
        long length;
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(56);
        }
        return (length = PersistentFSImpl.getLengthIfUpToDate(file2)) == -1L ? PersistentFSImpl.reloadLengthFromDelegate(file2, PersistentFSImpl.getDelegate(file2)) : length;
    }

    @Override
    public long getLastRecordedLength(@NotNull VirtualFile file2) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(57);
        }
        int id = PersistentFSImpl.getFileId(file2);
        return FSRecords.getLength(id);
    }

    @NotNull
    public VirtualFile copyFile(Object requestor, @NotNull VirtualFile file2, @NotNull VirtualFile parent, @NotNull String name) throws IOException {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(58);
        }
        if (parent == null) {
            PersistentFSImpl.$$$reportNull$$$0(59);
        }
        if (name == null) {
            PersistentFSImpl.$$$reportNull$$$0(60);
        }
        PersistentFSImpl.getDelegate(file2).copyFile(requestor, file2, parent, name);
        this.processEvent((VFileEvent)new VFileCopyEvent(requestor, file2, parent, name));
        VirtualFile child2 = parent.findChild(name);
        if (child2 == null) {
            throw new IOException("Cannot create child");
        }
        VirtualFile virtualFile = child2;
        if (virtualFile == null) {
            PersistentFSImpl.$$$reportNull$$$0(61);
        }
        return virtualFile;
    }

    @NotNull
    public VirtualFile createChildDirectory(Object requestor, @NotNull VirtualFile parent, @NotNull String dir) throws IOException {
        if (parent == null) {
            PersistentFSImpl.$$$reportNull$$$0(62);
        }
        if (dir == null) {
            PersistentFSImpl.$$$reportNull$$$0(63);
        }
        PersistentFSImpl.getDelegate(parent).createChildDirectory(requestor, parent, dir);
        this.processEvent((VFileEvent)new VFileCreateEvent(requestor, parent, dir, true, null, null, false, ChildInfo.EMPTY_ARRAY));
        VirtualFile child2 = parent.findChild(dir);
        if (child2 == null) {
            throw new IOException("Cannot create child directory '" + dir + "' at " + parent.getPath());
        }
        VirtualFile virtualFile = child2;
        if (virtualFile == null) {
            PersistentFSImpl.$$$reportNull$$$0(64);
        }
        return virtualFile;
    }

    @NotNull
    public VirtualFile createChildFile(Object requestor, @NotNull VirtualFile parent, @NotNull String file2) throws IOException {
        if (parent == null) {
            PersistentFSImpl.$$$reportNull$$$0(65);
        }
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(66);
        }
        PersistentFSImpl.getDelegate(parent).createChildFile(requestor, parent, file2);
        this.processEvent((VFileEvent)new VFileCreateEvent(requestor, parent, file2, false, null, null, false, null));
        VirtualFile child2 = parent.findChild(file2);
        if (child2 == null) {
            throw new IOException("Cannot create child file '" + file2 + "' at " + parent.getPath());
        }
        if (child2.getCharset().equals(StandardCharsets.UTF_8)) {
            EncodingManager encodingManager;
            Project project = ProjectLocator.getInstance().guessProjectForFile(child2);
            Object object = encodingManager = project == null ? EncodingManager.getInstance() : EncodingProjectManager.getInstance((Project)project);
            if (encodingManager.shouldAddBOMForNewUtf8File()) {
                child2.setBOM(CharsetToolkit.UTF8_BOM);
            }
        }
        VirtualFile virtualFile = child2;
        if (virtualFile == null) {
            PersistentFSImpl.$$$reportNull$$$0(67);
        }
        return virtualFile;
    }

    public void deleteFile(Object requestor, @NotNull VirtualFile file2) throws IOException {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(68);
        }
        NewVirtualFileSystem delegate = PersistentFSImpl.getDelegate(file2);
        delegate.deleteFile(requestor, file2);
        if (!delegate.exists(file2)) {
            this.processEvent((VFileEvent)new VFileDeleteEvent(requestor, file2, false));
        }
    }

    public void renameFile(Object requestor, @NotNull VirtualFile file2, @NotNull String newName) throws IOException {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(69);
        }
        if (newName == null) {
            PersistentFSImpl.$$$reportNull$$$0(70);
        }
        PersistentFSImpl.getDelegate(file2).renameFile(requestor, file2, newName);
        String oldName = file2.getName();
        if (!newName.equals(oldName)) {
            this.processEvent((VFileEvent)new VFilePropertyChangeEvent(requestor, file2, "name", (Object)oldName, (Object)newName, false));
        }
    }

    @NotNull
    public byte[] contentsToByteArray(@NotNull VirtualFile file2) throws IOException {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(71);
        }
        byte[] byArray = this.contentsToByteArray(file2, true);
        if (byArray == null) {
            PersistentFSImpl.$$$reportNull$$$0(72);
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public byte[] contentsToByteArray(@NotNull VirtualFile file2, boolean cacheContent) throws IOException {
        byte[] byArray;
        boolean reloadFromDelegate;
        boolean outdated;
        long length;
        int fileId;
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(73);
        }
        DataInputStream contentStream = null;
        Object object = this.myInputLock;
        synchronized (object) {
            fileId = PersistentFSImpl.getFileId(file2);
            length = PersistentFSImpl.getLengthIfUpToDate(file2);
            outdated = length == -1L;
            reloadFromDelegate = outdated || (contentStream = PersistentFSImpl.readContent(file2)) == null;
        }
        if (reloadFromDelegate) {
            byte[] content2;
            NewVirtualFileSystem delegate = PersistentFSImpl.getDelegate(file2);
            if (outdated) {
                FSRecords.setLength(fileId, delegate.getLength(file2));
                content2 = delegate.contentsToByteArray(file2);
            } else {
                content2 = delegate.contentsToByteArray(file2);
                FSRecords.setLength(fileId, content2.length);
            }
            Application application = ApplicationManager.getApplication();
            if ((!delegate.isReadOnly() || cacheContent && !application.isInternal() && !application.isUnitTestMode()) && (long)content2.length <= PersistentFSConstants.FILE_LENGTH_TO_CACHE_THRESHOLD) {
                Object object2 = this.myInputLock;
                synchronized (object2) {
                    PersistentFSImpl.writeContent(file2, new ByteArraySequence(content2), delegate.isReadOnly());
                    PersistentFSImpl.setFlag(file2, 8, false);
                }
            }
            if (content2 == null) {
                PersistentFSImpl.$$$reportNull$$$0(74);
            }
            return content2;
        }
        try {
            assert (length >= 0L) : file2;
            byArray = FileUtil.loadBytes((InputStream)contentStream, (int)((int)length));
        }
        catch (IOException e) {
            FSRecords.handleError(e);
            if (ArrayUtilRt.EMPTY_BYTE_ARRAY == null) {
                PersistentFSImpl.$$$reportNull$$$0(76);
            }
            return ArrayUtilRt.EMPTY_BYTE_ARRAY;
        }
        if (byArray == null) {
            PersistentFSImpl.$$$reportNull$$$0(75);
        }
        return byArray;
    }

    @Override
    @NotNull
    public byte[] contentsToByteArray(int contentId) throws IOException {
        DataInputStream stream = PersistentFSImpl.readContentById(contentId);
        byte[] byArray = FileUtil.loadBytes((InputStream)stream);
        if (byArray == null) {
            PersistentFSImpl.$$$reportNull$$$0(77);
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public InputStream getInputStream(@NotNull VirtualFile file2) throws IOException {
        DataInputStream contentStream;
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(78);
        }
        Object object = this.myInputLock;
        // MONITORENTER : object
        if (PersistentFSImpl.getLengthIfUpToDate(file2) != -1L && !FileUtilRt.isTooLarge((long)file2.getLength()) && (contentStream = PersistentFSImpl.readContent(file2)) != null) {
            DataInputStream dataInputStream = contentStream;
            // MONITOREXIT : object
            if (dataInputStream != null) return dataInputStream;
            PersistentFSImpl.$$$reportNull$$$0(81);
            return dataInputStream;
        }
        NewVirtualFileSystem delegate = PersistentFSImpl.getDelegate(file2);
        long len = PersistentFSImpl.reloadLengthFromDelegate(file2, delegate);
        InputStream nativeStream = delegate.getInputStream(file2);
        if (len > PersistentFSConstants.FILE_LENGTH_TO_CACHE_THRESHOLD) {
            InputStream inputStream = nativeStream;
            // MONITOREXIT : object
            if (inputStream != null) return inputStream;
            PersistentFSImpl.$$$reportNull$$$0(79);
            return inputStream;
        }
        InputStream inputStream = this.createReplicator(file2, nativeStream, len, delegate.isReadOnly());
        // MONITOREXIT : object
        if (inputStream != null) return inputStream;
        PersistentFSImpl.$$$reportNull$$$0(80);
        return inputStream;
    }

    private static long reloadLengthFromDelegate(@NotNull VirtualFile file2, @NotNull NewVirtualFileSystem delegate) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(82);
        }
        if (delegate == null) {
            PersistentFSImpl.$$$reportNull$$$0(83);
        }
        long len = delegate.getLength(file2);
        FSRecords.setLength(PersistentFSImpl.getFileId(file2), len);
        return len;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    private InputStream createReplicator(final @NotNull VirtualFile file2, @NotNull InputStream nativeStream, final long fileLength, boolean bl) {
        void readOnly;
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(84);
        }
        if (nativeStream == null) {
            PersistentFSImpl.$$$reportNull$$$0(85);
        }
        if (nativeStream instanceof BufferExposingByteArrayInputStream) {
            BufferExposingByteArrayInputStream byteStream = (BufferExposingByteArrayInputStream)nativeStream;
            byte[] bytes = byteStream.getInternalBuffer();
            this.storeContentToStorage(fileLength, file2, (boolean)readOnly, bytes, bytes.length);
            InputStream inputStream = nativeStream;
            if (inputStream == null) {
                PersistentFSImpl.$$$reportNull$$$0(86);
            }
            return inputStream;
        }
        BufferExposingByteArrayOutputStream cache = new BufferExposingByteArrayOutputStream((int)fileLength);
        ReplicatorInputStream replicatorInputStream = new ReplicatorInputStream(nativeStream, cache, (boolean)readOnly, cache){
            final /* synthetic */ boolean val$readOnly;
            final /* synthetic */ BufferExposingByteArrayOutputStream val$cache;
            {
                this.val$readOnly = bl;
                this.val$cache = bufferExposingByteArrayOutputStream;
                super(arg0, arg1);
            }

            public void close() throws IOException {
                super.close();
                PersistentFSImpl.this.storeContentToStorage(fileLength, file2, this.val$readOnly, this.val$cache.getInternalBuffer(), this.val$cache.size());
            }
        };
        if (replicatorInputStream == null) {
            PersistentFSImpl.$$$reportNull$$$0(87);
        }
        return replicatorInputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void storeContentToStorage(long fileLength, @NotNull VirtualFile file2, boolean readOnly, @NotNull byte[] bytes, int n) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(88);
        }
        if (bytes == null) {
            PersistentFSImpl.$$$reportNull$$$0(89);
        }
        Object object = this.myInputLock;
        synchronized (object) {
            void bytesLength;
            if ((long)bytesLength == fileLength) {
                PersistentFSImpl.writeContent(file2, new ByteArraySequence(bytes, 0, (int)bytesLength), readOnly);
                PersistentFSImpl.setFlag(file2, 8, false);
            } else {
                PersistentFSImpl.setFlag(file2, 8, true);
            }
        }
    }

    private static long getLengthIfUpToDate(@NotNull VirtualFile file2) {
        int fileId;
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(90);
        }
        return BitUtil.isSet((int)FSRecords.getFlags(fileId = PersistentFSImpl.getFileId(file2)), (int)8) ? -1L : FSRecords.getLength(fileId);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public OutputStream getOutputStream(final @NotNull VirtualFile file2, final Object requestor, final long modStamp, long l) {
        void timeStamp;
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(91);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream((long)timeStamp){
            private boolean closed;
            final /* synthetic */ long val$timeStamp;
            {
                this.val$timeStamp = l2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() throws IOException {
                Throwable throwable;
                if (this.closed) {
                    return;
                }
                super.close();
                ApplicationManager.getApplication().assertWriteAccessAllowed();
                VFileContentChangeEvent event = new VFileContentChangeEvent(requestor, file2, file2.getModificationStamp(), modStamp, false);
                List<VFileContentChangeEvent> events = Collections.singletonList(event);
                PersistentFSImpl.this.myPublisher.before(events);
                NewVirtualFileSystem delegate = PersistentFSImpl.getDelegate(file2);
                try {
                    throwable = null;
                    try (DataOutputStream persistenceStream = PersistentFSImpl.writeContent(file2, delegate.isReadOnly());){
                        ((OutputStream)persistenceStream).write(this.buf, 0, this.count);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                catch (Throwable throwable3) {
                    try {
                        try (OutputStream ioFileStream = delegate.getOutputStream(file2, requestor, modStamp, this.val$timeStamp);){
                            ioFileStream.write(this.buf, 0, this.count);
                        }
                        this.closed = true;
                    }
                    catch (Throwable throwable4) {
                        this.closed = true;
                        FileAttributes attributes = delegate.getAttributes(file2);
                        PersistentFSImpl.executeTouch(file2, false, event.getModificationStamp(), attributes != null ? attributes.length : 0L, attributes != null ? attributes.lastModified : 0L);
                        PersistentFSImpl.this.myPublisher.after(events);
                        throw throwable4;
                    }
                    FileAttributes attributes = delegate.getAttributes(file2);
                    PersistentFSImpl.executeTouch(file2, false, event.getModificationStamp(), attributes != null ? attributes.length : 0L, attributes != null ? attributes.lastModified : 0L);
                    PersistentFSImpl.this.myPublisher.after(events);
                    throw throwable3;
                }
                try {
                    throwable = null;
                    try (OutputStream ioFileStream = delegate.getOutputStream(file2, requestor, modStamp, this.val$timeStamp);){
                        ioFileStream.write(this.buf, 0, this.count);
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                    this.closed = true;
                }
                catch (Throwable throwable6) {
                    this.closed = true;
                    FileAttributes attributes = delegate.getAttributes(file2);
                    PersistentFSImpl.executeTouch(file2, false, event.getModificationStamp(), attributes != null ? attributes.length : 0L, attributes != null ? attributes.lastModified : 0L);
                    PersistentFSImpl.this.myPublisher.after(events);
                    throw throwable6;
                }
                FileAttributes attributes = delegate.getAttributes(file2);
                PersistentFSImpl.executeTouch(file2, false, event.getModificationStamp(), attributes != null ? attributes.length : 0L, attributes != null ? attributes.lastModified : 0L);
                PersistentFSImpl.this.myPublisher.after(events);
            }
        };
        if (byteArrayOutputStream == null) {
            PersistentFSImpl.$$$reportNull$$$0(92);
        }
        return byteArrayOutputStream;
    }

    @Override
    public int acquireContent(@NotNull VirtualFile file2) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(93);
        }
        return FSRecords.acquireFileContent(PersistentFSImpl.getFileId(file2));
    }

    @Override
    public void releaseContent(int contentId) {
        FSRecords.releaseContent(contentId);
    }

    @Override
    public int getCurrentContentId(@NotNull VirtualFile file2) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(94);
        }
        return FSRecords.getContentId(PersistentFSImpl.getFileId(file2));
    }

    public void moveFile(Object requestor, @NotNull VirtualFile file2, @NotNull VirtualFile newParent) throws IOException {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(95);
        }
        if (newParent == null) {
            PersistentFSImpl.$$$reportNull$$$0(96);
        }
        PersistentFSImpl.getDelegate(file2).moveFile(requestor, file2, newParent);
        this.processEvent((VFileEvent)new VFileMoveEvent(requestor, file2, newParent));
    }

    private void processEvent(@NotNull VFileEvent event) {
        if (event == null) {
            PersistentFSImpl.$$$reportNull$$$0(97);
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        if (event.isValid()) {
            List<VFileEvent> events = Collections.singletonList(event);
            this.myPublisher.before(events);
            this.applyEvent(event);
            this.myPublisher.after(events);
        }
    }

    private static int groupByPath(@NotNull List<? extends VFileEvent> events, int startIndex, @NotNull MostlySingularMultiMap<String, VFileEvent> filesInvolved, @NotNull Set<? super String> middleDirsInvolved, @NotNull Set<? super String> deletedPaths, @NotNull Set<? super String> createdPaths, @NotNull Set<? super VFileEvent> eventsToRemove) {
        int i;
        if (events == null) {
            PersistentFSImpl.$$$reportNull$$$0(98);
        }
        if (filesInvolved == null) {
            PersistentFSImpl.$$$reportNull$$$0(99);
        }
        if (middleDirsInvolved == null) {
            PersistentFSImpl.$$$reportNull$$$0(100);
        }
        if (deletedPaths == null) {
            PersistentFSImpl.$$$reportNull$$$0(101);
        }
        if (createdPaths == null) {
            PersistentFSImpl.$$$reportNull$$$0(102);
        }
        if (eventsToRemove == null) {
            PersistentFSImpl.$$$reportNull$$$0(103);
        }
        for (i = startIndex; i < events.size(); ++i) {
            String path2;
            VFileEvent event = events.get(i);
            String path = event.getPath();
            if (event instanceof VFileDeleteEvent && PersistentFSImpl.removeNestedDelete(path, deletedPaths)) {
                eventsToRemove.add((VFileEvent)event);
                continue;
            }
            if (event instanceof VFileCreateEvent && !createdPaths.add(path)) {
                eventsToRemove.add((VFileEvent)event);
                continue;
            }
            if (PersistentFSImpl.checkIfConflictingPaths(event, path, filesInvolved, middleDirsInvolved) || (path2 = PersistentFSImpl.getAlternativePath(event)) != null && !FileUtil.PATH_HASHING_STRATEGY.equals((Object)path2, (Object)path) && PersistentFSImpl.checkIfConflictingPaths(event, path2, filesInvolved, middleDirsInvolved)) break;
        }
        return i;
    }

    @Nullable
    private static String getAlternativePath(@NotNull VFileEvent event) {
        if (event == null) {
            PersistentFSImpl.$$$reportNull$$$0(104);
        }
        String path2 = null;
        if (event instanceof VFilePropertyChangeEvent && ((VFilePropertyChangeEvent)event).getPropertyName().equals("name")) {
            VFilePropertyChangeEvent pce = (VFilePropertyChangeEvent)event;
            VirtualFile parent = pce.getFile().getParent();
            String newName = (String)pce.getNewValue();
            path2 = parent == null ? newName : parent.getPath() + "/" + newName;
        } else if (event instanceof VFileCopyEvent) {
            path2 = ((VFileCopyEvent)event).getFile().getPath();
        } else if (event instanceof VFileMoveEvent) {
            VFileMoveEvent vme = (VFileMoveEvent)event;
            String newName = vme.getFile().getName();
            path2 = vme.getNewParent().getPath() + "/" + newName;
        }
        return path2;
    }

    private static boolean removeNestedDelete(@NotNull String path, @NotNull Set<? super String> deletedPaths) {
        int liPrev;
        if (path == null) {
            PersistentFSImpl.$$$reportNull$$$0(105);
        }
        if (deletedPaths == null) {
            PersistentFSImpl.$$$reportNull$$$0(106);
        }
        if (!deletedPaths.add(path)) {
            return true;
        }
        int li = path.length();
        while ((liPrev = path.lastIndexOf(47, li - 1)) != -1) {
            path = path.substring(0, liPrev);
            li = liPrev;
            if (!deletedPaths.contains(path)) continue;
            return true;
        }
        return false;
    }

    private static boolean checkIfConflictingPaths(@NotNull VFileEvent event, @NotNull String path, @NotNull MostlySingularMultiMap<String, VFileEvent> files2, @NotNull Set<? super String> middleDirs) {
        int liPrev;
        Iterable stored;
        if (event == null) {
            PersistentFSImpl.$$$reportNull$$$0(107);
        }
        if (path == null) {
            PersistentFSImpl.$$$reportNull$$$0(108);
        }
        if (files2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(109);
        }
        if (middleDirs == null) {
            PersistentFSImpl.$$$reportNull$$$0(110);
        }
        if (!PersistentFSImpl.canReconcileEvents(event, stored = files2.get((Object)path))) {
            return true;
        }
        if (middleDirs.contains(path)) {
            return true;
        }
        files2.add((Object)path, (Object)event);
        int li = path.length();
        while ((liPrev = path.lastIndexOf(47, li - 1)) != -1) {
            String parentDir = path.substring(0, liPrev);
            if (files2.containsKey((Object)parentDir)) {
                return true;
            }
            if (!middleDirs.add(parentDir)) break;
            li = liPrev;
        }
        return false;
    }

    private static boolean canReconcileEvents(@NotNull VFileEvent event, @NotNull Iterable<? extends VFileEvent> stored) {
        if (event == null) {
            PersistentFSImpl.$$$reportNull$$$0(111);
        }
        if (stored == null) {
            PersistentFSImpl.$$$reportNull$$$0(112);
        }
        return ContainerUtil.and(stored, e -> PersistentFSImpl.canReconcile(event, e));
    }

    private static boolean canReconcile(@NotNull VFileEvent event1, @NotNull VFileEvent event2) {
        if (event1 == null) {
            PersistentFSImpl.$$$reportNull$$$0(113);
        }
        if (event2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(114);
        }
        return PersistentFSImpl.isContentChangeLikeHarmlessEvent(event1) && PersistentFSImpl.isContentChangeLikeHarmlessEvent(event2);
    }

    private static boolean isContentChangeLikeHarmlessEvent(@NotNull VFileEvent event1) {
        if (event1 == null) {
            PersistentFSImpl.$$$reportNull$$$0(115);
        }
        return event1 instanceof VFileContentChangeEvent || event1 instanceof VFilePropertyChangeEvent && (((VFilePropertyChangeEvent)event1).getPropertyName().equals("writable") || ((VFilePropertyChangeEvent)event1).getPropertyName().equals("encoding"));
    }

    private int groupAndValidate(@NotNull List<? extends VFileEvent> events, int startIndex, @NotNull List<? super Runnable> outApplyEvents, @NotNull List<? super VFileEvent> outValidatedEvents, @NotNull MostlySingularMultiMap<String, VFileEvent> filesInvolved, @NotNull Set<? super String> middleDirsInvolved) {
        if (events == null) {
            PersistentFSImpl.$$$reportNull$$$0(116);
        }
        if (outApplyEvents == null) {
            PersistentFSImpl.$$$reportNull$$$0(117);
        }
        if (outValidatedEvents == null) {
            PersistentFSImpl.$$$reportNull$$$0(118);
        }
        if (filesInvolved == null) {
            PersistentFSImpl.$$$reportNull$$$0(119);
        }
        if (middleDirsInvolved == null) {
            PersistentFSImpl.$$$reportNull$$$0(120);
        }
        THashSet toIgnore = new THashSet(ContainerUtil.identityStrategy());
        int endIndex = PersistentFSImpl.groupByPath(events, startIndex, filesInvolved, middleDirsInvolved, (Set<? super String>)new THashSet(FileUtil.PATH_HASHING_STRATEGY), (Set<? super String>)new THashSet(FileUtil.PATH_HASHING_STRATEGY), (Set<? super VFileEvent>)toIgnore);
        assert (endIndex > startIndex) : events.get(startIndex) + "; files: " + filesInvolved + "; middleDirs: " + middleDirsInvolved;
        this.groupCreations(events, startIndex, endIndex, outValidatedEvents, outApplyEvents, (Set<? extends VFileEvent>)toIgnore);
        this.groupDeletions(events, startIndex, endIndex, outValidatedEvents, outApplyEvents, (Set<? extends VFileEvent>)toIgnore);
        this.groupOthers(events, startIndex, endIndex, outValidatedEvents, outApplyEvents);
        return endIndex;
    }

    private void groupCreations(@NotNull List<? extends VFileEvent> events, final int start2, final int end, @NotNull List<? super VFileEvent> outValidated, @NotNull List<? super Runnable> outApplyEvents, @NotNull Set<? extends VFileEvent> toIgnore) {
        if (events == null) {
            PersistentFSImpl.$$$reportNull$$$0(121);
        }
        if (outValidated == null) {
            PersistentFSImpl.$$$reportNull$$$0(122);
        }
        if (outApplyEvents == null) {
            PersistentFSImpl.$$$reportNull$$$0(123);
        }
        if (toIgnore == null) {
            PersistentFSImpl.$$$reportNull$$$0(124);
        }
        MultiMap<VirtualDirectoryImpl, VFileCreateEvent> grouped = null;
        for (int i = start2; i < end; ++i) {
            VFileEvent e = events.get(i);
            if (!(e instanceof VFileCreateEvent) || toIgnore.contains(e)) continue;
            VFileCreateEvent event = (VFileCreateEvent)e;
            VirtualDirectoryImpl parent = (VirtualDirectoryImpl)event.getParent();
            if (grouped == null) {
                grouped = new MultiMap<VirtualDirectoryImpl, VFileCreateEvent>(){

                    @NotNull
                    protected Map<VirtualDirectoryImpl, Collection<VFileCreateEvent>> createMap() {
                        THashMap tHashMap = new THashMap(end - start2);
                        if (tHashMap == null) {
                            3.$$$reportNull$$$0(0);
                        }
                        return tHashMap;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl$3", "createMap"));
                    }
                };
            }
            grouped.putValue((Object)parent, (Object)event);
        }
        if (grouped != null) {
            boolean hasValidEvents = false;
            for (Map.Entry entry : grouped.entrySet()) {
                VirtualDirectoryImpl directory = (VirtualDirectoryImpl)((Object)entry.getKey());
                List createEvents = (List)entry.getValue();
                directory.validateChildrenToCreate(createEvents);
                hasValidEvents |= !createEvents.isEmpty();
                outValidated.addAll(createEvents);
            }
            if (hasValidEvents) {
                MultiMap<VirtualDirectoryImpl, VFileCreateEvent> finalGrouped = grouped;
                outApplyEvents.add(() -> {
                    this.applyCreations(finalGrouped);
                    this.incStructuralModificationCount();
                });
            }
        }
    }

    private void groupDeletions(@NotNull List<? extends VFileEvent> events, final int start2, final int end, @NotNull List<? super VFileEvent> outValidated, @NotNull List<? super Runnable> outApplyEvents, @NotNull Set<? extends VFileEvent> toIgnore) {
        if (events == null) {
            PersistentFSImpl.$$$reportNull$$$0(125);
        }
        if (outValidated == null) {
            PersistentFSImpl.$$$reportNull$$$0(126);
        }
        if (outApplyEvents == null) {
            PersistentFSImpl.$$$reportNull$$$0(127);
        }
        if (toIgnore == null) {
            PersistentFSImpl.$$$reportNull$$$0(128);
        }
        MultiMap<VirtualDirectoryImpl, VFileDeleteEvent> grouped = null;
        boolean hasValidEvents = false;
        for (int i = start2; i < end; ++i) {
            VFileEvent event = events.get(i);
            if (!(event instanceof VFileDeleteEvent) || toIgnore.contains(event) || !event.isValid()) continue;
            VFileDeleteEvent de = (VFileDeleteEvent)event;
            VirtualDirectoryImpl parent = (VirtualDirectoryImpl)de.getFile().getParent();
            if (grouped == null) {
                grouped = new MultiMap<VirtualDirectoryImpl, VFileDeleteEvent>(){

                    @NotNull
                    protected Map<VirtualDirectoryImpl, Collection<VFileDeleteEvent>> createMap() {
                        HashMap<VirtualDirectoryImpl, Collection<VFileDeleteEvent>> hashMap = new HashMap<VirtualDirectoryImpl, Collection<VFileDeleteEvent>>(end - start2);
                        if (hashMap == null) {
                            4.$$$reportNull$$$0(0);
                        }
                        return hashMap;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl$4", "createMap"));
                    }
                };
            }
            grouped.putValue((Object)parent, (Object)de);
            outValidated.add((VFileEvent)event);
            hasValidEvents = true;
        }
        if (hasValidEvents) {
            MultiMap<VirtualDirectoryImpl, VFileDeleteEvent> finalGrouped = grouped;
            outApplyEvents.add(() -> {
                this.clearIdCache();
                this.applyDeletions(finalGrouped);
                this.incStructuralModificationCount();
            });
        }
    }

    private void groupOthers(@NotNull List<? extends VFileEvent> events, int start2, int end, @NotNull List<? super VFileEvent> outValidated, @NotNull List<? super Runnable> outApplyEvents) {
        if (events == null) {
            PersistentFSImpl.$$$reportNull$$$0(129);
        }
        if (outValidated == null) {
            PersistentFSImpl.$$$reportNull$$$0(130);
        }
        if (outApplyEvents == null) {
            PersistentFSImpl.$$$reportNull$$$0(131);
        }
        for (int i = start2; i < end; ++i) {
            VFileEvent event = events.get(i);
            if (event instanceof VFileCreateEvent || event instanceof VFileDeleteEvent || !event.isValid()) continue;
            outValidated.add((VFileEvent)event);
            outApplyEvents.add(() -> this.applyEvent(event));
        }
    }

    @Override
    public void processEvents(@NotNull List<? extends VFileEvent> events) {
        if (events == null) {
            PersistentFSImpl.$$$reportNull$$$0(132);
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        int startIndex = 0;
        final int cappedInitialSize = Math.min(events.size(), 1024);
        ArrayList applyEvents = new ArrayList(cappedInitialSize);
        MostlySingularMultiMap<String, VFileEvent> files2 = new MostlySingularMultiMap<String, VFileEvent>(){

            @NotNull
            protected Map<String, Object> createMap() {
                THashMap tHashMap = new THashMap(cappedInitialSize, FileUtil.PATH_HASHING_STRATEGY);
                if (tHashMap == null) {
                    5.$$$reportNull$$$0(0);
                }
                return tHashMap;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl$5", "createMap"));
            }
        };
        THashSet middleDirs = new THashSet(cappedInitialSize, FileUtil.PATH_HASHING_STRATEGY);
        ArrayList validated = new ArrayList(cappedInitialSize);
        while (startIndex != events.size()) {
            applyEvents.clear();
            files2.clear();
            middleDirs.clear();
            validated.clear();
            startIndex = this.groupAndValidate(events, startIndex, applyEvents, validated, files2, (Set<? super String>)middleDirs);
            if (validated.isEmpty()) continue;
            ImmutableList toSend = ContainerUtil.immutableList((Object[])validated.toArray(new VFileEvent[0]));
            this.myPublisher.before((List)toSend);
            applyEvents.forEach(Runnable::run);
            this.myPublisher.after((List)toSend);
        }
    }

    private void applyDeletions(@NotNull MultiMap<VirtualDirectoryImpl, VFileDeleteEvent> deletions) {
        if (deletions == null) {
            PersistentFSImpl.$$$reportNull$$$0(133);
        }
        for (Map.Entry entry : deletions.entrySet()) {
            VirtualDirectoryImpl parent = (VirtualDirectoryImpl)((Object)entry.getKey());
            Collection deleteEvents = (Collection)entry.getValue();
            if (parent == null || !parent.isValid()) {
                deleteEvents.forEach(this::applyEvent);
                return;
            }
            int parentId = PersistentFSImpl.getFileId((VirtualFile)parent);
            int[] oldIds = FSRecords.list(parentId);
            TIntHashSet parentChildrenIds = new TIntHashSet(oldIds);
            ArrayList<CharSequence> childrenNamesDeleted = new ArrayList<CharSequence>(deleteEvents.size());
            TIntHashSet childrenIdsDeleted = new TIntHashSet(deleteEvents.size());
            for (VFileDeleteEvent event : deleteEvents) {
                VirtualFile file2 = event.getFile();
                int id = PersistentFSImpl.getFileId(file2);
                childrenNamesDeleted.add(file2.getNameSequence());
                childrenIdsDeleted.add(id);
                FSRecords.deleteRecordRecursively(id);
                PersistentFSImpl.invalidateSubtree(file2);
                parentChildrenIds.remove(id);
            }
            FSRecords.updateList(parentId, parentChildrenIds.toArray());
            parent.removeChildren(childrenIdsDeleted, childrenNamesDeleted);
        }
    }

    private void applyCreations(@NotNull MultiMap<VirtualDirectoryImpl, VFileCreateEvent> creations) {
        if (creations == null) {
            PersistentFSImpl.$$$reportNull$$$0(134);
        }
        for (Map.Entry entry : creations.entrySet()) {
            VirtualDirectoryImpl parent = (VirtualDirectoryImpl)((Object)entry.getKey());
            Collection createEvents = (Collection)entry.getValue();
            this.applyCreateEventsInDirectory(parent, createEvents);
        }
    }

    private void applyCreateEventsInDirectory(@NotNull VirtualDirectoryImpl parent, @NotNull Collection<? extends VFileCreateEvent> createEvents) {
        int parentId;
        NewVirtualFile vf;
        if (parent == null) {
            PersistentFSImpl.$$$reportNull$$$0(135);
        }
        if (createEvents == null) {
            PersistentFSImpl.$$$reportNull$$$0(136);
        }
        if (!((vf = this.findFileById(parentId = PersistentFSImpl.getFileId((VirtualFile)parent))) instanceof VirtualDirectoryImpl)) {
            return;
        }
        parent = (VirtualDirectoryImpl)vf;
        NewVirtualFileSystem delegate = PersistentFSImpl.replaceWithNativeFS(PersistentFSImpl.getDelegate((VirtualFile)parent));
        TIntHashSet parentChildrenIds = new TIntHashSet(createEvents.size());
        List<ChildInfo> childrenAdded = PersistentFSImpl.getOrCreateChildInfos(parent, createEvents, VFileCreateEvent::getChildName, parentChildrenIds, delegate, (createEvent, childId) -> {
            createEvent.resetCache();
            String name = createEvent.getChildName();
            Pair<FileAttributes, String> childData = PersistentFSImpl.getChildData(delegate, createEvent.getParent(), name, createEvent.getAttributes(), createEvent.getSymlinkTarget());
            if (childData == null) {
                return null;
            }
            childId = PersistentFSImpl.makeChildRecord(parentId, name, childData, delegate);
            return new ChildInfoImpl((int)childId, name, (FileAttributes)childData.first, createEvent.getChildren(), createEvent.getSymlinkTarget());
        });
        FSRecords.updateList(parentId, parentChildrenIds.toArray());
        parent.createAndAddChildren(childrenAdded, false, (PairConsumer<? super VirtualFile, ? super ChildInfo>)((PairConsumer)(__, ___) -> {}));
        PersistentFSImpl.saveScannedChildrenRecursively(createEvents, delegate);
    }

    private static void saveScannedChildrenRecursively(@NotNull Collection<? extends VFileCreateEvent> createEvents, @NotNull NewVirtualFileSystem delegate) {
        if (createEvents == null) {
            PersistentFSImpl.$$$reportNull$$$0(137);
        }
        if (delegate == null) {
            PersistentFSImpl.$$$reportNull$$$0(138);
        }
        for (VFileCreateEvent vFileCreateEvent : createEvents) {
            VirtualFile createdFile;
            ChildInfo[] children2 = vFileCreateEvent.getChildren();
            if (children2 == null || !((createdFile = vFileCreateEvent.getFile()) instanceof VirtualDirectoryImpl)) continue;
            ArrayDeque<Pair> queue = new ArrayDeque<Pair>();
            queue.add(Pair.create((Object)((Object)((VirtualDirectoryImpl)createdFile)), (Object)children2));
            while (!queue.isEmpty()) {
                Pair queued = (Pair)queue.remove();
                VirtualDirectoryImpl directory = (VirtualDirectoryImpl)((Object)queued.first);
                TIntHashSet childIds = new TIntHashSet();
                List<Object> scannedChildren = Arrays.asList((Object[])queued.second);
                List<ChildInfo> added = PersistentFSImpl.getOrCreateChildInfos(directory, scannedChildren, childInfo -> childInfo.getName(), childIds, delegate, (childInfo, childId) -> {
                    if (childId < 0) {
                        String childName = childInfo.getName().toString();
                        Pair<FileAttributes, String> childData = PersistentFSImpl.getChildData(delegate, (VirtualFile)directory, childName, childInfo.getFileAttributes(), childInfo.getSymLinkTarget());
                        if (childData == null) {
                            return null;
                        }
                        childId = PersistentFSImpl.makeChildRecord(directory.getId(), childName, childData, delegate);
                    }
                    return new ChildInfoImpl((int)childId, childInfo.getNameId(), childInfo.getFileAttributes(), childInfo.getChildren(), childInfo.getSymLinkTarget());
                });
                FSRecords.updateList(directory.getId(), childIds.toArray());
                PersistentFSImpl.setChildrenCached(directory.getId());
                directory.createAndAddChildren(added, true, (PairConsumer<? super VirtualFile, ? super ChildInfo>)((PairConsumer)(childCreated, childInfo) -> {
                    if (childCreated instanceof VirtualDirectoryImpl && childInfo.getChildren() != null) {
                        queue.add(Pair.create((Object)((Object)((VirtualDirectoryImpl)((Object)((Object)childCreated)))), (Object)childInfo.getChildren()));
                    }
                }));
            }
        }
    }

    @NotNull
    private static <T> List<ChildInfo> getOrCreateChildInfos(@NotNull VirtualDirectoryImpl parent, @NotNull Collection<? extends T> createEvents, @NotNull Function<? super T, ? extends CharSequence> nameExtractor, @NotNull TIntHashSet parentChildrenIds, @NotNull NewVirtualFileSystem delegate, @NotNull PairFunction<? super T, ? super Integer, ? extends ChildInfo> convertor) {
        if (parent == null) {
            PersistentFSImpl.$$$reportNull$$$0(139);
        }
        if (createEvents == null) {
            PersistentFSImpl.$$$reportNull$$$0(140);
        }
        if (nameExtractor == null) {
            PersistentFSImpl.$$$reportNull$$$0(141);
        }
        if (parentChildrenIds == null) {
            PersistentFSImpl.$$$reportNull$$$0(142);
        }
        if (delegate == null) {
            PersistentFSImpl.$$$reportNull$$$0(143);
        }
        if (convertor == null) {
            PersistentFSImpl.$$$reportNull$$$0(144);
        }
        int parentId = parent.getId();
        FSRecords.NameId[] oldNameIds = FSRecords.listAll(parentId);
        int[] oldIds = new int[oldNameIds.length];
        CharSequenceHashingStrategy strategy = delegate.isCaseSensitive() ? CharSequenceHashingStrategy.CASE_SENSITIVE : CharSequenceHashingStrategy.CASE_INSENSITIVE;
        THashSet persistedNames = new THashSet(oldNameIds.length, (TObjectHashingStrategy)strategy);
        for (int i = 0; i < oldNameIds.length; ++i) {
            FSRecords.NameId nameId = oldNameIds[i];
            parentChildrenIds.add(nameId.id);
            persistedNames.add(nameId.name);
            oldIds[i] = nameId.id;
        }
        ArrayList<ChildInfo> childrenAdded = new ArrayList<ChildInfo>(createEvents.size());
        for (T createEvent : createEvents) {
            ChildInfo childInfo;
            CharSequence name = nameExtractor.apply(createEvent);
            int childId = -1;
            if (persistedNames.contains(name)) {
                childId = PersistentFSImpl.findExistingId(name.toString(), oldIds, delegate);
            }
            if ((childInfo = (ChildInfo)convertor.fun(createEvent, (Object)childId)) == null) continue;
            childrenAdded.add(childInfo);
            parentChildrenIds.add(childInfo.getId());
        }
        ArrayList<ChildInfo> arrayList = childrenAdded;
        if (arrayList == null) {
            PersistentFSImpl.$$$reportNull$$$0(145);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public VirtualFileSystemEntry findRoot(@NotNull String path, @NotNull NewVirtualFileSystem fs) {
        boolean mark;
        String rootPath;
        CharSequence rootName;
        if (path == null) {
            PersistentFSImpl.$$$reportNull$$$0(146);
        }
        if (fs == null) {
            PersistentFSImpl.$$$reportNull$$$0(147);
        }
        if (path.isEmpty()) {
            LOG.error("Invalid root, fs=" + fs);
            return null;
        }
        String rootUrl = PersistentFSImpl.normalizeRootUrl(path, fs);
        VirtualFileSystemEntry root = this.myRoots.get(rootUrl);
        if (root != null) {
            return root;
        }
        if (fs instanceof ArchiveFileSystem) {
            ArchiveFileSystem afs = (ArchiveFileSystem)fs;
            VirtualFile localFile = afs.findLocalByRootPath(path);
            if (localFile == null) {
                return null;
            }
            rootName = localFile.getNameSequence();
            rootPath = afs.getRootPathByLocal(localFile);
        } else {
            rootName = rootPath = path;
        }
        FileAttributes attributes = fs.getAttributes((VirtualFile)new StubVirtualFile(){

            @NotNull
            public String getPath() {
                String string = rootPath;
                if (string == null) {
                    6.$$$reportNull$$$0(0);
                }
                return string;
            }

            @Nullable
            public VirtualFile getParent() {
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl$6", "getPath"));
            }
        });
        if (attributes == null || !attributes.isDirectory()) {
            return null;
        }
        int rootId = FSRecords.findRootRecord(rootUrl);
        VfsData.Segment segment = this.myVfsData.getSegment(rootId, true);
        VfsData.DirectoryData directoryData = new VfsData.DirectoryData();
        FsRoot newRoot = new FsRoot(rootId, segment, directoryData, fs, rootName, StringUtil.trimTrailing((String)rootPath, (char)'/'));
        Map<String, VirtualFileSystemEntry> map2 = this.myRoots;
        synchronized (map2) {
            root = this.myRoots.get(rootUrl);
            if (root != null) {
                return root;
            }
            try {
                VfsData.initFile(rootId, segment, -1, directoryData);
            }
            catch (VfsData.FileAlreadyCreatedException e) {
                for (Map.Entry<String, VirtualFileSystemEntry> entry : this.myRoots.entrySet()) {
                    VirtualFileSystemEntry existingRoot = entry.getValue();
                    if (existingRoot.getId() != rootId) continue;
                    String message = "Duplicate FS roots: " + rootUrl + " / " + entry.getKey() + " id=" + rootId + " valid=" + existingRoot.isValid();
                    throw new RuntimeException(message, e);
                }
                throw new RuntimeException("No root duplication, roots=" + Arrays.toString(FSRecords.listAll(1)), e);
            }
            this.incStructuralModificationCount();
            mark = PersistentFSImpl.writeAttributesToRecord(rootId, 0, rootName, fs, attributes, null);
            this.myRoots.put(rootUrl, newRoot);
            this.myIdToDirCache.put(rootId, (Object)newRoot);
        }
        if (!mark && attributes.lastModified != FSRecords.getTimestamp(rootId)) {
            ((VirtualFileSystemEntry)newRoot).markDirtyRecursively();
        }
        LOG.assertTrue(rootId == newRoot.getId(), (Object)("root=" + (Object)((Object)newRoot) + " expected=" + rootId + " actual=" + newRoot.getId()));
        return newRoot;
    }

    @NotNull
    private static String normalizeRootUrl(@NotNull String basePath, @NotNull NewVirtualFileSystem fs) {
        if (basePath == null) {
            PersistentFSImpl.$$$reportNull$$$0(148);
        }
        if (fs == null) {
            PersistentFSImpl.$$$reportNull$$$0(149);
        }
        String normalized = VfsImplUtil.normalize(fs, FileUtil.toCanonicalPath((String)basePath));
        String protocol = fs.getProtocol();
        StringBuilder result2 = new StringBuilder(protocol.length() + "://".length() + normalized.length());
        result2.append(protocol).append("://").append(normalized);
        String string = StringUtil.endsWithChar((CharSequence)result2, (char)'/') ? UriUtil.trimTrailingSlashes(result2.toString()) : result2.toString();
        if (string == null) {
            PersistentFSImpl.$$$reportNull$$$0(150);
        }
        return string;
    }

    @Override
    public void clearIdCache() {
        this.myIdToDirCache.entrySet().removeIf(e -> ((VirtualFileSystemEntry)((Object)((Object)e.getValue()))).getParent() != null);
    }

    @Nullable
    public NewVirtualFile findFileById(int id) {
        VirtualFileSystemEntry cached = (VirtualFileSystemEntry)((Object)this.myIdToDirCache.get(id));
        return cached != null ? cached : FSRecords.findFileById(id, this.myIdToDirCache);
    }

    @Override
    public NewVirtualFile findFileByIdIfCached(int id) {
        return this.myVfsData.hasLoadedFile(id) ? this.findFileById(id) : null;
    }

    @NotNull
    public VirtualFile[] getRoots() {
        Collection<VirtualFileSystemEntry> roots = this.myRoots.values();
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray(roots);
        if (virtualFileArray == null) {
            PersistentFSImpl.$$$reportNull$$$0(151);
        }
        return virtualFileArray;
    }

    @NotNull
    public VirtualFile[] getRoots(@NotNull NewVirtualFileSystem fs) {
        if (fs == null) {
            PersistentFSImpl.$$$reportNull$$$0(152);
        }
        ArrayList<NewVirtualFile> roots = new ArrayList<NewVirtualFile>();
        for (NewVirtualFile newVirtualFile : this.myRoots.values()) {
            if (newVirtualFile.getFileSystem() != fs) continue;
            roots.add(newVirtualFile);
        }
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray(roots);
        if (virtualFileArray == null) {
            PersistentFSImpl.$$$reportNull$$$0(153);
        }
        return virtualFileArray;
    }

    @NotNull
    public VirtualFile[] getLocalRoots() {
        SmartList roots = new SmartList();
        for (NewVirtualFile newVirtualFile : this.myRoots.values()) {
            if (!newVirtualFile.isInLocalFileSystem() || newVirtualFile.getFileSystem() instanceof TempFileSystem) continue;
            roots.add(newVirtualFile);
        }
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray((Collection)roots);
        if (virtualFileArray == null) {
            PersistentFSImpl.$$$reportNull$$$0(154);
        }
        return virtualFileArray;
    }

    private void applyEvent(@NotNull VFileEvent event) {
        if (event == null) {
            PersistentFSImpl.$$$reportNull$$$0(155);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Applying " + event);
        }
        try {
            if (event instanceof VFileCreateEvent) {
                VFileCreateEvent ce = (VFileCreateEvent)event;
                this.executeCreateChild(ce.getParent(), ce.getChildName(), ce.getAttributes(), ce.getSymlinkTarget(), ce.isEmptyDirectory());
            } else if (event instanceof VFileDeleteEvent) {
                VFileDeleteEvent deleteEvent = (VFileDeleteEvent)event;
                this.executeDelete(deleteEvent.getFile());
            } else if (event instanceof VFileContentChangeEvent) {
                VFileContentChangeEvent contentUpdateEvent = (VFileContentChangeEvent)event;
                VirtualFile file2 = contentUpdateEvent.getFile();
                long length = contentUpdateEvent.getNewLength();
                long timestamp = contentUpdateEvent.getNewTimestamp();
                if (!contentUpdateEvent.isLengthAndTimestampDiffProvided()) {
                    NewVirtualFileSystem delegate = PersistentFSImpl.getDelegate(file2);
                    FileAttributes attributes = delegate.getAttributes(file2);
                    length = attributes != null ? attributes.length : 0L;
                    timestamp = attributes != null ? attributes.lastModified : 0L;
                }
                PersistentFSImpl.executeTouch(file2, contentUpdateEvent.isFromRefresh(), contentUpdateEvent.getModificationStamp(), length, timestamp);
            } else if (event instanceof VFileCopyEvent) {
                VFileCopyEvent ce = (VFileCopyEvent)event;
                this.executeCreateChild(ce.getNewParent(), ce.getNewChildName(), null, null, ce.getFile().getChildren().length == 0);
            } else if (event instanceof VFileMoveEvent) {
                VFileMoveEvent moveEvent = (VFileMoveEvent)event;
                this.executeMove(moveEvent.getFile(), moveEvent.getNewParent());
            } else if (event instanceof VFilePropertyChangeEvent) {
                VFilePropertyChangeEvent propertyChangeEvent = (VFilePropertyChangeEvent)event;
                VirtualFile file3 = propertyChangeEvent.getFile();
                Object newValue = propertyChangeEvent.getNewValue();
                switch (propertyChangeEvent.getPropertyName()) {
                    case "name": {
                        PersistentFSImpl.executeRename(file3, (String)newValue);
                        break;
                    }
                    case "writable": {
                        PersistentFSImpl.executeSetWritable(file3, (Boolean)newValue);
                        if (!LOG.isDebugEnabled()) break;
                        LOG.debug("File " + file3 + " writable=" + file3.isWritable() + " id=" + PersistentFSImpl.getFileId(file3));
                        break;
                    }
                    case "HIDDEN": {
                        PersistentFSImpl.executeSetHidden(file3, (Boolean)newValue);
                        break;
                    }
                    case "symlink": {
                        PersistentFSImpl.executeSetTarget(file3, (String)newValue);
                        this.markForContentReloadRecursively(PersistentFSImpl.getFileId(file3));
                    }
                }
            }
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    @NotNull
    @NonNls
    public String toString() {
        if ("PersistentFS" == null) {
            PersistentFSImpl.$$$reportNull$$$0(156);
        }
        return "PersistentFS";
    }

    private void executeCreateChild(@NotNull VirtualFile parent, @NotNull String name, @Nullable FileAttributes attributes, @Nullable String symlinkTarget, boolean isEmptyDirectory) {
        if (parent == null) {
            PersistentFSImpl.$$$reportNull$$$0(157);
        }
        if (name == null) {
            PersistentFSImpl.$$$reportNull$$$0(158);
        }
        NewVirtualFileSystem delegate = PersistentFSImpl.getDelegate(parent);
        int parentId = PersistentFSImpl.getFileId(parent);
        Pair<FileAttributes, String> childData = PersistentFSImpl.getChildData(delegate, parent, name, attributes, symlinkTarget);
        if (childData != null) {
            int childId = PersistentFSImpl.makeChildRecord(parentId, name, childData, delegate);
            PersistentFSImpl.appendIdToParentList(parentId, childId);
            assert (parent instanceof VirtualDirectoryImpl) : parent;
            VirtualDirectoryImpl dir = (VirtualDirectoryImpl)parent;
            VirtualFileSystemEntry child2 = dir.createChild(name, childId, dir.getFileSystem(), (FileAttributes)childData.first, isEmptyDirectory);
            if (isEmptyDirectory) {
                PersistentFSImpl.setChildrenCached(childId);
            }
            dir.addChild(child2);
            this.incStructuralModificationCount();
        }
    }

    private static int makeChildRecord(int parentId, @NotNull CharSequence name, @NotNull Pair<FileAttributes, String> childData, @NotNull NewVirtualFileSystem fs) {
        if (name == null) {
            PersistentFSImpl.$$$reportNull$$$0(159);
        }
        if (childData == null) {
            PersistentFSImpl.$$$reportNull$$$0(160);
        }
        if (fs == null) {
            PersistentFSImpl.$$$reportNull$$$0(161);
        }
        int childId = FSRecords.createRecord();
        PersistentFSImpl.writeAttributesToRecord(childId, parentId, name, fs, (FileAttributes)childData.first, (String)childData.second);
        assert (childId > 0) : childId;
        return childId;
    }

    @Nullable
    private static Pair<FileAttributes, String> getChildData(@NotNull NewVirtualFileSystem fs, @NotNull VirtualFile parent, @NotNull String name, @Nullable FileAttributes attributes, @Nullable String symlinkTarget) {
        if (fs == null) {
            PersistentFSImpl.$$$reportNull$$$0(162);
        }
        if (parent == null) {
            PersistentFSImpl.$$$reportNull$$$0(163);
        }
        if (name == null) {
            PersistentFSImpl.$$$reportNull$$$0(164);
        }
        if (attributes == null) {
            FakeVirtualFile virtualFile = new FakeVirtualFile(parent, name);
            attributes = fs.getAttributes((VirtualFile)virtualFile);
            symlinkTarget = attributes != null && attributes.isSymLink() ? fs.resolveSymLink((VirtualFile)virtualFile) : null;
        }
        return attributes == null ? null : Pair.create((Object)attributes, (Object)symlinkTarget);
    }

    private static void appendIdToParentList(int parentId, int childId) {
        int[] childrenList = FSRecords.list(parentId);
        childrenList = ArrayUtil.append((int[])childrenList, (int)childId);
        FSRecords.updateList(parentId, childrenList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeDelete(@NotNull VirtualFile file2) {
        int parentId;
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(165);
        }
        if (!file2.exists()) {
            LOG.error("Deleting a file which does not exist: " + ((VirtualFileWithId)file2).getId() + " " + file2.getPath());
            return;
        }
        this.clearIdCache();
        int id = PersistentFSImpl.getFileId(file2);
        VirtualFile parent = file2.getParent();
        int n = parentId = parent == null ? 0 : PersistentFSImpl.getFileId(parent);
        if (parentId == 0) {
            String rootUrl = PersistentFSImpl.normalizeRootUrl(file2.getPath(), (NewVirtualFileSystem)file2.getFileSystem());
            Map<String, VirtualFileSystemEntry> map2 = this.myRoots;
            synchronized (map2) {
                this.myRoots.remove(rootUrl);
                this.myIdToDirCache.remove(id);
                FSRecords.deleteRootRecord(id);
            }
        } else {
            PersistentFSImpl.removeIdFromParentList(parentId, id, parent, file2);
            VirtualDirectoryImpl directory = (VirtualDirectoryImpl)file2.getParent();
            assert (directory != null) : file2;
            directory.removeChild(file2);
        }
        FSRecords.deleteRecordRecursively(id);
        PersistentFSImpl.invalidateSubtree(file2);
        this.incStructuralModificationCount();
    }

    private static void invalidateSubtree(@NotNull VirtualFile file2) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(166);
        }
        VirtualFileSystemEntry impl = (VirtualFileSystemEntry)file2;
        impl.invalidate();
        for (VirtualFile child2 : impl.getCachedChildren()) {
            PersistentFSImpl.invalidateSubtree(child2);
        }
    }

    private static void removeIdFromParentList(int parentId, int id, @NotNull VirtualFile parent, VirtualFile file2) {
        int[] childList;
        int index;
        if (parent == null) {
            PersistentFSImpl.$$$reportNull$$$0(167);
        }
        if ((index = ArrayUtil.indexOf((int[])(childList = FSRecords.list(parentId)), (int)id)) == -1) {
            throw new RuntimeException("Cannot find child (" + id + ")" + file2 + "\n\tin (" + parentId + ")" + parent + "\n\tactual children:" + Arrays.toString(childList));
        }
        childList = ArrayUtil.remove((int[])childList, (int)index);
        FSRecords.updateList(parentId, childList);
    }

    private static void executeRename(@NotNull VirtualFile file2, @NotNull String newName) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(168);
        }
        if (newName == null) {
            PersistentFSImpl.$$$reportNull$$$0(169);
        }
        int id = PersistentFSImpl.getFileId(file2);
        FSRecords.setName(id, newName);
        ((VirtualFileSystemEntry)file2).setNewName(newName);
    }

    private static void executeSetWritable(@NotNull VirtualFile file2, boolean writableFlag) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(170);
        }
        PersistentFSImpl.setFlag(file2, 4, !writableFlag);
        ((VirtualFileSystemEntry)file2).updateProperty("writable", writableFlag);
    }

    private static void executeSetHidden(@NotNull VirtualFile file2, boolean hiddenFlag) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(171);
        }
        PersistentFSImpl.setFlag(file2, 64, hiddenFlag);
        ((VirtualFileSystemEntry)file2).updateProperty("HIDDEN", hiddenFlag);
    }

    private static void executeSetTarget(@NotNull VirtualFile file2, @Nullable String target2) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(172);
        }
        FSRecords.storeSymlinkTarget(PersistentFSImpl.getFileId(file2), target2);
    }

    private static void setFlag(@NotNull VirtualFile file2, int mask, boolean value) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(173);
        }
        PersistentFSImpl.setFlag(PersistentFSImpl.getFileId(file2), mask, value);
    }

    private static void setFlag(int id, int mask, boolean value) {
        int flags;
        int oldFlags = FSRecords.getFlags(id);
        int n = flags = value ? oldFlags | mask : oldFlags & ~mask;
        if (oldFlags != flags) {
            FSRecords.setFlags(id, flags, true);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void executeTouch(@NotNull VirtualFile file2, boolean reloadContentFromDelegate, long newModificationStamp, long newLength, long l) {
        void newTimestamp;
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(174);
        }
        if (reloadContentFromDelegate) {
            PersistentFSImpl.setFlag(file2, 8, true);
        }
        int fileId = PersistentFSImpl.getFileId(file2);
        FSRecords.setLength(fileId, newLength);
        FSRecords.setTimestamp(fileId, (long)newTimestamp);
        ((VirtualFileSystemEntry)file2).setModificationStamp(newModificationStamp);
    }

    private void executeMove(@NotNull VirtualFile file2, @NotNull VirtualFile newParent) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(175);
        }
        if (newParent == null) {
            PersistentFSImpl.$$$reportNull$$$0(176);
        }
        this.clearIdCache();
        int fileId = PersistentFSImpl.getFileId(file2);
        int newParentId = PersistentFSImpl.getFileId(newParent);
        int oldParentId = PersistentFSImpl.getFileId(file2.getParent());
        PersistentFSImpl.removeIdFromParentList(oldParentId, fileId, file2.getParent(), file2);
        FSRecords.setParent(fileId, newParentId);
        PersistentFSImpl.appendIdToParentList(newParentId, fileId);
        ((VirtualFileSystemEntry)file2).setParent(newParent);
    }

    @Override
    public String getName(int id) {
        assert (id > 0);
        return FSRecords.getName(id);
    }

    public void cleanPersistedContent(int id) {
        PersistentFSImpl.doCleanPersistedContent(id);
    }

    public void cleanPersistedContents() {
        int[] roots;
        for (int root : roots = FSRecords.listRoots()) {
            this.markForContentReloadRecursively(root);
        }
    }

    private void markForContentReloadRecursively(int id) {
        if (PersistentFSImpl.isDirectory(this.getFileAttributes(id))) {
            for (int child2 : FSRecords.list(id)) {
                this.markForContentReloadRecursively(child2);
            }
        } else {
            PersistentFSImpl.doCleanPersistedContent(id);
        }
    }

    private static void doCleanPersistedContent(int id) {
        PersistentFSImpl.setFlag(id, 8, true);
    }

    private static boolean looksCanonical(@NotNull String pathBeforeSlash) {
        int i;
        if (pathBeforeSlash == null) {
            PersistentFSImpl.$$$reportNull$$$0(177);
        }
        if (pathBeforeSlash.endsWith("/")) {
            return false;
        }
        int start2 = 0;
        while ((i = pathBeforeSlash.indexOf("..", start2)) != -1) {
            if (i != 0 && pathBeforeSlash.charAt(i - 1) == '/') {
                return false;
            }
            if (i < pathBeforeSlash.length() - 2 && pathBeforeSlash.charAt(i + 2) == '/') {
                return false;
            }
            start2 = i + 1;
        }
        return true;
    }

    @Override
    public boolean mayHaveChildren(int id) {
        return FSRecords.mayHaveChildren(id);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 11: 
            case 13: 
            case 15: 
            case 18: 
            case 19: 
            case 21: 
            case 26: 
            case 28: 
            case 30: 
            case 61: 
            case 64: 
            case 67: 
            case 72: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 79: 
            case 80: 
            case 81: 
            case 86: 
            case 87: 
            case 92: 
            case 145: 
            case 150: 
            case 151: 
            case 153: 
            case 154: 
            case 156: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 11: 
            case 13: 
            case 15: 
            case 18: 
            case 19: 
            case 21: 
            case 26: 
            case 28: 
            case 30: 
            case 61: 
            case 64: 
            case 67: 
            case 72: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 79: 
            case 80: 
            case 81: 
            case 86: 
            case 87: 
            case 92: 
            case 145: 
            case 150: 
            case 151: 
            case 153: 
            case 154: 
            case 156: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bus";
                break;
            }
            case 1: 
            case 9: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "segment";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 4: 
            case 12: 
            case 50: 
            case 59: 
            case 62: 
            case 65: 
            case 135: 
            case 139: 
            case 157: 
            case 163: 
            case 167: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 11: 
            case 13: 
            case 15: 
            case 18: 
            case 19: 
            case 21: 
            case 26: 
            case 28: 
            case 30: 
            case 61: 
            case 64: 
            case 67: 
            case 72: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 79: 
            case 80: 
            case 81: 
            case 86: 
            case 87: 
            case 92: 
            case 145: 
            case 150: 
            case 151: 
            case 153: 
            case 154: 
            case 156: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl";
                break;
            }
            case 7: 
            case 10: 
            case 16: 
            case 20: 
            case 22: 
            case 24: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 37: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 56: 
            case 57: 
            case 58: 
            case 66: 
            case 68: 
            case 69: 
            case 71: 
            case 73: 
            case 78: 
            case 82: 
            case 84: 
            case 88: 
            case 90: 
            case 91: 
            case 93: 
            case 94: 
            case 95: 
            case 165: 
            case 166: 
            case 168: 
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 174: 
            case 175: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childrenIds";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "current";
                break;
            }
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "att";
                break;
            }
            case 32: 
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bytes";
                break;
            }
            case 34: 
            case 60: 
            case 158: 
            case 159: 
            case 164: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 35: 
            case 38: 
            case 52: 
            case 55: 
            case 147: 
            case 149: 
            case 152: 
            case 161: 
            case 162: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fs";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "n1";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "n2";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileOrDirectory";
                break;
            }
            case 51: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childName";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childIds";
                break;
            }
            case 70: 
            case 169: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 83: 
            case 138: 
            case 143: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nativeStream";
                break;
            }
            case 96: 
            case 176: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newParent";
                break;
            }
            case 97: 
            case 104: 
            case 107: 
            case 111: 
            case 155: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 98: 
            case 116: 
            case 121: 
            case 125: 
            case 129: 
            case 132: {
                objectArray2 = objectArray3;
                objectArray3[0] = "events";
                break;
            }
            case 99: 
            case 119: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesInvolved";
                break;
            }
            case 100: 
            case 120: {
                objectArray2 = objectArray3;
                objectArray3[0] = "middleDirsInvolved";
                break;
            }
            case 101: 
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deletedPaths";
                break;
            }
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "createdPaths";
                break;
            }
            case 103: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventsToRemove";
                break;
            }
            case 105: 
            case 108: 
            case 146: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 109: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 110: {
                objectArray2 = objectArray3;
                objectArray3[0] = "middleDirs";
                break;
            }
            case 112: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stored";
                break;
            }
            case 113: 
            case 115: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event1";
                break;
            }
            case 114: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event2";
                break;
            }
            case 117: 
            case 123: 
            case 127: 
            case 131: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outApplyEvents";
                break;
            }
            case 118: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outValidatedEvents";
                break;
            }
            case 122: 
            case 126: 
            case 130: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outValidated";
                break;
            }
            case 124: 
            case 128: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toIgnore";
                break;
            }
            case 133: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deletions";
                break;
            }
            case 134: {
                objectArray2 = objectArray3;
                objectArray3[0] = "creations";
                break;
            }
            case 136: 
            case 137: 
            case 140: {
                objectArray2 = objectArray3;
                objectArray3[0] = "createEvents";
                break;
            }
            case 141: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameExtractor";
                break;
            }
            case 142: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentChildrenIds";
                break;
            }
            case 144: {
                objectArray2 = objectArray3;
                objectArray3[0] = "convertor";
                break;
            }
            case 148: {
                objectArray2 = objectArray3;
                objectArray3[0] = "basePath";
                break;
            }
            case 160: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childData";
                break;
            }
            case 177: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathBeforeSlash";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCacheDir";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDelegate";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "list";
                break;
            }
            case 13: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "listPersisted";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "persistAllChildren";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "listAll";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "writeAttribute";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "readContentById";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "writeContent";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "copyFile";
                break;
            }
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "createChildDirectory";
                break;
            }
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "createChildFile";
                break;
            }
            case 72: 
            case 74: 
            case 75: 
            case 76: 
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "contentsToByteArray";
                break;
            }
            case 79: 
            case 80: 
            case 81: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputStream";
                break;
            }
            case 86: 
            case 87: {
                objectArray = objectArray2;
                objectArray2[1] = "createReplicator";
                break;
            }
            case 92: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputStream";
                break;
            }
            case 145: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateChildInfos";
                break;
            }
            case 150: {
                objectArray = objectArray2;
                objectArray2[1] = "normalizeRootUrl";
                break;
            }
            case 151: 
            case 153: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoots";
                break;
            }
            case 154: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalRoots";
                break;
            }
            case 156: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "areChildrenLoaded";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getOrCacheDir";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 11: 
            case 13: 
            case 15: 
            case 18: 
            case 19: 
            case 21: 
            case 26: 
            case 28: 
            case 30: 
            case 61: 
            case 64: 
            case 67: 
            case 72: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 79: 
            case 80: 
            case 81: 
            case 86: 
            case 87: 
            case 92: 
            case 145: 
            case 150: 
            case 151: 
            case 153: 
            case 154: 
            case 156: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getDelegate";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "wereChildrenAccessed";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "list";
                break;
            }
            case 12: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "listPersisted";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "persistAllChildren";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "listAll";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "readAttribute";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "writeAttribute";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "readContent";
                break;
            }
            case 29: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "writeContent";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "storeUnlinkedContent";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getModificationCount";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "writeAttributesToRecord";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "isDirectory";
                break;
            }
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "namesEqual";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "exists";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getTimeStamp";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "setTimeStamp";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getFileId";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "isSymLink";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "resolveSymLink";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "isWritable";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "isHidden";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "setWritable";
                break;
            }
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "getId";
                break;
            }
            case 53: 
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "findExistingId";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "getLength";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "getLastRecordedLength";
                break;
            }
            case 58: 
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "copyFile";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "createChildDirectory";
                break;
            }
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "createChildFile";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "deleteFile";
                break;
            }
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "renameFile";
                break;
            }
            case 71: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "contentsToByteArray";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "getInputStream";
                break;
            }
            case 82: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "reloadLengthFromDelegate";
                break;
            }
            case 84: 
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "createReplicator";
                break;
            }
            case 88: 
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "storeContentToStorage";
                break;
            }
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "getLengthIfUpToDate";
                break;
            }
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "getOutputStream";
                break;
            }
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "acquireContent";
                break;
            }
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentContentId";
                break;
            }
            case 95: 
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "moveFile";
                break;
            }
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "processEvent";
                break;
            }
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "groupByPath";
                break;
            }
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "getAlternativePath";
                break;
            }
            case 105: 
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "removeNestedDelete";
                break;
            }
            case 107: 
            case 108: 
            case 109: 
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "checkIfConflictingPaths";
                break;
            }
            case 111: 
            case 112: {
                objectArray = objectArray;
                objectArray[2] = "canReconcileEvents";
                break;
            }
            case 113: 
            case 114: {
                objectArray = objectArray;
                objectArray[2] = "canReconcile";
                break;
            }
            case 115: {
                objectArray = objectArray;
                objectArray[2] = "isContentChangeLikeHarmlessEvent";
                break;
            }
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: {
                objectArray = objectArray;
                objectArray[2] = "groupAndValidate";
                break;
            }
            case 121: 
            case 122: 
            case 123: 
            case 124: {
                objectArray = objectArray;
                objectArray[2] = "groupCreations";
                break;
            }
            case 125: 
            case 126: 
            case 127: 
            case 128: {
                objectArray = objectArray;
                objectArray[2] = "groupDeletions";
                break;
            }
            case 129: 
            case 130: 
            case 131: {
                objectArray = objectArray;
                objectArray[2] = "groupOthers";
                break;
            }
            case 132: {
                objectArray = objectArray;
                objectArray[2] = "processEvents";
                break;
            }
            case 133: {
                objectArray = objectArray;
                objectArray[2] = "applyDeletions";
                break;
            }
            case 134: {
                objectArray = objectArray;
                objectArray[2] = "applyCreations";
                break;
            }
            case 135: 
            case 136: {
                objectArray = objectArray;
                objectArray[2] = "applyCreateEventsInDirectory";
                break;
            }
            case 137: 
            case 138: {
                objectArray = objectArray;
                objectArray[2] = "saveScannedChildrenRecursively";
                break;
            }
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateChildInfos";
                break;
            }
            case 146: 
            case 147: {
                objectArray = objectArray;
                objectArray[2] = "findRoot";
                break;
            }
            case 148: 
            case 149: {
                objectArray = objectArray;
                objectArray[2] = "normalizeRootUrl";
                break;
            }
            case 152: {
                objectArray = objectArray;
                objectArray[2] = "getRoots";
                break;
            }
            case 155: {
                objectArray = objectArray;
                objectArray[2] = "applyEvent";
                break;
            }
            case 157: 
            case 158: {
                objectArray = objectArray;
                objectArray[2] = "executeCreateChild";
                break;
            }
            case 159: 
            case 160: 
            case 161: {
                objectArray = objectArray;
                objectArray[2] = "makeChildRecord";
                break;
            }
            case 162: 
            case 163: 
            case 164: {
                objectArray = objectArray;
                objectArray[2] = "getChildData";
                break;
            }
            case 165: {
                objectArray = objectArray;
                objectArray[2] = "executeDelete";
                break;
            }
            case 166: {
                objectArray = objectArray;
                objectArray[2] = "invalidateSubtree";
                break;
            }
            case 167: {
                objectArray = objectArray;
                objectArray[2] = "removeIdFromParentList";
                break;
            }
            case 168: 
            case 169: {
                objectArray = objectArray;
                objectArray[2] = "executeRename";
                break;
            }
            case 170: {
                objectArray = objectArray;
                objectArray[2] = "executeSetWritable";
                break;
            }
            case 171: {
                objectArray = objectArray;
                objectArray[2] = "executeSetHidden";
                break;
            }
            case 172: {
                objectArray = objectArray;
                objectArray[2] = "executeSetTarget";
                break;
            }
            case 173: {
                objectArray = objectArray;
                objectArray[2] = "setFlag";
                break;
            }
            case 174: {
                objectArray = objectArray;
                objectArray[2] = "executeTouch";
                break;
            }
            case 175: 
            case 176: {
                objectArray = objectArray;
                objectArray[2] = "executeMove";
                break;
            }
            case 177: {
                objectArray = objectArray;
                objectArray[2] = "looksCanonical";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 11: 
            case 13: 
            case 15: 
            case 18: 
            case 19: 
            case 21: 
            case 26: 
            case 28: 
            case 30: 
            case 61: 
            case 64: 
            case 67: 
            case 72: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 79: 
            case 80: 
            case 81: 
            case 86: 
            case 87: 
            case 92: 
            case 145: 
            case 150: 
            case 151: 
            case 153: 
            case 154: 
            case 156: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class FsRoot
    extends VirtualDirectoryImpl {
        private final CharSequence myName;
        private final String myPathWithOneSlash;

        private FsRoot(int id, @NotNull VfsData.Segment segment, @NotNull VfsData.DirectoryData data, @NotNull NewVirtualFileSystem fs, @NotNull CharSequence name, @NotNull String pathBeforeSlash) {
            if (segment == null) {
                FsRoot.$$$reportNull$$$0(0);
            }
            if (data == null) {
                FsRoot.$$$reportNull$$$0(1);
            }
            if (fs == null) {
                FsRoot.$$$reportNull$$$0(2);
            }
            if (name == null) {
                FsRoot.$$$reportNull$$$0(3);
            }
            if (pathBeforeSlash == null) {
                FsRoot.$$$reportNull$$$0(4);
            }
            super(id, segment, data, null, fs);
            this.myName = name;
            if (!PersistentFSImpl.looksCanonical(pathBeforeSlash)) {
                throw new IllegalArgumentException("path must be canonical but got: '" + pathBeforeSlash + "'");
            }
            this.myPathWithOneSlash = pathBeforeSlash + '/';
        }

        @Override
        @NotNull
        public CharSequence getNameSequence() {
            CharSequence charSequence = this.myName;
            if (charSequence == null) {
                FsRoot.$$$reportNull$$$0(5);
            }
            return charSequence;
        }

        @Override
        @NotNull
        protected char[] appendPathOnFileSystem(int pathLength, int[] position) {
            int myLength = this.myPathWithOneSlash.length() - 1;
            char[] chars = new char[pathLength + myLength];
            CharArrayUtil.getChars((CharSequence)this.myPathWithOneSlash, (char[])chars, (int)0, (int)position[0], (int)myLength);
            position[0] = position[0] + myLength;
            if (chars == null) {
                FsRoot.$$$reportNull$$$0(6);
            }
            return chars;
        }

        @Override
        public void setNewName(@NotNull String newName) {
            if (newName == null) {
                FsRoot.$$$reportNull$$$0(7);
            }
            throw new IncorrectOperationException();
        }

        @Override
        public final void setParent(@NotNull VirtualFile newParent) {
            if (newParent == null) {
                FsRoot.$$$reportNull$$$0(8);
            }
            throw new IncorrectOperationException();
        }

        @Override
        @NotNull
        public String getPath() {
            String string = this.myPathWithOneSlash;
            if (string == null) {
                FsRoot.$$$reportNull$$$0(9);
            }
            return string;
        }

        @Override
        @NotNull
        public String getUrl() {
            String string = this.getFileSystem().getProtocol() + "://" + this.getPath();
            if (string == null) {
                FsRoot.$$$reportNull$$$0(10);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: 
                case 6: 
                case 9: 
                case 10: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: 
                case 6: 
                case 9: 
                case 10: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "segment";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fs";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pathBeforeSlash";
                    break;
                }
                case 5: 
                case 6: 
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl$FsRoot";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newName";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newParent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl$FsRoot";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNameSequence";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "appendPathOnFileSystem";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPath";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUrl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: 
                case 6: 
                case 9: 
                case 10: {
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "setNewName";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "setParent";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: 
                case 6: 
                case 9: 
                case 10: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

