/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.impl.InheritedJdkOrderEntryImpl;
import com.intellij.openapi.roots.impl.LibraryOrderEntryImpl;
import com.intellij.openapi.roots.impl.ModuleJdkOrderEntryImpl;
import com.intellij.openapi.roots.impl.ModuleLibraryOrderEntryImpl;
import com.intellij.openapi.roots.impl.ModuleOrderEntryImpl;
import com.intellij.openapi.roots.impl.ModuleSourceOrderEntryImpl;
import com.intellij.openapi.roots.impl.ProjectRootManagerImpl;
import com.intellij.openapi.roots.impl.RootModelImpl;
import com.intellij.openapi.util.InvalidDataException;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

class OrderEntryFactory {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.roots.impl.OrderEntryFactory");
    @NonNls
    public static final String ORDER_ENTRY_ELEMENT_NAME = "orderEntry";
    @NonNls
    public static final String ORDER_ENTRY_TYPE_ATTR = "type";

    OrderEntryFactory() {
    }

    @NotNull
    static OrderEntry createOrderEntryByElement(@NotNull Element element, @NotNull RootModelImpl rootModel, @NotNull ProjectRootManagerImpl projectRootManager) throws InvalidDataException {
        if (element == null) {
            OrderEntryFactory.$$$reportNull$$$0(0);
        }
        if (rootModel == null) {
            OrderEntryFactory.$$$reportNull$$$0(1);
        }
        if (projectRootManager == null) {
            OrderEntryFactory.$$$reportNull$$$0(2);
        }
        LOG.assertTrue(ORDER_ENTRY_ELEMENT_NAME.equals(element.getName()));
        String type = element.getAttributeValue(ORDER_ENTRY_TYPE_ATTR);
        if (type == null) {
            throw new InvalidDataException();
        }
        if ("sourceFolder".equals(type)) {
            ModuleSourceOrderEntryImpl moduleSourceOrderEntryImpl = new ModuleSourceOrderEntryImpl(element, rootModel);
            if (moduleSourceOrderEntryImpl == null) {
                OrderEntryFactory.$$$reportNull$$$0(3);
            }
            return moduleSourceOrderEntryImpl;
        }
        if ("jdk".equals(type)) {
            ModuleJdkOrderEntryImpl moduleJdkOrderEntryImpl = new ModuleJdkOrderEntryImpl(element, rootModel, projectRootManager);
            if (moduleJdkOrderEntryImpl == null) {
                OrderEntryFactory.$$$reportNull$$$0(4);
            }
            return moduleJdkOrderEntryImpl;
        }
        if ("inheritedJdk".equals(type)) {
            InheritedJdkOrderEntryImpl inheritedJdkOrderEntryImpl = new InheritedJdkOrderEntryImpl(element, rootModel, projectRootManager);
            if (inheritedJdkOrderEntryImpl == null) {
                OrderEntryFactory.$$$reportNull$$$0(5);
            }
            return inheritedJdkOrderEntryImpl;
        }
        if ("library".equals(type)) {
            LibraryOrderEntryImpl libraryOrderEntryImpl = new LibraryOrderEntryImpl(element, rootModel, projectRootManager);
            if (libraryOrderEntryImpl == null) {
                OrderEntryFactory.$$$reportNull$$$0(6);
            }
            return libraryOrderEntryImpl;
        }
        if ("module-library".equals(type)) {
            ModuleLibraryOrderEntryImpl moduleLibraryOrderEntryImpl = new ModuleLibraryOrderEntryImpl(element, rootModel, projectRootManager);
            if (moduleLibraryOrderEntryImpl == null) {
                OrderEntryFactory.$$$reportNull$$$0(7);
            }
            return moduleLibraryOrderEntryImpl;
        }
        if ("module".equals(type)) {
            ModuleOrderEntryImpl moduleOrderEntryImpl = new ModuleOrderEntryImpl(element, rootModel);
            if (moduleOrderEntryImpl == null) {
                OrderEntryFactory.$$$reportNull$$$0(8);
            }
            return moduleOrderEntryImpl;
        }
        throw new InvalidDataException("Unknown order entry type:" + type);
    }

    @NotNull
    static Element createOrderEntryElement(@NotNull String type) {
        if (type == null) {
            OrderEntryFactory.$$$reportNull$$$0(9);
        }
        Element element = new Element(ORDER_ENTRY_ELEMENT_NAME);
        element.setAttribute(ORDER_ENTRY_TYPE_ATTR, type);
        Element element2 = element;
        if (element2 == null) {
            OrderEntryFactory.$$$reportNull$$$0(10);
        }
        return element2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootModel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectRootManager";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/impl/OrderEntryFactory";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = ORDER_ENTRY_TYPE_ATTR;
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/impl/OrderEntryFactory";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createOrderEntryByElement";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createOrderEntryElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createOrderEntryByElement";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createOrderEntryElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

