/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.newEditor;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableGroup;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.options.ex.ConfigurableVisitor;
import com.intellij.openapi.options.ex.ConfigurableWrapper;
import com.intellij.openapi.options.ex.Settings;
import com.intellij.openapi.options.newEditor.AbstractEditor;
import com.intellij.openapi.options.newEditor.Banner;
import com.intellij.openapi.options.newEditor.ConfigurableController;
import com.intellij.openapi.options.newEditor.ConfigurableEditor;
import com.intellij.openapi.options.newEditor.ISettingsTreeViewFactory;
import com.intellij.openapi.options.newEditor.OptionsEditorColleague;
import com.intellij.openapi.options.newEditor.SettingsFilter;
import com.intellij.openapi.options.newEditor.SettingsSearch;
import com.intellij.openapi.options.newEditor.SettingsTreeView;
import com.intellij.openapi.options.newEditor.SpotlightPainter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.LoadingDecorator;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.impl.IdeFrameDecorator;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.util.Alarm;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

final class SettingsEditor
extends AbstractEditor
implements DataProvider {
    private static final String SELECTED_CONFIGURABLE = "settings.editor.selected.configurable";
    private static final String SPLITTER_PROPORTION = "settings.editor.splitter.proportion";
    private static final float SPLITTER_PROPORTION_DEFAULT_VALUE = 0.2f;
    private final PropertiesComponent myProperties;
    private final Settings mySettings;
    private final SettingsSearch mySearch;
    private final SettingsFilter myFilter;
    private final SettingsTreeView myTreeView;
    private final ConfigurableEditor myEditor;
    private final OnePixelSplitter mySplitter;
    private final SpotlightPainter mySpotlightPainter;
    private final LoadingDecorator myLoadingDecorator;
    private final Banner myBanner;
    private final Map<Configurable, ConfigurableController> myControllers;
    private ConfigurableController myLastController;

    SettingsEditor(@NotNull Disposable parent, @NotNull Project project, @NotNull List<ConfigurableGroup> groups, @Nullable Configurable configurable2, String filter, ISettingsTreeViewFactory factory) {
        String id;
        if (parent == null) {
            SettingsEditor.$$$reportNull$$$0(0);
        }
        if (project == null) {
            SettingsEditor.$$$reportNull$$$0(1);
        }
        if (groups == null) {
            SettingsEditor.$$$reportNull$$$0(2);
        }
        super(parent);
        this.myControllers = new HashMap<Configurable, ConfigurableController>();
        this.myProperties = PropertiesComponent.getInstance((Project)project);
        this.mySettings = new Settings(groups){

            @Override
            @NotNull
            protected Promise<? super Object> selectImpl(Configurable configurable2) {
                SettingsEditor.this.myFilter.update((String)null, false, true);
                Promise<? super Object> promise = SettingsEditor.this.myTreeView.select(configurable2);
                if (promise == null) {
                    1.$$$reportNull$$$0(0);
                }
                return promise;
            }

            @Override
            public void revalidate() {
                SettingsEditor.this.myEditor.requestUpdate();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/newEditor/SettingsEditor$1", "selectImpl"));
            }
        };
        this.mySearch = new SettingsSearch(){

            @Override
            void onTextKeyEvent(KeyEvent event) {
                ((SettingsEditor)SettingsEditor.this).myTreeView.myTree.processKeyEvent(event);
            }
        };
        JPanel searchPanel = new JPanel((LayoutManager)new VerticalLayout(0));
        searchPanel.add("CENTER", (Component)((Object)this.mySearch));
        this.myFilter = new SettingsFilter(project, groups, this.mySearch){

            @Override
            Configurable getConfigurable(SimpleNode node) {
                return SettingsTreeView.getConfigurable(node);
            }

            @Override
            SimpleNode findNode(Configurable configurable2) {
                return SettingsEditor.this.myTreeView.findNode(configurable2);
            }

            @Override
            void updateSpotlight(boolean now) {
                if (!SettingsEditor.this.myDisposed && SettingsEditor.this.mySpotlightPainter != null) {
                    if (!now) {
                        SettingsEditor.this.mySpotlightPainter.updateLater();
                    } else {
                        SettingsEditor.this.mySpotlightPainter.updateNow();
                    }
                }
            }
        };
        this.myFilter.myContext.addColleague(new OptionsEditorColleague(){

            @Override
            @NotNull
            public Promise<? super Object> onSelected(@Nullable Configurable configurable2, Configurable oldConfigurable) {
                if (configurable2 != null) {
                    SettingsEditor.this.myProperties.setValue(SettingsEditor.SELECTED_CONFIGURABLE, ConfigurableVisitor.ByID.getID(configurable2));
                    SettingsEditor.this.myLoadingDecorator.startLoading(false);
                }
                SettingsEditor.this.checkModified(oldConfigurable);
                Promise<? super Object> result2 = SettingsEditor.this.myEditor.select(configurable2);
                result2.onSuccess(it -> {
                    SettingsEditor.this.updateController(configurable2);
                    SettingsEditor.this.myLoadingDecorator.stopLoading();
                });
                Promise<? super Object> promise = result2;
                if (promise == null) {
                    4.$$$reportNull$$$0(0);
                }
                return promise;
            }

            @Override
            @NotNull
            public Promise<? super Object> onModifiedAdded(Configurable configurable2) {
                Promise<? super Object> promise = this.updateIfCurrent(configurable2);
                if (promise == null) {
                    4.$$$reportNull$$$0(1);
                }
                return promise;
            }

            @Override
            @NotNull
            public Promise<? super Object> onModifiedRemoved(Configurable configurable2) {
                Promise<? super Object> promise = this.updateIfCurrent(configurable2);
                if (promise == null) {
                    4.$$$reportNull$$$0(2);
                }
                return promise;
            }

            @Override
            @NotNull
            public Promise<? super Object> onErrorsChanged() {
                Promise<? super Object> promise = this.updateIfCurrent(((SettingsEditor)SettingsEditor.this).myFilter.myContext.getCurrentConfigurable());
                if (promise == null) {
                    4.$$$reportNull$$$0(3);
                }
                return promise;
            }

            @NotNull
            private Promise<? super Object> updateIfCurrent(@Nullable Configurable configurable2) {
                if (configurable2 != null && configurable2 == ((SettingsEditor)SettingsEditor.this).myFilter.myContext.getCurrentConfigurable()) {
                    SettingsEditor.this.updateStatus(configurable2);
                    Promise promise = Promises.resolvedPromise();
                    if (promise == null) {
                        4.$$$reportNull$$$0(4);
                    }
                    return promise;
                }
                Promise promise = Promises.cancelledPromise();
                if (promise == null) {
                    4.$$$reportNull$$$0(5);
                }
                return promise;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/openapi/options/newEditor/SettingsEditor$4";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "onSelected";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "onModifiedAdded";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "onModifiedRemoved";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "onErrorsChanged";
                        break;
                    }
                    case 4: 
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "updateIfCurrent";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        });
        this.myTreeView = factory.createTreeView(this.myFilter, groups);
        this.myTreeView.myTree.addKeyListener((KeyListener)this.mySearch);
        this.myEditor = new ConfigurableEditor(this, null){

            @Override
            boolean apply() {
                SettingsEditor.this.checkModified(((SettingsEditor)SettingsEditor.this).myFilter.myContext.getCurrentConfigurable());
                if (((SettingsEditor)SettingsEditor.this).myFilter.myContext.getModified().isEmpty()) {
                    return true;
                }
                LinkedHashMap<Configurable, ConfigurationException> map2 = new LinkedHashMap<Configurable, ConfigurationException>();
                for (Configurable configurable2 : ((SettingsEditor)SettingsEditor.this).myFilter.myContext.getModified()) {
                    ConfigurationException exception = ConfigurableEditor.apply(configurable2);
                    if (exception != null) {
                        map2.put(configurable2, exception);
                        continue;
                    }
                    if (configurable2.isModified()) continue;
                    ((SettingsEditor)SettingsEditor.this).myFilter.myContext.fireModifiedRemoved(configurable2, null);
                }
                SettingsEditor.this.mySearch.updateToolTipText();
                ((SettingsEditor)SettingsEditor.this).myFilter.myContext.fireErrorsChanged(map2, null);
                if (!map2.isEmpty()) {
                    Configurable targetConfigurable = (Configurable)map2.keySet().iterator().next();
                    ConfigurationException exception = (ConfigurationException)((Object)map2.get(targetConfigurable));
                    Configurable originator = exception.getOriginator();
                    if (originator != null) {
                        targetConfigurable = originator;
                    }
                    SettingsEditor.this.myTreeView.select(targetConfigurable);
                    return false;
                }
                SettingsEditor.this.updateStatus(((SettingsEditor)SettingsEditor.this).myFilter.myContext.getCurrentConfigurable());
                return true;
            }

            @Override
            void updateCurrent(Configurable configurable2, boolean reset) {
                if (reset && configurable2 != null) {
                    ((SettingsEditor)SettingsEditor.this).myFilter.myContext.fireReset(configurable2);
                }
                SettingsEditor.this.checkModified(configurable2);
            }

            @Override
            void openLink(Configurable configurable2) {
                SettingsEditor.this.mySettings.select(configurable2);
            }
        };
        this.myEditor.setPreferredSize((Dimension)JBUI.size((int)800, (int)600));
        this.myLoadingDecorator = new LoadingDecorator((JComponent)this.myEditor, (Disposable)this, 10, true);
        this.myBanner = new Banner(this.myEditor.getResetAction());
        searchPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.myBanner.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 10));
        this.mySearch.setBackground(UIUtil.SIDE_PANEL_BACKGROUND);
        searchPanel.setBackground(UIUtil.SIDE_PANEL_BACKGROUND);
        JPanel left = new JPanel(new BorderLayout());
        left.add("North", searchPanel);
        left.add("Center", this.myTreeView);
        JPanel right = new JPanel(new BorderLayout());
        right.add("North", this.myBanner);
        right.add("Center", this.myLoadingDecorator.getComponent());
        this.mySplitter = new OnePixelSplitter(false, this.myProperties.getFloat(SPLITTER_PROPORTION, 0.2f));
        this.mySplitter.setHonorComponentsMinimumSize(true);
        this.mySplitter.setFirstComponent((JComponent)left);
        this.mySplitter.setSecondComponent((JComponent)right);
        if (IdeFrameDecorator.isCustomDecorationActive()) {
            this.mySplitter.getDivider().setOpaque(false);
        }
        this.mySpotlightPainter = new SpotlightPainter(this.myEditor, this){

            @Override
            void updateNow() {
                Configurable configurable2 = ((SettingsEditor)SettingsEditor.this).myFilter.myContext.getCurrentConfigurable();
                if (((SettingsEditor)SettingsEditor.this).myTreeView.myTree.hasFocus() || SettingsEditor.this.mySearch.getTextEditor().hasFocus()) {
                    this.update(SettingsEditor.this.myFilter, configurable2, SettingsEditor.this.myEditor.getContent(configurable2));
                }
            }
        };
        this.add("Center", (Component)this.mySplitter);
        if (configurable2 == null && (configurable2 = new ConfigurableVisitor.ByID((id = this.myProperties.getValue(SELECTED_CONFIGURABLE)) != null ? id : "preferences.lookFeel").find(groups)) == null) {
            configurable2 = ConfigurableVisitor.ALL.find(groups);
        }
        this.myTreeView.select(configurable2).onSuccess(it -> this.myFilter.update(filter, false, true));
        Disposer.register((Disposable)this, (Disposable)this.myTreeView);
        this.installSpotlightRemover();
        this.mySearch.getTextEditor().addActionListener(event -> this.myTreeView.select(this.myFilter.myContext.getCurrentConfigurable()).onSuccess(o -> this.requestFocusToEditor()));
    }

    private void requestFocusToEditor() {
        JComponent component = this.myEditor.getPreferredFocusedComponent();
        if (component != null) {
            IdeFocusManager.findInstanceByComponent((Component)component).requestFocus((Component)component, true);
        }
    }

    private void installSpotlightRemover() {
        FocusAdapter spotlightRemover = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                Component comp = e.getOppositeComponent();
                if (comp == SettingsEditor.this.mySearch.getTextEditor() || comp == ((SettingsEditor)SettingsEditor.this).myTreeView.myTree) {
                    return;
                }
                SettingsEditor.this.mySpotlightPainter.update(null, null, null);
            }

            @Override
            public void focusGained(FocusEvent e) {
                if (!StringUtil.isEmpty((String)SettingsEditor.this.mySearch.getText())) {
                    SettingsEditor.this.mySpotlightPainter.updateNow();
                }
            }
        };
        this.myTreeView.myTree.addFocusListener((FocusListener)spotlightRemover);
        this.mySearch.getTextEditor().addFocusListener((FocusListener)spotlightRemover);
    }

    public Object getData(@NotNull @NonNls String dataId) {
        if (dataId == null) {
            SettingsEditor.$$$reportNull$$$0(3);
        }
        return Settings.KEY.is(dataId) ? this.mySettings : (SearchTextField.KEY.is(dataId) ? this.mySearch : null);
    }

    @Override
    void disposeOnce() {
        this.myProperties.setValue(SPLITTER_PROPORTION, this.mySplitter.getProportion(), 0.2f);
    }

    @Override
    Action getApplyAction() {
        return this.myEditor.getApplyAction();
    }

    @Override
    Action getResetAction() {
        return null;
    }

    @Override
    String getHelpTopic() {
        Configurable configurable2 = this.myFilter.myContext.getCurrentConfigurable();
        while (configurable2 != null) {
            String topic = configurable2.getHelpTopic();
            if (topic != null) {
                return topic;
            }
            configurable2 = this.myFilter.myContext.getParentConfigurable(configurable2);
        }
        return "preferences";
    }

    @Override
    boolean apply() {
        return this.myEditor.apply();
    }

    @Override
    boolean cancel() {
        if (this.myFilter.myContext.isHoldingFilter()) {
            this.mySearch.setText("");
            return false;
        }
        return super.cancel();
    }

    @Override
    JComponent getPreferredFocusedComponent() {
        return this.myTreeView != null ? this.myTreeView.myTree : this.myEditor;
    }

    @Nullable
    Collection<String> getPathNames() {
        return this.myTreeView == null ? null : this.myTreeView.getPathNames(this.myFilter.myContext.getCurrentConfigurable());
    }

    public void addOptionsListener(OptionsEditorColleague colleague) {
        this.myFilter.myContext.addColleague(colleague);
    }

    void updateStatus(Configurable configurable2) {
        this.myFilter.updateSpotlight(configurable2 == null);
        if (this.myBanner != null) {
            this.myBanner.setProject(this.myTreeView.findConfigurableProject(configurable2));
            this.myBanner.setText(this.myTreeView.getPathNames(configurable2));
        }
        if (this.myEditor != null) {
            ConfigurationException exception = this.myFilter.myContext.getErrors().get(configurable2);
            this.myEditor.getApplyAction().setEnabled(!this.myFilter.myContext.getModified().isEmpty());
            this.myEditor.getResetAction().setEnabled(this.myFilter.myContext.isModified(configurable2) || exception != null);
            this.myEditor.setError(exception);
            this.myEditor.revalidate();
        }
        if (configurable2 != null) {
            new Alarm().addRequest(() -> {
                if (!this.myDisposed && this.mySpotlightPainter != null) {
                    this.mySpotlightPainter.updateNow();
                }
            }, 300);
        }
    }

    void updateController(Configurable configurable2) {
        ConfigurableController controller;
        if (this.myLastController != null) {
            this.myLastController.setBanner(null);
            this.myLastController = null;
        }
        if ((controller = ConfigurableController.getOrCreate(configurable2, this.myControllers)) != null) {
            this.myLastController = controller;
            controller.setBanner(this.myBanner);
        }
    }

    void checkModified(Configurable configurable2) {
        Configurable parent = this.myFilter.myContext.getParentConfigurable(configurable2);
        if (ConfigurableWrapper.hasOwnContent((UnnamedConfigurable)parent)) {
            this.checkModifiedForItem(parent);
            for (Configurable child2 : this.myFilter.myContext.getChildren(parent)) {
                this.checkModifiedForItem(child2);
            }
        } else if (configurable2 != null) {
            this.checkModifiedForItem(configurable2);
        }
        this.updateStatus(configurable2);
    }

    private void checkModifiedForItem(Configurable configurable2) {
        if (configurable2 != null) {
            JComponent component = this.myEditor.getContent(configurable2);
            if (component == null && ConfigurableWrapper.hasOwnContent((UnnamedConfigurable)configurable2)) {
                component = this.myEditor.readContent(configurable2);
            }
            if (component != null) {
                this.checkModifiedInternal(configurable2);
            }
        }
    }

    private void checkModifiedInternal(Configurable configurable2) {
        if (configurable2.isModified()) {
            this.myFilter.myContext.fireModifiedAdded(configurable2, null);
        } else if (!this.myFilter.myContext.getErrors().containsKey(configurable2)) {
            this.myFilter.myContext.fireModifiedRemoved(configurable2, null);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groups";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/options/newEditor/SettingsEditor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getData";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

