/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.softwrap.mapping;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.SoftWrap;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.SoftWrapModelImpl;
import org.jetbrains.annotations.NotNull;

public class IncrementalCacheUpdateEvent {
    private final int myStartOffset;
    private final int myMandatoryEndOffset;
    private int myActualEndOffset;
    private final int myLengthDiff;
    @NotNull
    private final LogicalPosition myStartLogicalPosition;

    IncrementalCacheUpdateEvent(@NotNull DocumentEvent event, @NotNull EditorImpl editor) {
        if (event == null) {
            IncrementalCacheUpdateEvent.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            IncrementalCacheUpdateEvent.$$$reportNull$$$0(1);
        }
        this(event.getOffset(), event.getOffset() + event.getOldLength(), event.getOffset() + event.getNewLength(), editor);
    }

    IncrementalCacheUpdateEvent(int startOffset, int endOffset, @NotNull EditorImpl editor) {
        if (editor == null) {
            IncrementalCacheUpdateEvent.$$$reportNull$$$0(2);
        }
        this(startOffset, endOffset, endOffset, editor);
    }

    IncrementalCacheUpdateEvent(@NotNull Document document) {
        if (document == null) {
            IncrementalCacheUpdateEvent.$$$reportNull$$$0(3);
        }
        this.myActualEndOffset = -1;
        this.myStartOffset = 0;
        this.myMandatoryEndOffset = document.getTextLength();
        this.myLengthDiff = 0;
        this.myStartLogicalPosition = new LogicalPosition(0, 0);
    }

    private IncrementalCacheUpdateEvent(int startOffset, int oldEndOffset, int newEndOffset, @NotNull EditorImpl editor) {
        if (editor == null) {
            IncrementalCacheUpdateEvent.$$$reportNull$$$0(4);
        }
        this.myActualEndOffset = -1;
        VisualLineInfo info = IncrementalCacheUpdateEvent.getVisualLineInfo(editor, startOffset, false);
        if (info.startsWithSoftWrap) {
            info = IncrementalCacheUpdateEvent.getVisualLineInfo(editor, info.startOffset, true);
        }
        this.myStartOffset = info.startOffset;
        this.myStartLogicalPosition = editor.offsetToLogicalPosition(this.myStartOffset);
        this.myMandatoryEndOffset = newEndOffset;
        this.myLengthDiff = newEndOffset - oldEndOffset;
    }

    private static VisualLineInfo getVisualLineInfo(@NotNull EditorImpl editor, int offset, boolean beforeSoftWrap) {
        if (editor == null) {
            IncrementalCacheUpdateEvent.$$$reportNull$$$0(5);
        }
        DocumentEx document = editor.getDocument();
        int textLength = document.getTextLength();
        if (offset <= 0 || textLength == 0) {
            return new VisualLineInfo(0, false);
        }
        offset = Math.min(offset, textLength);
        int startOffset = EditorUtil.getNotFoldedLineStartOffset(editor, offset);
        SoftWrapModelImpl softWrapModel = editor.getSoftWrapModel();
        int wrapIndex = softWrapModel.getSoftWrapIndex(offset);
        int prevSoftWrapIndex = wrapIndex < 0 ? -wrapIndex - 2 : wrapIndex - (beforeSoftWrap ? 1 : 0);
        SoftWrap prevSoftWrap = prevSoftWrapIndex < 0 ? null : softWrapModel.getRegisteredSoftWraps().get(prevSoftWrapIndex);
        int visualLineStartOffset = prevSoftWrap == null ? startOffset : Math.max(startOffset, prevSoftWrap.getStart());
        return new VisualLineInfo(visualLineStartOffset, prevSoftWrap != null && prevSoftWrap.getStart() == visualLineStartOffset);
    }

    public int getStartOffset() {
        return this.myStartOffset;
    }

    @NotNull
    LogicalPosition getStartLogicalPosition() {
        LogicalPosition logicalPosition = this.myStartLogicalPosition;
        if (logicalPosition == null) {
            IncrementalCacheUpdateEvent.$$$reportNull$$$0(6);
        }
        return logicalPosition;
    }

    public int getMandatoryEndOffset() {
        return this.myMandatoryEndOffset;
    }

    public int getActualEndOffset() {
        return this.myActualEndOffset;
    }

    public void setActualEndOffset(int actualEndOffset) {
        this.myActualEndOffset = actualEndOffset;
    }

    public int getLengthDiff() {
        return this.myLengthDiff;
    }

    public String toString() {
        return "startOffset=" + this.myStartOffset + ", mandatoryEndOffset=" + this.myMandatoryEndOffset + ", actualEndOffset=" + this.myActualEndOffset + ", lengthDiff=" + this.myLengthDiff + ", startLogicalPosition=" + this.myStartLogicalPosition;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/softwrap/mapping/IncrementalCacheUpdateEvent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/softwrap/mapping/IncrementalCacheUpdateEvent";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getStartLogicalPosition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getVisualLineInfo";
                break;
            }
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class VisualLineInfo {
        private final int startOffset;
        private final boolean startsWithSoftWrap;

        private VisualLineInfo(int startOffset, boolean wrap) {
            this.startOffset = startOffset;
            this.startsWithSoftWrap = wrap;
        }
    }
}

