/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCopyPasteHelper;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.SelectionEvent;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SelectionModelImpl
implements SelectionModel {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.editor.impl.SelectionModelImpl");
    private final List<SelectionListener> mySelectionListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private final EditorImpl myEditor;
    private TextAttributes myTextAttributes;

    public SelectionModelImpl(EditorImpl editor) {
        this.myEditor = editor;
    }

    public boolean isUnknownDirection() {
        return this.myEditor.getCaretModel().getCurrentCaret().isUnknownDirection();
    }

    public void setUnknownDirection(boolean unknownDirection) {
        this.myEditor.getCaretModel().getCurrentCaret().setUnknownDirection(unknownDirection);
    }

    public int getSelectionStart() {
        return this.myEditor.getCaretModel().getCurrentCaret().getSelectionStart();
    }

    @NotNull
    public VisualPosition getSelectionStartPosition() {
        VisualPosition visualPosition = this.myEditor.getCaretModel().getCurrentCaret().getSelectionStartPosition();
        if (visualPosition == null) {
            SelectionModelImpl.$$$reportNull$$$0(0);
        }
        return visualPosition;
    }

    public int getSelectionEnd() {
        return this.myEditor.getCaretModel().getCurrentCaret().getSelectionEnd();
    }

    @NotNull
    public VisualPosition getSelectionEndPosition() {
        VisualPosition visualPosition = this.myEditor.getCaretModel().getCurrentCaret().getSelectionEndPosition();
        if (visualPosition == null) {
            SelectionModelImpl.$$$reportNull$$$0(1);
        }
        return visualPosition;
    }

    public boolean hasSelection() {
        return this.hasSelection(false);
    }

    public boolean hasSelection(boolean anyCaret) {
        if (!anyCaret) {
            return this.myEditor.getCaretModel().getCurrentCaret().hasSelection();
        }
        for (Caret caret : this.myEditor.getCaretModel().getAllCarets()) {
            if (!caret.hasSelection()) continue;
            return true;
        }
        return false;
    }

    public void setSelection(int startOffset, int endOffset) {
        this.myEditor.getCaretModel().getCurrentCaret().setSelection(startOffset, endOffset);
    }

    public void setSelection(int startOffset, @Nullable VisualPosition endPosition, int endOffset) {
        this.myEditor.getCaretModel().getCurrentCaret().setSelection(startOffset, endPosition, endOffset);
    }

    public void setSelection(@Nullable VisualPosition startPosition, int startOffset, @Nullable VisualPosition endPosition, int endOffset) {
        this.myEditor.getCaretModel().getCurrentCaret().setSelection(startPosition, startOffset, endPosition, endOffset);
    }

    void fireSelectionChanged(SelectionEvent event) {
        TextRange[] oldRanges = event.getOldRanges();
        TextRange[] newRanges = event.getNewRanges();
        int count = Math.min(oldRanges.length, newRanges.length);
        for (int i = 0; i < count; ++i) {
            TextRange oldRange = oldRanges[i];
            TextRange newRange = newRanges[i];
            int oldSelectionStart = oldRange.getStartOffset();
            int startOffset = newRange.getStartOffset();
            int oldSelectionEnd = oldRange.getEndOffset();
            int endOffset = newRange.getEndOffset();
            this.myEditor.repaint(Math.min(oldSelectionStart, startOffset), Math.max(oldSelectionStart, startOffset), false);
            this.myEditor.repaint(Math.min(oldSelectionEnd, endOffset), Math.max(oldSelectionEnd, endOffset), false);
        }
        TextRange[] remaining = oldRanges.length < newRanges.length ? newRanges : oldRanges;
        for (int i = count; i < remaining.length; ++i) {
            TextRange range2 = remaining[i];
            this.myEditor.repaint(range2.getStartOffset(), range2.getEndOffset(), false);
        }
        this.broadcastSelectionEvent(event);
    }

    private void broadcastSelectionEvent(SelectionEvent event) {
        for (SelectionListener listener2 : this.mySelectionListeners) {
            try {
                listener2.selectionChanged(event);
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
    }

    public void removeSelection() {
        this.removeSelection(false);
    }

    public void removeSelection(boolean allCarets) {
        if (!allCarets) {
            this.myEditor.getCaretModel().getCurrentCaret().removeSelection();
        } else {
            for (Caret caret : this.myEditor.getCaretModel().getAllCarets()) {
                caret.removeSelection();
            }
        }
    }

    public void setBlockSelection(@NotNull LogicalPosition blockStart, @NotNull LogicalPosition blockEnd) {
        if (blockStart == null) {
            SelectionModelImpl.$$$reportNull$$$0(2);
        }
        if (blockEnd == null) {
            SelectionModelImpl.$$$reportNull$$$0(3);
        }
        List caretStates = EditorModificationUtil.calcBlockSelectionState((Editor)this.myEditor, (LogicalPosition)blockStart, (LogicalPosition)blockEnd);
        this.myEditor.getCaretModel().setCaretsAndSelections(caretStates);
    }

    @NotNull
    public int[] getBlockSelectionStarts() {
        List<Caret> carets = this.myEditor.getCaretModel().getAllCarets();
        int[] result2 = new int[carets.size()];
        int i = 0;
        for (Caret caret : carets) {
            result2[i++] = caret.getSelectionStart();
        }
        if (result2 == null) {
            SelectionModelImpl.$$$reportNull$$$0(4);
        }
        return result2;
    }

    @NotNull
    public int[] getBlockSelectionEnds() {
        List<Caret> carets = this.myEditor.getCaretModel().getAllCarets();
        int[] result2 = new int[carets.size()];
        int i = 0;
        for (Caret caret : carets) {
            result2[i++] = caret.getSelectionEnd();
        }
        if (result2 == null) {
            SelectionModelImpl.$$$reportNull$$$0(5);
        }
        return result2;
    }

    public void addSelectionListener(@NotNull SelectionListener listener2) {
        if (listener2 == null) {
            SelectionModelImpl.$$$reportNull$$$0(6);
        }
        this.mySelectionListeners.add(listener2);
    }

    public void removeSelectionListener(@NotNull SelectionListener listener2) {
        if (listener2 == null) {
            SelectionModelImpl.$$$reportNull$$$0(7);
        }
        boolean success = this.mySelectionListeners.remove(listener2);
        LOG.assertTrue(success);
    }

    public String getSelectedText() {
        return this.getSelectedText(false);
    }

    public String getSelectedText(boolean allCarets) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (this.myEditor.getCaretModel().supportsMultipleCarets() && allCarets) {
            StringBuilder buf = new StringBuilder();
            String separator = "";
            for (Caret caret : this.myEditor.getCaretModel().getAllCarets()) {
                buf.append(separator);
                String caretSelectedText = caret.getSelectedText();
                if (caretSelectedText != null) {
                    buf.append(caretSelectedText);
                }
                separator = "\n";
            }
            return buf.toString();
        }
        return this.myEditor.getCaretModel().getCurrentCaret().getSelectedText();
    }

    public static void doSelectLineAtCaret(Caret caret) {
        int lineNumber = caret.getLogicalPosition().line;
        Editor editor = caret.getEditor();
        Document document = editor.getDocument();
        if (lineNumber >= document.getLineCount()) {
            return;
        }
        Pair<LogicalPosition, LogicalPosition> lines = EditorUtil.calcCaretLineRange(caret);
        LogicalPosition lineStart = (LogicalPosition)lines.first;
        LogicalPosition nextLineStart = (LogicalPosition)lines.second;
        int start2 = editor.logicalPositionToOffset(lineStart);
        int end = editor.logicalPositionToOffset(nextLineStart);
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        caret.removeSelection();
        caret.setSelection(start2, end);
    }

    public int getLeadSelectionOffset() {
        return this.myEditor.getCaretModel().getCurrentCaret().getLeadSelectionOffset();
    }

    @NotNull
    public VisualPosition getLeadSelectionPosition() {
        VisualPosition visualPosition = this.myEditor.getCaretModel().getCurrentCaret().getLeadSelectionPosition();
        if (visualPosition == null) {
            SelectionModelImpl.$$$reportNull$$$0(8);
        }
        return visualPosition;
    }

    public void selectLineAtCaret() {
        this.myEditor.getCaretModel().getCurrentCaret().selectLineAtCaret();
    }

    public void selectWordAtCaret(boolean honorCamelWordsSettings) {
        this.myEditor.getCaretModel().getCurrentCaret().selectWordAtCaret(honorCamelWordsSettings);
    }

    public void copySelectionToClipboard() {
        EditorCopyPasteHelper.getInstance().copySelectionToClipboard((Editor)this.myEditor);
    }

    public TextAttributes getTextAttributes() {
        if (this.myTextAttributes == null) {
            TextAttributes textAttributes = new TextAttributes();
            EditorColorsScheme scheme = this.myEditor.getColorsScheme();
            textAttributes.setForegroundColor(scheme.getColor(EditorColors.SELECTION_FOREGROUND_COLOR));
            textAttributes.setBackgroundColor(scheme.getColor(EditorColors.SELECTION_BACKGROUND_COLOR));
            this.myTextAttributes = textAttributes;
        }
        return this.myTextAttributes;
    }

    public void reinitSettings() {
        this.myTextAttributes = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/SelectionModelImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "blockStart";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "blockEnd";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectionStartPosition";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectionEndPosition";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/SelectionModelImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getBlockSelectionStarts";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getBlockSelectionEnds";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getLeadSelectionPosition";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setBlockSelection";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addSelectionListener";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "removeSelectionListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

