/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.diagnostic.Dumpable;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretAction;
import com.intellij.openapi.editor.CaretActionListener;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.CaretState;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.InlayModel;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.SelectionEvent;
import com.intellij.openapi.editor.ex.PrioritizedDocumentListener;
import com.intellij.openapi.editor.impl.CaretImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.InlineInlayImpl;
import com.intellij.openapi.editor.impl.RangeMarkerTree;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EmptyClipboardOwner;
import gnu.trove.TIntArrayList;
import java.awt.GraphicsEnvironment;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CaretModelImpl
implements CaretModel,
PrioritizedDocumentListener,
Disposable,
Dumpable,
InlayModel.Listener {
    private final EditorImpl myEditor;
    private final EventDispatcher<CaretListener> myCaretListeners;
    private final EventDispatcher<CaretActionListener> myCaretActionListeners;
    private TextAttributes myTextAttributes;
    boolean myIsInUpdate;
    final RangeMarkerTree<CaretImpl.PositionMarker> myPositionMarkerTree;
    final RangeMarkerTree<CaretImpl.SelectionMarker> mySelectionMarkerTree;
    private final LinkedList<CaretImpl> myCarets;
    @NotNull
    private volatile CaretImpl myPrimaryCaret;
    private CaretImpl myCurrentCaret;
    private boolean myPerformCaretMergingAfterCurrentOperation;
    private boolean myVisualPositionUpdateScheduled;
    int myDocumentUpdateCounter;
    private static final Comparator<VisualPosition> VISUAL_POSITION_COMPARATOR = (o1, o2) -> {
        if (o1.line != o2.line) {
            return o1.line - o2.line;
        }
        return o1.column - o2.column;
    };
    private static final Comparator<Caret> CARET_POSITION_COMPARATOR = (o1, o2) -> VISUAL_POSITION_COMPARATOR.compare(o1.getVisualPosition(), o2.getVisualPosition());

    public CaretModelImpl(@NotNull EditorImpl editor) {
        if (editor == null) {
            CaretModelImpl.$$$reportNull$$$0(0);
        }
        this.myCaretListeners = EventDispatcher.create(CaretListener.class);
        this.myCaretActionListeners = EventDispatcher.create(CaretActionListener.class);
        this.myCarets = new LinkedList();
        this.myEditor = editor;
        this.myEditor.addPropertyChangeListener(evt -> {
            if ("columnMode".equals(evt.getPropertyName()) && !this.myEditor.isColumnMode()) {
                for (CaretImpl caret : this.myCarets) {
                    caret.resetVirtualSelection();
                }
            }
        }, this);
        this.myPositionMarkerTree = new RangeMarkerTree(this.myEditor.getDocument());
        this.mySelectionMarkerTree = new RangeMarkerTree(this.myEditor.getDocument());
        this.myPrimaryCaret = new CaretImpl(this.myEditor, this);
        this.myCarets.add(this.myPrimaryCaret);
    }

    void onBulkDocumentUpdateStarted() {
    }

    void onBulkDocumentUpdateFinished() {
        this.doWithCaretMerging(() -> {});
    }

    public void documentChanged(@NotNull DocumentEvent e) {
        if (e == null) {
            CaretModelImpl.$$$reportNull$$$0(1);
        }
        this.myIsInUpdate = false;
        ++this.myDocumentUpdateCounter;
        if (!this.myEditor.getDocument().isInBulkUpdate()) {
            this.doWithCaretMerging(() -> {});
            if (this.myVisualPositionUpdateScheduled) {
                this.updateVisualPosition();
            }
        }
    }

    public void beforeDocumentChange(@NotNull DocumentEvent e) {
        if (e == null) {
            CaretModelImpl.$$$reportNull$$$0(2);
        }
        if (!this.myEditor.getDocument().isInBulkUpdate() && e.isWholeTextReplaced()) {
            for (CaretImpl caret : this.myCarets) {
                caret.updateCachedStateIfNeeded();
            }
        }
        this.myIsInUpdate = true;
        this.myVisualPositionUpdateScheduled = false;
    }

    @Override
    public int getPriority() {
        return 120;
    }

    public void dispose() {
        for (CaretImpl caret : this.myCarets) {
            Disposer.dispose((Disposable)caret);
        }
        this.mySelectionMarkerTree.dispose(this.myEditor.getDocument());
        this.myPositionMarkerTree.dispose(this.myEditor.getDocument());
    }

    public void updateVisualPosition() {
        for (CaretImpl caret : this.myCarets) {
            caret.updateVisualPosition();
        }
    }

    public void moveCaretRelatively(int columnShift, int lineShift, boolean withSelection, boolean blockSelection, boolean scrollToCaret) {
        this.getCurrentCaret().moveCaretRelatively(columnShift, lineShift, withSelection, scrollToCaret);
    }

    public void moveToLogicalPosition(@NotNull LogicalPosition pos) {
        if (pos == null) {
            CaretModelImpl.$$$reportNull$$$0(3);
        }
        this.getCurrentCaret().moveToLogicalPosition(pos);
    }

    public void moveToVisualPosition(@NotNull VisualPosition pos) {
        if (pos == null) {
            CaretModelImpl.$$$reportNull$$$0(4);
        }
        this.getCurrentCaret().moveToVisualPosition(pos);
    }

    public void moveToOffset(int offset) {
        this.getCurrentCaret().moveToOffset(offset);
    }

    public void moveToOffset(int offset, boolean locateBeforeSoftWrap) {
        this.getCurrentCaret().moveToOffset(offset, locateBeforeSoftWrap);
    }

    public boolean isUpToDate() {
        return this.getCurrentCaret().isUpToDate();
    }

    @NotNull
    public LogicalPosition getLogicalPosition() {
        LogicalPosition logicalPosition = this.getCurrentCaret().getLogicalPosition();
        if (logicalPosition == null) {
            CaretModelImpl.$$$reportNull$$$0(5);
        }
        return logicalPosition;
    }

    @NotNull
    public VisualPosition getVisualPosition() {
        VisualPosition visualPosition = this.getCurrentCaret().getVisualPosition();
        if (visualPosition == null) {
            CaretModelImpl.$$$reportNull$$$0(6);
        }
        return visualPosition;
    }

    public int getOffset() {
        return this.getCurrentCaret().getOffset();
    }

    public int getVisualLineStart() {
        return this.getCurrentCaret().getVisualLineStart();
    }

    public int getVisualLineEnd() {
        return this.getCurrentCaret().getVisualLineEnd();
    }

    int getWordAtCaretStart() {
        return this.getCurrentCaret().getWordAtCaretStart();
    }

    int getWordAtCaretEnd() {
        return this.getCurrentCaret().getWordAtCaretEnd();
    }

    public void addCaretListener(@NotNull CaretListener listener2) {
        if (listener2 == null) {
            CaretModelImpl.$$$reportNull$$$0(7);
        }
        this.myCaretListeners.addListener((EventListener)listener2);
    }

    public void removeCaretListener(@NotNull CaretListener listener2) {
        if (listener2 == null) {
            CaretModelImpl.$$$reportNull$$$0(8);
        }
        this.myCaretListeners.removeListener((EventListener)listener2);
    }

    @NotNull
    public TextAttributes getTextAttributes() {
        TextAttributes textAttributes = this.myTextAttributes;
        if (textAttributes == null) {
            this.myTextAttributes = textAttributes = new TextAttributes();
            if (this.myEditor.getSettings().isCaretRowShown()) {
                textAttributes.setBackgroundColor(this.myEditor.getColorsScheme().getColor(EditorColors.CARET_ROW_COLOR));
            }
        }
        TextAttributes textAttributes2 = textAttributes;
        if (textAttributes2 == null) {
            CaretModelImpl.$$$reportNull$$$0(9);
        }
        return textAttributes2;
    }

    public void reinitSettings() {
        this.myTextAttributes = null;
    }

    public boolean supportsMultipleCarets() {
        return true;
    }

    @NotNull
    public CaretImpl getCurrentCaret() {
        CaretImpl currentCaret = this.myCurrentCaret;
        CaretImpl caretImpl = ApplicationManager.getApplication().isDispatchThread() && currentCaret != null ? currentCaret : this.getPrimaryCaret();
        if (caretImpl == null) {
            CaretModelImpl.$$$reportNull$$$0(10);
        }
        return caretImpl;
    }

    @NotNull
    public CaretImpl getPrimaryCaret() {
        CaretImpl caretImpl = this.myPrimaryCaret;
        if (caretImpl == null) {
            CaretModelImpl.$$$reportNull$$$0(11);
        }
        return caretImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCaretCount() {
        LinkedList<CaretImpl> linkedList = this.myCarets;
        synchronized (linkedList) {
            return this.myCarets.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<Caret> getAllCarets() {
        ArrayList<Caret> carets;
        LinkedList<CaretImpl> linkedList = this.myCarets;
        synchronized (linkedList) {
            carets = new ArrayList<Caret>(this.myCarets);
        }
        Collections.sort(carets, CARET_POSITION_COMPARATOR);
        ArrayList<Caret> arrayList = carets;
        if (arrayList == null) {
            CaretModelImpl.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Caret getCaretAt(@NotNull VisualPosition pos) {
        if (pos == null) {
            CaretModelImpl.$$$reportNull$$$0(13);
        }
        LinkedList<CaretImpl> linkedList = this.myCarets;
        synchronized (linkedList) {
            for (CaretImpl caret : this.myCarets) {
                if (!caret.getVisualPosition().equals((Object)pos)) continue;
                return caret;
            }
            return null;
        }
    }

    @Nullable
    public Caret addCaret(@NotNull VisualPosition pos) {
        if (pos == null) {
            CaretModelImpl.$$$reportNull$$$0(14);
        }
        return this.addCaret(pos, true);
    }

    @Nullable
    public Caret addCaret(@NotNull VisualPosition pos, boolean makePrimary) {
        if (pos == null) {
            CaretModelImpl.$$$reportNull$$$0(15);
        }
        EditorImpl.assertIsDispatchThread();
        CaretImpl caret = new CaretImpl(this.myEditor, this);
        caret.doMoveToVisualPosition(pos, false);
        if (this.addCaret(caret, makePrimary)) {
            return caret;
        }
        Disposer.dispose((Disposable)caret);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean addCaret(@NotNull CaretImpl caretToAdd, boolean makePrimary) {
        if (caretToAdd == null) {
            CaretModelImpl.$$$reportNull$$$0(16);
        }
        EditorImpl.assertIsDispatchThread();
        for (CaretImpl caret : this.myCarets) {
            if (!CaretModelImpl.caretsOverlap(caret, caretToAdd)) continue;
            return false;
        }
        LinkedList<CaretImpl> linkedList = this.myCarets;
        synchronized (linkedList) {
            if (makePrimary) {
                this.myCarets.addLast(caretToAdd);
                this.myPrimaryCaret = caretToAdd;
            } else {
                this.myCarets.addFirst(caretToAdd);
            }
        }
        this.fireCaretAdded(caretToAdd);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeCaret(@NotNull Caret caret) {
        if (caret == null) {
            CaretModelImpl.$$$reportNull$$$0(17);
        }
        EditorImpl.assertIsDispatchThread();
        if (this.myCarets.size() <= 1 || !(caret instanceof CaretImpl)) {
            return false;
        }
        LinkedList<CaretImpl> linkedList = this.myCarets;
        synchronized (linkedList) {
            if (!this.myCarets.remove(caret)) {
                return false;
            }
            this.myPrimaryCaret = this.myCarets.getLast();
        }
        this.fireCaretRemoved(caret);
        Disposer.dispose((Disposable)caret);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSecondaryCarets() {
        EditorImpl.assertIsDispatchThread();
        ListIterator<CaretImpl> caretIterator = this.myCarets.listIterator(this.myCarets.size() - 1);
        while (caretIterator.hasPrevious()) {
            CaretImpl caret = caretIterator.previous();
            LinkedList<CaretImpl> linkedList = this.myCarets;
            synchronized (linkedList) {
                caretIterator.remove();
            }
            this.fireCaretRemoved(caret);
            Disposer.dispose((Disposable)caret);
        }
    }

    public void runForEachCaret(@NotNull CaretAction action2) {
        if (action2 == null) {
            CaretModelImpl.$$$reportNull$$$0(18);
        }
        this.runForEachCaret(action2, false);
    }

    public void runForEachCaret(@NotNull CaretAction action2, boolean reverseOrder) {
        if (action2 == null) {
            CaretModelImpl.$$$reportNull$$$0(19);
        }
        EditorImpl.assertIsDispatchThread();
        if (this.myCurrentCaret != null) {
            throw new IllegalStateException("Recursive runForEachCaret invocations are not allowed");
        }
        ((CaretActionListener)this.myCaretActionListeners.getMulticaster()).beforeAllCaretsAction();
        this.doWithCaretMerging(() -> {
            try {
                List<Caret> sortedCarets = this.getAllCarets();
                if (reverseOrder) {
                    Collections.reverse(sortedCarets);
                }
                for (Caret caret : sortedCarets) {
                    this.myCurrentCaret = (CaretImpl)caret;
                    action2.perform(caret);
                }
            }
            finally {
                this.myCurrentCaret = null;
            }
        });
        ((CaretActionListener)this.myCaretActionListeners.getMulticaster()).afterAllCaretsAction();
    }

    public void addCaretActionListener(@NotNull CaretActionListener listener2, @NotNull Disposable disposable) {
        if (listener2 == null) {
            CaretModelImpl.$$$reportNull$$$0(20);
        }
        if (disposable == null) {
            CaretModelImpl.$$$reportNull$$$0(21);
        }
        this.myCaretActionListeners.addListener((EventListener)listener2, disposable);
    }

    public void runBatchCaretOperation(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            CaretModelImpl.$$$reportNull$$$0(22);
        }
        EditorImpl.assertIsDispatchThread();
        this.doWithCaretMerging(runnable2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeOverlappingCaretsAndSelections() {
        EditorImpl.assertIsDispatchThread();
        if (this.myCarets.size() <= 1) {
            return;
        }
        LinkedList<CaretImpl> carets = new LinkedList<CaretImpl>(this.myCarets);
        Collections.sort(carets, CARET_POSITION_COMPARATOR);
        ListIterator it = carets.listIterator();
        CaretImpl keepPrimary = this.getPrimaryCaret();
        while (it.hasNext()) {
            CaretImpl toRemove2;
            CaretImpl toRetain;
            CaretImpl prevCaret = null;
            if (it.hasPrevious()) {
                prevCaret = (CaretImpl)((Object)it.previous());
                it.next();
            }
            CaretImpl currCaret = (CaretImpl)((Object)it.next());
            if (prevCaret == null || !CaretModelImpl.caretsOverlap(currCaret, prevCaret)) continue;
            int newSelectionStart = Math.min(currCaret.getSelectionStart(), prevCaret.getSelectionStart());
            int newSelectionEnd = Math.max(currCaret.getSelectionEnd(), prevCaret.getSelectionEnd());
            if (currCaret.getOffset() >= prevCaret.getSelectionStart() && currCaret.getOffset() <= prevCaret.getSelectionEnd()) {
                toRetain = prevCaret;
                toRemove2 = currCaret;
                it.remove();
                it.previous();
            } else {
                toRetain = currCaret;
                toRemove2 = prevCaret;
                it.previous();
                it.previous();
                it.remove();
            }
            if (toRemove2 == keepPrimary) {
                keepPrimary = toRetain;
            }
            this.removeCaret(toRemove2);
            if (newSelectionStart >= newSelectionEnd) continue;
            toRetain.setSelection(newSelectionStart, newSelectionEnd);
        }
        if (keepPrimary != this.getPrimaryCaret()) {
            LinkedList<CaretImpl> linkedList = this.myCarets;
            synchronized (linkedList) {
                this.myCarets.remove((Object)keepPrimary);
                this.myCarets.add(keepPrimary);
                this.myPrimaryCaret = keepPrimary;
            }
        }
    }

    private static boolean caretsOverlap(@NotNull CaretImpl firstCaret, @NotNull CaretImpl secondCaret) {
        if (firstCaret == null) {
            CaretModelImpl.$$$reportNull$$$0(23);
        }
        if (secondCaret == null) {
            CaretModelImpl.$$$reportNull$$$0(24);
        }
        if (firstCaret.getVisualPosition().equals((Object)secondCaret.getVisualPosition())) {
            return true;
        }
        int firstStart = firstCaret.getSelectionStart();
        int secondStart = secondCaret.getSelectionStart();
        int firstEnd = firstCaret.getSelectionEnd();
        int secondEnd = secondCaret.getSelectionEnd();
        return firstStart < secondStart && firstEnd > secondStart || firstStart > secondStart && firstStart < secondEnd || firstStart == secondStart && secondEnd != secondStart && firstEnd > firstStart || (CaretModelImpl.hasPureVirtualSelection(firstCaret) || CaretModelImpl.hasPureVirtualSelection(secondCaret)) && (firstStart == secondStart || firstEnd == secondEnd);
    }

    private static boolean hasPureVirtualSelection(@NotNull CaretImpl firstCaret) {
        if (firstCaret == null) {
            CaretModelImpl.$$$reportNull$$$0(25);
        }
        return firstCaret.getSelectionStart() == firstCaret.getSelectionEnd() && firstCaret.hasVirtualSelection();
    }

    void doWithCaretMerging(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            CaretModelImpl.$$$reportNull$$$0(26);
        }
        EditorImpl.assertIsDispatchThread();
        if (this.myPerformCaretMergingAfterCurrentOperation) {
            runnable2.run();
        } else {
            this.myPerformCaretMergingAfterCurrentOperation = true;
            try {
                runnable2.run();
                this.mergeOverlappingCaretsAndSelections();
            }
            finally {
                this.myPerformCaretMergingAfterCurrentOperation = false;
            }
        }
    }

    public void setCaretsAndSelections(@NotNull List<? extends CaretState> caretStates) {
        if (caretStates == null) {
            CaretModelImpl.$$$reportNull$$$0(27);
        }
        this.setCaretsAndSelections(caretStates, true);
    }

    public void setCaretsAndSelections(@NotNull List<? extends CaretState> caretStates, boolean updateSystemSelection) {
        if (caretStates == null) {
            CaretModelImpl.$$$reportNull$$$0(28);
        }
        EditorImpl.assertIsDispatchThread();
        if (caretStates.isEmpty()) {
            throw new IllegalArgumentException("At least one caret should exist");
        }
        this.doWithCaretMerging(() -> {
            CaretImpl caret;
            int index = 0;
            int oldCaretCount = this.myCarets.size();
            Iterator caretIterator = this.myCarets.iterator();
            TIntArrayList selectionStartsBefore = null;
            TIntArrayList selectionStartsAfter = null;
            TIntArrayList selectionEndsBefore = null;
            TIntArrayList selectionEndsAfter = null;
            for (CaretState caretState : caretStates) {
                if (index++ < oldCaretCount) {
                    caret = (CaretImpl)((Object)((Object)caretIterator.next()));
                    if (caretState != null && caretState.getCaretPosition() != null) {
                        caret.moveToLogicalPosition(caretState.getCaretPosition());
                    }
                } else {
                    caret = new CaretImpl(this.myEditor, this);
                    if (caretState != null && caretState.getCaretPosition() != null) {
                        caret.moveToLogicalPosition(caretState.getCaretPosition(), false, null, false, false);
                    }
                    LinkedList<CaretImpl> linkedList = this.myCarets;
                    synchronized (linkedList) {
                        this.myCarets.add(caret);
                        this.myPrimaryCaret = caret;
                    }
                    this.fireCaretAdded(caret);
                }
                if (caretState != null && caretState.getCaretPosition() != null && caretState.getVisualColumnAdjustment() != 0) {
                    caret.myVisualColumnAdjustment = caretState.getVisualColumnAdjustment();
                    caret.updateVisualPosition();
                }
                if (caretState == null || caretState.getSelectionStart() == null || caretState.getSelectionEnd() == null) continue;
                if (selectionStartsBefore == null) {
                    int capacity = caretStates.size();
                    selectionStartsBefore = new TIntArrayList(capacity);
                    selectionStartsAfter = new TIntArrayList(capacity);
                    selectionEndsBefore = new TIntArrayList(capacity);
                    selectionEndsAfter = new TIntArrayList(capacity);
                }
                selectionStartsBefore.add(caret.getSelectionStart());
                selectionEndsBefore.add(caret.getSelectionEnd());
                caret.doSetSelection(this.myEditor.logicalToVisualPosition(caretState.getSelectionStart()), this.myEditor.logicalPositionToOffset(caretState.getSelectionStart()), this.myEditor.logicalToVisualPosition(caretState.getSelectionEnd()), this.myEditor.logicalPositionToOffset(caretState.getSelectionEnd()), true, false, false);
                selectionStartsAfter.add(caret.getSelectionStart());
                selectionEndsAfter.add(caret.getSelectionEnd());
            }
            int caretsToRemove = this.myCarets.size() - caretStates.size();
            for (int i = 0; i < caretsToRemove; ++i) {
                LinkedList<CaretImpl> linkedList = this.myCarets;
                synchronized (linkedList) {
                    caret = this.myCarets.removeLast();
                    this.myPrimaryCaret = this.myCarets.getLast();
                }
                this.fireCaretRemoved(caret);
                Disposer.dispose((Disposable)caret);
            }
            if (updateSystemSelection) {
                this.updateSystemSelection();
            }
            if (selectionStartsBefore != null) {
                SelectionEvent event = new SelectionEvent((Editor)this.myEditor, selectionStartsBefore.toNativeArray(), selectionEndsBefore.toNativeArray(), selectionStartsAfter.toNativeArray(), selectionEndsAfter.toNativeArray());
                this.myEditor.getSelectionModel().fireSelectionChanged(event);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public List<CaretState> getCaretsAndSelections() {
        LinkedList<CaretImpl> linkedList = this.myCarets;
        // MONITORENTER : linkedList
        ArrayList<CaretState> states = new ArrayList<CaretState>(this.myCarets.size());
        Iterator iterator = this.myCarets.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                ArrayList<CaretState> arrayList = states;
                // MONITOREXIT : linkedList
                if (arrayList != null) return arrayList;
                CaretModelImpl.$$$reportNull$$$0(29);
                return arrayList;
            }
            CaretImpl caret = (CaretImpl)((Object)iterator.next());
            states.add(new CaretState(caret.getLogicalPosition(), caret.myVisualColumnAdjustment, caret.getSelectionStartLogicalPosition(), caret.getSelectionEndLogicalPosition()));
        }
    }

    void updateSystemSelection() {
        if (GraphicsEnvironment.isHeadless()) {
            return;
        }
        Clipboard clip = this.myEditor.getComponent().getToolkit().getSystemSelection();
        if (clip != null) {
            clip.setContents(new StringSelection(this.myEditor.getSelectionModel().getSelectedText(true)), (ClipboardOwner)EmptyClipboardOwner.INSTANCE);
        }
    }

    void fireCaretPositionChanged(@NotNull CaretEvent caretEvent) {
        if (caretEvent == null) {
            CaretModelImpl.$$$reportNull$$$0(30);
        }
        ((CaretListener)this.myCaretListeners.getMulticaster()).caretPositionChanged(caretEvent);
    }

    private void fireCaretAdded(@NotNull Caret caret) {
        if (caret == null) {
            CaretModelImpl.$$$reportNull$$$0(31);
        }
        ((CaretListener)this.myCaretListeners.getMulticaster()).caretAdded(new CaretEvent(caret, caret.getLogicalPosition(), caret.getLogicalPosition()));
    }

    private void fireCaretRemoved(@NotNull Caret caret) {
        if (caret == null) {
            CaretModelImpl.$$$reportNull$$$0(32);
        }
        ((CaretListener)this.myCaretListeners.getMulticaster()).caretRemoved(new CaretEvent(caret, caret.getLogicalPosition(), caret.getLogicalPosition()));
    }

    public boolean isIteratingOverCarets() {
        return this.myCurrentCaret != null;
    }

    @NotNull
    public String dumpState() {
        String string = "[in update: " + this.myIsInUpdate + ", update counter: " + this.myDocumentUpdateCounter + ", perform caret merging: " + this.myPerformCaretMergingAfterCurrentOperation + ", current caret: " + (Object)((Object)this.myCurrentCaret) + ", all carets: " + ContainerUtil.map(this.myCarets, CaretImpl::dumpState) + "]";
        if (string == null) {
            CaretModelImpl.$$$reportNull$$$0(33);
        }
        return string;
    }

    public void onAdded(@NotNull Inlay inlay) {
        if (inlay == null) {
            CaretModelImpl.$$$reportNull$$$0(34);
        }
        if (this.myEditor.getDocument().isInBulkUpdate()) {
            return;
        }
        Inlay.Placement placement = inlay.getPlacement();
        if (placement == Inlay.Placement.INLINE) {
            int offset = inlay.getOffset();
            for (CaretImpl caret : this.myCarets) {
                caret.onInlayAdded(offset);
            }
        } else if (placement != Inlay.Placement.AFTER_LINE_END || this.hasCaretInVirtualSpace()) {
            this.updateVisualPosition();
        }
    }

    public void onRemoved(@NotNull Inlay inlay) {
        if (inlay == null) {
            CaretModelImpl.$$$reportNull$$$0(35);
        }
        if (this.myEditor.getDocument().isInBulkUpdate()) {
            return;
        }
        Inlay.Placement placement = inlay.getPlacement();
        if (this.myEditor.getDocument().isInEventsHandling()) {
            if (placement == Inlay.Placement.AFTER_LINE_END) {
                this.myVisualPositionUpdateScheduled = true;
            }
            return;
        }
        if (placement == Inlay.Placement.INLINE) {
            this.doWithCaretMerging(() -> {
                for (CaretImpl caret : this.myCarets) {
                    caret.onInlayRemoved(inlay.getOffset(), ((InlineInlayImpl)inlay).getOrder());
                }
            });
        } else if (placement != Inlay.Placement.AFTER_LINE_END || this.hasCaretInVirtualSpace()) {
            this.updateVisualPosition();
        }
    }

    public void onUpdated(@NotNull Inlay inlay) {
        if (inlay == null) {
            CaretModelImpl.$$$reportNull$$$0(36);
        }
        if (this.myEditor.getDocument().isInBulkUpdate()) {
            return;
        }
        if (inlay.getPlacement() != Inlay.Placement.AFTER_LINE_END || this.hasCaretInVirtualSpace()) {
            this.updateVisualPosition();
        }
    }

    private boolean hasCaretInVirtualSpace() {
        return this.myEditor.getSettings().isVirtualSpace() && ContainerUtil.exists(this.myCarets, CaretImpl::isInVirtualSpace);
    }

    public void validateState() {
        for (CaretImpl caret : this.myCarets) {
            caret.validateState();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 29: 
            case 33: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 29: 
            case 33: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: 
            case 4: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pos";
                break;
            }
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 29: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/CaretModelImpl";
                break;
            }
            case 7: 
            case 8: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caretToAdd";
                break;
            }
            case 17: 
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caret";
                break;
            }
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 22: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstCaret";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "secondCaret";
                break;
            }
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caretStates";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caretEvent";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inlay";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/CaretModelImpl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogicalPosition";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisualPosition";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextAttributes";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentCaret";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrimaryCaret";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllCarets";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getCaretsAndSelections";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "dumpState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "documentChanged";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "beforeDocumentChange";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "moveToLogicalPosition";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "moveToVisualPosition";
                break;
            }
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 29: 
            case 33: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addCaretListener";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "removeCaretListener";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getCaretAt";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addCaret";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "removeCaret";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "runForEachCaret";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "addCaretActionListener";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "runBatchCaretOperation";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "caretsOverlap";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "hasPureVirtualSelection";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "doWithCaretMerging";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "setCaretsAndSelections";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "fireCaretPositionChanged";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "fireCaretAdded";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "fireCaretRemoved";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "onAdded";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "onRemoved";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "onUpdated";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 29: 
            case 33: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

