/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application.impl;

import com.intellij.BundleBase;
import com.intellij.CommonBundle;
import com.intellij.concurrency.JobScheduler;
import com.intellij.configurationStore.StoreUtil;
import com.intellij.diagnostic.Activity;
import com.intellij.diagnostic.LoadingPhase;
import com.intellij.diagnostic.ParallelActivity;
import com.intellij.diagnostic.PerformanceWatcher;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.diagnostic.ThreadDumper;
import com.intellij.execution.process.ProcessIOExecutorService;
import com.intellij.featureStatistics.fusCollectors.LifecycleUsageTriggerCollector;
import com.intellij.ide.ActivityTracker;
import com.intellij.ide.AppLifecycleListener;
import com.intellij.ide.ApplicationActivationStateManager;
import com.intellij.ide.ApplicationInitializedListener;
import com.intellij.ide.ApplicationLoadListener;
import com.intellij.ide.GeneralSettings;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.SaveAndSyncHandler;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.idea.Main;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ModalityInvokator;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionGuardImpl;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationUtil;
import com.intellij.openapi.application.impl.AWTExceptionHandler;
import com.intellij.openapi.application.impl.AnyModalityState;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.application.impl.ModalityInvokatorImpl;
import com.intellij.openapi.application.impl.ModalityStateEx;
import com.intellij.openapi.application.impl.NoSwingUnderWriteAction;
import com.intellij.openapi.application.impl.ReadMostlyRWLock;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServiceDescriptor;
import com.intellij.openapi.components.ServiceKt;
import com.intellij.openapi.components.impl.PlatformComponentManagerImpl;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.RuntimeExceptionWithAttachments;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.impl.ExtensionsAreaImpl;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.progress.util.PotemkinProgress;
import com.intellij.openapi.progress.util.ProgressWindow;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Consumer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PausesStat;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.Restarter;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.AppScheduledExecutorService;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import com.intellij.util.io.storage.HeavyProcessLatch;
import com.intellij.util.messages.ListenerDescriptor;
import com.intellij.util.messages.Topic;
import com.intellij.util.messages.impl.MessageBusImpl;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import net.miginfocom.layout.PlatformDefaults;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.picocontainer.MutablePicoContainer;
import sun.awt.AWTAccessor;
import sun.awt.AWTAutoShutdown;

public class ApplicationImpl
extends PlatformComponentManagerImpl
implements ApplicationEx {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.application.impl.ApplicationImpl");
    final ReadMostlyRWLock myLock;
    private final ModalityInvokator myInvokator;
    private final EventDispatcher<ApplicationListener> myDispatcher;
    private final boolean myTestModeFlag;
    private final boolean myHeadlessMode;
    private final boolean myCommandLineMode;
    private final boolean myIsInternal;
    private final String myName;
    private final Stack<Class> myWriteActionsStack;
    private final TransactionGuardImpl myTransactionGuard;
    private int myWriteStackBase;
    private final long myStartTime;
    private boolean mySaveAllowed;
    private volatile boolean myExitInProgress;
    private volatile boolean myDisposeInProgress;
    private final Disposable myLastDisposable;
    private static final int ourDumpThreadsOnLongWriteActionWaiting = Integer.getInteger("dump.threads.on.long.write.action.waiting", 0);
    private final ExecutorService ourThreadExecutorsService;
    private boolean myLoaded;
    private static final String WAS_EVER_SHOWN = "was.ever.shown";
    private volatile boolean myWriteActionPending;
    private final boolean gatherStatistics;

    public ApplicationImpl(boolean isInternal, boolean isUnitTestMode, boolean isHeadless, boolean isCommandLine, @NotNull String appName) {
        if (appName == null) {
            ApplicationImpl.$$$reportNull$$$0(0);
        }
        super(null);
        this.myInvokator = new ModalityInvokatorImpl();
        this.myDispatcher = EventDispatcher.create(ApplicationListener.class);
        this.myWriteActionsStack = new Stack();
        this.myTransactionGuard = new TransactionGuardImpl();
        this.myStartTime = System.currentTimeMillis();
        this.myLastDisposable = Disposer.newDisposable();
        this.ourThreadExecutorsService = AppExecutorUtil.getAppExecutorService();
        ApplicationManager.setApplication((Application)this, (Disposable)this.myLastDisposable);
        this.getPicoContainer().registerComponentInstance(Application.class, (Object)this);
        this.getPicoContainer().registerComponentInstance((Object)TransactionGuard.class.getName(), (Object)this.myTransactionGuard);
        boolean strictMode = isUnitTestMode || isInternal;
        BundleBase.assertOnMissedKeys((boolean)strictMode);
        AWTExceptionHandler.register();
        Disposer.setDebugMode((isInternal || isUnitTestMode || Disposer.isDebugDisposerOn() ? 1 : 0) != 0);
        this.myName = appName;
        this.myIsInternal = isInternal;
        this.myTestModeFlag = isUnitTestMode;
        this.myHeadlessMode = isHeadless;
        this.myCommandLineMode = isCommandLine;
        boolean bl = this.mySaveAllowed = !isUnitTestMode && !isHeadless;
        if (!isUnitTestMode && !isHeadless) {
            Disposer.register((Disposable)this, (Disposable)Disposer.newDisposable(), (String)"ui");
        }
        this.gatherStatistics = LOG.isDebugEnabled() || this.isUnitTestMode() || this.isInternal();
        Activity activity = StartUpMeasurer.start((String)"instantiate AppDelayQueue");
        this.myLock = new ReadMostlyRWLock((Thread)UIUtil.invokeAndWaitIfNeeded(() -> {
            AppScheduledExecutorService service = (AppScheduledExecutorService)AppExecutorUtil.getAppScheduledExecutorService();
            Thread thread = service.getPeriodicTasksThread();
            AWTAutoShutdown.getInstance().notifyThreadBusy(thread);
            Disposer.register((Disposable)this, () -> AWTAutoShutdown.getInstance().notifyThreadFree(thread));
            return Thread.currentThread();
        }));
        activity.end();
        NoSwingUnderWriteAction.watchForEvents(this);
    }

    public static void patchSystem() {
        LOG.info("CPU cores: " + Runtime.getRuntime().availableProcessors() + "; ForkJoinPool.commonPool: " + ForkJoinPool.commonPool() + "; factory: " + ForkJoinPool.commonPool().getFactory());
        IdeEventQueue.getInstance();
    }

    public static void registerMessageBusListeners(@NotNull Application app, @NotNull List<IdeaPluginDescriptor> pluginDescriptors, boolean isUnitTestMode) {
        if (app == null) {
            ApplicationImpl.$$$reportNull$$$0(1);
        }
        if (pluginDescriptors == null) {
            ApplicationImpl.$$$reportNull$$$0(2);
        }
        ConcurrentMap map2 = ContainerUtil.newConcurrentMap();
        for (IdeaPluginDescriptor descriptor2 : pluginDescriptors) {
            List<ListenerDescriptor> listeners = ((IdeaPluginDescriptorImpl)descriptor2).getListeners();
            if (listeners.isEmpty()) continue;
            for (ListenerDescriptor listener2 : listeners) {
                if (isUnitTestMode && !listener2.activeInTestMode) continue;
                List list2 = (List)map2.get(listener2.topicClassName);
                if (list2 == null) {
                    list2 = new SmartList();
                    map2.put(listener2.topicClassName, list2);
                }
                list2.add(listener2);
            }
        }
        ((MessageBusImpl)app.getMessageBus()).setLazyListeners(map2);
    }

    @Override
    public void executeByImpatientReader(@NotNull Runnable runnable2) throws ApplicationUtil.CannotRunReadActionException {
        if (runnable2 == null) {
            ApplicationImpl.$$$reportNull$$$0(3);
        }
        if (this.isDispatchThread()) {
            runnable2.run();
        } else {
            this.myLock.executeByImpatientReader(runnable2);
        }
    }

    @Override
    public boolean isInImpatientReader() {
        return this.myLock.isInImpatientReader();
    }

    private boolean disposeSelf(boolean checkCanCloseProject) {
        ProjectManagerEx manager = ProjectManagerEx.getInstanceEx();
        SaveAndSyncHandler.getInstance().saveSettingsUnderModalProgress((ComponentManager)this, false);
        if (manager != null) {
            boolean[] canClose = new boolean[]{true};
            try {
                CommandProcessor.getInstance().executeCommand(null, () -> {
                    if (!manager.closeAndDisposeAllProjects(checkCanCloseProject)) {
                        canClose[0] = false;
                    }
                }, ApplicationBundle.message((String)"command.exit", (Object[])new Object[0]), null);
            }
            catch (Throwable e) {
                LOG.error(e);
            }
            if (!canClose[0]) {
                return false;
            }
        }
        this.runWriteAction(() -> Disposer.dispose((Disposable)this));
        Disposer.assertIsEmpty();
        return true;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            ApplicationImpl.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    public boolean holdsReadLock() {
        return this.myLock.isReadLockedByThisThread();
    }

    @Override
    @NotNull
    protected MutablePicoContainer createPicoContainer() {
        MutablePicoContainer mutablePicoContainer = Extensions.getRootArea().getPicoContainer();
        if (mutablePicoContainer == null) {
            ApplicationImpl.$$$reportNull$$$0(5);
        }
        return mutablePicoContainer;
    }

    public boolean isInternal() {
        return this.myIsInternal;
    }

    public boolean isEAP() {
        return ApplicationInfoImpl.getShadowInstance().isEAP();
    }

    public boolean isUnitTestMode() {
        return this.myTestModeFlag;
    }

    public boolean isHeadlessEnvironment() {
        return this.myHeadlessMode;
    }

    public boolean isCommandLine() {
        return this.myCommandLineMode;
    }

    @NotNull
    public Future<?> executeOnPooledThread(final @NotNull Runnable action2) {
        if (action2 == null) {
            ApplicationImpl.$$$reportNull$$$0(6);
        }
        final ReadMostlyRWLock.SuspensionId suspensionId = this.myLock.currentReadPrivilege();
        Future<?> future2 = this.ourThreadExecutorsService.submit(new Runnable(){

            public String toString() {
                return action2.toString();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try (AccessToken ignored2 = ApplicationImpl.this.myLock.applyReadPrivilege(suspensionId);){
                    action2.run();
                }
                catch (ProcessCanceledException ignored2) {
                }
                catch (Throwable e) {
                    LOG.error(e);
                }
                finally {
                    Thread.interrupted();
                }
            }
        });
        if (future2 == null) {
            ApplicationImpl.$$$reportNull$$$0(7);
        }
        return future2;
    }

    @NotNull
    public <T> Future<T> executeOnPooledThread(final @NotNull Callable<T> action2) {
        if (action2 == null) {
            ApplicationImpl.$$$reportNull$$$0(8);
        }
        final ReadMostlyRWLock.SuspensionId suspensionId = this.myLock.currentReadPrivilege();
        Future future2 = this.ourThreadExecutorsService.submit(new Callable<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            @Override
            public T call() {
                Object v;
                Throwable throwable;
                AccessToken ignored2222;
                block19: {
                    block20: {
                        ignored2222 = ApplicationImpl.this.myLock.applyReadPrivilege(suspensionId);
                        throwable = null;
                        v = action2.call();
                        if (ignored2222 == null) break block19;
                        if (throwable == null) break block20;
                        try {
                            ignored2222.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        break block19;
                    }
                    ignored2222.close();
                }
                Thread.interrupted();
                return v;
                {
                    catch (Throwable throwable3) {
                        try {
                            try {
                                throwable = throwable3;
                                throw throwable3;
                            }
                            catch (Throwable throwable4) {
                                if (ignored2222 != null) {
                                    if (throwable != null) {
                                        try {
                                            ignored2222.close();
                                        }
                                        catch (Throwable throwable5) {
                                            throwable.addSuppressed(throwable5);
                                        }
                                    } else {
                                        ignored2222.close();
                                    }
                                }
                                throw throwable4;
                            }
                        }
                        catch (ProcessCanceledException ignored2222) {
                            Thread.interrupted();
                        }
                        catch (Throwable e) {
                            try {
                                LOG.error(e);
                            }
                            catch (Throwable throwable6) {
                                throw throwable6;
                            }
                            finally {
                                Thread.interrupted();
                            }
                        }
                    }
                }
                return null;
            }

            public String toString() {
                return action2.toString();
            }
        });
        if (future2 == null) {
            ApplicationImpl.$$$reportNull$$$0(9);
        }
        return future2;
    }

    public boolean isDispatchThread() {
        return this.myLock.isWriteThread();
    }

    @NotNull
    public ModalityInvokator getInvokator() {
        ModalityInvokator modalityInvokator = this.myInvokator;
        if (modalityInvokator == null) {
            ApplicationImpl.$$$reportNull$$$0(10);
        }
        return modalityInvokator;
    }

    public void invokeLater(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            ApplicationImpl.$$$reportNull$$$0(11);
        }
        this.invokeLater(runnable2, this.getDisposed());
    }

    public void invokeLater(@NotNull Runnable runnable2, @NotNull Condition expired) {
        if (runnable2 == null) {
            ApplicationImpl.$$$reportNull$$$0(12);
        }
        if (expired == null) {
            ApplicationImpl.$$$reportNull$$$0(13);
        }
        this.invokeLater(runnable2, ModalityState.defaultModalityState(), expired);
    }

    public void invokeLater(@NotNull Runnable runnable2, @NotNull ModalityState state) {
        if (runnable2 == null) {
            ApplicationImpl.$$$reportNull$$$0(14);
        }
        if (state == null) {
            ApplicationImpl.$$$reportNull$$$0(15);
        }
        this.invokeLater(runnable2, state, this.getDisposed());
    }

    public void invokeLater(@NotNull Runnable runnable2, @NotNull ModalityState state, @NotNull Condition expired) {
        if (runnable2 == null) {
            ApplicationImpl.$$$reportNull$$$0(16);
        }
        if (state == null) {
            ApplicationImpl.$$$reportNull$$$0(17);
        }
        if (expired == null) {
            ApplicationImpl.$$$reportNull$$$0(18);
        }
        LaterInvocator.invokeLaterWithCallback(this.myTransactionGuard.wrapLaterInvocation(runnable2, state), state, expired, null);
    }

    @Override
    public void load(@Nullable String configPath) {
        this.registerComponents(PluginManagerCore.getLoadedPlugins());
        this.load(configPath, null);
    }

    @Override
    public void registerComponents(@NotNull List<? extends IdeaPluginDescriptor> plugins2) {
        if (plugins2 == null) {
            ApplicationImpl.$$$reportNull$$$0(19);
        }
        super.registerComponents(plugins2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(@Nullable String configPath, @Nullable ProgressIndicator indicator) {
        AccessToken token = HeavyProcessLatch.INSTANCE.processStarted("Loading application components");
        try {
            ApplicationInitializedListener listener3;
            if (!this.isHeadlessEnvironment()) {
                AppExecutorUtil.getAppExecutorService().submit(() -> PlatformDefaults.setLogicalPixelBase((int)100));
            }
            Activity componentRegisteredActivity = StartUpMeasurer.start((String)(this.activityNamePrefix() + "component registered callback"));
            String effectiveConfigPath = FileUtilRt.toSystemIndependentName((String)(configPath == null ? PathManager.getConfigPath() : configPath));
            ApplicationLoadListener.EP_NAME.forEachExtensionSafe(listener2 -> listener2.beforeApplicationLoaded(this, effectiveConfigPath));
            ServiceKt.getStateStore(this).setPath(effectiveConfigPath);
            LoadingPhase.setCurrentPhase((LoadingPhase)LoadingPhase.CONFIGURATION_STORE_INITIALIZED);
            ApplicationLoadListener.EP_NAME.forEachExtensionSafe(listener2 -> listener2.beforeComponentsCreated());
            componentRegisteredActivity.end();
            if (indicator == null) {
                this.createComponents(null);
            } else {
                ProgressManager.getInstance().runProcess(() -> this.createComponents(indicator), indicator);
            }
            this.ourThreadExecutorsService.submit(() -> ApplicationImpl.createLocatorFile());
            Activity activity = StartUpMeasurer.start((String)"app initialized callback");
            Iterator iterator = ((ExtensionsAreaImpl)Extensions.getArea(null)).getExtensionPoint("com.intellij.applicationInitializedListener").iterator();
            while (iterator.hasNext() && (listener3 = (ApplicationInitializedListener)iterator.next()) != null) {
                try {
                    listener3.componentsInitialized();
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Throwable e) {
                    LOG.error(e);
                }
            }
            activity.end();
        }
        finally {
            token.finish();
        }
        this.myLoaded = true;
    }

    @Override
    @Nullable
    protected ProgressIndicator getProgressIndicator() {
        ProgressManager progressManager = (ProgressManager)this.getPicoContainer().getComponentInstance((Object)ProgressManager.class.getName());
        return progressManager == null ? null : progressManager.getProgressIndicator();
    }

    private static void createLocatorFile() {
        Path locatorFile = Paths.get(PathManager.getSystemPath(), ".home");
        try {
            Files.write(locatorFile, PathManager.getHomePath().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            LOG.warn("can't store a location in '" + locatorFile + "'", (Throwable)e);
        }
    }

    @Override
    public boolean isLoaded() {
        return this.myLoaded;
    }

    @Override
    public void dispose() {
        this.fireApplicationExiting();
        ShutDownTracker.getInstance().ensureStopperThreadsFinished();
        this.disposeComponents();
        AppScheduledExecutorService service = (AppScheduledExecutorService)AppExecutorUtil.getAppScheduledExecutorService();
        service.shutdownAppScheduledExecutorService();
        super.dispose();
        Disposer.dispose((Disposable)this.myLastDisposable);
        if (this.gatherStatistics) {
            LOG.info(this.writeActionStatistics());
            LOG.info(ActionUtil.ActionPauses.STAT.statistics());
            LOG.info(((AppScheduledExecutorService)AppExecutorUtil.getAppScheduledExecutorService()).statistics() + "; ProcessIOExecutorService threads: " + ((ProcessIOExecutorService)ProcessIOExecutorService.INSTANCE).getThreadCounter());
        }
    }

    @NotNull
    public String writeActionStatistics() {
        String string = ActionPauses.WRITE.statistics();
        if (string == null) {
            ApplicationImpl.$$$reportNull$$$0(20);
        }
        return string;
    }

    @Override
    public boolean runProcessWithProgressSynchronously(@NotNull Runnable process2, @NotNull String progressTitle, boolean canBeCanceled, Project project) {
        if (process2 == null) {
            ApplicationImpl.$$$reportNull$$$0(21);
        }
        if (progressTitle == null) {
            ApplicationImpl.$$$reportNull$$$0(22);
        }
        return this.runProcessWithProgressSynchronously(process2, progressTitle, canBeCanceled, project, null);
    }

    @Override
    public boolean runProcessWithProgressSynchronously(@NotNull Runnable process2, @NotNull String progressTitle, boolean canBeCanceled, @Nullable Project project, JComponent parentComponent) {
        if (process2 == null) {
            ApplicationImpl.$$$reportNull$$$0(23);
        }
        if (progressTitle == null) {
            ApplicationImpl.$$$reportNull$$$0(24);
        }
        return this.runProcessWithProgressSynchronously(process2, progressTitle, canBeCanceled, project, parentComponent, null);
    }

    @Override
    public boolean runProcessWithProgressSynchronously(@NotNull Runnable process2, @NotNull String progressTitle, boolean canBeCanceled, @Nullable Project project, JComponent parentComponent, String cancelText) {
        if (process2 == null) {
            ApplicationImpl.$$$reportNull$$$0(25);
        }
        if (progressTitle == null) {
            ApplicationImpl.$$$reportNull$$$0(26);
        }
        this.assertIsDispatchThread();
        boolean writeAccessAllowed = this.isWriteAccessAllowed();
        if (writeAccessAllowed || this.isHeadlessEnvironment() && !this.isUnitTestMode()) {
            if (writeAccessAllowed) {
                LOG.debug("Starting process with progress from within write action makes no sense");
            }
            try {
                ProgressManager.getInstance().runProcess(process2, (ProgressIndicator)new EmptyProgressIndicator());
            }
            catch (ProcessCanceledException e) {
                return false;
            }
            return true;
        }
        ProgressWindow progress = new ProgressWindow(canBeCanceled, false, project, parentComponent, cancelText);
        Disposer.register((Disposable)this, (Disposable)progress);
        progress.setTitle(progressTitle);
        AtomicBoolean threadStarted = new AtomicBoolean();
        SwingUtilities.invokeLater(() -> {
            this.executeOnPooledThread(() -> {
                try {
                    ProgressManager.getInstance().runProcess(process2, (ProgressIndicator)progress);
                }
                catch (ProcessCanceledException e) {
                    progress.cancel();
                }
                catch (RuntimeException e) {
                    progress.cancel();
                    throw e;
                }
            });
            threadStarted.set(true);
        });
        progress.startBlocking();
        LOG.assertTrue(threadStarted.get());
        LOG.assertTrue(!progress.isRunning());
        return !progress.isCanceled();
    }

    @Override
    public boolean runProcessWithProgressSynchronouslyInReadAction(@Nullable Project project, @NotNull String progressTitle, boolean canBeCanceled, String cancelText, JComponent parentComponent, @NotNull Runnable process2) {
        if (progressTitle == null) {
            ApplicationImpl.$$$reportNull$$$0(27);
        }
        if (process2 == null) {
            ApplicationImpl.$$$reportNull$$$0(28);
        }
        this.assertIsDispatchThread();
        boolean writeAccessAllowed = this.isWriteAccessAllowed();
        if (writeAccessAllowed) {
            throw new IncorrectOperationException("Starting process with progress from within write action makes no sense");
        }
        ProgressWindow progress = new ProgressWindow(canBeCanceled, false, project, parentComponent, cancelText);
        Disposer.register((Disposable)this, (Disposable)progress);
        progress.setTitle(progressTitle);
        Semaphore readActionAcquired = new Semaphore();
        readActionAcquired.down();
        Semaphore modalityEntered = new Semaphore();
        modalityEntered.down();
        this.executeOnPooledThread(() -> {
            try {
                ApplicationManager.getApplication().runReadAction(() -> {
                    readActionAcquired.up();
                    modalityEntered.waitFor();
                    ProgressManager.getInstance().runProcess(process2, (ProgressIndicator)progress);
                });
            }
            catch (ProcessCanceledException e) {
                progress.cancel();
            }
            catch (RuntimeException e) {
                progress.cancel();
                throw e;
            }
        });
        readActionAcquired.waitFor();
        progress.startBlocking(() -> ((Semaphore)modalityEntered).up());
        LOG.assertTrue(!progress.isRunning());
        return !progress.isCanceled();
    }

    public void invokeAndWait(@NotNull Runnable runnable2, @NotNull ModalityState modalityState) {
        if (runnable2 == null) {
            ApplicationImpl.$$$reportNull$$$0(29);
        }
        if (modalityState == null) {
            ApplicationImpl.$$$reportNull$$$0(30);
        }
        if (this.isDispatchThread()) {
            runnable2.run();
            return;
        }
        if (this.holdsReadLock()) {
            throw new IllegalStateException("Calling invokeAndWait from read-action leads to possible deadlock.");
        }
        LaterInvocator.invokeAndWait(this.myTransactionGuard.wrapLaterInvocation(runnable2, modalityState), modalityState);
    }

    public void invokeAndWait(@NotNull Runnable runnable2) throws ProcessCanceledException {
        if (runnable2 == null) {
            ApplicationImpl.$$$reportNull$$$0(31);
        }
        this.invokeAndWait(runnable2, ModalityState.defaultModalityState());
    }

    @NotNull
    public ModalityState getCurrentModalityState() {
        ModalityStateEx modalityStateEx = LaterInvocator.getCurrentModalityState();
        if (modalityStateEx == null) {
            ApplicationImpl.$$$reportNull$$$0(32);
        }
        return modalityStateEx;
    }

    @NotNull
    public ModalityState getModalityStateForComponent(@NotNull Component c2) {
        Window window;
        if (c2 == null) {
            ApplicationImpl.$$$reportNull$$$0(33);
        }
        if (!this.isDispatchThread()) {
            LOG.debug("please, use application dispatch thread to get a modality state");
        }
        if ((window = UIUtil.getWindow((Component)c2)) == null) {
            ModalityState modalityState = this.getNoneModalityState();
            if (modalityState == null) {
                ApplicationImpl.$$$reportNull$$$0(34);
            }
            return modalityState;
        }
        ModalityStateEx modalityStateEx = LaterInvocator.modalityStateForWindow(window);
        if (modalityStateEx == null) {
            ApplicationImpl.$$$reportNull$$$0(35);
        }
        return modalityStateEx;
    }

    @NotNull
    public ModalityState getAnyModalityState() {
        AnyModalityState anyModalityState = AnyModalityState.ANY;
        if (anyModalityState == null) {
            ApplicationImpl.$$$reportNull$$$0(36);
        }
        return anyModalityState;
    }

    @NotNull
    public ModalityState getDefaultModalityState() {
        ModalityState modalityState = this.isDispatchThread() ? this.getCurrentModalityState() : CoreProgressManager.getCurrentThreadProgressModality();
        if (modalityState == null) {
            ApplicationImpl.$$$reportNull$$$0(37);
        }
        return modalityState;
    }

    @NotNull
    public ModalityState getNoneModalityState() {
        ModalityState modalityState = ModalityState.NON_MODAL;
        if (modalityState == null) {
            ApplicationImpl.$$$reportNull$$$0(38);
        }
        return modalityState;
    }

    public long getStartTime() {
        return this.myStartTime;
    }

    public long getIdleTime() {
        return IdeEventQueue.getInstance().getIdleTime();
    }

    public void exit() {
        this.exit(false, false);
    }

    @Override
    public void exit(boolean force, boolean exitConfirmed) {
        this.exit(false, exitConfirmed, false);
    }

    public void restart() {
        this.restart(false);
    }

    @Override
    public void restart(boolean exitConfirmed) {
        this.exit(false, exitConfirmed, true);
    }

    public void restart(boolean exitConfirmed, boolean elevate) {
        this.exit(false, exitConfirmed, true, elevate, ArrayUtilRt.EMPTY_STRING_ARRAY);
    }

    public void exit(boolean force, boolean exitConfirmed, boolean restart2) {
        this.exit(force, exitConfirmed, restart2, ArrayUtilRt.EMPTY_STRING_ARRAY);
    }

    public void exit(boolean force, boolean exitConfirmed, boolean restart2, @NotNull String[] beforeRestart) {
        if (beforeRestart == null) {
            ApplicationImpl.$$$reportNull$$$0(39);
        }
        this.exit(force, exitConfirmed, restart2, false, beforeRestart);
    }

    private void exit(boolean force, boolean exitConfirmed, boolean restart2, boolean elevate, @NotNull String[] beforeRestart) {
        if (beforeRestart == null) {
            ApplicationImpl.$$$reportNull$$$0(40);
        }
        if (!force) {
            if (this.myExitInProgress) {
                return;
            }
            if (!exitConfirmed && this.getDefaultModalityState() != ModalityState.NON_MODAL) {
                return;
            }
        }
        this.myExitInProgress = true;
        if (this.isDispatchThread()) {
            this.doExit(force, exitConfirmed, restart2, elevate, beforeRestart);
        } else {
            this.invokeLater(() -> this.doExit(force, exitConfirmed, restart2, elevate, beforeRestart), ModalityState.NON_MODAL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doExit(boolean force, boolean exitConfirmed, boolean restart2, boolean elevate, String[] beforeRestart) {
        try {
            if (!force && !ApplicationImpl.confirmExitIfNeeded(exitConfirmed)) {
                return;
            }
            AppLifecycleListener lifecycleListener = (AppLifecycleListener)this.getMessageBus().syncPublisher(AppLifecycleListener.TOPIC);
            lifecycleListener.appClosing();
            this.myDisposeInProgress = true;
            if (!force && !this.canExit()) {
                return;
            }
            lifecycleListener.appWillBeClosed(restart2);
            LifecycleUsageTriggerCollector.onIdeClose(restart2);
            boolean success = this.disposeSelf(!force);
            if (!success || this.isUnitTestMode() || Boolean.getBoolean("idea.test.guimode")) {
                if (Boolean.getBoolean("idea.test.guimode")) {
                    ApplicationImpl.shutdown();
                }
                return;
            }
            int exitCode = 0;
            if (restart2 && Restarter.isSupported()) {
                try {
                    Restarter.scheduleRestart(elevate, beforeRestart);
                }
                catch (Throwable t) {
                    LOG.error("Restart failed", t);
                    Main.showMessage((String)"Restart failed", (Throwable)t);
                    exitCode = 2;
                }
            }
            System.exit(exitCode);
        }
        finally {
            this.myDisposeInProgress = false;
            this.myExitInProgress = false;
        }
    }

    private static void shutdown() {
        IdeEventQueue.applicationClose();
        ShutDownTracker.getInstance().run();
    }

    private static boolean confirmExitIfNeeded(boolean exitConfirmed) {
        final boolean hasUnsafeBgTasks = ProgressManager.getInstance().hasUnsafeProgressIndicator();
        if (exitConfirmed && !hasUnsafeBgTasks) {
            return true;
        }
        DialogWrapper.DoNotAskOption option = new DialogWrapper.DoNotAskOption(){

            public boolean isToBeShown() {
                return GeneralSettings.getInstance().isConfirmExit() && ProjectManager.getInstance().getOpenProjects().length > 0;
            }

            public void setToBeShown(boolean value, int exitCode) {
                GeneralSettings.getInstance().setConfirmExit(value);
            }

            public boolean canBeHidden() {
                return !hasUnsafeBgTasks;
            }

            public boolean shouldSaveOptionsOnCancel() {
                return false;
            }

            @NotNull
            public String getDoNotShowMessage() {
                if ("Do not ask me again" == null) {
                    3.$$$reportNull$$$0(0);
                }
                return "Do not ask me again";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/impl/ApplicationImpl$3", "getDoNotShowMessage"));
            }
        };
        if (hasUnsafeBgTasks || option.isToBeShown()) {
            final AtomicBoolean alreadyGone = new AtomicBoolean(false);
            if (hasUnsafeBgTasks) {
                final Runnable dialogRemover = Messages.createMessageDialogRemover(null);
                Runnable task2 = new Runnable(){

                    @Override
                    public void run() {
                        if (alreadyGone.get()) {
                            return;
                        }
                        if (!ProgressManager.getInstance().hasUnsafeProgressIndicator()) {
                            alreadyGone.set(true);
                            dialogRemover.run();
                        } else {
                            JobScheduler.getScheduler().schedule(this, 1L, TimeUnit.SECONDS);
                        }
                    }
                };
                JobScheduler.getScheduler().schedule(task2, 1L, TimeUnit.SECONDS);
            }
            String name = ApplicationNamesInfo.getInstance().getFullProductName();
            String message = ApplicationBundle.message((String)(hasUnsafeBgTasks ? "exit.confirm.prompt.tasks" : "exit.confirm.prompt"), (Object[])new Object[]{name});
            int result2 = ((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo((String)ApplicationBundle.message((String)"exit.confirm.title", (Object[])new Object[0]), (String)message).yesText(ApplicationBundle.message((String)"command.exit", (Object[])new Object[0]))).noText(CommonBundle.message((String)"button.cancel", (Object[])new Object[0]))).doNotAsk(option)).show();
            if (alreadyGone.getAndSet(true)) {
                if (!option.isToBeShown()) {
                    return true;
                }
                result2 = ((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo((String)ApplicationBundle.message((String)"exit.confirm.title", (Object[])new Object[0]), (String)ApplicationBundle.message((String)"exit.confirm.prompt", (Object[])new Object[]{name})).yesText(ApplicationBundle.message((String)"command.exit", (Object[])new Object[0]))).noText(CommonBundle.message((String)"button.cancel", (Object[])new Object[0]))).doNotAsk(option)).show();
            }
            if (result2 != 0) {
                return false;
            }
        }
        return true;
    }

    private boolean canExit() {
        Project[] projects;
        for (ApplicationListener applicationListener : this.myDispatcher.getListeners()) {
            if (applicationListener.canExitApplication()) continue;
            return false;
        }
        ProjectManagerEx projectManager = ProjectManagerEx.getInstanceEx();
        for (Project project : projects = projectManager.getOpenProjects()) {
            if (projectManager.canClose(project)) continue;
            return false;
        }
        return true;
    }

    public void runReadAction(@NotNull Runnable action2) {
        if (action2 == null) {
            ApplicationImpl.$$$reportNull$$$0(41);
        }
        if (this.checkReadAccessAllowedAndNoPendingWrites()) {
            action2.run();
        } else {
            this.startRead();
            try {
                action2.run();
            }
            finally {
                this.endRead();
            }
        }
    }

    public <T> T runReadAction(@NotNull Computable<T> computation) {
        if (computation == null) {
            ApplicationImpl.$$$reportNull$$$0(42);
        }
        if (this.checkReadAccessAllowedAndNoPendingWrites()) {
            return (T)computation.compute();
        }
        this.startRead();
        try {
            Object object = computation.compute();
            return (T)object;
        }
        finally {
            this.endRead();
        }
    }

    public <T, E extends Throwable> T runReadAction(@NotNull ThrowableComputable<T, E> computation) throws E {
        if (computation == null) {
            ApplicationImpl.$$$reportNull$$$0(43);
        }
        if (this.checkReadAccessAllowedAndNoPendingWrites()) {
            return (T)computation.compute();
        }
        this.startRead();
        try {
            Object object = computation.compute();
            return (T)object;
        }
        finally {
            this.endRead();
        }
    }

    private void startRead() {
        this.myLock.readLock();
    }

    private void endRead() {
        this.myLock.readUnlock();
    }

    @ApiStatus.Experimental
    public boolean runWriteActionWithNonCancellableProgressInDispatchThread(@NotNull String title, @Nullable Project project, @Nullable JComponent parentComponent, @NotNull Consumer<? super ProgressIndicator> action2) {
        if (title == null) {
            ApplicationImpl.$$$reportNull$$$0(44);
        }
        if (action2 == null) {
            ApplicationImpl.$$$reportNull$$$0(45);
        }
        return this.runEdtProgressWriteAction(title, project, parentComponent, null, action2);
    }

    @ApiStatus.Experimental
    public boolean runWriteActionWithCancellableProgressInDispatchThread(@NotNull String title, @Nullable Project project, @Nullable JComponent parentComponent, @NotNull Consumer<? super ProgressIndicator> action2) {
        if (title == null) {
            ApplicationImpl.$$$reportNull$$$0(46);
        }
        if (action2 == null) {
            ApplicationImpl.$$$reportNull$$$0(47);
        }
        return this.runEdtProgressWriteAction(title, project, parentComponent, IdeBundle.message((String)"action.stop", (Object[])new Object[0]), action2);
    }

    private boolean runEdtProgressWriteAction(@NotNull String title, @Nullable Project project, @Nullable JComponent parentComponent, @Nullable @Nls(capitalization=Nls.Capitalization.Title) String cancelText, @NotNull Consumer<? super ProgressIndicator> action2) {
        if (title == null) {
            ApplicationImpl.$$$reportNull$$$0(48);
        }
        if (action2 == null) {
            ApplicationImpl.$$$reportNull$$$0(49);
        }
        return (Boolean)this.runWriteActionWithClass(action2.getClass(), () -> {
            PotemkinProgress indicator = new PotemkinProgress(title, project, parentComponent, cancelText);
            indicator.runInSwingThread(() -> action2.consume((Object)indicator));
            return !indicator.isCanceled();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T, E extends Throwable> T runWriteActionWithClass(@NotNull Class<?> clazz, @NotNull ThrowableComputable<T, E> computable) throws E {
        if (clazz == null) {
            ApplicationImpl.$$$reportNull$$$0(50);
        }
        if (computable == null) {
            ApplicationImpl.$$$reportNull$$$0(51);
        }
        this.startWrite(clazz);
        try {
            Object object = computable.compute();
            return (T)object;
        }
        finally {
            this.endWrite(clazz);
        }
    }

    public void runWriteAction(@NotNull Runnable action2) {
        if (action2 == null) {
            ApplicationImpl.$$$reportNull$$$0(52);
        }
        Class<?> clazz = action2.getClass();
        this.startWrite(clazz);
        try {
            action2.run();
        }
        finally {
            this.endWrite(clazz);
        }
    }

    public <T> T runWriteAction(@NotNull Computable<T> computation) {
        if (computation == null) {
            ApplicationImpl.$$$reportNull$$$0(53);
        }
        Class<?> clazz = computation.getClass();
        return this.runWriteActionWithClass(clazz, () -> computation.compute());
    }

    public <T, E extends Throwable> T runWriteAction(@NotNull ThrowableComputable<T, E> computation) throws E {
        if (computation == null) {
            ApplicationImpl.$$$reportNull$$$0(54);
        }
        Class<?> clazz = computation.getClass();
        return this.runWriteActionWithClass(clazz, computation);
    }

    public boolean hasWriteAction(@NotNull Class<?> actionClass) {
        if (actionClass == null) {
            ApplicationImpl.$$$reportNull$$$0(55);
        }
        this.assertReadAccessAllowed();
        for (int i = this.myWriteActionsStack.size() - 1; i >= 0; --i) {
            Class action2 = (Class)this.myWriteActionsStack.get(i);
            if (actionClass != action2 && !ReflectionUtil.isAssignable(actionClass, (Class)action2)) continue;
            return true;
        }
        return false;
    }

    public void assertReadAccessAllowed() {
        if (!this.isReadAccessAllowed()) {
            LOG.error("Read access is allowed from event dispatch thread or inside read-action only (see com.intellij.openapi.application.Application.runReadAction())", new String[]{"Current thread: " + ApplicationImpl.describe(Thread.currentThread()), "; dispatch thread: " + EventQueue.isDispatchThread() + "; isDispatchThread(): " + this.isDispatchThread(), "SystemEventQueueThread: " + ApplicationImpl.describe(ApplicationImpl.getEventQueueThread())});
        }
    }

    private static String describe(Thread o) {
        return o == null ? "null" : o + " " + System.identityHashCode(o);
    }

    private static Thread getEventQueueThread() {
        EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        return AWTAccessor.getEventQueueAccessor().getDispatchThread(eventQueue);
    }

    public boolean isReadAccessAllowed() {
        return this.isDispatchThread() || this.myLock.isReadLockedByThisThread();
    }

    private boolean checkReadAccessAllowedAndNoPendingWrites() throws ApplicationUtil.CannotRunReadActionException {
        return this.isDispatchThread() || this.myLock.checkReadLockedByThisThreadAndNoPendingWrites();
    }

    public void assertIsDispatchThread() {
        if (this.isDispatchThread()) {
            return;
        }
        if (ShutDownTracker.isShutdownHookRunning()) {
            return;
        }
        this.assertIsDispatchThread("Access is allowed from event dispatch thread only.");
    }

    private void assertIsDispatchThread(String message) {
        if (this.isDispatchThread()) {
            return;
        }
        throw new RuntimeExceptionWithAttachments(message, "EventQueue.isDispatchThread()=" + EventQueue.isDispatchThread() + " Toolkit.getEventQueue()=" + Toolkit.getDefaultToolkit().getSystemEventQueue() + "\nCurrent thread: " + ApplicationImpl.describe(Thread.currentThread()) + "\nSystemEventQueueThread: " + ApplicationImpl.describe(ApplicationImpl.getEventQueueThread()), new Attachment[]{new Attachment("threadDump.txt", ThreadDumper.dumpThreadsToString())});
    }

    @Override
    public void assertIsDispatchThread(@Nullable JComponent component) {
        if (component == null) {
            return;
        }
        if (this.isDispatchThread()) {
            return;
        }
        if (Boolean.TRUE.equals(component.getClientProperty(WAS_EVER_SHOWN))) {
            this.assertIsDispatchThread();
        } else {
            JRootPane root = component.getRootPane();
            if (root != null) {
                component.putClientProperty(WAS_EVER_SHOWN, Boolean.TRUE);
                this.assertIsDispatchThread();
            }
        }
    }

    @Override
    public void assertTimeConsuming() {
        if (this.myTestModeFlag || this.myHeadlessMode || ShutDownTracker.isShutdownHookRunning()) {
            return;
        }
        LOG.assertTrue(!this.isDispatchThread(), (Object)"This operation is time consuming and must not be called on EDT");
    }

    @Override
    public boolean tryRunReadAction(@NotNull Runnable action2) {
        if (action2 == null) {
            ApplicationImpl.$$$reportNull$$$0(56);
        }
        if (this.checkReadAccessAllowedAndNoPendingWrites()) {
            action2.run();
        } else {
            if (!this.myLock.tryReadLock()) {
                return false;
            }
            try {
                action2.run();
            }
            finally {
                this.endRead();
            }
        }
        return true;
    }

    public boolean isActive() {
        if (this.isHeadlessEnvironment()) {
            return true;
        }
        Window activeWindow = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        if (ApplicationActivationStateManager.getState().isInactive() && activeWindow != null) {
            ApplicationActivationStateManager.updateState(activeWindow);
        }
        return ApplicationActivationStateManager.getState().isActive();
    }

    @NotNull
    public AccessToken acquireReadActionLock() {
        Object object = this.checkReadAccessAllowedAndNoPendingWrites() ? AccessToken.EMPTY_ACCESS_TOKEN : new ReadAccessToken();
        if (object == null) {
            ApplicationImpl.$$$reportNull$$$0(57);
        }
        return object;
    }

    @Override
    public boolean isWriteActionPending() {
        return this.myWriteActionPending;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startWrite(@NotNull Class clazz) {
        if (clazz == null) {
            ApplicationImpl.$$$reportNull$$$0(58);
        }
        if (!this.isWriteAccessAllowed()) {
            this.assertIsDispatchThread("Write access is allowed from event dispatch thread only");
        }
        boolean writeActionPending = this.myWriteActionPending;
        if (this.gatherStatistics && this.myWriteActionsStack.isEmpty() && !writeActionPending) {
            ActionPauses.WRITE.started();
        }
        this.myWriteActionPending = true;
        try {
            ActivityTracker.getInstance().inc();
            this.fireBeforeWriteActionStart(clazz);
            if (!this.myLock.isWriteLocked()) {
                long elapsed;
                ScheduledFuture<?> reportSlowWrite = ourDumpThreadsOnLongWriteActionWaiting <= 0 ? null : JobScheduler.getScheduler().scheduleWithFixedDelay(() -> PerformanceWatcher.getInstance().dumpThreads("waiting", true), ourDumpThreadsOnLongWriteActionWaiting, ourDumpThreadsOnLongWriteActionWaiting, TimeUnit.MILLISECONDS);
                long t = LOG.isDebugEnabled() ? System.currentTimeMillis() : 0L;
                this.myLock.writeLock();
                if (LOG.isDebugEnabled() && (elapsed = System.currentTimeMillis() - t) != 0L) {
                    LOG.debug("Write action wait time: " + elapsed);
                }
                if (reportSlowWrite != null) {
                    reportSlowWrite.cancel(false);
                }
            }
        }
        finally {
            this.myWriteActionPending = writeActionPending;
        }
        this.myWriteActionsStack.push((Object)clazz);
        this.fireWriteActionStarted(clazz);
    }

    private void endWrite(@NotNull Class clazz) {
        if (clazz == null) {
            ApplicationImpl.$$$reportNull$$$0(59);
        }
        try {
            this.fireWriteActionFinished(clazz);
        }
        finally {
            this.myWriteActionsStack.pop();
            if (this.gatherStatistics && this.myWriteActionsStack.isEmpty() && !this.myWriteActionPending) {
                ActionPauses.WRITE.finished("write action (" + clazz + ")");
            }
            if (this.myWriteActionsStack.size() == this.myWriteStackBase) {
                this.myLock.writeUnlock();
            }
            if (this.myWriteActionsStack.isEmpty()) {
                this.fireAfterWriteActionFinished(clazz);
            }
        }
    }

    @NotNull
    public AccessToken acquireWriteActionLock(@NotNull Class clazz) {
        if (clazz == null) {
            ApplicationImpl.$$$reportNull$$$0(60);
        }
        WriteAccessToken writeAccessToken = new WriteAccessToken(clazz);
        if (writeAccessToken == null) {
            ApplicationImpl.$$$reportNull$$$0(61);
        }
        return writeAccessToken;
    }

    public void assertWriteAccessAllowed() {
        LOG.assertTrue(this.isWriteAccessAllowed(), (Object)"Write access is allowed inside write-action only (see com.intellij.openapi.application.Application.runWriteAction())");
    }

    public boolean isWriteAccessAllowed() {
        return this.isDispatchThread() && this.myLock.isWriteLocked();
    }

    @Override
    public boolean isWriteActionInProgress() {
        return this.myLock.isWriteLocked();
    }

    public void executeSuspendingWriteAction(@Nullable Project project, @NotNull String title, @NotNull Runnable runnable2) {
        if (title == null) {
            ApplicationImpl.$$$reportNull$$$0(62);
        }
        if (runnable2 == null) {
            ApplicationImpl.$$$reportNull$$$0(63);
        }
        this.assertIsDispatchThread();
        if (!this.myLock.isWriteLocked()) {
            ApplicationImpl.runModalProgress(project, title, runnable2);
            return;
        }
        this.myTransactionGuard.submitTransactionAndWait(() -> {
            int prevBase = this.myWriteStackBase;
            this.myWriteStackBase = this.myWriteActionsStack.size();
            try (AccessToken ignored = this.myLock.writeSuspend();){
                ApplicationImpl.runModalProgress(project, title, () -> {
                    try (AccessToken ignored1 = this.myLock.grantReadPrivilege();){
                        runnable2.run();
                    }
                });
            }
            finally {
                this.myWriteStackBase = prevBase;
            }
        });
    }

    private static void runModalProgress(@Nullable Project project, @NotNull String title, final @NotNull Runnable runnable2) {
        if (title == null) {
            ApplicationImpl.$$$reportNull$$$0(64);
        }
        if (runnable2 == null) {
            ApplicationImpl.$$$reportNull$$$0(65);
        }
        ProgressManager.getInstance().run((Task)new Task.Modal(project, title, false){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    5.$$$reportNull$$$0(0);
                }
                runnable2.run();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/application/impl/ApplicationImpl$5", "run"));
            }
        });
    }

    public void addApplicationListener(@NotNull ApplicationListener l) {
        if (l == null) {
            ApplicationImpl.$$$reportNull$$$0(66);
        }
        this.myDispatcher.addListener((EventListener)l);
    }

    public void addApplicationListener(@NotNull ApplicationListener l, @NotNull Disposable parent) {
        if (l == null) {
            ApplicationImpl.$$$reportNull$$$0(67);
        }
        if (parent == null) {
            ApplicationImpl.$$$reportNull$$$0(68);
        }
        this.myDispatcher.addListener((EventListener)l, parent);
    }

    public void removeApplicationListener(@NotNull ApplicationListener l) {
        if (l == null) {
            ApplicationImpl.$$$reportNull$$$0(69);
        }
        this.myDispatcher.removeListener((EventListener)l);
    }

    private void fireApplicationExiting() {
        ((ApplicationListener)this.myDispatcher.getMulticaster()).applicationExiting();
    }

    private void fireBeforeWriteActionStart(@NotNull Class action2) {
        if (action2 == null) {
            ApplicationImpl.$$$reportNull$$$0(70);
        }
        ((ApplicationListener)this.myDispatcher.getMulticaster()).beforeWriteActionStart((Object)action2);
    }

    private void fireWriteActionStarted(@NotNull Class action2) {
        if (action2 == null) {
            ApplicationImpl.$$$reportNull$$$0(71);
        }
        ((ApplicationListener)this.myDispatcher.getMulticaster()).writeActionStarted((Object)action2);
    }

    private void fireWriteActionFinished(@NotNull Class action2) {
        if (action2 == null) {
            ApplicationImpl.$$$reportNull$$$0(72);
        }
        ((ApplicationListener)this.myDispatcher.getMulticaster()).writeActionFinished((Object)action2);
    }

    private void fireAfterWriteActionFinished(@NotNull Class action2) {
        if (action2 == null) {
            ApplicationImpl.$$$reportNull$$$0(73);
        }
        ((ApplicationListener)this.myDispatcher.getMulticaster()).afterWriteActionFinished((Object)action2);
    }

    public void saveSettings() {
        if (this.mySaveAllowed) {
            StoreUtil.saveSettings(this, false);
        }
    }

    public void saveAll() {
        StoreUtil.saveDocumentsAndProjectsAndApp(false);
    }

    @Override
    public void setSaveAllowed(boolean value) {
        this.mySaveAllowed = value;
    }

    @Override
    public boolean isSaveAllowed() {
        return this.mySaveAllowed;
    }

    @NotNull
    public <T> T[] getExtensions(@NotNull ExtensionPointName<T> extensionPointName) {
        if (extensionPointName == null) {
            ApplicationImpl.$$$reportNull$$$0(74);
        }
        Object[] objectArray = Extensions.getRootArea().getExtensionPoint(extensionPointName).getExtensions();
        if (objectArray == null) {
            ApplicationImpl.$$$reportNull$$$0(75);
        }
        return objectArray;
    }

    public boolean isDisposeInProgress() {
        return this.myDisposeInProgress || ShutDownTracker.isShutdownHookRunning();
    }

    public boolean isRestartCapable() {
        return Restarter.isSupported();
    }

    public void setDisposeInProgress(boolean disposeInProgress) {
        this.myDisposeInProgress = disposeInProgress;
    }

    public String toString() {
        return "Application" + (this.isDisposed() ? " (Disposed)" : "") + (this.isUnitTestMode() ? " (Unit test)" : "") + (this.isInternal() ? " (Internal)" : "") + (this.isHeadlessEnvironment() ? " (Headless)" : "") + (this.isCommandLine() ? " (Command line)" : "");
    }

    @Override
    @Nullable
    protected String activityNamePrefix() {
        return "app ";
    }

    @Override
    @NotNull
    protected List<ServiceDescriptor> getServices(@NotNull IdeaPluginDescriptor pluginDescriptor) {
        if (pluginDescriptor == null) {
            ApplicationImpl.$$$reportNull$$$0(76);
        }
        List<ServiceDescriptor> list2 = ((IdeaPluginDescriptorImpl)pluginDescriptor).getAppServices();
        if (list2 == null) {
            ApplicationImpl.$$$reportNull$$$0(77);
        }
        return list2;
    }

    @Override
    protected void logMessageBusDelivery(Topic topic, String messageName, Object handler2, long durationNanos) {
        super.logMessageBusDelivery(topic, messageName, handler2, durationNanos);
        if (topic == ProjectManager.TOPIC) {
            ParallelActivity.PROJECT_OPEN_HANDLER.record(StartUpMeasurer.getCurrentTime() - durationNanos, handler2.getClass(), StartUpMeasurer.Level.PROJECT);
        } else if (topic == VirtualFileManager.VFS_CHANGES && TimeUnit.NANOSECONDS.toMillis(durationNanos) > 50L) {
            LOG.info(String.format("LONG VFS PROCESSING. Topic=%s, offender=%s, message=%s, time=%dms", topic.getDisplayName(), handler2.getClass(), messageName, TimeUnit.NANOSECONDS.toMillis(durationNanos)));
        }
    }

    void disableEventsUntil(@NotNull Disposable disposable) {
        if (disposable == null) {
            ApplicationImpl.$$$reportNull$$$0(78);
        }
        this.myDispatcher.neuterMultiCasterWhilePerformanceTestIsRunningUntil(disposable);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 20: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 57: 
            case 61: 
            case 75: 
            case 77: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 20: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 57: 
            case 61: 
            case 75: 
            case 77: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "app";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDescriptors";
                break;
            }
            case 3: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 29: 
            case 31: 
            case 63: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 20: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 57: 
            case 61: 
            case 75: 
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/application/impl/ApplicationImpl";
                break;
            }
            case 6: 
            case 8: 
            case 41: 
            case 45: 
            case 47: 
            case 49: 
            case 52: 
            case 56: 
            case 70: 
            case 71: 
            case 72: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 13: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expired";
                break;
            }
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugins";
                break;
            }
            case 21: 
            case 23: 
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 22: 
            case 24: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressTitle";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modalityState";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 39: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beforeRestart";
                break;
            }
            case 42: 
            case 43: 
            case 53: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computation";
                break;
            }
            case 44: 
            case 46: 
            case 48: 
            case 62: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 50: 
            case 58: 
            case 59: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionClass";
                break;
            }
            case 66: 
            case 67: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "l";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionPointName";
                break;
            }
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDescriptor";
                break;
            }
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/application/impl/ApplicationImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createPicoContainer";
                break;
            }
            case 7: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "executeOnPooledThread";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getInvokator";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "writeActionStatistics";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentModalityState";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getModalityStateForComponent";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnyModalityState";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultModalityState";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getNoneModalityState";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "acquireReadActionLock";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "acquireWriteActionLock";
                break;
            }
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensions";
                break;
            }
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "getServices";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "registerMessageBusListeners";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "executeByImpatientReader";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 20: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 57: 
            case 61: 
            case 75: 
            case 77: {
                break;
            }
            case 6: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "executeOnPooledThread";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "invokeLater";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "registerComponents";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "runProcessWithProgressSynchronously";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "runProcessWithProgressSynchronouslyInReadAction";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "invokeAndWait";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getModalityStateForComponent";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "exit";
                break;
            }
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "runReadAction";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "runWriteActionWithNonCancellableProgressInDispatchThread";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "runWriteActionWithCancellableProgressInDispatchThread";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "runEdtProgressWriteAction";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "runWriteActionWithClass";
                break;
            }
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "runWriteAction";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "hasWriteAction";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "tryRunReadAction";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "startWrite";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "endWrite";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "acquireWriteActionLock";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "executeSuspendingWriteAction";
                break;
            }
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "runModalProgress";
                break;
            }
            case 66: 
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "addApplicationListener";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "removeApplicationListener";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "fireBeforeWriteActionStart";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "fireWriteActionStarted";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "fireWriteActionFinished";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "fireAfterWriteActionFinished";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "getExtensions";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "getServices";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "disableEventsUntil";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 20: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 57: 
            case 61: 
            case 75: 
            case 77: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class ReadAccessToken
    extends AccessToken {
        private ReadAccessToken() {
            ApplicationImpl.this.startRead();
        }

        public void finish() {
            ApplicationImpl.this.endRead();
        }
    }

    private class WriteAccessToken
    extends AccessToken {
        @NotNull
        private final Class clazz;

        WriteAccessToken(Class clazz) {
            if (clazz == null) {
                WriteAccessToken.$$$reportNull$$$0(0);
            }
            this.clazz = clazz;
            ApplicationImpl.this.startWrite(clazz);
            this.markThreadNameInStackTrace();
        }

        public void finish() {
            try {
                ApplicationImpl.this.endWrite(this.clazz);
            }
            finally {
                this.unmarkThreadNameInStackTrace();
            }
        }

        private void markThreadNameInStackTrace() {
            String id = this.id();
            if (id != null) {
                Thread thread = Thread.currentThread();
                thread.setName(thread.getName() + id);
            }
        }

        private void unmarkThreadNameInStackTrace() {
            String id = this.id();
            if (id != null) {
                Thread thread = Thread.currentThread();
                String name = thread.getName();
                name = StringUtil.replace((String)name, (String)id, (String)"");
                thread.setName(name);
            }
        }

        private String id() {
            Class<?> aClass = ((Object)((Object)this)).getClass();
            String name = aClass.getName();
            while (name == null) {
                aClass = aClass.getSuperclass();
                name = aClass.getName();
            }
            name = name.substring(name.lastIndexOf(46) + 1);
            if (!(name = name.substring(name.lastIndexOf(36) + 1)).equals("AccessToken")) {
                return " [" + name + "]";
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/openapi/application/impl/ApplicationImpl$WriteAccessToken", "<init>"));
        }
    }

    private static class ActionPauses {
        private static final PausesStat WRITE = new PausesStat("Write action");

        private ActionPauses() {
        }
    }
}

