/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.impl;

import com.intellij.AbstractBundle;
import com.intellij.CommonBundle;
import com.intellij.diagnostic.PluginException;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.ide.ActivityTracker;
import com.intellij.ide.DataManager;
import com.intellij.ide.actions.ActionsCollector;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.idea.IdeaLogger;
import com.intellij.internal.statistic.collectors.fus.actions.persistence.ActionIdProvider;
import com.intellij.internal.statistic.collectors.fus.actions.persistence.ActionsCollectorImpl;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AbbreviationManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionGroupStub;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.ActionStub;
import com.intellij.openapi.actionSystem.ActionStubBase;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Anchor;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Constraints;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.DefaultCompactActionGroup;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.MouseShortcut;
import com.intellij.openapi.actionSystem.OverridingAction;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.PreloadableAction;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.TimerListener;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.ex.ActionPopupMenuListener;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.actionSystem.impl.AbbreviationManagerImpl;
import com.intellij.openapi.actionSystem.impl.ActionPopupMenuImpl;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.actionSystem.impl.ButtonToolbarImpl;
import com.intellij.openapi.actionSystem.impl.ChameleonAction;
import com.intellij.openapi.actionSystem.impl.PresentationFactory;
import com.intellij.openapi.actionSystem.impl.ProxyShortcutSet;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationActivationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionGuardImpl;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.keymap.ex.KeymapManagerEx;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectType;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.pico.CachingConstructorInjectionComponentAdapter;
import com.intellij.util.ui.UIUtil;
import gnu.trove.THashMap;
import gnu.trove.TObjectIntHashMap;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ActionManagerImpl
extends ActionManagerEx
implements Disposable {
    private static final String ACTION_ELEMENT_NAME = "action";
    private static final String GROUP_ELEMENT_NAME = "group";
    private static final String CLASS_ATTR_NAME = "class";
    private static final String ID_ATTR_NAME = "id";
    private static final String INTERNAL_ATTR_NAME = "internal";
    private static final String ICON_ATTR_NAME = "icon";
    private static final String ADD_TO_GROUP_ELEMENT_NAME = "add-to-group";
    private static final String SHORTCUT_ELEMENT_NAME = "keyboard-shortcut";
    private static final String MOUSE_SHORTCUT_ELEMENT_NAME = "mouse-shortcut";
    private static final String DESCRIPTION = "description";
    private static final String TEXT_ATTR_NAME = "text";
    private static final String POPUP_ATTR_NAME = "popup";
    private static final String COMPACT_ATTR_NAME = "compact";
    private static final String SEPARATOR_ELEMENT_NAME = "separator";
    private static final String REFERENCE_ELEMENT_NAME = "reference";
    private static final String ABBREVIATION_ELEMENT_NAME = "abbreviation";
    private static final String GROUPID_ATTR_NAME = "group-id";
    private static final String ANCHOR_ELEMENT_NAME = "anchor";
    private static final String FIRST = "first";
    private static final String LAST = "last";
    private static final String BEFORE = "before";
    private static final String AFTER = "after";
    private static final String SECONDARY = "secondary";
    private static final String RELATIVE_TO_ACTION_ATTR_NAME = "relative-to-action";
    private static final String FIRST_KEYSTROKE_ATTR_NAME = "first-keystroke";
    private static final String SECOND_KEYSTROKE_ATTR_NAME = "second-keystroke";
    private static final String REMOVE_SHORTCUT_ATTR_NAME = "remove";
    private static final String REPLACE_SHORTCUT_ATTR_NAME = "replace-all";
    private static final String KEYMAP_ATTR_NAME = "keymap";
    private static final String KEYSTROKE_ATTR_NAME = "keystroke";
    private static final String REF_ATTR_NAME = "ref";
    private static final String VALUE_ATTR_NAME = "value";
    private static final String ACTIONS_BUNDLE = "messages.ActionsBundle";
    private static final String USE_SHORTCUT_OF_ATTR_NAME = "use-shortcut-of";
    private static final String OVERRIDES_ATTR_NAME = "overrides";
    private static final String KEEP_CONTENT_ATTR_NAME = "keep-content";
    private static final String PROJECT_TYPE = "project-type";
    private static final String UNREGISTER_ELEMENT_NAME = "unregister";
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.actionSystem.impl.ActionManagerImpl");
    private static final int DEACTIVATED_TIMER_DELAY = 5000;
    private static final int TIMER_DELAY = 500;
    private static final int UPDATE_DELAY_AFTER_TYPING = 500;
    private final Object myLock = new Object();
    private final Map<String, AnAction> myId2Action = new THashMap();
    private final MultiMap<PluginId, String> myPlugin2Id = new MultiMap();
    private final TObjectIntHashMap<String> myId2Index = new TObjectIntHashMap();
    private final Map<Object, String> myAction2Id = new THashMap();
    private final MultiMap<String, String> myId2GroupId = new MultiMap();
    private final List<String> myNotRegisteredInternalActionIds = new ArrayList<String>();
    private final List<AnActionListener> myActionListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private final List<ActionPopupMenuListener> myActionPopupMenuListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private final List<Object> myPopups = new ArrayList<Object>();
    private MyTimer myTimer;
    private int myRegisteredActionsCount;
    private String myLastPreformedActionId;
    private String myPrevPerformedActionId;
    private long myLastTimeEditorWasTypedIn;
    private boolean myTransparentOnlyUpdate;
    private final Map<OverridingAction, AnAction> myBaseActions = new HashMap<OverridingAction, AnAction>();
    private final AnActionListener messageBusPublisher;
    private int myAnonymousGroupIdCounter;

    ActionManagerImpl() {
        this.registerPluginActions();
        this.messageBusPublisher = (AnActionListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(AnActionListener.TOPIC);
    }

    @Nullable
    static AnAction convertStub(@NotNull ActionStub stub) {
        AnAction anAction;
        if (stub == null) {
            ActionManagerImpl.$$$reportNull$$$0(0);
        }
        if ((anAction = ActionManagerImpl.instantiate(stub.getClassName(), stub.getLoader(), stub.getPluginId(), AnAction.class)) == null) {
            return null;
        }
        stub.initAction(anAction);
        ActionManagerImpl.updateIconFromStub((ActionStubBase)stub, anAction);
        return anAction;
    }

    @Nullable
    private static <T> T instantiate(String stubClassName, ClassLoader classLoader, PluginId pluginId, Class<T> expectedClass) {
        Object obj;
        try {
            Class<?> aClass = Class.forName(stubClassName, true, classLoader);
            obj = expectedClass == ActionGroup.class ? new CachingConstructorInjectionComponentAdapter((Object)stubClassName, aClass).getComponentInstance(ApplicationManager.getApplication().getPicoContainer()) : ReflectionUtil.newInstance(aClass);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            LOG.error((Throwable)new PluginException(e, pluginId));
            return null;
        }
        if (!expectedClass.isInstance(obj)) {
            LOG.error((Throwable)new PluginException("class with name '" + stubClassName + "' must be an instance of '" + expectedClass.getName() + "'; got " + obj, pluginId));
            return null;
        }
        return (T)obj;
    }

    private static void updateIconFromStub(@NotNull ActionStubBase stub, AnAction anAction) {
        String iconPath;
        if (stub == null) {
            ActionManagerImpl.$$$reportNull$$$0(1);
        }
        if ((iconPath = stub.getIconPath()) != null) {
            IdeaPluginDescriptor plugin;
            Class<?> actionClass = anAction.getClass();
            ClassLoader classLoader = actionClass.getClassLoader();
            if (stub.getPluginId() != null && (plugin = PluginManager.getPlugin(stub.getPluginId())) != null) {
                classLoader = plugin.getPluginClassLoader();
            }
            ActionManagerImpl.setIconFromClass(actionClass, classLoader, iconPath, anAction.getTemplatePresentation(), stub.getPluginId());
        }
    }

    @Nullable
    static ActionGroup convertGroupStub(@NotNull ActionGroupStub stub) {
        ActionGroup group;
        if (stub == null) {
            ActionManagerImpl.$$$reportNull$$$0(2);
        }
        if ((group = ActionManagerImpl.instantiate(stub.getActionClass(), stub.getClassLoader(), stub.getPluginId(), ActionGroup.class)) == null) {
            return null;
        }
        stub.initGroup(group);
        ActionManagerImpl.updateIconFromStub((ActionStubBase)stub, (AnAction)group);
        return group;
    }

    private static void processAbbreviationNode(@NotNull Element e, @NotNull String id) {
        String abbr;
        if (e == null) {
            ActionManagerImpl.$$$reportNull$$$0(3);
        }
        if (id == null) {
            ActionManagerImpl.$$$reportNull$$$0(4);
        }
        if (!StringUtil.isEmpty((String)(abbr = e.getAttributeValue(VALUE_ATTR_NAME)))) {
            AbbreviationManagerImpl abbreviationManager = (AbbreviationManagerImpl)AbbreviationManager.getInstance();
            abbreviationManager.register(abbr, id, true);
        }
    }

    @Nullable
    private static ResourceBundle getActionsResourceBundle(ClassLoader loader, IdeaPluginDescriptor plugin) {
        String resBundleName = plugin != null && !"com.intellij".equals(plugin.getPluginId().getIdString()) ? plugin.getResourceBundleBaseName() : ACTIONS_BUNDLE;
        ResourceBundle bundle = null;
        if (resBundleName != null) {
            bundle = AbstractBundle.getResourceBundle((String)resBundleName, (ClassLoader)loader);
        }
        return bundle;
    }

    private static boolean isSecondary(Element element) {
        return "true".equalsIgnoreCase(element.getAttributeValue(SECONDARY));
    }

    private static void setIcon(@Nullable String iconPath, @NotNull String className, @NotNull ClassLoader loader, @NotNull Presentation presentation, PluginId pluginId) {
        if (className == null) {
            ActionManagerImpl.$$$reportNull$$$0(5);
        }
        if (loader == null) {
            ActionManagerImpl.$$$reportNull$$$0(6);
        }
        if (presentation == null) {
            ActionManagerImpl.$$$reportNull$$$0(7);
        }
        if (iconPath == null) {
            return;
        }
        try {
            Class<?> actionClass = Class.forName(className, true, loader);
            ActionManagerImpl.setIconFromClass(actionClass, loader, iconPath, presentation, pluginId);
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            LOG.error(e);
            ActionManagerImpl.reportActionError(pluginId, "class with name \"" + className + "\" not found");
        }
    }

    private static void setIconFromClass(final @NotNull Class actionClass, final @NotNull ClassLoader classLoader, final @NotNull String iconPath, @NotNull Presentation presentation, final PluginId pluginId) {
        if (actionClass == null) {
            ActionManagerImpl.$$$reportNull$$$0(8);
        }
        if (classLoader == null) {
            ActionManagerImpl.$$$reportNull$$$0(9);
        }
        if (iconPath == null) {
            ActionManagerImpl.$$$reportNull$$$0(10);
        }
        if (presentation == null) {
            ActionManagerImpl.$$$reportNull$$$0(11);
        }
        IconLoader.LazyIcon lazyIcon = new IconLoader.LazyIcon(){

            protected Icon compute() {
                Icon icon = IconLoader.findIcon((String)iconPath, (Class)actionClass, (boolean)true, (boolean)false);
                if (icon == null) {
                    icon = IconLoader.findIcon((String)iconPath, (ClassLoader)classLoader);
                }
                if (icon == null) {
                    ActionManagerImpl.reportActionError(pluginId, "Icon cannot be found in '" + iconPath + "', action '" + actionClass + "'");
                }
                return icon;
            }

            public String toString() {
                return "LazyIcon@ActionManagerImpl (path: " + iconPath + ", action class: " + actionClass + ")";
            }
        };
        if (!Registry.is((String)"ide.lazyIconLoading")) {
            lazyIcon.load();
        }
        presentation.setIcon((Icon)lazyIcon);
    }

    private static String computeDescription(ResourceBundle bundle, String id, String elementType, String descriptionValue) {
        if (bundle != null) {
            String key = elementType + "." + id + ".description";
            return CommonBundle.messageOrDefault((ResourceBundle)bundle, (String)key, (String)StringUtil.notNullize((String)descriptionValue), (Object[])new Object[0]);
        }
        return descriptionValue;
    }

    private static String computeActionText(ResourceBundle bundle, String id, String elementType, String textValue) {
        return CommonBundle.messageOrDefault((ResourceBundle)bundle, (String)(elementType + "." + id + "." + TEXT_ATTR_NAME), (String)StringUtil.notNullize((String)textValue), (Object[])new Object[0]);
    }

    private static boolean checkRelativeToAction(String relativeToActionId, @NotNull Anchor anchor2, @NotNull String actionName, @Nullable PluginId pluginId) {
        if (anchor2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(12);
        }
        if (actionName == null) {
            ActionManagerImpl.$$$reportNull$$$0(13);
        }
        if ((Anchor.BEFORE == anchor2 || Anchor.AFTER == anchor2) && relativeToActionId == null) {
            ActionManagerImpl.reportActionError(pluginId, actionName + ": \"relative-to-action\" cannot be null if anchor is \"after\" or \"before\"");
            return false;
        }
        return true;
    }

    @Nullable
    private static Anchor parseAnchor(String anchorStr, @Nullable String actionName, @Nullable PluginId pluginId) {
        if (anchorStr == null) {
            return Anchor.LAST;
        }
        if (FIRST.equalsIgnoreCase(anchorStr)) {
            return Anchor.FIRST;
        }
        if (LAST.equalsIgnoreCase(anchorStr)) {
            return Anchor.LAST;
        }
        if (BEFORE.equalsIgnoreCase(anchorStr)) {
            return Anchor.BEFORE;
        }
        if (AFTER.equalsIgnoreCase(anchorStr)) {
            return Anchor.AFTER;
        }
        ActionManagerImpl.reportActionError(pluginId, actionName + ": anchor should be one of the following constants: \"first\", \"last\", \"before\" or \"after\"");
        return null;
    }

    private static void processMouseShortcutNode(Element element, String actionId, PluginId pluginId, @NotNull KeymapManager keymapManager2) {
        MouseShortcut shortcut;
        String keystrokeString;
        if (keymapManager2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(14);
        }
        if ((keystrokeString = element.getAttributeValue(KEYSTROKE_ATTR_NAME)) == null || keystrokeString.trim().isEmpty()) {
            ActionManagerImpl.reportActionError(pluginId, "\"keystroke\" attribute must be specified for action with id=" + actionId);
            return;
        }
        try {
            shortcut = KeymapUtil.parseMouseShortcut((String)keystrokeString);
        }
        catch (Exception ex) {
            ActionManagerImpl.reportActionError(pluginId, "\"keystroke\" attribute has invalid value for action with id=" + actionId);
            return;
        }
        String keymapName = element.getAttributeValue(KEYMAP_ATTR_NAME);
        if (keymapName == null || keymapName.isEmpty()) {
            ActionManagerImpl.reportActionError(pluginId, "attribute \"keymap\" should be defined");
            return;
        }
        Keymap keymap = keymapManager2.getKeymap(keymapName);
        if (keymap == null) {
            ActionManagerImpl.reportActionError(pluginId, "keymap \"" + keymapName + "\" not found");
            return;
        }
        ActionManagerImpl.processRemoveAndReplace(element, actionId, keymap, (Shortcut)shortcut);
    }

    private static void assertActionIsGroupOrStub(AnAction action2) {
        if (!(action2 instanceof ActionGroup || action2 instanceof ActionStub || action2 instanceof ChameleonAction)) {
            LOG.error("Action : " + action2 + "; class: " + action2.getClass());
        }
    }

    private static void reportActionError(PluginId pluginId, @NotNull String message) {
        if (message == null) {
            ActionManagerImpl.$$$reportNull$$$0(15);
        }
        ActionManagerImpl.reportActionError(pluginId, message, null);
    }

    private static void reportActionError(PluginId pluginId, @NotNull String message, @Nullable Throwable cause) {
        if (message == null) {
            ActionManagerImpl.$$$reportNull$$$0(16);
        }
        if (pluginId != null) {
            LOG.error((Throwable)new PluginException(message, cause, pluginId));
        } else if (cause != null) {
            LOG.error(message, cause);
        } else {
            LOG.error(message);
        }
    }

    private static void reportActionWarning(PluginId pluginId, @NotNull String message) {
        if (message == null) {
            ActionManagerImpl.$$$reportNull$$$0(17);
        }
        if (pluginId == null) {
            LOG.warn(message);
        } else {
            LOG.warn(new PluginException(message, null, pluginId).getMessage());
        }
    }

    private static String getPluginInfo(@Nullable PluginId id) {
        IdeaPluginDescriptor plugin;
        if (id != null && (plugin = PluginManager.getPlugin(id)) != null) {
            String name = plugin.getName();
            if (name == null) {
                name = id.getIdString();
            }
            return " Plugin: " + name;
        }
        return "";
    }

    @NotNull
    private static DataContext getContextBy(Component contextComponent) {
        DataManager dataManager = DataManager.getInstance();
        DataContext dataContext = contextComponent != null ? dataManager.getDataContext(contextComponent) : dataManager.getDataContext();
        if (dataContext == null) {
            ActionManagerImpl.$$$reportNull$$$0(18);
        }
        return dataContext;
    }

    public void dispose() {
        if (this.myTimer != null) {
            this.myTimer.stop();
            this.myTimer = null;
        }
    }

    public void addTimerListener(int delay, @NotNull TimerListener listener2) {
        if (listener2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(19);
        }
        this._addTimerListener(listener2, false);
    }

    public void removeTimerListener(@NotNull TimerListener listener2) {
        if (listener2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(20);
        }
        this._removeTimerListener(listener2, false);
    }

    public void addTransparentTimerListener(int delay, @NotNull TimerListener listener2) {
        if (listener2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(21);
        }
        this._addTimerListener(listener2, true);
    }

    public void removeTransparentTimerListener(@NotNull TimerListener listener2) {
        if (listener2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(22);
        }
        this._removeTimerListener(listener2, true);
    }

    private void _addTimerListener(TimerListener listener2, boolean transparent) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        if (this.myTimer == null) {
            this.myTimer = new MyTimer();
            this.myTimer.start();
        }
        this.myTimer.addTimerListener(listener2, transparent);
    }

    private void _removeTimerListener(TimerListener listener2, boolean transparent) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        if (LOG.assertTrue(this.myTimer != null)) {
            this.myTimer.removeTimerListener(listener2, transparent);
        }
    }

    public ActionPopupMenu createActionPopupMenu(@NotNull String place, @NotNull ActionGroup group, @Nullable PresentationFactory presentationFactory) {
        if (place == null) {
            ActionManagerImpl.$$$reportNull$$$0(23);
        }
        if (group == null) {
            ActionManagerImpl.$$$reportNull$$$0(24);
        }
        return new ActionPopupMenuImpl(place, group, this, presentationFactory);
    }

    @NotNull
    public ActionPopupMenu createActionPopupMenu(@NotNull String place, @NotNull ActionGroup group) {
        if (place == null) {
            ActionManagerImpl.$$$reportNull$$$0(25);
        }
        if (group == null) {
            ActionManagerImpl.$$$reportNull$$$0(26);
        }
        ActionPopupMenuImpl actionPopupMenuImpl = new ActionPopupMenuImpl(place, group, this, null);
        if (actionPopupMenuImpl == null) {
            ActionManagerImpl.$$$reportNull$$$0(27);
        }
        return actionPopupMenuImpl;
    }

    @NotNull
    public ActionToolbar createActionToolbar(@NotNull String place, @NotNull ActionGroup group, boolean horizontal) {
        if (place == null) {
            ActionManagerImpl.$$$reportNull$$$0(28);
        }
        if (group == null) {
            ActionManagerImpl.$$$reportNull$$$0(29);
        }
        ActionToolbar actionToolbar = this.createActionToolbar(place, group, horizontal, false);
        if (actionToolbar == null) {
            ActionManagerImpl.$$$reportNull$$$0(30);
        }
        return actionToolbar;
    }

    @NotNull
    public ActionToolbar createActionToolbar(@NotNull String place, @NotNull ActionGroup group, boolean horizontal, boolean decorateButtons) {
        if (place == null) {
            ActionManagerImpl.$$$reportNull$$$0(31);
        }
        if (group == null) {
            ActionManagerImpl.$$$reportNull$$$0(32);
        }
        ActionToolbarImpl actionToolbarImpl = new ActionToolbarImpl(place, group, horizontal, decorateButtons, KeymapManagerEx.getInstanceEx());
        if (actionToolbarImpl == null) {
            ActionManagerImpl.$$$reportNull$$$0(33);
        }
        return actionToolbarImpl;
    }

    private void registerPluginActions() {
        List<IdeaPluginDescriptor> plugins2 = PluginManagerCore.getLoadedPlugins();
        for (IdeaPluginDescriptor plugin : plugins2) {
            List elementList = plugin.getAndClearActionDescriptionElements();
            if (elementList == null) continue;
            long startTime = StartUpMeasurer.getCurrentTime();
            for (Element e : elementList) {
                this.processActionsChildElement(plugin.getPluginClassLoader(), plugin.getPluginId(), e);
            }
            StartUpMeasurer.addPluginCost((String)plugin.getPluginId().getIdString(), (String)"Actions", (long)(System.nanoTime() - startTime));
        }
    }

    @Nullable
    public AnAction getAction(@NotNull String id) {
        if (id == null) {
            ActionManagerImpl.$$$reportNull$$$0(34);
        }
        return this.getActionImpl(id, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private AnAction getActionImpl(@NotNull String id, boolean canReturnStub) {
        AnAction converted;
        AnAction action2;
        if (id == null) {
            ActionManagerImpl.$$$reportNull$$$0(35);
        }
        Object object = this.myLock;
        synchronized (object) {
            action2 = this.myId2Action.get(id);
            if (canReturnStub || !(action2 instanceof ActionStubBase)) {
                return action2;
            }
        }
        Object object2 = converted = action2 instanceof ActionStub ? ActionManagerImpl.convertStub((ActionStub)action2) : ActionManagerImpl.convertGroupStub((ActionGroupStub)action2);
        if (converted == null) {
            this.unregisterAction(id);
            return null;
        }
        Object object3 = this.myLock;
        synchronized (object3) {
            action2 = this.myId2Action.get(id);
            if (action2 instanceof ActionStubBase) {
                action2 = this.replaceStub((ActionStubBase)action2, converted);
            }
            return action2;
        }
    }

    @NotNull
    private AnAction replaceStub(@NotNull ActionStubBase stub, AnAction anAction) {
        if (stub == null) {
            ActionManagerImpl.$$$reportNull$$$0(36);
        }
        LOG.assertTrue(this.myAction2Id.containsKey(stub));
        this.myAction2Id.remove(stub);
        LOG.assertTrue(this.myId2Action.containsKey(stub.getId()));
        AnAction action2 = this.myId2Action.remove(stub.getId());
        LOG.assertTrue(action2 != null);
        LOG.assertTrue(action2.equals(stub));
        this.myAction2Id.put(anAction, stub.getId());
        AnAction anAction2 = this.addToMap(stub.getId(), anAction, stub.getPluginId(), stub instanceof ActionStub ? ((ActionStub)stub).getProjectType() : null);
        if (anAction2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(37);
        }
        return anAction2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getId(@NotNull AnAction action2) {
        if (action2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(38);
        }
        if (action2 instanceof ActionStubBase) {
            return ((ActionStubBase)action2).getId();
        }
        Object object = this.myLock;
        synchronized (object) {
            return this.myAction2Id.get(action2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public String[] getActionIds(@NotNull String idPrefix) {
        if (idPrefix == null) {
            ActionManagerImpl.$$$reportNull$$$0(39);
        }
        Object object = this.myLock;
        // MONITORENTER : object
        ArrayList<String> idList = new ArrayList<String>();
        Iterator<String> iterator = this.myId2Action.keySet().iterator();
        while (true) {
            if (!iterator.hasNext()) {
                String[] stringArray = ArrayUtilRt.toStringArray(idList);
                // MONITOREXIT : object
                if (stringArray != null) return stringArray;
                ActionManagerImpl.$$$reportNull$$$0(40);
                return stringArray;
            }
            String id = iterator.next();
            if (!id.startsWith(idPrefix)) continue;
            idList.add(id);
        }
    }

    public boolean isGroup(@NotNull String actionId) {
        if (actionId == null) {
            ActionManagerImpl.$$$reportNull$$$0(41);
        }
        return this.getActionImpl(actionId, true) instanceof ActionGroup;
    }

    @NotNull
    public JComponent createButtonToolbar(@NotNull String actionPlace, @NotNull ActionGroup messageActionGroup) {
        if (actionPlace == null) {
            ActionManagerImpl.$$$reportNull$$$0(42);
        }
        if (messageActionGroup == null) {
            ActionManagerImpl.$$$reportNull$$$0(43);
        }
        ButtonToolbarImpl buttonToolbarImpl = new ButtonToolbarImpl(actionPlace, messageActionGroup);
        if (buttonToolbarImpl == null) {
            ActionManagerImpl.$$$reportNull$$$0(44);
        }
        return buttonToolbarImpl;
    }

    public AnAction getActionOrStub(@NotNull String id) {
        if (id == null) {
            ActionManagerImpl.$$$reportNull$$$0(45);
        }
        return this.getActionImpl(id, true);
    }

    @Nullable
    private AnAction processActionElement(@NotNull Element element, ClassLoader loader, PluginId pluginId) {
        String className;
        if (element == null) {
            ActionManagerImpl.$$$reportNull$$$0(46);
        }
        if ((className = element.getAttributeValue(CLASS_ATTR_NAME)) == null || className.isEmpty()) {
            ActionManagerImpl.reportActionError(pluginId, "action element should have specified \"class\" attribute");
            return null;
        }
        String id = ActionManagerImpl.obtainActionId(element, className);
        if (Boolean.valueOf(element.getAttributeValue(INTERNAL_ATTR_NAME)).booleanValue() && !ApplicationManager.getApplication().isInternal()) {
            this.myNotRegisteredInternalActionIds.add(id);
            return null;
        }
        String iconPath = element.getAttributeValue(ICON_ATTR_NAME);
        String projectType = element.getAttributeValue(PROJECT_TYPE);
        String textValue = element.getAttributeValue(TEXT_ATTR_NAME);
        String descriptionValue = element.getAttributeValue(DESCRIPTION);
        ActionStub stub = new ActionStub(className, id, loader, pluginId, iconPath, projectType, () -> {
            IdeaPluginDescriptor plugin = PluginManager.getPlugin(pluginId);
            ResourceBundle bundle = ActionManagerImpl.getActionsResourceBundle(loader, plugin);
            String text2 = ActionManagerImpl.computeActionText(bundle, id, ACTION_ELEMENT_NAME, textValue);
            if (text2 == null) {
                ActionManagerImpl.reportActionError(pluginId, "'text' attribute is mandatory (action ID=" + id + ";" + (plugin == null ? "" : " plugin path: " + plugin.getPath()) + ")");
            }
            Presentation presentation = new Presentation();
            presentation.setText(text2);
            presentation.setDescription(ActionManagerImpl.computeDescription(bundle, id, ACTION_ELEMENT_NAME, descriptionValue));
            return presentation;
        });
        KeymapManagerEx keymapManager2 = KeymapManagerEx.getInstanceEx();
        for (Element e : element.getChildren()) {
            if (ADD_TO_GROUP_ELEMENT_NAME.equals(e.getName())) {
                this.processAddToGroupNode((AnAction)stub, e, pluginId, ActionManagerImpl.isSecondary(e));
                continue;
            }
            if (SHORTCUT_ELEMENT_NAME.equals(e.getName())) {
                ActionManagerImpl.processKeyboardShortcutNode(e, id, pluginId, keymapManager2);
                continue;
            }
            if (MOUSE_SHORTCUT_ELEMENT_NAME.equals(e.getName())) {
                ActionManagerImpl.processMouseShortcutNode(e, id, pluginId, keymapManager2);
                continue;
            }
            if (ABBREVIATION_ELEMENT_NAME.equals(e.getName())) {
                ActionManagerImpl.processAbbreviationNode(e, id);
                continue;
            }
            ActionManagerImpl.reportActionError(pluginId, "unexpected name of element \"" + e.getName() + "\"");
            return null;
        }
        if (element.getAttributeValue(USE_SHORTCUT_OF_ATTR_NAME) != null) {
            keymapManager2.bindShortcuts(element.getAttributeValue(USE_SHORTCUT_OF_ATTR_NAME), id);
        }
        this.registerOrReplaceActionInner(element, id, (AnAction)stub, pluginId);
        return stub;
    }

    private static String obtainActionId(Element element, String className) {
        String id = element.getAttributeValue(ID_ATTR_NAME);
        return StringUtil.isEmpty((String)id) ? StringUtil.getShortName((String)className) : id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerOrReplaceActionInner(@NotNull Element element, @NotNull String id, @NotNull AnAction action2, @Nullable PluginId pluginId) {
        if (element == null) {
            ActionManagerImpl.$$$reportNull$$$0(47);
        }
        if (id == null) {
            ActionManagerImpl.$$$reportNull$$$0(48);
        }
        if (action2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(49);
        }
        Object object = this.myLock;
        synchronized (object) {
            if (Boolean.parseBoolean(element.getAttributeValue(OVERRIDES_ATTR_NAME))) {
                if (this.getActionOrStub(id) == null) {
                    LOG.error(element.getName() + " '" + id + "' doesn't override anything");
                    return;
                }
                AnAction prev = this.replaceAction(id, action2, pluginId);
                if (action2 instanceof DefaultActionGroup && prev instanceof DefaultActionGroup && Boolean.parseBoolean(element.getAttributeValue(KEEP_CONTENT_ATTR_NAME))) {
                    ((DefaultActionGroup)action2).copyFromGroup((DefaultActionGroup)prev);
                }
            } else {
                this.registerAction(id, action2, pluginId, element.getAttributeValue(PROJECT_TYPE));
            }
            ((ActionsCollectorImpl)ActionsCollector.getInstance()).onActionLoadedFromXml(action2, id, pluginId);
        }
    }

    private AnAction processGroupElement(@NotNull Element element, ClassLoader loader, PluginId pluginId) {
        if (element == null) {
            ActionManagerImpl.$$$reportNull$$$0(50);
        }
        IdeaPluginDescriptor plugin = PluginManager.getPlugin(pluginId);
        ResourceBundle bundle = ActionManagerImpl.getActionsResourceBundle(loader, plugin);
        if (!GROUP_ELEMENT_NAME.equals(element.getName())) {
            ActionManagerImpl.reportActionError(pluginId, "unexpected name of element \"" + element.getName() + "\"");
            return null;
        }
        String className = element.getAttributeValue(CLASS_ATTR_NAME);
        if (className == null) {
            className = "true".equals(element.getAttributeValue(COMPACT_ATTR_NAME)) ? DefaultCompactActionGroup.class.getName() : DefaultActionGroup.class.getName();
        }
        try {
            String description;
            DefaultActionGroup group;
            String id = element.getAttributeValue(ID_ATTR_NAME);
            if (id != null && id.isEmpty()) {
                ActionManagerImpl.reportActionError(pluginId, "ID of the group cannot be an empty string");
                return null;
            }
            boolean customClass = false;
            if (DefaultActionGroup.class.getName().equals(className)) {
                group = new DefaultActionGroup();
            } else if (DefaultCompactActionGroup.class.getName().equals(className)) {
                group = new DefaultCompactActionGroup();
            } else if (id == null) {
                Class<?> aClass = Class.forName(className, true, loader);
                Object obj = new CachingConstructorInjectionComponentAdapter((Object)className, aClass).getComponentInstance(ApplicationManager.getApplication().getPicoContainer());
                if (!(obj instanceof ActionGroup)) {
                    ActionManagerImpl.reportActionError(pluginId, "class with name \"" + className + "\" should be instance of " + ActionGroup.class.getName());
                    return null;
                }
                if (element.getChildren().size() != element.getChildren(ADD_TO_GROUP_ELEMENT_NAME).size() && !(obj instanceof DefaultActionGroup)) {
                    ActionManagerImpl.reportActionError(pluginId, "class with name \"" + className + "\" should be instance of " + DefaultActionGroup.class.getName() + " because there are children specified");
                    return null;
                }
                customClass = true;
                group = (ActionGroup)obj;
            } else {
                group = new ActionGroupStub(id, className, loader, pluginId);
                customClass = true;
            }
            if (Boolean.valueOf(element.getAttributeValue(INTERNAL_ATTR_NAME)).booleanValue() && !ApplicationManager.getApplication().isInternal()) {
                this.myNotRegisteredInternalActionIds.add(id);
                return null;
            }
            if (id == null) {
                id = "<anonymous-group-" + this.myAnonymousGroupIdCounter++ + ">";
            }
            this.registerOrReplaceActionInner(element, id, (AnAction)group, pluginId);
            Presentation presentation = group.getTemplatePresentation();
            String text2 = ActionManagerImpl.computeActionText(bundle, id, GROUP_ELEMENT_NAME, element.getAttributeValue(TEXT_ATTR_NAME));
            if (!StringUtil.isEmpty((String)text2) || presentation.getText() == null) {
                presentation.setText(text2);
            }
            if (!StringUtil.isEmpty((String)(description = ActionManagerImpl.computeDescription(bundle, id, GROUP_ELEMENT_NAME, element.getAttributeValue(DESCRIPTION)))) || presentation.getDescription() == null) {
                presentation.setDescription(description);
            }
            String iconPath = element.getAttributeValue(ICON_ATTR_NAME);
            if (group instanceof ActionGroupStub) {
                ((ActionGroupStub)group).setIconPath(iconPath);
            } else {
                ActionManagerImpl.setIcon(iconPath, className, loader, presentation, pluginId);
            }
            String popup2 = element.getAttributeValue(POPUP_ATTR_NAME);
            if (popup2 != null) {
                group.setPopup(Boolean.valueOf(popup2).booleanValue());
                if (group instanceof ActionGroupStub) {
                    ((ActionGroupStub)group).setPopupDefinedInXml(true);
                }
            }
            if (customClass && element.getAttributeValue(USE_SHORTCUT_OF_ATTR_NAME) != null) {
                KeymapManagerEx.getInstanceEx().bindShortcuts(element.getAttributeValue(USE_SHORTCUT_OF_ATTR_NAME), id);
            }
            for (Element child2 : element.getChildren()) {
                AnAction action2;
                String name = child2.getName();
                if (ACTION_ELEMENT_NAME.equals(name)) {
                    action2 = this.processActionElement(child2, loader, pluginId);
                    if (action2 == null) continue;
                    ActionManagerImpl.assertActionIsGroupOrStub(action2);
                    this.addToGroupInner((AnAction)group, action2, Constraints.LAST, ActionManagerImpl.isSecondary(child2));
                    continue;
                }
                if (SEPARATOR_ELEMENT_NAME.equals(name)) {
                    this.processSeparatorNode(group, child2, pluginId);
                    continue;
                }
                if (GROUP_ELEMENT_NAME.equals(name)) {
                    action2 = this.processGroupElement(child2, loader, pluginId);
                    if (action2 == null) continue;
                    this.addToGroupInner((AnAction)group, action2, Constraints.LAST, false);
                    continue;
                }
                if (ADD_TO_GROUP_ELEMENT_NAME.equals(name)) {
                    this.processAddToGroupNode((AnAction)group, child2, pluginId, ActionManagerImpl.isSecondary(child2));
                    continue;
                }
                if (REFERENCE_ELEMENT_NAME.equals(name)) {
                    action2 = this.processReferenceElement(child2, pluginId);
                    if (action2 == null) continue;
                    this.addToGroupInner((AnAction)group, action2, Constraints.LAST, ActionManagerImpl.isSecondary(child2));
                    continue;
                }
                ActionManagerImpl.reportActionError(pluginId, "unexpected name of element \"" + name + "\n");
                return null;
            }
            return group;
        }
        catch (Exception e) {
            String message = "cannot create class \"" + className + "\"";
            ActionManagerImpl.reportActionError(pluginId, message, e);
            return null;
        }
    }

    private void processReferenceNode(Element element, PluginId pluginId) {
        AnAction action2 = this.processReferenceElement(element, pluginId);
        if (action2 == null) {
            return;
        }
        for (Element child2 : element.getChildren()) {
            if (!ADD_TO_GROUP_ELEMENT_NAME.equals(child2.getName())) continue;
            this.processAddToGroupNode(action2, child2, pluginId, ActionManagerImpl.isSecondary(child2));
        }
    }

    private void processAddToGroupNode(AnAction action2, Element element, PluginId pluginId, boolean secondary) {
        if (!(action2 instanceof Separator)) {
            ActionManagerImpl.assertActionIsGroupOrStub(action2);
        }
        String actionName = String.format("%s (%s)", action2 instanceof ActionStub ? ((ActionStub)action2).getClassName() : action2.getClass().getName(), action2 instanceof ActionStub ? ((ActionStub)action2).getId() : this.myAction2Id.get(action2));
        if (!ADD_TO_GROUP_ELEMENT_NAME.equals(element.getName())) {
            ActionManagerImpl.reportActionError(pluginId, "unexpected name of element \"" + element.getName() + "\"");
            return;
        }
        AnAction parentGroup = this.getParentGroup(element.getAttributeValue(GROUPID_ATTR_NAME), actionName, pluginId);
        if (parentGroup == null) {
            return;
        }
        Anchor anchor2 = ActionManagerImpl.parseAnchor(element.getAttributeValue(ANCHOR_ELEMENT_NAME), actionName, pluginId);
        if (anchor2 == null) {
            return;
        }
        String relativeToActionId = element.getAttributeValue(RELATIVE_TO_ACTION_ATTR_NAME);
        if (!ActionManagerImpl.checkRelativeToAction(relativeToActionId, anchor2, actionName, pluginId)) {
            return;
        }
        this.addToGroupInner(parentGroup, action2, new Constraints(anchor2, relativeToActionId), secondary);
    }

    private void addToGroupInner(AnAction group, AnAction action2, Constraints constraints, boolean secondary) {
        String actionId = action2 instanceof ActionStub ? ((ActionStub)action2).getId() : this.myAction2Id.get(action2);
        ((DefaultActionGroup)group).addAction(action2, constraints, (ActionManager)this).setAsSecondary(secondary);
        this.myId2GroupId.putValue((Object)actionId, (Object)this.myAction2Id.get(group));
    }

    @Nullable
    public AnAction getParentGroup(String groupId, @Nullable String actionName, @Nullable PluginId pluginId) {
        if (groupId == null || groupId.isEmpty()) {
            ActionManagerImpl.reportActionError(pluginId, actionName + ": attribute \"group-id\" should be defined");
            return null;
        }
        AnAction parentGroup = this.getActionImpl(groupId, true);
        if (parentGroup == null) {
            ActionManagerImpl.reportActionError(pluginId, actionName + ": group with id \"" + groupId + "\" isn't registered; action will be added to the \"Other\" group");
            parentGroup = this.getActionImpl("OtherMenu", true);
        }
        if (!(parentGroup instanceof DefaultActionGroup)) {
            ActionManagerImpl.reportActionError(pluginId, actionName + ": group with id \"" + groupId + "\" should be instance of " + DefaultActionGroup.class.getName() + " but was " + (parentGroup != null ? parentGroup.getClass() : "[null]"));
            return null;
        }
        return parentGroup;
    }

    private void processSeparatorNode(@Nullable DefaultActionGroup parentGroup, Element element, PluginId pluginId) {
        Separator separator;
        if (!SEPARATOR_ELEMENT_NAME.equals(element.getName())) {
            ActionManagerImpl.reportActionError(pluginId, "unexpected name of element \"" + element.getName() + "\"");
            return;
        }
        String text2 = element.getAttributeValue(TEXT_ATTR_NAME);
        Separator separator2 = separator = text2 != null ? new Separator(text2) : Separator.getInstance();
        if (parentGroup != null) {
            parentGroup.add((AnAction)separator, (ActionManager)this);
        }
        for (Element child2 : element.getChildren()) {
            if (!ADD_TO_GROUP_ELEMENT_NAME.equals(child2.getName())) continue;
            this.processAddToGroupNode((AnAction)separator, child2, pluginId, ActionManagerImpl.isSecondary(child2));
        }
    }

    private void processUnregisterNode(Element element, PluginId pluginId) {
        String id = element.getAttributeValue(ID_ATTR_NAME);
        if (id == null) {
            ActionManagerImpl.reportActionError(pluginId, "'id' attribute is required for 'unregister' elements");
            return;
        }
        AnAction action2 = this.getAction(id);
        if (action2 == null) {
            ActionManagerImpl.reportActionError(pluginId, "Trying to unregister non-existing action " + id);
            return;
        }
        AbbreviationManager.getInstance().removeAllAbbreviations(id);
        for (AnAction anAction : this.myId2Action.values()) {
            if (!(anAction instanceof DefaultActionGroup)) continue;
            ((DefaultActionGroup)anAction).remove(action2, id);
        }
        this.unregisterAction(id);
    }

    private static void processKeyboardShortcutNode(Element element, String actionId, PluginId pluginId, @NotNull KeymapManagerEx keymapManager2) {
        String firstStrokeString;
        if (keymapManager2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(51);
        }
        if ((firstStrokeString = element.getAttributeValue(FIRST_KEYSTROKE_ATTR_NAME)) == null) {
            ActionManagerImpl.reportActionError(pluginId, "\"first-keystroke\" attribute must be specified for action with id=" + actionId);
            return;
        }
        KeyStroke firstKeyStroke = ActionManagerImpl.getKeyStroke((String)firstStrokeString);
        if (firstKeyStroke == null) {
            ActionManagerImpl.reportActionError(pluginId, "\"first-keystroke\" attribute has invalid value for action with id=" + actionId);
            return;
        }
        KeyStroke secondKeyStroke = null;
        String secondStrokeString = element.getAttributeValue(SECOND_KEYSTROKE_ATTR_NAME);
        if (secondStrokeString != null && (secondKeyStroke = ActionManagerImpl.getKeyStroke((String)secondStrokeString)) == null) {
            ActionManagerImpl.reportActionError(pluginId, "\"second-keystroke\" attribute has invalid value for action with id=" + actionId);
            return;
        }
        String keymapName = element.getAttributeValue(KEYMAP_ATTR_NAME);
        if (keymapName == null || keymapName.trim().isEmpty()) {
            ActionManagerImpl.reportActionError(pluginId, "attribute \"keymap\" should be defined");
            return;
        }
        Keymap keymap = keymapManager2.getKeymap(keymapName);
        if (keymap == null) {
            ActionManagerImpl.reportActionWarning(pluginId, "keymap \"" + keymapName + "\" not found");
            return;
        }
        KeyboardShortcut shortcut = new KeyboardShortcut(firstKeyStroke, secondKeyStroke);
        ActionManagerImpl.processRemoveAndReplace(element, actionId, keymap, (Shortcut)shortcut);
    }

    private static void processRemoveAndReplace(@NotNull Element element, String actionId, @NotNull Keymap keymap, @NotNull Shortcut shortcut) {
        if (element == null) {
            ActionManagerImpl.$$$reportNull$$$0(52);
        }
        if (keymap == null) {
            ActionManagerImpl.$$$reportNull$$$0(53);
        }
        if (shortcut == null) {
            ActionManagerImpl.$$$reportNull$$$0(54);
        }
        boolean remove = Boolean.parseBoolean(element.getAttributeValue(REMOVE_SHORTCUT_ATTR_NAME));
        boolean replace = Boolean.parseBoolean(element.getAttributeValue(REPLACE_SHORTCUT_ATTR_NAME));
        if (remove) {
            keymap.removeShortcut(actionId, shortcut);
        }
        if (replace) {
            keymap.removeAllActionShortcuts(actionId);
        }
        if (!remove) {
            keymap.addShortcut(actionId, shortcut);
        }
    }

    @Nullable
    private AnAction processReferenceElement(Element element, PluginId pluginId) {
        if (!REFERENCE_ELEMENT_NAME.equals(element.getName())) {
            ActionManagerImpl.reportActionError(pluginId, "unexpected name of element \"" + element.getName() + "\"");
            return null;
        }
        String ref = element.getAttributeValue(REF_ATTR_NAME);
        if (ref == null) {
            ref = element.getAttributeValue(ID_ATTR_NAME);
        }
        if (ref == null || ref.isEmpty()) {
            ActionManagerImpl.reportActionError(pluginId, "ID of reference element should be defined");
            return null;
        }
        AnAction action2 = this.getActionImpl(ref, true);
        if (action2 == null) {
            if (!this.myNotRegisteredInternalActionIds.contains(ref)) {
                ActionManagerImpl.reportActionError(pluginId, "action specified by reference isn't registered (ID=" + ref + ")");
            }
            return null;
        }
        ActionManagerImpl.assertActionIsGroupOrStub(action2);
        return action2;
    }

    private void processActionsChildElement(ClassLoader loader, PluginId pluginId, @NotNull Element child2) {
        String name;
        if (child2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(55);
        }
        if (ACTION_ELEMENT_NAME.equals(name = child2.getName())) {
            AnAction action2 = this.processActionElement(child2, loader, pluginId);
            if (action2 != null) {
                ActionManagerImpl.assertActionIsGroupOrStub(action2);
            }
        } else if (GROUP_ELEMENT_NAME.equals(name)) {
            this.processGroupElement(child2, loader, pluginId);
        } else if (SEPARATOR_ELEMENT_NAME.equals(name)) {
            this.processSeparatorNode(null, child2, pluginId);
        } else if (REFERENCE_ELEMENT_NAME.equals(name)) {
            this.processReferenceNode(child2, pluginId);
        } else if (UNREGISTER_ELEMENT_NAME.equals(name)) {
            this.processUnregisterNode(child2, pluginId);
        } else {
            ActionManagerImpl.reportActionError(pluginId, "unexpected name of element \"" + name + "\n");
        }
    }

    public void registerAction(@NotNull String actionId, @NotNull AnAction action2, @Nullable PluginId pluginId) {
        if (actionId == null) {
            ActionManagerImpl.$$$reportNull$$$0(56);
        }
        if (action2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(57);
        }
        this.registerAction(actionId, action2, pluginId, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerAction(@NotNull String actionId, @NotNull AnAction action2, @Nullable PluginId pluginId, @Nullable String projectType) {
        if (actionId == null) {
            ActionManagerImpl.$$$reportNull$$$0(58);
        }
        if (action2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(59);
        }
        Object object = this.myLock;
        synchronized (object) {
            if (this.addToMap(actionId, action2, pluginId, projectType) == null) {
                return;
            }
            if (this.myAction2Id.containsKey(action2)) {
                ActionManagerImpl.reportActionError(pluginId, "action was already registered for another ID. ID is " + this.myAction2Id.get(action2) + ActionManagerImpl.getPluginInfo(pluginId));
                return;
            }
            this.myId2Index.put((Object)actionId, this.myRegisteredActionsCount++);
            this.myAction2Id.put(action2, actionId);
            if (pluginId != null && !(action2 instanceof ActionGroup)) {
                this.myPlugin2Id.putValue((Object)pluginId, (Object)actionId);
            }
            action2.registerCustomShortcutSet((ShortcutSet)new ProxyShortcutSet(actionId), null);
        }
    }

    private AnAction addToMap(String actionId, AnAction action2, PluginId pluginId, String projectType) {
        if (projectType != null || this.myId2Action.containsKey(actionId)) {
            return this.registerChameleon(actionId, action2, pluginId, projectType);
        }
        this.myId2Action.put(actionId, action2);
        return action2;
    }

    private AnAction registerChameleon(String actionId, AnAction action2, PluginId pluginId, String projectType) {
        ChameleonAction chameleonAction;
        ProjectType type = projectType == null ? null : new ProjectType(projectType);
        AnAction o = this.myId2Action.get(actionId);
        if (o == null) {
            ChameleonAction chameleonAction2 = new ChameleonAction(action2, type);
            this.myId2Action.put(actionId, chameleonAction2);
            return chameleonAction2;
        }
        if (o instanceof ChameleonAction) {
            chameleonAction = (ChameleonAction)o;
        } else {
            chameleonAction = new ChameleonAction(o, type);
            this.myId2Action.put(actionId, chameleonAction);
        }
        AnAction old = chameleonAction.addAction(action2, type);
        if (old != null) {
            ActionManagerImpl.reportActionError(pluginId, "action with the ID \"" + actionId + "\" was already registered. Action being registered is " + action2 + "; Registered action is " + this.myId2Action.get(actionId) + ActionManagerImpl.getPluginInfo(pluginId));
            return null;
        }
        return chameleonAction;
    }

    public void registerAction(@NotNull String actionId, @NotNull AnAction action2) {
        if (actionId == null) {
            ActionManagerImpl.$$$reportNull$$$0(60);
        }
        if (action2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(61);
        }
        this.registerAction(actionId, action2, null);
    }

    public void unregisterAction(@NotNull String actionId) {
        if (actionId == null) {
            ActionManagerImpl.$$$reportNull$$$0(62);
        }
        this.unregisterAction(actionId, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterAction(@NotNull String actionId, boolean removeFromGroups) {
        if (actionId == null) {
            ActionManagerImpl.$$$reportNull$$$0(63);
        }
        Object object = this.myLock;
        synchronized (object) {
            if (!this.myId2Action.containsKey(actionId) && LOG.isDebugEnabled()) {
                LOG.debug("action with ID " + actionId + " wasn't registered");
                return;
            }
            AnAction oldValue = this.myId2Action.remove(actionId);
            this.myAction2Id.remove(oldValue);
            this.myId2Index.remove((Object)actionId);
            for (Map.Entry entry : this.myPlugin2Id.entrySet()) {
                Collection pluginActions = (Collection)entry.getValue();
                pluginActions.remove(actionId);
            }
            if (removeFromGroups) {
                for (String groupId : this.myId2GroupId.get((Object)actionId)) {
                    DefaultActionGroup group = (DefaultActionGroup)ObjectUtils.assertNotNull((Object)((DefaultActionGroup)this.getActionOrStub(groupId)));
                    group.remove(oldValue, actionId);
                }
            }
            if (oldValue instanceof ActionGroup) {
                this.myId2GroupId.values().remove(actionId);
            }
        }
    }

    @NotNull
    public Comparator<String> getRegistrationOrderComparator() {
        Comparator<String> comparator2 = Comparator.comparingInt(arg_0 -> this.myId2Index.get(arg_0));
        if (comparator2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(64);
        }
        return comparator2;
    }

    @NotNull
    public String[] getPluginActions(@NotNull PluginId pluginName) {
        if (pluginName == null) {
            ActionManagerImpl.$$$reportNull$$$0(65);
        }
        String[] stringArray = ArrayUtilRt.toStringArray((Collection)this.myPlugin2Id.get((Object)pluginName));
        if (stringArray == null) {
            ActionManagerImpl.$$$reportNull$$$0(66);
        }
        return stringArray;
    }

    public void addActionPopup(@NotNull Object menu2) {
        if (menu2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(67);
        }
        this.myPopups.add(menu2);
        if (menu2 instanceof ActionPopupMenu) {
            for (ActionPopupMenuListener listener2 : this.myActionPopupMenuListeners) {
                listener2.actionPopupMenuCreated((ActionPopupMenu)menu2);
            }
        }
    }

    void removeActionPopup(@NotNull Object menu2) {
        boolean removed;
        if (menu2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(68);
        }
        if ((removed = this.myPopups.remove(menu2)) && menu2 instanceof ActionPopupMenu) {
            for (ActionPopupMenuListener listener2 : this.myActionPopupMenuListeners) {
                listener2.actionPopupMenuReleased((ActionPopupMenu)menu2);
            }
        }
    }

    public void queueActionPerformedEvent(@NotNull AnAction action2, @NotNull DataContext context, @NotNull AnActionEvent event) {
        if (action2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(69);
        }
        if (context == null) {
            ActionManagerImpl.$$$reportNull$$$0(70);
        }
        if (event == null) {
            ActionManagerImpl.$$$reportNull$$$0(71);
        }
        if (this.myPopups.isEmpty()) {
            this.fireAfterActionPerformed(action2, context, event);
        }
    }

    public boolean isToolWindowContextMenuVisible() {
        for (Object popup2 : this.myPopups) {
            if (!(popup2 instanceof ActionPopupMenuImpl) || !((ActionPopupMenuImpl)popup2).isToolWindowContextMenu()) continue;
            return true;
        }
        return false;
    }

    public boolean isActionPopupStackEmpty() {
        return this.myPopups.isEmpty();
    }

    public boolean isTransparentOnlyActionsUpdateNow() {
        return this.myTransparentOnlyUpdate;
    }

    public void addActionPopupMenuListener(@NotNull ActionPopupMenuListener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(72);
        }
        if (parentDisposable == null) {
            ActionManagerImpl.$$$reportNull$$$0(73);
        }
        this.myActionPopupMenuListeners.add(listener2);
        Disposer.register((Disposable)parentDisposable, () -> this.myActionPopupMenuListeners.remove(listener2));
    }

    public void replaceAction(@NotNull String actionId, @NotNull AnAction newAction) {
        Class callerClass;
        if (actionId == null) {
            ActionManagerImpl.$$$reportNull$$$0(74);
        }
        if (newAction == null) {
            ActionManagerImpl.$$$reportNull$$$0(75);
        }
        PluginId pluginId = (callerClass = ReflectionUtil.getGrandCallerClass()) != null ? PluginManagerCore.getPluginByClassName(callerClass.getName()) : null;
        this.replaceAction(actionId, newAction, pluginId);
    }

    private AnAction replaceAction(@NotNull String actionId, @NotNull AnAction newAction, @Nullable PluginId pluginId) {
        AnAction oldAction;
        if (actionId == null) {
            ActionManagerImpl.$$$reportNull$$$0(76);
        }
        if (newAction == null) {
            ActionManagerImpl.$$$reportNull$$$0(77);
        }
        AnAction anAction = oldAction = newAction instanceof OverridingAction ? this.getAction(actionId) : this.getActionOrStub(actionId);
        if (oldAction != null) {
            boolean isGroup;
            if (newAction instanceof OverridingAction) {
                this.myBaseActions.put((OverridingAction)newAction, oldAction);
            }
            if ((isGroup = oldAction instanceof ActionGroup) != newAction instanceof ActionGroup) {
                throw new IllegalStateException("cannot replace a group with an action and vice versa: " + actionId);
            }
            for (String groupId : this.myId2GroupId.get((Object)actionId)) {
                DefaultActionGroup group = (DefaultActionGroup)this.getActionOrStub(groupId);
                if (group == null) {
                    throw new IllegalStateException("Trying to replace action which has been added to a non-existing group " + groupId);
                }
                group.replaceAction(oldAction, newAction);
            }
            this.unregisterAction(actionId, false);
        }
        this.registerAction(actionId, newAction, pluginId);
        return oldAction;
    }

    public AnAction getBaseAction(OverridingAction overridingAction) {
        return this.myBaseActions.get(overridingAction);
    }

    public void addAnActionListener(AnActionListener listener2) {
        this.myActionListeners.add(listener2);
    }

    public void removeAnActionListener(AnActionListener listener2) {
        this.myActionListeners.remove(listener2);
    }

    public void fireBeforeActionPerformed(@NotNull AnAction action2, @NotNull DataContext dataContext, @NotNull AnActionEvent event) {
        if (action2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(78);
        }
        if (dataContext == null) {
            ActionManagerImpl.$$$reportNull$$$0(79);
        }
        if (event == null) {
            ActionManagerImpl.$$$reportNull$$$0(80);
        }
        this.myPrevPerformedActionId = this.myLastPreformedActionId;
        this.myLastPreformedActionId = this.getId(action2);
        if (this.myLastPreformedActionId == null && action2 instanceof ActionIdProvider) {
            this.myLastPreformedActionId = ((ActionIdProvider)action2).getId();
        }
        IdeaLogger.ourLastActionId = this.myLastPreformedActionId;
        PsiFile file2 = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        Language language = file2 != null ? file2.getLanguage() : null;
        ActionsCollector.getInstance().record((Project)CommonDataKeys.PROJECT.getData(dataContext), action2, event, language);
        for (AnActionListener listener2 : this.myActionListeners) {
            listener2.beforeActionPerformed(action2, dataContext, event);
        }
        this.messageBusPublisher.beforeActionPerformed(action2, dataContext, event);
    }

    public void fireAfterActionPerformed(@NotNull AnAction action2, @NotNull DataContext dataContext, @NotNull AnActionEvent event) {
        if (action2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(81);
        }
        if (dataContext == null) {
            ActionManagerImpl.$$$reportNull$$$0(82);
        }
        if (event == null) {
            ActionManagerImpl.$$$reportNull$$$0(83);
        }
        this.myPrevPerformedActionId = this.myLastPreformedActionId;
        IdeaLogger.ourLastActionId = this.myLastPreformedActionId = this.getId(action2);
        for (AnActionListener listener2 : this.myActionListeners) {
            try {
                listener2.afterActionPerformed(action2, dataContext, event);
            }
            catch (AbstractMethodError abstractMethodError) {}
        }
        this.messageBusPublisher.afterActionPerformed(action2, dataContext, event);
    }

    public KeyboardShortcut getKeyboardShortcut(@NotNull String actionId) {
        Shortcut[] shortcuts;
        if (actionId == null) {
            ActionManagerImpl.$$$reportNull$$$0(84);
        }
        AnAction action2 = ActionManager.getInstance().getAction(actionId);
        ShortcutSet shortcutSet = action2.getShortcutSet();
        for (Shortcut shortcut : shortcuts = shortcutSet.getShortcuts()) {
            KeyboardShortcut kb;
            if (!(shortcut instanceof KeyboardShortcut) || (kb = (KeyboardShortcut)shortcut).getSecondKeyStroke() != null) continue;
            return (KeyboardShortcut)shortcut;
        }
        return null;
    }

    public void fireBeforeEditorTyping(char c2, @NotNull DataContext dataContext) {
        if (dataContext == null) {
            ActionManagerImpl.$$$reportNull$$$0(85);
        }
        this.myLastTimeEditorWasTypedIn = System.currentTimeMillis();
        for (AnActionListener listener2 : this.myActionListeners) {
            listener2.beforeEditorTyping(c2, dataContext);
        }
        this.messageBusPublisher.beforeEditorTyping(c2, dataContext);
    }

    public String getLastPreformedActionId() {
        return this.myLastPreformedActionId;
    }

    public String getPrevPreformedActionId() {
        return this.myPrevPerformedActionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getActionIds() {
        Object object = this.myLock;
        synchronized (object) {
            return new HashSet<String>(this.myId2Action.keySet());
        }
    }

    public void preloadActions(ProgressIndicator indicator) {
        Application application = ApplicationManager.getApplication();
        for (String id : this.getActionIds()) {
            indicator.checkCanceled();
            if (application.isDisposeInProgress() || application.isDisposed()) {
                return;
            }
            AnAction action2 = this.getAction(id);
            if (!(action2 instanceof PreloadableAction)) continue;
            ((PreloadableAction)action2).preload();
        }
    }

    @NotNull
    public ActionCallback tryToExecute(@NotNull AnAction action2, @NotNull InputEvent inputEvent, @Nullable Component contextComponent, @Nullable String place, boolean now) {
        if (action2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(86);
        }
        if (inputEvent == null) {
            ActionManagerImpl.$$$reportNull$$$0(87);
        }
        Application app = ApplicationManager.getApplication();
        assert (app.isDispatchThread());
        ActionCallback result2 = new ActionCallback();
        Runnable doRunnable = () -> this.tryToExecuteNow(action2, inputEvent, contextComponent, place, result2);
        if (now) {
            doRunnable.run();
        } else {
            SwingUtilities.invokeLater(doRunnable);
        }
        ActionCallback actionCallback = result2;
        if (actionCallback == null) {
            ActionManagerImpl.$$$reportNull$$$0(88);
        }
        return actionCallback;
    }

    private void tryToExecuteNow(@NotNull AnAction action2, InputEvent inputEvent, Component contextComponent, String place, ActionCallback result2) {
        if (action2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(89);
        }
        Presentation presentation = action2.getTemplatePresentation().clone();
        IdeFocusManager.findInstanceByContext((DataContext)ActionManagerImpl.getContextBy(contextComponent)).doWhenFocusSettlesDown(() -> ((TransactionGuardImpl)TransactionGuard.getInstance()).performUserActivity(() -> {
            DataContext context = ActionManagerImpl.getContextBy(contextComponent);
            AnActionEvent event = new AnActionEvent(inputEvent, context, place != null ? place : "unknown", presentation, (ActionManager)this, inputEvent.getModifiersEx());
            ActionUtil.performDumbAwareUpdate((boolean)LaterInvocator.isInModalContext(), (AnAction)action2, (AnActionEvent)event, (boolean)false);
            if (!event.getPresentation().isEnabled()) {
                result2.setRejected();
                return;
            }
            ActionUtil.lastUpdateAndCheckDumb((AnAction)action2, (AnActionEvent)event, (boolean)false);
            if (!event.getPresentation().isEnabled()) {
                result2.setRejected();
                return;
            }
            Component component = (Component)PlatformDataKeys.CONTEXT_COMPONENT.getData(context);
            if (component != null && !component.isShowing() && !"TouchBarGeneral".equals(place)) {
                result2.setRejected();
                return;
            }
            this.fireBeforeActionPerformed(action2, context, event);
            UIUtil.addAwtListener(event1 -> {
                if (!(event1.getID() != 200 && event1.getID() != 205 || result2.isProcessed())) {
                    WindowEvent we = (WindowEvent)event1;
                    IdeFocusManager.findInstanceByComponent((Component)we.getWindow()).doWhenFocusSettlesDown(result2.createSetDoneRunnable(), ModalityState.defaultModalityState());
                }
            }, (long)64L, (Disposable)result2);
            ActionUtil.performActionDumbAware((AnAction)action2, (AnActionEvent)event);
            result2.setDone();
            this.queueActionPerformedEvent(action2, context, event);
        }), ModalityState.defaultModalityState());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 18: 
            case 27: 
            case 30: 
            case 33: 
            case 37: 
            case 40: 
            case 44: 
            case 64: 
            case 66: 
            case 88: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 18: 
            case 27: 
            case 30: 
            case 33: 
            case 37: 
            case 40: 
            case 44: 
            case 64: 
            case 66: 
            case 88: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: 
            case 34: 
            case 35: 
            case 45: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = ID_ATTR_NAME;
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loader";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionClass";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classLoader";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iconPath";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = ANCHOR_ELEMENT_NAME;
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionName";
                break;
            }
            case 14: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keymapManager";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 18: 
            case 27: 
            case 30: 
            case 33: 
            case 37: 
            case 40: 
            case 44: 
            case 64: 
            case 66: 
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/actionSystem/impl/ActionManagerImpl";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 23: 
            case 25: 
            case 28: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 24: 
            case 26: 
            case 29: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = GROUP_ELEMENT_NAME;
                break;
            }
            case 38: 
            case 49: 
            case 57: 
            case 59: 
            case 61: 
            case 69: 
            case 78: 
            case 81: 
            case 86: 
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = ACTION_ELEMENT_NAME;
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idPrefix";
                break;
            }
            case 41: 
            case 56: 
            case 58: 
            case 60: 
            case 62: 
            case 63: 
            case 74: 
            case 76: 
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionId";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionPlace";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageActionGroup";
                break;
            }
            case 46: 
            case 47: 
            case 50: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = KEYMAP_ATTR_NAME;
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortcut";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginName";
                break;
            }
            case 67: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "menu";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 71: 
            case 80: 
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 75: 
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newAction";
                break;
            }
            case 79: 
            case 82: 
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputEvent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/actionSystem/impl/ActionManagerImpl";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextBy";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "createActionPopupMenu";
                break;
            }
            case 30: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "createActionToolbar";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceStub";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionIds";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "createButtonToolbar";
                break;
            }
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "getRegistrationOrderComparator";
                break;
            }
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginActions";
                break;
            }
            case 88: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToExecute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "convertStub";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "updateIconFromStub";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "convertGroupStub";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processAbbreviationNode";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setIcon";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setIconFromClass";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "checkRelativeToAction";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "processMouseShortcutNode";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "reportActionError";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "reportActionWarning";
                break;
            }
            case 18: 
            case 27: 
            case 30: 
            case 33: 
            case 37: 
            case 40: 
            case 44: 
            case 64: 
            case 66: 
            case 88: {
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "addTimerListener";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "removeTimerListener";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "addTransparentTimerListener";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "removeTransparentTimerListener";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "createActionPopupMenu";
                break;
            }
            case 28: 
            case 29: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "createActionToolbar";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getAction";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getActionImpl";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "replaceStub";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getId";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getActionIds";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "isGroup";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "createButtonToolbar";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getActionOrStub";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "processActionElement";
                break;
            }
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "registerOrReplaceActionInner";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "processGroupElement";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "processKeyboardShortcutNode";
                break;
            }
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "processRemoveAndReplace";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "processActionsChildElement";
                break;
            }
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "registerAction";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "unregisterAction";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "getPluginActions";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "addActionPopup";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "removeActionPopup";
                break;
            }
            case 69: 
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "queueActionPerformedEvent";
                break;
            }
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "addActionPopupMenuListener";
                break;
            }
            case 74: 
            case 75: 
            case 76: 
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "replaceAction";
                break;
            }
            case 78: 
            case 79: 
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "fireBeforeActionPerformed";
                break;
            }
            case 81: 
            case 82: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "fireAfterActionPerformed";
                break;
            }
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "getKeyboardShortcut";
                break;
            }
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "fireBeforeEditorTyping";
                break;
            }
            case 86: 
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "tryToExecute";
                break;
            }
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "tryToExecuteNow";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 18: 
            case 27: 
            case 30: 
            case 33: 
            case 37: 
            case 40: 
            case 44: 
            case 64: 
            case 66: 
            case 88: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyTimer
    extends Timer
    implements ActionListener {
        private final List<TimerListener> myTimerListeners;
        private final List<TimerListener> myTransparentTimerListeners;
        private int myLastTimePerformed;

        private MyTimer() {
            super(500, null);
            this.myTimerListeners = ContainerUtil.createLockFreeCopyOnWriteList();
            this.myTransparentTimerListeners = ContainerUtil.createLockFreeCopyOnWriteList();
            this.addActionListener(this);
            this.setRepeats(true);
            MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect();
            connection.subscribe(ApplicationActivationListener.TOPIC, (Object)new ApplicationActivationListener(){

                public void applicationActivated(@NotNull IdeFrame ideFrame) {
                    if (ideFrame == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    MyTimer.this.setDelay(500);
                    MyTimer.this.restart();
                }

                public void applicationDeactivated(@NotNull IdeFrame ideFrame) {
                    if (ideFrame == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    MyTimer.this.setDelay(5000);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "ideFrame";
                    objectArray2[1] = "com/intellij/openapi/actionSystem/impl/ActionManagerImpl$MyTimer$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "applicationActivated";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "applicationDeactivated";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }

        public String toString() {
            return "Action manager timer";
        }

        void addTimerListener(@NotNull TimerListener listener2, boolean transparent) {
            if (listener2 == null) {
                MyTimer.$$$reportNull$$$0(0);
            }
            (transparent ? this.myTransparentTimerListeners : this.myTimerListeners).add(listener2);
        }

        void removeTimerListener(@NotNull TimerListener listener2, boolean transparent) {
            if (listener2 == null) {
                MyTimer.$$$reportNull$$$0(1);
            }
            (transparent ? this.myTransparentTimerListeners : this.myTimerListeners).remove(listener2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            if (ActionManagerImpl.this.myLastTimeEditorWasTypedIn + 500L > System.currentTimeMillis()) {
                return;
            }
            int lastEventCount = this.myLastTimePerformed;
            this.myLastTimePerformed = ActivityTracker.getInstance().getCount();
            if (this.myLastTimePerformed == lastEventCount && !Registry.is((String)"actionSystem.always.update.toolbar.actions")) {
                return;
            }
            boolean transparentOnly = this.myLastTimePerformed == lastEventCount;
            try {
                ActionManagerImpl.this.myTransparentOnlyUpdate = transparentOnly;
                HashSet notified = new HashSet();
                this.notifyListeners(this.myTransparentTimerListeners, notified);
                if (transparentOnly) {
                    return;
                }
                this.notifyListeners(this.myTimerListeners, notified);
            }
            finally {
                ActionManagerImpl.this.myTransparentOnlyUpdate = false;
            }
        }

        private void notifyListeners(List<? extends TimerListener> timerListeners, Set<? super TimerListener> notified) {
            for (TimerListener timerListener : timerListeners) {
                if (!notified.add((TimerListener)timerListener)) continue;
                this.runListenerAction(timerListener);
            }
        }

        private void runListenerAction(@NotNull TimerListener listener2) {
            ModalityState modalityState;
            if (listener2 == null) {
                MyTimer.$$$reportNull$$$0(2);
            }
            if ((modalityState = listener2.getModalityState()) == null) {
                return;
            }
            LOG.debug("notify ", new Object[]{listener2});
            if (!ModalityState.current().dominates(modalityState)) {
                try {
                    listener2.run();
                }
                catch (ProcessCanceledException processCanceledException) {
                }
                catch (Throwable e) {
                    LOG.error(e);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "listener";
            objectArray2[1] = "com/intellij/openapi/actionSystem/impl/ActionManagerImpl$MyTimer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addTimerListener";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "removeTimerListener";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "runListenerAction";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

