/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.largeFilesEditor.search;

import com.intellij.largeFilesEditor.search.Position;
import com.intellij.openapi.util.Key;

public class SearchResult {
    public static final Key<SearchResult> KEY = new Key("lfe.SearchResult");
    public final Position startPosition;
    public final Position endPostion;
    public final String contextPrefix;
    public final String stringToFind;
    public final String contextPostfix;

    public SearchResult(long startPageNumber, int startOffsetInPage, long endPageNumber, int endOffsetInPage, String contextPrefix, String stringToFind, String contextPostfix) {
        this.startPosition = new Position(startPageNumber, startOffsetInPage);
        this.endPostion = new Position(endPageNumber, endOffsetInPage);
        this.contextPrefix = contextPrefix == null ? "" : contextPrefix;
        this.stringToFind = stringToFind == null ? "" : stringToFind;
        this.contextPostfix = contextPostfix == null ? "" : contextPostfix;
    }

    public String toString() {
        return String.format("p%ds%d-p%ds%d: pref{%s},orig{%s},post{%s}", this.startPosition.pageNumber, this.startPosition.symbolOffsetInPage, this.endPostion.pageNumber, this.endPostion.symbolOffsetInPage, this.contextPrefix, this.stringToFind, this.contextPostfix);
    }

    public boolean equals(Object target2) {
        if (this == target2) {
            return true;
        }
        if (target2 instanceof SearchResult) {
            SearchResult targetResult = (SearchResult)target2;
            if (this.startPosition.equals(targetResult.startPosition) && this.endPostion.equals(targetResult.endPostion) && this.contextPrefix.equals(targetResult.contextPrefix) && this.stringToFind.equals(targetResult.stringToFind) && this.contextPostfix.equals(targetResult.contextPostfix)) {
                return true;
            }
        }
        return false;
    }
}

