/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.utils;

import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.featureStatistics.FeatureUsageTrackerImpl;
import com.intellij.internal.statistic.connect.StatisticsService;
import com.intellij.internal.statistic.eventLog.EventLogStatisticsService;
import com.intellij.internal.statistic.persistence.SentUsagesPersistence;
import com.intellij.internal.statistic.persistence.UsageStatisticsPersistenceComponent;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;

public class StatisticsUploadAssistant {
    private static final String IDEA_SUPPRESS_REPORT_STATISTICS = "idea.suppress.statistics.report";
    private static final String ENABLE_LOCAL_STATISTICS_WITHOUT_REPORT = "idea.local.statistics.without.report";
    public static final Object LOCK = new Object();

    private StatisticsUploadAssistant() {
    }

    public static boolean isShouldShowNotification() {
        return UsageStatisticsPersistenceComponent.getInstance().isShowNotification() && System.currentTimeMillis() - 604800000L > ((FeatureUsageTrackerImpl)FeatureUsageTracker.getInstance()).getFirstRunTime();
    }

    public static long getSendPeriodInMillis() {
        return UsageStatisticsPersistenceComponent.getInstance().getPeriod().getMillis();
    }

    public static boolean isTimeToSend() {
        return StatisticsUploadAssistant.isTimeToSend(UsageStatisticsPersistenceComponent.getInstance());
    }

    public static boolean isTimeToSend(UsageStatisticsPersistenceComponent settings) {
        long timeDelta = System.currentTimeMillis() - settings.getLastTimeSent();
        return Math.abs(timeDelta) > settings.getPeriod().getMillis();
    }

    public static boolean isSendAllowed() {
        return StatisticsUploadAssistant.isSendAllowed(UsageStatisticsPersistenceComponent.getInstance());
    }

    public static boolean isSendAllowed(SentUsagesPersistence settings) {
        return settings != null && settings.isAllowed() && !Boolean.getBoolean(IDEA_SUPPRESS_REPORT_STATISTICS) && !Boolean.getBoolean(ENABLE_LOCAL_STATISTICS_WITHOUT_REPORT);
    }

    public static boolean isCollectAllowed() {
        UsageStatisticsPersistenceComponent settings = UsageStatisticsPersistenceComponent.getInstance();
        return settings != null && settings.isAllowed() || Boolean.getBoolean(ENABLE_LOCAL_STATISTICS_WITHOUT_REPORT);
    }

    public static boolean isTestStatisticsEnabled() {
        return Boolean.getBoolean(ENABLE_LOCAL_STATISTICS_WITHOUT_REPORT) || StringUtil.isNotEmpty((String)System.getenv("TEAMCITY_VERSION"));
    }

    public static void updateSentTime() {
        UsageStatisticsPersistenceComponent.getInstance().setSentTime(System.currentTimeMillis());
    }

    @NotNull
    public static StatisticsService getEventLogStatisticsService(@NotNull String recorderId) {
        if (recorderId == null) {
            StatisticsUploadAssistant.$$$reportNull$$$0(0);
        }
        EventLogStatisticsService eventLogStatisticsService = new EventLogStatisticsService(recorderId);
        if (eventLogStatisticsService == null) {
            StatisticsUploadAssistant.$$$reportNull$$$0(1);
        }
        return eventLogStatisticsService;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recorderId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/utils/StatisticsUploadAssistant";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/utils/StatisticsUploadAssistant";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getEventLogStatisticsService";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getEventLogStatisticsService";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

