/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.service.fus.collectors;

import com.intellij.concurrency.JobScheduler;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.eventLog.FeatureUsageGroup;
import com.intellij.internal.statistic.eventLog.fus.FeatureUsageLogger;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsageCollectorEP;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FUCounterUsageLogger {
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger");
    private static final int LOG_REGISTERED_DELAY_MIN = 1440;
    private static final int LOG_REGISTERED_INITIAL_DELAY_MIN = 5;
    private static final String REGISTERED = "registered";
    private static final String[] GENERAL_GROUPS = new String[]{"event.log", "lifecycle", "performance", "actions", "ui.dialogs", "ui.settings", "toolwindow", "intentions", "toolbar", "run.configuration.exec", "file.types.usage", "productivity", "live.templates", "completion.postfix"};
    private static final FUCounterUsageLogger INSTANCE = new FUCounterUsageLogger();
    private final Map<String, EventLogGroup> myGroups = new HashMap<String, EventLogGroup>();

    @NotNull
    public static FUCounterUsageLogger getInstance() {
        FUCounterUsageLogger fUCounterUsageLogger = INSTANCE;
        if (fUCounterUsageLogger == null) {
            FUCounterUsageLogger.$$$reportNull$$$0(0);
        }
        return fUCounterUsageLogger;
    }

    public FUCounterUsageLogger() {
        int version2 = FeatureUsageLogger.INSTANCE.getConfig().getVersion();
        for (String group : GENERAL_GROUPS) {
            this.register(new EventLogGroup(group, version2));
        }
        for (CounterUsageCollectorEP ep : CounterUsageCollectorEP.EP_NAME.getExtensionList()) {
            String id = ep.getGroupId();
            if (!StringUtil.isNotEmpty((String)id)) continue;
            this.register(new EventLogGroup(id, ep.version));
        }
        JobScheduler.getScheduler().scheduleWithFixedDelay(() -> this.logRegisteredGroups(), 5L, 1440L, TimeUnit.MINUTES);
    }

    @Deprecated
    public void register(@NotNull FeatureUsageGroup group) {
        if (group == null) {
            FUCounterUsageLogger.$$$reportNull$$$0(1);
        }
    }

    private void register(@NotNull EventLogGroup group) {
        if (group == null) {
            FUCounterUsageLogger.$$$reportNull$$$0(2);
        }
        this.myGroups.put(group.getId(), group);
    }

    public void logRegisteredGroups() {
        for (EventLogGroup group : this.myGroups.values()) {
            FeatureUsageLogger.INSTANCE.log(group, REGISTERED);
        }
    }

    public void logEvent(@NotNull Project project, @NotNull String groupId, @NotNull String eventId) {
        EventLogGroup group;
        if (project == null) {
            FUCounterUsageLogger.$$$reportNull$$$0(3);
        }
        if (groupId == null) {
            FUCounterUsageLogger.$$$reportNull$$$0(4);
        }
        if (eventId == null) {
            FUCounterUsageLogger.$$$reportNull$$$0(5);
        }
        if ((group = this.findRegisteredGroupById(groupId)) != null) {
            Map<String, Object> data = new FeatureUsageData().addProject(project).build();
            FeatureUsageLogger.INSTANCE.log(group, eventId, data);
        }
    }

    public void logEvent(@NotNull Project project, @NotNull String groupId, @NotNull String eventId, @NotNull FeatureUsageData data) {
        EventLogGroup group;
        if (project == null) {
            FUCounterUsageLogger.$$$reportNull$$$0(6);
        }
        if (groupId == null) {
            FUCounterUsageLogger.$$$reportNull$$$0(7);
        }
        if (eventId == null) {
            FUCounterUsageLogger.$$$reportNull$$$0(8);
        }
        if (data == null) {
            FUCounterUsageLogger.$$$reportNull$$$0(9);
        }
        if ((group = this.findRegisteredGroupById(groupId)) != null) {
            FeatureUsageLogger.INSTANCE.log(group, eventId, data.addProject(project).build());
        }
    }

    public void logEvent(@NotNull String groupId, @NotNull String eventId) {
        EventLogGroup group;
        if (groupId == null) {
            FUCounterUsageLogger.$$$reportNull$$$0(10);
        }
        if (eventId == null) {
            FUCounterUsageLogger.$$$reportNull$$$0(11);
        }
        if ((group = this.findRegisteredGroupById(groupId)) != null) {
            FeatureUsageLogger.INSTANCE.log(group, eventId);
        }
    }

    public void logEvent(@NotNull String groupId, @NotNull String eventId, @NotNull FeatureUsageData data) {
        EventLogGroup group;
        if (groupId == null) {
            FUCounterUsageLogger.$$$reportNull$$$0(12);
        }
        if (eventId == null) {
            FUCounterUsageLogger.$$$reportNull$$$0(13);
        }
        if (data == null) {
            FUCounterUsageLogger.$$$reportNull$$$0(14);
        }
        if ((group = this.findRegisteredGroupById(groupId)) != null) {
            FeatureUsageLogger.INSTANCE.log(group, eventId, data.build());
        }
    }

    @Nullable
    private EventLogGroup findRegisteredGroupById(@NotNull String groupId) {
        if (groupId == null) {
            FUCounterUsageLogger.$$$reportNull$$$0(15);
        }
        if (!this.myGroups.containsKey(groupId)) {
            LOG.warn("Cannot record event because group '" + groupId + "' is not registered.");
            return null;
        }
        return this.myGroups.get(groupId);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/service/fus/collectors/FUCounterUsageLogger";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupId";
                break;
            }
            case 5: 
            case 8: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventId";
                break;
            }
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/service/fus/collectors/FUCounterUsageLogger";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "register";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "logEvent";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findRegisteredGroupById";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

