/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.validator.persistence;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.text.StringUtil;
import java.util.HashMap;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

@State(name="EventLogWhitelist", storages={@Storage(value="usage.statistics.xml", roamingType=RoamingType.DISABLED)})
public class EventLogWhitelistSettingsPersistence
implements PersistentStateComponent<Element> {
    private final Map<String, Long> myLastModifications = new HashMap<String, Long>();
    private static final String WHITELIST_MODIFY = "update";
    private static final String RECORDER_ID = "recorder-id";
    private static final String LAST_MODIFIED = "last-modified";

    public static EventLogWhitelistSettingsPersistence getInstance() {
        return (EventLogWhitelistSettingsPersistence)ServiceManager.getService(EventLogWhitelistSettingsPersistence.class);
    }

    public long getLastModified(@NotNull String recorderId) {
        if (recorderId == null) {
            EventLogWhitelistSettingsPersistence.$$$reportNull$$$0(0);
        }
        return this.myLastModifications.containsKey(recorderId) ? Math.max(this.myLastModifications.get(recorderId), 0L) : 0L;
    }

    public void setLastModified(@NotNull String recorderId, long lastUpdate) {
        if (recorderId == null) {
            EventLogWhitelistSettingsPersistence.$$$reportNull$$$0(1);
        }
        this.myLastModifications.put(recorderId, Math.max(lastUpdate, 0L));
    }

    public void loadState(@NotNull Element element) {
        if (element == null) {
            EventLogWhitelistSettingsPersistence.$$$reportNull$$$0(2);
        }
        this.myLastModifications.clear();
        for (Element update2 : element.getChildren(WHITELIST_MODIFY)) {
            String recorder = update2.getAttributeValue(RECORDER_ID);
            if (!StringUtil.isNotEmpty((String)recorder)) continue;
            long lastUpdate = EventLogWhitelistSettingsPersistence.parseLastUpdate(update2);
            this.myLastModifications.put(recorder, lastUpdate);
        }
    }

    private static long parseLastUpdate(@NotNull Element update2) {
        if (update2 == null) {
            EventLogWhitelistSettingsPersistence.$$$reportNull$$$0(3);
        }
        try {
            return Long.parseLong(update2.getAttributeValue(LAST_MODIFIED, "0"));
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    public Element getState() {
        Element element = new Element("state");
        for (Map.Entry<String, Long> entry : this.myLastModifications.entrySet()) {
            Element update2 = new Element(WHITELIST_MODIFY);
            update2.setAttribute(RECORDER_ID, entry.getKey());
            update2.setAttribute(LAST_MODIFIED, String.valueOf(entry.getValue()));
            element.addContent(update2);
        }
        return element;
    }

    public void noStateLoaded() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recorderId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = WHITELIST_MODIFY;
                break;
            }
        }
        objectArray2[1] = "com/intellij/internal/statistic/eventLog/validator/persistence/EventLogWhitelistSettingsPersistence";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getLastModified";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "setLastModified";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "loadState";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "parseLastUpdate";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

