/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.services;

import com.intellij.execution.services.ServiceEventListener;
import com.intellij.execution.services.ServiceModel;
import com.intellij.execution.services.ServiceModelFilter;
import com.intellij.execution.services.ServiceView;
import com.intellij.execution.services.ServiceViewContributor;
import com.intellij.execution.services.ServiceViewDragHelper;
import com.intellij.execution.services.ServiceViewManager;
import com.intellij.execution.services.ServiceViewModel;
import com.intellij.execution.services.ServiceViewNonActivatingDescriptor;
import com.intellij.execution.services.ServiceViewSourceScrollHelper;
import com.intellij.execution.services.ServiceViewState;
import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.TreeState;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.AutoScrollToSourceHandler;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerAdapter;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

@com.intellij.openapi.components.State(name="ServiceViewManager", storages={@Storage(value="$WORKSPACE_FILE$")})
public final class ServiceViewManagerImpl
implements ServiceViewManager,
PersistentStateComponent<State> {
    @NonNls
    private static final String HELP_ID = "services.tool.window";
    private final Project myProject;
    private State myState;
    private final ServiceModel myModel;
    private final ServiceModelFilter myModelFilter;
    private ServiceView myAllServicesView;
    private final List<ServiceView> myServiceViews;
    private ContentManager myContentManager;
    private Content myAllServicesContent;
    private AutoScrollToSourceHandler myAutoScrollToSourceHandler;

    public ServiceViewManagerImpl(@NotNull Project project) {
        if (project == null) {
            ServiceViewManagerImpl.$$$reportNull$$$0(0);
        }
        this.myState = new State();
        this.myServiceViews = ContainerUtil.newSmartList();
        this.myProject = project;
        this.myModel = new ServiceModel(this.myProject);
        Disposer.register((Disposable)this.myProject, (Disposable)this.myModel);
        this.myModelFilter = new ServiceModelFilter();
        this.myProject.getMessageBus().connect((Disposable)this.myModel).subscribe(ServiceEventListener.TOPIC, e -> this.myModel.refresh(e).onSuccess(o -> {
            List<? extends ServiceModel.ServiceViewItem> roots = this.myModel.getRoots();
            ServiceModel.ServiceViewItem eventRoot = (ServiceModel.ServiceViewItem)ContainerUtil.find(roots, root -> e.contributorClass.isInstance(root.getRootContributor()));
            this.updateToolWindow(!roots.isEmpty(), eventRoot != null && !(eventRoot.getViewDescriptor() instanceof ServiceViewNonActivatingDescriptor), false);
            this.processAllModels(viewModel -> viewModel.eventProcessed(e));
        }));
        this.myModel.initRoots().onSuccess(o -> {
            List<? extends ServiceModel.ServiceViewItem> roots = this.myModel.getRoots();
            this.updateToolWindow(!roots.isEmpty(), roots.stream().anyMatch(root -> !(root.getViewDescriptor() instanceof ServiceViewNonActivatingDescriptor)), true);
        });
    }

    void createToolWindowContent(@NotNull ToolWindow toolWindow) {
        if (toolWindow == null) {
            ServiceViewManagerImpl.$$$reportNull$$$0(1);
        }
        this.myContentManager = toolWindow.getContentManager();
        this.myContentManager.addContentManagerListener((ContentManagerListener)new MyContentMangerListener());
        ToolWindowEx toolWindowEx = (ToolWindowEx)toolWindow;
        this.myAutoScrollToSourceHandler = ServiceViewSourceScrollHelper.installAutoScrollSupport(this.myProject, toolWindowEx);
        this.createAllServicesView();
        this.loadViews();
        ServiceViewManagerImpl.registerActivateByContributorActions();
        ServiceViewDragHelper.installDnDSupport(this.myProject, toolWindowEx.getDecorator(), this.myContentManager);
    }

    private void createAllServicesView() {
        this.myAllServicesView = ServiceView.createView(this.myProject, new ServiceViewModel.AllServicesModel(this.myModel, this.myModelFilter), this.prepareViewState(this.myState.allServicesViewState));
        this.myAllServicesContent = ContentFactory.SERVICE.getInstance().createContent((JComponent)this.myAllServicesView, null, false);
        this.myAllServicesContent.putUserData(ToolWindow.SHOW_CONTENT_ICON, (Object)Boolean.TRUE);
        this.myAllServicesContent.setHelpId(ServiceViewManagerImpl.getToolWindowContextHelpId());
        this.myAllServicesContent.setCloseable(false);
        Disposer.register((Disposable)this.myAllServicesContent, (Disposable)this.myAllServicesView);
        Disposer.register((Disposable)this.myAllServicesContent, (Disposable)this.myAllServicesView.getModel());
        Disposer.register((Disposable)this.myAllServicesContent, () -> {
            this.myAllServicesView = null;
            this.myAllServicesContent = null;
            this.myServiceViews.clear();
            this.myContentManager = null;
        });
        this.setScrollToSourceHandler(this.myAllServicesView);
        this.myContentManager.addContent(this.myAllServicesContent);
        this.myAllServicesView.getModel().addModelListener(() -> {
            boolean isEmpty = this.myAllServicesView.getModel().getRoots().isEmpty();
            AppUIUtil.invokeOnEdt(() -> {
                if (isEmpty) {
                    if (this.myContentManager.getIndexOfContent(this.myAllServicesContent) >= 0) {
                        this.myContentManager.removeContent(this.myAllServicesContent, false);
                    }
                } else if (this.myContentManager.getIndexOfContent(this.myAllServicesContent) < 0) {
                    this.myContentManager.addContent(this.myAllServicesContent, 0);
                }
            }, this.myProject.getDisposed());
        });
    }

    private void loadViews() {
        this.myModel.getInvoker().invokeLater(() -> {
            Map contributors = FactoryMap.create(className -> {
                for (ServiceViewContributor contributor : ServiceModel.getContributors()) {
                    if (!className.equals(contributor.getClass().getName())) continue;
                    return contributor;
                }
                return null;
            });
            ArrayList<ServiceModelFilter.ServiceViewFilter> filters = new ArrayList<ServiceModelFilter.ServiceViewFilter>();
            ArrayList<Pair> loadedModels = new ArrayList<Pair>();
            ServiceViewModel toSelect2 = null;
            for (int i = 0; i < this.myState.viewStates.size(); ++i) {
                ServiceViewState viewState = this.myState.viewStates.get(i);
                ServiceModelFilter.ServiceViewFilter parentFilter = null;
                if (viewState.parentView >= 0 && viewState.parentView < filters.size()) {
                    parentFilter = (ServiceModelFilter.ServiceViewFilter)filters.get(viewState.parentView);
                }
                ServiceModelFilter.ServiceViewFilter filter = parentFilter;
                ServiceViewModel viewModel = ServiceViewModel.loadModel(viewState, this.myModel, this.myModelFilter, parentFilter, contributors);
                if (viewModel != null) {
                    loadedModels.add(Pair.create((Object)viewModel, (Object)viewState));
                    if (this.myState.selectedView == i) {
                        toSelect2 = viewModel;
                    }
                    filter = viewModel.getFilter();
                }
                filters.add(filter);
            }
            if (!loadedModels.isEmpty()) {
                ServiceViewModel modelToSelect = toSelect2;
                AppUIUtil.invokeOnEdt(() -> {
                    for (Pair pair : loadedModels) {
                        this.extract((ServiceViewModel)pair.first, (ServiceViewState)pair.second, false);
                    }
                    this.selectContentByModel(modelToSelect);
                    this.filtersChanged();
                }, this.myProject.getDisposed());
            }
        });
    }

    private void selectContentByModel(@Nullable ServiceViewModel modelToSelect) {
        if (modelToSelect != null) {
            for (Content content2 : this.myContentManager.getContents()) {
                ServiceView serviceView = ServiceViewManagerImpl.getServiceView(content2);
                if (serviceView == null || serviceView.getModel() != modelToSelect) continue;
                this.myContentManager.setSelectedContent(content2);
                break;
            }
        } else {
            Content content3 = this.myContentManager.getContent(0);
            if (content3 != null) {
                this.myContentManager.setSelectedContent(content3);
            }
        }
    }

    private void processAllModels(Consumer<ServiceViewModel> consumer) {
        AppUIUtil.invokeOnEdt(() -> {
            ArrayList<ServiceViewModel> models = new ArrayList<ServiceViewModel>();
            ServiceView allServicesView = this.myAllServicesView;
            if (allServicesView != null) {
                models.add(allServicesView.getModel());
            }
            for (ServiceView serviceView : this.myServiceViews) {
                models.add(serviceView.getModel());
            }
            this.myModel.getInvoker().invokeLater(() -> {
                for (ServiceViewModel viewModel : models) {
                    consumer.accept(viewModel);
                }
            });
        }, this.myProject.getDisposed());
    }

    private void filtersChanged() {
        this.processAllModels(ServiceViewModel::filtersChanged);
    }

    private static void registerActivateByContributorActions() {
        for (ServiceViewContributor contributor : ServiceModel.getContributors()) {
            Object action2;
            ActionManager actionManager = ActionManager.getInstance();
            String actionId = ServiceViewManagerImpl.getActivateContributorActionId(contributor);
            if (actionId == null || (action2 = actionManager.getAction(actionId)) != null) continue;
            action2 = new ActivateToolWindowByContributorAction(contributor);
            actionManager.registerAction(actionId, action2);
        }
    }

    @NotNull
    public Promise<Void> select(@NotNull Object service, @NotNull Class<?> contributorClass, boolean activate, boolean focus) {
        if (service == null) {
            ServiceViewManagerImpl.$$$reportNull$$$0(2);
        }
        if (contributorClass == null) {
            ServiceViewManagerImpl.$$$reportNull$$$0(3);
        }
        AsyncPromise result2 = new AsyncPromise();
        this.myModel.getInvoker().runOrInvokeLater(() -> AppUIUtil.invokeLaterIfProjectAlive(this.myProject, () -> {
            ToolWindow window;
            Runnable runnable2 = () -> {
                List contents;
                ContentManager contentManager = this.myContentManager;
                List list2 = contents = contentManager == null ? Collections.emptyList() : ContainerUtil.newSmartList((Object[])contentManager.getContents());
                if (contents.isEmpty()) {
                    result2.setError("Content not initialized");
                    return;
                }
                Collections.reverse(contents);
                ServiceViewManagerImpl.select(this.myProject, contents.iterator(), (AsyncPromise<Void>)result2, service, contributorClass, focus);
            };
            ToolWindow toolWindow = window = activate ? ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(ToolWindowId.SERVICES) : null;
            if (window != null) {
                window.activate(runnable2, focus, focus);
            } else {
                runnable2.run();
            }
        }));
        AsyncPromise asyncPromise = result2;
        if (asyncPromise == null) {
            ServiceViewManagerImpl.$$$reportNull$$$0(4);
        }
        return asyncPromise;
    }

    private static void select(Project project, Iterator<Content> iterator, AsyncPromise<Void> result2, @NotNull Object service, @NotNull Class<?> contributorClass, boolean focus) {
        Content content2;
        ServiceView serviceView;
        if (service == null) {
            ServiceViewManagerImpl.$$$reportNull$$$0(5);
        }
        if (contributorClass == null) {
            ServiceViewManagerImpl.$$$reportNull$$$0(6);
        }
        if ((serviceView = ServiceViewManagerImpl.getServiceView(content2 = iterator.next())) == null) {
            if (iterator.hasNext()) {
                ServiceViewManagerImpl.select(project, iterator, result2, service, contributorClass, focus);
            } else {
                result2.setError("Not services content");
            }
            return;
        }
        serviceView.select(service, contributorClass).onSuccess(v -> {
            AppUIUtil.invokeOnEdt(() -> {
                ContentManager contentManager = content2.getManager();
                if (contentManager == null) {
                    return;
                }
                if (contentManager.getSelectedContent() != content2 && contentManager.getIndexOfContent(content2) >= 0) {
                    contentManager.setSelectedContent(content2, focus);
                }
            }, project.getDisposed());
            result2.setResult(null);
        }).onError(e -> {
            if (iterator.hasNext()) {
                ServiceViewManagerImpl.select(project, iterator, result2, service, contributorClass, focus);
            } else {
                result2.setError(e);
            }
        });
    }

    private void updateToolWindow(boolean available, boolean show, boolean onInit) {
        ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)this.myProject);
        if (toolWindowManager == null) {
            return;
        }
        toolWindowManager.invokeLater(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            boolean doShow = available && (!onInit || this.myContentManager != null);
            ToolWindow toolWindow = toolWindowManager.getToolWindow(ToolWindowId.SERVICES);
            if (toolWindow == null) {
                toolWindow = this.createToolWindow(toolWindowManager, available);
                if (doShow) {
                    toolWindow.show(null);
                }
                return;
            }
            doShow = show && !toolWindow.isAvailable() && doShow;
            toolWindow.setAvailable(available, null);
            if (doShow) {
                toolWindow.show(null);
            }
        });
    }

    @NotNull
    private ToolWindowEx createToolWindow(ToolWindowManager toolWindowManager, boolean available) {
        String id = ServiceViewManagerImpl.getToolWindowId();
        ToolWindowEx toolWindow = (ToolWindowEx)toolWindowManager.registerToolWindow(id, true, ToolWindowAnchor.BOTTOM, (Disposable)this.myProject, true);
        toolWindow.setIcon(ServiceViewManagerImpl.getToolWindowIcon());
        toolWindow.setAvailable(available, null);
        this.createToolWindowContent(toolWindow);
        ToolWindowEx toolWindowEx = toolWindow;
        if (toolWindowEx == null) {
            ServiceViewManagerImpl.$$$reportNull$$$0(7);
        }
        return toolWindowEx;
    }

    void extract(@NotNull ServiceViewDragHelper.ServiceViewDragBean dragBean) {
        List<ServiceModel.ServiceViewItem> items;
        if (dragBean == null) {
            ServiceViewManagerImpl.$$$reportNull$$$0(8);
        }
        if ((items = dragBean.getItems()).isEmpty()) {
            return;
        }
        ServiceView selectedView = dragBean.getServiceView();
        ServiceModelFilter.ServiceViewFilter parentFilter = selectedView == null ? null : selectedView.getModel().getFilter();
        ServiceViewModel viewModel = ServiceViewModel.createModel(items, dragBean.getContributor(), this.myModel, this.myModelFilter, parentFilter);
        this.extract(viewModel, new ServiceViewState(), true);
    }

    private void extract(ServiceViewModel viewModel, ServiceViewState viewState, boolean select) {
        ServiceView serviceView = ServiceView.createView(this.myProject, viewModel, this.prepareViewState(viewState));
        if (viewModel instanceof ServiceViewModel.ContributorModel) {
            this.extractContributor((ServiceViewModel.ContributorModel)viewModel, serviceView, select);
        } else if (viewModel instanceof ServiceViewModel.GroupModel) {
            this.extractGroup((ServiceViewModel.GroupModel)viewModel, serviceView, select);
        } else if (viewModel instanceof ServiceViewModel.SingeServiceModel) {
            this.extractService((ServiceViewModel.SingeServiceModel)viewModel, serviceView, select);
        } else if (viewModel instanceof ServiceViewModel.ServiceListModel) {
            this.extractList((ServiceViewModel.ServiceListModel)viewModel, serviceView, viewState.id, select, -1);
        }
    }

    private void extractContributor(ServiceViewModel.ContributorModel viewModel, ServiceView serviceView, boolean select) {
        this.addServiceView(serviceView, viewModel.getContributor().getViewDescriptor().getContentPresentation(), select);
    }

    private void extractGroup(ServiceViewModel.GroupModel viewModel, ServiceView serviceView, boolean select) {
        Content content2 = this.addServiceView(serviceView, viewModel.getGroup().getViewDescriptor().getContentPresentation(), select);
        viewModel.addModelListener(() -> this.updateContentTab(viewModel.getGroup(), content2));
    }

    private void extractService(ServiceViewModel.SingeServiceModel viewModel, ServiceView serviceView, boolean select) {
        Content content2 = this.addServiceView(serviceView, viewModel.getService().getViewDescriptor().getContentPresentation(), select);
        viewModel.addModelListener(() -> {
            ServiceModel.ServiceViewItem item = viewModel.getService();
            if (item != null && !viewModel.getChildren(item).isEmpty()) {
                AppUIUtil.invokeOnEdt(() -> {
                    int index = this.myContentManager.getIndexOfContent(content2);
                    if (index < 0) {
                        return;
                    }
                    this.myContentManager.removeContent(content2, true);
                    ServiceViewModel.ServiceListModel listModel = new ServiceViewModel.ServiceListModel(this.myModel, this.myModelFilter, ContainerUtil.newSmartList((Object)item), viewModel.getFilter().getParent());
                    ServiceView listView = ServiceView.createView(this.myProject, listModel, this.prepareViewState(new ServiceViewState()));
                    this.extractList(listModel, listView, null, true, index);
                }, this.myProject.getDisposed());
            } else {
                this.updateContentTab(item, content2);
            }
        });
    }

    private void extractList(ServiceViewModel.ServiceListModel viewModel, ServiceView serviceView, String name, boolean select, int index) {
        ItemPresentation presentation;
        List<ServiceModel.ServiceViewItem> items = viewModel.getItems();
        if (items.size() == 1) {
            presentation = items.get(0).getViewDescriptor().getContentPresentation();
        } else {
            if (StringUtil.isEmpty((String)name) && StringUtil.isEmpty((String)(name = Messages.showInputDialog((Project)this.myProject, (String)"Group Name:", (String)"Group Services", null, null, null)))) {
                return;
            }
            presentation = new PresentationData(name, null, AllIcons.Nodes.Folder, null);
        }
        Content content2 = this.addServiceView(serviceView, presentation, select, index);
        viewModel.addModelListener(() -> this.updateContentTab((ServiceModel.ServiceViewItem)ContainerUtil.getOnlyItem(viewModel.getRoots()), content2));
    }

    private Content addServiceView(ServiceView serviceView, ItemPresentation presentation, boolean select) {
        return this.addServiceView(serviceView, presentation, select, -1);
    }

    private Content addServiceView(ServiceView serviceView, ItemPresentation presentation, boolean select, int index) {
        int viewIndex = index == -1 ? -1 : (this.myContentManager.getIndexOfContent(this.myAllServicesContent) >= 0 ? index - 1 : index);
        this.myServiceViews.add(viewIndex == -1 || viewIndex > this.myServiceViews.size() ? this.myServiceViews.size() : viewIndex, serviceView);
        List<ServiceModelFilter.ServiceViewFilter> filters = this.myModelFilter.getFilters();
        filters.add(viewIndex == -1 || viewIndex > filters.size() ? filters.size() : viewIndex, serviceView.getModel().getFilter());
        Content content2 = ContentFactory.SERVICE.getInstance().createContent((JComponent)serviceView, ServiceViewDragHelper.getDisplayName(presentation), false);
        content2.putUserData(ToolWindow.SHOW_CONTENT_ICON, (Object)Boolean.TRUE);
        content2.setHelpId(ServiceViewManagerImpl.getToolWindowContextHelpId());
        content2.setCloseable(true);
        content2.setIcon(presentation.getIcon(false));
        Disposer.register((Disposable)content2, (Disposable)serviceView);
        Disposer.register((Disposable)content2, (Disposable)serviceView.getModel());
        this.setScrollToSourceHandler(serviceView);
        this.myContentManager.addContent(content2, index);
        if (select) {
            this.myContentManager.setSelectedContent(content2);
        }
        serviceView.getModel().addModelListener(() -> {
            if (serviceView.getModel().getRoots().isEmpty()) {
                AppUIUtil.invokeOnEdt(() -> this.myContentManager.removeContent(content2, true), this.myProject.getDisposed());
            }
        });
        this.filtersChanged();
        return content2;
    }

    @Nullable
    private ServiceView getSelectedView() {
        ContentManager contentManager = this.myContentManager;
        Content content2 = contentManager == null ? null : contentManager.getSelectedContent();
        return content2 == null ? null : ServiceViewManagerImpl.getServiceView(content2);
    }

    private void setScrollToSourceHandler(ServiceView serviceView) {
        AutoScrollToSourceHandler toSourceHandler = this.myAutoScrollToSourceHandler;
        if (toSourceHandler != null) {
            serviceView.setAutoScrollToSourceHandler(toSourceHandler);
        }
    }

    @Nullable
    private static ServiceView getServiceView(Content content2) {
        return (ServiceView)ObjectUtils.tryCast((Object)content2.getComponent(), ServiceView.class);
    }

    private void updateContentTab(ServiceModel.ServiceViewItem item, Content content2) {
        if (item != null) {
            AppUIUtil.invokeOnEdt(() -> {
                ItemPresentation itemPresentation = item.getViewDescriptor().getContentPresentation();
                content2.setDisplayName(ServiceViewDragHelper.getDisplayName(itemPresentation));
                content2.setIcon(itemPresentation.getIcon(false));
            }, this.myProject.getDisposed());
        }
    }

    @NotNull
    public State getState() {
        if (this.myAllServicesView != null) {
            this.myAllServicesView.saveState(this.myState.allServicesViewState);
            this.myState.allServicesViewState.treeStateElement = new Element("root");
            this.myState.allServicesViewState.treeState.writeExternal(this.myState.allServicesViewState.treeStateElement);
        }
        this.myState.viewStates.clear();
        for (ServiceView serviceView : this.myServiceViews) {
            ServiceViewState viewState = new ServiceViewState();
            this.myState.viewStates.add(viewState);
            serviceView.saveState(viewState);
            ServiceViewModel viewModel = serviceView.getModel();
            if (viewModel instanceof ServiceViewModel.ServiceListModel) {
                viewState.id = this.myContentManager.getContent((JComponent)serviceView).getDisplayName();
            }
            viewState.parentView = this.myModelFilter.getFilters().indexOf(viewModel.getFilter().getParent());
            viewState.treeStateElement = new Element("root");
            viewState.treeState.writeExternal(viewState.treeStateElement);
        }
        if (this.myContentManager != null) {
            this.myState.selectedView = this.myServiceViews.indexOf(this.getSelectedView());
        }
        State state = this.myState;
        if (state == null) {
            ServiceViewManagerImpl.$$$reportNull$$$0(9);
        }
        return state;
    }

    public void loadState(@NotNull State state) {
        if (state == null) {
            ServiceViewManagerImpl.$$$reportNull$$$0(10);
        }
        this.myState = state;
        for (ServiceViewState viewState : this.myState.viewStates) {
            viewState.treeState = TreeState.createFrom((Element)viewState.treeStateElement);
        }
    }

    private static String getToolWindowId() {
        return ToolWindowId.SERVICES;
    }

    private static Icon getToolWindowIcon() {
        return AllIcons.Toolwindows.ToolWindowServices;
    }

    static String getToolWindowContextHelpId() {
        return HELP_ID;
    }

    private ServiceViewState prepareViewState(ServiceViewState state) {
        state.showServicesTree = this.myState.showServicesTree;
        return state;
    }

    boolean isShowServicesTree() {
        return this.myState.showServicesTree;
    }

    void setShowServicesTree(boolean value) {
        this.myState.showServicesTree = value;
        ServiceView allServicesView = this.myAllServicesView;
        if (allServicesView != null) {
            allServicesView.getUi().setMasterComponentVisible(value);
        }
        for (ServiceView serviceView : this.myServiceViews) {
            serviceView.getUi().setMasterComponentVisible(value);
        }
    }

    boolean isSplitByTypeEnabled() {
        ContentManager contentManager = this.myContentManager;
        if (contentManager == null) {
            return false;
        }
        if (contentManager.getIndexOfContent(this.myAllServicesContent) < 0) {
            return false;
        }
        for (ServiceView serviceView : this.myServiceViews) {
            if (serviceView.getModel() instanceof ServiceViewModel.ContributorModel) continue;
            return false;
        }
        return true;
    }

    void splitByType() {
        this.myModel.getInvoker().invokeLater(() -> {
            List contributors = ContainerUtil.map(this.myModel.getRoots(), ServiceModel.ServiceViewItem::getContributor);
            AppUIUtil.invokeOnEdt(() -> {
                for (ServiceViewContributor contributor : contributors) {
                    this.splitByType(contributor);
                }
            });
        });
    }

    private void splitByType(ServiceViewContributor contributor) {
        for (ServiceView serviceView : this.myServiceViews) {
            ServiceViewModel viewModel = serviceView.getModel();
            if (!(viewModel instanceof ServiceViewModel.ContributorModel) || !contributor.equals(((ServiceViewModel.ContributorModel)viewModel).getContributor())) continue;
            return;
        }
        ServiceViewModel.ContributorModel contributorModel = new ServiceViewModel.ContributorModel(this.myModel, this.myModelFilter, contributor, null);
        ServiceView contributorView = ServiceView.createView(this.myProject, contributorModel, this.prepareViewState(new ServiceViewState()));
        this.extractContributor(contributorModel, contributorView, true);
    }

    public List<Object> getChildrenSafe(@NotNull List<Object> valueSubPath) {
        Content content2;
        ServiceView serviceView;
        if (valueSubPath == null) {
            ServiceViewManagerImpl.$$$reportNull$$$0(11);
        }
        ServiceView serviceView2 = serviceView = (content2 = this.myContentManager.getSelectedContent()) == null ? null : ServiceViewManagerImpl.getServiceView(content2);
        if (serviceView == null) {
            return Collections.emptyList();
        }
        return serviceView.getChildrenSafe(valueSubPath);
    }

    private static String getActivateContributorActionId(ServiceViewContributor contributor) {
        String id = contributor.getViewDescriptor().getId();
        return id == null ? null : "ServiceView.Activate" + id.replaceAll(" ", "");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 7: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 7: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindow";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contributorClass";
                break;
            }
            case 4: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/services/ServiceViewManagerImpl";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dragBean";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueSubPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/services/ServiceViewManagerImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "select";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createToolWindow";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createToolWindowContent";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "select";
                break;
            }
            case 4: 
            case 7: 
            case 9: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "extract";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getChildrenSafe";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 7: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ActivateToolWindowByContributorAction
    extends DumbAwareAction {
        private final ServiceViewContributor myContributor;

        private ActivateToolWindowByContributorAction(ServiceViewContributor contributor) {
            this.myContributor = contributor;
            ItemPresentation presentation = contributor.getViewDescriptor().getPresentation();
            Presentation templatePresentation = this.getTemplatePresentation();
            templatePresentation.setText(ServiceViewDragHelper.getDisplayName(presentation) + " (Services)");
            templatePresentation.setIcon(presentation.getIcon(false));
            templatePresentation.setDescription("Activate " + ServiceViewManagerImpl.getToolWindowId() + " window");
        }

        public void update(@NotNull AnActionEvent e) {
            Project project;
            if (e == null) {
                ActivateToolWindowByContributorAction.$$$reportNull$$$0(0);
            }
            if ((project = e.getProject()) == null) {
                e.getPresentation().setEnabledAndVisible(false);
                return;
            }
            ServiceViewManagerImpl manager = (ServiceViewManagerImpl)ServiceViewManager.getInstance((Project)project);
            for (ServiceModel.ServiceViewItem serviceViewItem : manager.myModel.getRoots()) {
                if (!this.myContributor.equals(serviceViewItem.getContributor())) continue;
                e.getPresentation().setEnabledAndVisible(true);
                return;
            }
            e.getPresentation().setEnabledAndVisible(false);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Project project;
            if (e == null) {
                ActivateToolWindowByContributorAction.$$$reportNull$$$0(1);
            }
            if ((project = e.getProject()) == null) {
                return;
            }
            ToolWindowManager windowManager = ToolWindowManager.getInstance((Project)project);
            ToolWindow window = windowManager.getToolWindow(ServiceViewManagerImpl.getToolWindowId());
            if (window.isActive()) {
                this.selectContributorView(project);
            } else {
                window.activate(() -> this.selectContributorView(project));
            }
        }

        private void selectContributorView(Project project) {
            ServiceViewManagerImpl manager = (ServiceViewManagerImpl)ServiceViewManager.getInstance((Project)project);
            for (ServiceView serviceView : manager.myServiceViews) {
                if (!(serviceView.getModel() instanceof ServiceViewModel.ContributorModel) || !this.myContributor.equals(((ServiceViewModel.ContributorModel)serviceView.getModel()).getContributor())) continue;
                Content content2 = manager.myContentManager.getContent((JComponent)serviceView);
                if (content2 != null) {
                    manager.myContentManager.setSelectedContent(content2, true);
                }
                return;
            }
            if (manager.myContentManager.getIndexOfContent(manager.myAllServicesContent) >= 0) {
                manager.myContentManager.setSelectedContent(manager.myAllServicesContent, true);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/execution/services/ServiceViewManagerImpl$ActivateToolWindowByContributorAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyContentMangerListener
    extends ContentManagerAdapter {
        private MyContentMangerListener() {
        }

        public void contentAdded(@NotNull ContentManagerEvent event) {
            if (event == null) {
                MyContentMangerListener.$$$reportNull$$$0(0);
            }
            if (ServiceViewManagerImpl.this.myContentManager.getContentCount() > 1) {
                ServiceViewManagerImpl.this.myAllServicesContent.setDisplayName("All Services");
            }
        }

        public void contentRemoved(@NotNull ContentManagerEvent event) {
            ServiceView serviceView;
            if (event == null) {
                MyContentMangerListener.$$$reportNull$$$0(1);
            }
            if ((serviceView = ServiceViewManagerImpl.getServiceView(event.getContent())) != null && serviceView != ServiceViewManagerImpl.this.myAllServicesView) {
                ServiceViewManagerImpl.this.myModelFilter.removeFilter(serviceView.getModel().getFilter());
                ServiceViewManagerImpl.this.myServiceViews.remove(serviceView);
                ServiceViewManagerImpl.this.filtersChanged();
            }
            if (ServiceViewManagerImpl.this.myContentManager.getContentCount() == 1) {
                ServiceViewManagerImpl.this.myAllServicesContent.setDisplayName(null);
            }
        }

        public void selectionChanged(@NotNull ContentManagerEvent event) {
            ServiceView serviceView;
            if (event == null) {
                MyContentMangerListener.$$$reportNull$$$0(2);
            }
            if ((serviceView = ServiceViewManagerImpl.getServiceView(event.getContent())) == null) {
                return;
            }
            if (event.getOperation() == ContentManagerEvent.ContentOperation.add) {
                serviceView.onViewSelected();
            } else {
                serviceView.onViewUnselected();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "event";
            objectArray2[1] = "com/intellij/execution/services/ServiceViewManagerImpl$MyContentMangerListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "contentAdded";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "contentRemoved";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "selectionChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class State {
        public ServiceViewState allServicesViewState = new ServiceViewState();
        public List<ServiceViewState> viewStates = new ArrayList<ServiceViewState>();
        public int selectedView = -1;
        public boolean showServicesTree = true;

        State() {
        }
    }
}

