/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.editorActions.TextBlockTransferableData;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RawText;
import com.intellij.openapi.ide.Sizeable;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextBlockTransferable
implements Transferable,
Sizeable {
    private final Collection<? extends TextBlockTransferableData> myExtraData;
    private final RawText myRawText;
    private final String myText;
    private final DataFlavor[] myTransferDataFlavors;

    public TextBlockTransferable(@NotNull String text2, @NotNull Collection<? extends TextBlockTransferableData> extraData, @Nullable RawText rawText) {
        if (text2 == null) {
            TextBlockTransferable.$$$reportNull$$$0(0);
        }
        if (extraData == null) {
            TextBlockTransferable.$$$reportNull$$$0(1);
        }
        this.myText = TextBlockTransferable.cleanFromNullsIfNeeded(text2);
        this.myExtraData = extraData;
        this.myRawText = rawText;
        ArrayList<DataFlavorWithPriority> dataFlavors = new ArrayList<DataFlavorWithPriority>();
        Collections.addAll(dataFlavors, new DataFlavorWithPriority(DataFlavor.stringFlavor, 0), new DataFlavorWithPriority(DataFlavor.plainTextFlavor, 0));
        DataFlavor flavor = RawText.getDataFlavor();
        if (this.myRawText != null && flavor != null) {
            dataFlavors.add(new DataFlavorWithPriority(flavor, 0));
        }
        for (TextBlockTransferableData textBlockTransferableData : extraData) {
            DataFlavor blockFlavor = textBlockTransferableData.getFlavor();
            if (blockFlavor == null) continue;
            dataFlavors.add(new DataFlavorWithPriority(blockFlavor, textBlockTransferableData.getPriority()));
        }
        dataFlavors.sort(Comparator.comparingInt(value -> -((DataFlavorWithPriority)value).priority));
        this.myTransferDataFlavors = (DataFlavor[])ContainerUtil.map2Array(dataFlavors, DataFlavor.class, value -> ((DataFlavorWithPriority)value).flavor);
    }

    public int getSize() {
        int size = this.myText.length();
        if (this.myRawText != null && this.myRawText.rawText != this.myText) {
            size += StringUtil.length((CharSequence)this.myRawText.rawText);
        }
        return size;
    }

    @NotNull
    private static String cleanFromNullsIfNeeded(@NotNull String text2) {
        if (text2 == null) {
            TextBlockTransferable.$$$reportNull$$$0(2);
        }
        String string = SystemInfo.isMac ? text2 : text2.replace('\u0000', ' ');
        if (string == null) {
            TextBlockTransferable.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return this.myTransferDataFlavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        DataFlavor[] flavors;
        for (DataFlavor flavor1 : flavors = this.getTransferDataFlavors()) {
            if (!flavor.equals(flavor1)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        try {
            for (TextBlockTransferableData textBlockTransferableData : this.myExtraData) {
                if (!Comparing.equal((Object)textBlockTransferableData.getFlavor(), (Object)flavor)) continue;
                return textBlockTransferableData;
            }
            if (this.myRawText != null && Comparing.equal((Object)RawText.getDataFlavor(), (Object)flavor)) {
                return this.myRawText;
            }
            if (DataFlavor.stringFlavor.equals(flavor)) {
                return this.myText;
            }
            if (DataFlavor.plainTextFlavor.equals(flavor)) {
                return new StringReader(this.myText);
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        throw new UnsupportedFlavorException(flavor);
    }

    @NotNull
    public static String convertLineSeparators(@NotNull Editor editor, @NotNull String input) {
        if (editor == null) {
            TextBlockTransferable.$$$reportNull$$$0(4);
        }
        if (input == null) {
            TextBlockTransferable.$$$reportNull$$$0(5);
        }
        String string = TextBlockTransferable.convertLineSeparators(editor, input, Collections.emptyList());
        if (string == null) {
            TextBlockTransferable.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public static String convertLineSeparators(@NotNull Editor editor, @NotNull String input, @NotNull Collection<? extends TextBlockTransferableData> itemsToUpdate) {
        if (editor == null) {
            TextBlockTransferable.$$$reportNull$$$0(7);
        }
        if (input == null) {
            TextBlockTransferable.$$$reportNull$$$0(8);
        }
        if (itemsToUpdate == null) {
            TextBlockTransferable.$$$reportNull$$$0(9);
        }
        String string = TextBlockTransferable.convertLineSeparators(input, editor.isOneLineMode() ? " " : "\n", itemsToUpdate);
        if (string == null) {
            TextBlockTransferable.$$$reportNull$$$0(10);
        }
        return string;
    }

    public static String convertLineSeparators(String text2, String newSeparator, Collection<? extends TextBlockTransferableData> itemsToUpdate) {
        if (itemsToUpdate.size() > 0) {
            int size = 0;
            for (TextBlockTransferableData textBlockTransferableData : itemsToUpdate) {
                size += textBlockTransferableData.getOffsetCount();
            }
            int[] offsets = new int[size];
            boolean bl = false;
            for (TextBlockTransferableData textBlockTransferableData : itemsToUpdate) {
                int n;
                n = textBlockTransferableData.getOffsets(offsets, n);
            }
            text2 = StringUtil.convertLineSeparators((String)text2, (String)newSeparator, (int[])offsets);
            boolean bl2 = false;
            for (TextBlockTransferableData textBlockTransferableData : itemsToUpdate) {
                int n;
                n = textBlockTransferableData.setOffsets(offsets, n);
            }
            return text2;
        }
        return StringUtil.convertLineSeparators((String)text2, (String)newSeparator);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extraData";
                break;
            }
            case 3: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/editorActions/TextBlockTransferable";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "itemsToUpdate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/editorActions/TextBlockTransferable";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "cleanFromNullsIfNeeded";
                break;
            }
            case 6: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "convertLineSeparators";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "cleanFromNullsIfNeeded";
                break;
            }
            case 3: 
            case 6: 
            case 10: {
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "convertLineSeparators";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DataFlavorWithPriority {
        private final DataFlavor flavor;
        private final int priority;

        private DataFlavorWithPriority(DataFlavor flavor, int priority) {
            this.flavor = flavor;
            this.priority = priority;
        }
    }
}

