
var callbackMap = new Map();
var callbackCounter = 0;

function callJVM(funcName, args, callback, preserveCallback) {
  if (callback != null) {
    callbackMap.set(callbackCounter, {preserve: preserveCallback, callback: callback});
    var callbackId = callbackCounter;
    args.push(callbackCounter);
    callbackCounter = (callbackCounter + 1) % 10000;
  }
  window.JSBridge[funcName](...args);
  return callbackId;
}

window.callback = function (callbackId, args) {
  let entry = callbackMap.get(callbackId);
  entry.callback(args);
  if (!entry.preserve) {
    callbackMap.delete(callbackId);
  }
}


//fixme: long running task freezes browser
window.processRequests = function(batch) {
  let receiver = WebConsole.instance();
  for (let request of batch) {
    let method = request.first;
    let args = request.second;
    receiver[method](...args);
  }
}