/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.watcher.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.plugins.watcher.FwTaskConfigurationListener;
import com.intellij.plugins.watcher.model.ApplicationTasksOptions;
import com.intellij.plugins.watcher.model.TaskOptions;
import com.intellij.plugins.watcher.model.TasksPersistentComponent;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="ProjectTasksOptions", storages={@Storage(value="watcherTasks.xml")})
public class ProjectTasksOptions
extends TasksPersistentComponent {
    private static final String SUPPRESSED_TASK_NAMES = "suppressed-tasks";
    private static final String ENABLED_GLOBAL = "enabled-global";
    private final Project myProject;
    private volatile List<String> mySuppressedTaskNames = Collections.emptyList();
    private volatile Set<String> mySuppressedTaskNameSet = Collections.emptySet();
    private final List<String> myEnabledGlobalWatcherNames = new ArrayList<String>();
    private final List<TaskOptions> myEnabledGlobalWatchers = new ArrayList<TaskOptions>();
    private final Set<FileType> myConfiguredWatcherFileTypes = new THashSet();
    private final List<FwTaskConfigurationListener> myTaskConfigurationListeners = ContainerUtil.createEmptyCOWList();

    public static ProjectTasksOptions getInstance(Project project) {
        return (ProjectTasksOptions)ServiceManager.getService((Project)project, ProjectTasksOptions.class);
    }

    public ProjectTasksOptions(Project project) {
        this.myProject = project;
    }

    @Nullable
    public Element getState() {
        Element element = ProjectTasksOptions.createElementRespectEnabledState(this.getTasks());
        if (!this.mySuppressedTaskNames.isEmpty()) {
            String allSuppressedTaskNames = StringUtil.join(this.mySuppressedTaskNames, (String)";");
            element.setAttribute(SUPPRESSED_TASK_NAMES, allSuppressedTaskNames);
        }
        if (!this.myEnabledGlobalWatcherNames.isEmpty()) {
            Element enabledGlobalsElement = new Element(ENABLED_GLOBAL);
            for (String watcher : this.myEnabledGlobalWatcherNames) {
                enabledGlobalsElement.addContent(new Element("option").setAttribute("value", watcher));
            }
            element.addContent(enabledGlobalsElement);
        }
        return element;
    }

    public void loadState(@NotNull Element state) {
        if (state == null) {
            ProjectTasksOptions.$$$reportNull$$$0(0);
        }
        this.setTasks(ProjectTasksOptions.loadFileWatcherList(state));
        String suppressedTaskNamesStr = state.getAttributeValue(SUPPRESSED_TASK_NAMES);
        if (!StringUtil.isEmptyOrSpaces((String)suppressedTaskNamesStr)) {
            this.setSuppressedTaskNames(StringUtil.split((String)suppressedTaskNamesStr, (String)";"));
        } else {
            this.setSuppressedTaskNames(Collections.emptyList());
        }
        Element enabledGlobalElement = state.getChild(ENABLED_GLOBAL);
        if (enabledGlobalElement != null) {
            ArrayList<String> enabledGlobalWatchers = new ArrayList<String>();
            for (Element optionElement : enabledGlobalElement.getChildren("option")) {
                String value = optionElement.getAttributeValue("value");
                if (StringUtil.isEmptyOrSpaces((String)value)) continue;
                enabledGlobalWatchers.add(value);
            }
            this.setEnabledGlobalWatcherNames(enabledGlobalWatchers);
        } else {
            this.setEnabledGlobalWatcherNames(Collections.emptyList());
        }
    }

    public void addTaskConfigurationListener(@NotNull FwTaskConfigurationListener listener) {
        if (listener == null) {
            ProjectTasksOptions.$$$reportNull$$$0(1);
        }
        if (this.myTaskConfigurationListeners.isEmpty()) {
            ApplicationTasksOptions.getInstance().addWatcherListListener(() -> this.onTasksUpdated(), (Disposable)this.myProject);
        }
        this.myTaskConfigurationListeners.add(listener);
    }

    @Override
    public void setTasks(List<Pair<TaskOptions, Boolean>> tasks) {
        super.setTasks(tasks);
        this.onTasksUpdated();
    }

    public void addTask(TaskOptions options, boolean isEnabled) {
        this.getTasks().add((Pair<TaskOptions, Boolean>)Pair.create((Object)options, (Object)isEnabled));
        this.onTasksUpdated();
    }

    private void onTasksUpdated() {
        this.updateEnabledGlobalWatcherList();
        this.myConfiguredWatcherFileTypes.clear();
        for (TaskOptions taskOptions : ApplicationTasksOptions.getInstance().getGlobalWatchers()) {
            this.myConfiguredWatcherFileTypes.add(taskOptions.getFileType());
        }
        for (Pair pair : this.getTasks()) {
            this.myConfiguredWatcherFileTypes.add(((TaskOptions)pair.first).getFileType());
        }
        this.fireConfigurationEvents();
        DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart();
    }

    private void updateEnabledGlobalWatcherList() {
        this.myEnabledGlobalWatchers.clear();
        for (TaskOptions watcher : ApplicationTasksOptions.getInstance().getGlobalWatchers()) {
            if (!this.myEnabledGlobalWatcherNames.contains(watcher.getName())) continue;
            this.myEnabledGlobalWatchers.add(watcher);
        }
    }

    private void fireConfigurationEvents() {
        boolean hasEnabledTasks = this.hasEnabledTasks();
        boolean hasEnabledTasksWithImmediateSync = this.hasEnabledTasksWithImmediateSync();
        UIUtil.invokeLaterIfNeeded(() -> {
            for (FwTaskConfigurationListener listener : this.myTaskConfigurationListeners) {
                listener.taskConfigurationChanged(hasEnabledTasks, hasEnabledTasksWithImmediateSync);
            }
        });
    }

    public boolean hasEnabledTasks() {
        if (!this.myEnabledGlobalWatchers.isEmpty()) {
            return true;
        }
        for (Pair<TaskOptions, Boolean> task : this.getTasks()) {
            if (!Boolean.TRUE.equals(task.getSecond())) continue;
            return true;
        }
        return false;
    }

    public boolean hasEnabledTasksWithImmediateSync() {
        for (TaskOptions taskOptions : this.myEnabledGlobalWatchers) {
            if (!taskOptions.isImmediateSync()) continue;
            return true;
        }
        for (Pair pair : this.getTasks()) {
            if (!Boolean.TRUE.equals(pair.getSecond()) || !((TaskOptions)pair.getFirst()).isImmediateSync()) continue;
            return true;
        }
        return false;
    }

    public void setSuppressedTaskNames(@NotNull List<String> suppressedTaskNames) {
        if (suppressedTaskNames == null) {
            ProjectTasksOptions.$$$reportNull$$$0(2);
        }
        ImmutableList immutableList = ImmutableList.copyOf(suppressedTaskNames);
        ImmutableSet immutableSet = ImmutableSet.copyOf((Collection)immutableList);
        this.mySuppressedTaskNames = immutableList;
        this.mySuppressedTaskNameSet = immutableSet;
        if (immutableSet.size() != immutableList.size()) {
            ArrayList mutableCopy = new ArrayList(immutableList);
            ContainerUtil.removeDuplicates(mutableCopy);
            this.mySuppressedTaskNames = ImmutableList.copyOf(mutableCopy);
            this.mySuppressedTaskNameSet = ImmutableSet.copyOf(mutableCopy);
        }
    }

    @NotNull
    public List<String> getEnabledGlobalWatcherNames() {
        ImmutableList immutableList = ImmutableList.copyOf(this.myEnabledGlobalWatcherNames);
        if (immutableList == null) {
            ProjectTasksOptions.$$$reportNull$$$0(3);
        }
        return immutableList;
    }

    public void setEnabledGlobalWatcherNames(@NotNull List<String> enabledGlobalWatcherNames) {
        if (enabledGlobalWatcherNames == null) {
            ProjectTasksOptions.$$$reportNull$$$0(4);
        }
        this.myEnabledGlobalWatcherNames.clear();
        this.myEnabledGlobalWatcherNames.addAll(enabledGlobalWatcherNames);
        this.onTasksUpdated();
    }

    @NotNull
    public List<TaskOptions> findTasksForFile(@NotNull VirtualFile file) {
        if (file == null) {
            ProjectTasksOptions.$$$reportNull$$$0(5);
        }
        if (ProjectUtil.isProjectOrWorkspaceFile((VirtualFile)file) || Comparing.equal((CharSequence)file.getNameSequence(), (CharSequence)"npm-debug.log", (boolean)SystemInfo.isFileSystemCaseSensitive)) {
            List<TaskOptions> list = Collections.emptyList();
            if (list == null) {
                ProjectTasksOptions.$$$reportNull$$$0(6);
            }
            return list;
        }
        if (this.getTasks().isEmpty() && this.myEnabledGlobalWatchers.isEmpty()) {
            List<TaskOptions> list = Collections.emptyList();
            if (list == null) {
                ProjectTasksOptions.$$$reportNull$$$0(7);
            }
            return list;
        }
        List list = (List)ReadAction.compute(() -> {
            SmartList result = new SmartList();
            for (Pair<TaskOptions, Boolean> task : this.getTasks()) {
                TaskOptions options;
                boolean enabled = (Boolean)task.getSecond();
                if (!enabled || !(options = (TaskOptions)task.getFirst()).getFileScope(this.myProject).contains(file)) continue;
                result.add(options);
            }
            for (TaskOptions watcher : this.myEnabledGlobalWatchers) {
                if (!watcher.getFileScope(this.myProject).contains(file)) continue;
                result.add(watcher);
            }
            return result;
        });
        if (list == null) {
            ProjectTasksOptions.$$$reportNull$$$0(8);
        }
        return list;
    }

    public boolean containWatcherWithFileType(@NotNull FileType type) {
        if (type == null) {
            ProjectTasksOptions.$$$reportNull$$$0(9);
        }
        return this.myConfiguredWatcherFileTypes.contains(type);
    }

    public boolean hasWatcherWithName(@NotNull String name) {
        if (name == null) {
            ProjectTasksOptions.$$$reportNull$$$0(10);
        }
        for (TaskOptions taskOptions : ApplicationTasksOptions.getInstance().getGlobalWatchers()) {
            if (!name.equals(taskOptions.getName())) continue;
            return true;
        }
        for (Pair pair : this.getTasks()) {
            if (!name.equals(((TaskOptions)pair.first).getName())) continue;
            return true;
        }
        return false;
    }

    public boolean hasEnabledWatcherWithName(@NotNull String name) {
        if (name == null) {
            ProjectTasksOptions.$$$reportNull$$$0(11);
        }
        if (this.myEnabledGlobalWatcherNames.contains(name)) {
            return true;
        }
        for (Pair<TaskOptions, Boolean> task : this.getTasks()) {
            if (!name.equals(((TaskOptions)task.first).getName()) || !((Boolean)task.second).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public void disableWatcher(String name) {
        if (this.myEnabledGlobalWatcherNames.removeIf(s -> s.equals(name))) {
            this.myEnabledGlobalWatchers.removeIf(watcher -> watcher.getName().equals(name));
            return;
        }
        List<Pair<TaskOptions, Boolean>> oldTasks = this.getTasks();
        int size = oldTasks.size();
        ArrayList<Pair<TaskOptions, Boolean>> newTasks = new ArrayList<Pair<TaskOptions, Boolean>>(size);
        for (Pair<TaskOptions, Boolean> pair : oldTasks) {
            TaskOptions options = (TaskOptions)pair.getFirst();
            if (name.equals(options.getName())) {
                newTasks.add((Pair<TaskOptions, Boolean>)Pair.create((Object)options, (Object)false));
                continue;
            }
            newTasks.add(pair);
        }
        this.setTasks(newTasks);
    }

    public boolean isSuppressedTaskName(@NotNull String taskName) {
        if (taskName == null) {
            ProjectTasksOptions.$$$reportNull$$$0(12);
        }
        return this.mySuppressedTaskNameSet.contains(taskName);
    }

    public void suppressTaskName(@NotNull String taskName) {
        if (taskName == null) {
            ProjectTasksOptions.$$$reportNull$$$0(13);
        }
        if (!this.isSuppressedTaskName(taskName)) {
            ArrayList<String> list = new ArrayList<String>(this.mySuppressedTaskNames);
            list.add(taskName);
            this.setSuppressedTaskNames(list);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suppressedTaskNames";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/plugins/watcher/model/ProjectTasksOptions";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enabledGlobalWatcherNames";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/plugins/watcher/model/ProjectTasksOptions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnabledGlobalWatcherNames";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "findTasksForFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addTaskConfigurationListener";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setSuppressedTaskNames";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setEnabledGlobalWatcherNames";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findTasksForFile";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "containWatcherWithFileType";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "hasWatcherWithName";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "hasEnabledWatcherWithName";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isSuppressedTaskName";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "suppressTaskName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

