/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.remote;

import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.DockerCloudType;
import com.intellij.docker.machine.DockerMachineNotStartedException;
import com.intellij.docker.machine.DockerMachineUtil;
import com.intellij.docker.remote.DockerCredentialsEditorLanguageContribution;
import com.intellij.docker.remote.DockerCredentialsHolder;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.ext.CredentialsEditor;
import com.intellij.remote.ext.CredentialsLanguageContribution;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.util.CloudAccountSelectionEditor;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.jetbrains.plugins.remotesdk.ui.StatusPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerCredentialsEditor
implements CredentialsEditor<DockerCredentialsHolder>,
PanelWithAnchor {
    private static final Logger LOG = Logger.getInstance(DockerCredentialsEditor.class);
    public static final String DEFAULT_DOCKER_PROJECT_PATH = "/opt/project";
    protected static final String DEFAULT_DOCKER_IMAGE_NAME = "python:3";
    private ComboBox myDockerImageCombo;
    private JPanel myDockerAccountSelectionPlaceHolder;
    private JPanel myMainPanel;
    private JBLabel myImageLabel;
    @Nullable
    private final DockerCredentialsEditorLanguageContribution<?> myEditorLanguageContribution;
    private final StatusPanel myStatusPanel;
    private final CloudAccountSelectionEditor myDockerAccountSelectionEditor;
    private boolean mySuppressDockerAccountSelectedEvent;
    private String myDockerImageNameToBeSelected;
    @Nullable
    private JComponent myAnchor;

    public DockerCredentialsEditor(@NotNull CredentialsLanguageContribution languageContribution, @NotNull StatusPanel statusPanel) {
        if (languageContribution == null) {
            DockerCredentialsEditor.$$$reportNull$$$0(0);
        }
        if (statusPanel == null) {
            DockerCredentialsEditor.$$$reportNull$$$0(1);
        }
        this.mySuppressDockerAccountSelectedEvent = false;
        this.$$$setupUI$$$();
        this.myEditorLanguageContribution = DockerCredentialsEditor.findEditorContribution(languageContribution);
        this.myStatusPanel = statusPanel;
        this.myDockerAccountSelectionEditor = new CloudAccountSelectionEditor(Collections.singletonList(DockerCloudType.getInstance()));
        this.myDockerAccountSelectionPlaceHolder.add(this.myDockerAccountSelectionEditor.getMainPanel());
        this.myDockerAccountSelectionEditor.setAccountSelectionListener(() -> {
            if (!this.mySuppressDockerAccountSelectedEvent) {
                RemoteServer account = this.myDockerAccountSelectionEditor.getSelectedAccount();
                if (account != null) {
                    LOG.debug("Docker account selected: " + account.getName());
                }
                this.onSelected();
            }
        });
    }

    @Nullable
    public JComponent getAnchor() {
        return this.myAnchor;
    }

    public void setAnchor(@Nullable JComponent anchor) {
        this.myAnchor = anchor;
        this.myImageLabel.setAnchor(anchor);
    }

    @Nullable
    private static DockerCredentialsEditorLanguageContribution findEditorContribution(@NotNull CredentialsLanguageContribution languageContribution) {
        if (languageContribution == null) {
            DockerCredentialsEditor.$$$reportNull$$$0(2);
        }
        for (DockerCredentialsEditorLanguageContribution o : (DockerCredentialsEditorLanguageContribution[])DockerCredentialsEditorLanguageContribution.EP_NAME.getExtensions()) {
            if (o.getLanguageContribution() != languageContribution) continue;
            return o;
        }
        return null;
    }

    public JPanel getMainPanel() {
        return this.myMainPanel;
    }

    public void onSelected() {
        if (this.myEditorLanguageContribution != null) {
            this.updateDockerImagesCombo(this.myEditorLanguageContribution);
        }
    }

    public ValidationInfo validate() {
        RemoteServer selectedAccount = this.myDockerAccountSelectionEditor.getSelectedAccount();
        if (selectedAccount == null) {
            return new ValidationInfo("Docker server is not selected", this.myDockerAccountSelectionEditor.getMainPanel());
        }
        if (StringUtil.isEmpty((String)((String)this.myDockerImageCombo.getSelectedItem()))) {
            return new ValidationInfo("Docker image name is not specified", (JComponent)this.myDockerImageCombo);
        }
        return null;
    }

    public void saveCredentials(DockerCredentialsHolder credentials) {
        RemoteServer account = this.myDockerAccountSelectionEditor.getSelectedAccount();
        String accountName = account == null ? null : account.getName();
        String imageName = StringUtil.notNullize((String)((String)this.myDockerImageCombo.getSelectedItem()));
        credentials.setAccountName(accountName);
        credentials.setImageName(imageName);
        credentials.setRemoteProjectPath(DEFAULT_DOCKER_PROJECT_PATH);
    }

    public void init(DockerCredentialsHolder credentials) {
        if (this.myEditorLanguageContribution != null) {
            this.myDockerImageNameToBeSelected = credentials.getImageName();
            this.mySuppressDockerAccountSelectedEvent = true;
            try {
                this.myDockerAccountSelectionEditor.setSelectedAccount(credentials.getAccountName());
                this.updateDockerImagesCombo(this.myEditorLanguageContribution);
            }
            finally {
                this.mySuppressDockerAccountSelectedEvent = false;
            }
        }
    }

    private void updateDockerImagesCombo(final @NotNull DockerCredentialsEditorLanguageContribution<?> editorLanguageContribution) {
        RemoteServer account;
        if (editorLanguageContribution == null) {
            DockerCredentialsEditor.$$$reportNull$$$0(3);
        }
        if ((account = this.myDockerAccountSelectionEditor.getSelectedAccount()) == null) {
            return;
        }
        LOG.debug("Listing images for Docker account: " + account.getName());
        if (this.myDockerImageNameToBeSelected == null) {
            this.myDockerImageNameToBeSelected = (String)this.myDockerImageCombo.getSelectedItem();
        } else {
            this.myDockerImageCombo.setSelectedItem((Object)this.myDockerImageNameToBeSelected);
        }
        if (this.myMainPanel.isShowing()) {
            this.doUpdateImageList(editorLanguageContribution, (RemoteServer<DockerCloudConfiguration>)account);
        } else {
            this.myMainPanel.addHierarchyListener(new HierarchyListener(){

                @Override
                public void hierarchyChanged(HierarchyEvent e) {
                    if ((e.getChangeFlags() & 4L) > 0L) {
                        Runnable runnable = () -> DockerCredentialsEditor.this.doUpdateImageList(editorLanguageContribution, (RemoteServer<DockerCloudConfiguration>)account);
                        Application app = ApplicationManager.getApplication();
                        if (app.isDispatchThread()) {
                            app.invokeLater(runnable, ModalityState.current());
                        }
                        DockerCredentialsEditor.this.myMainPanel.removeHierarchyListener(this);
                    }
                }
            });
        }
    }

    private void doUpdateImageList(@NotNull DockerCredentialsEditorLanguageContribution<?> editorLanguageContribution, RemoteServer<DockerCloudConfiguration> account) {
        if (editorLanguageContribution == null) {
            DockerCredentialsEditor.$$$reportNull$$$0(4);
        }
        StatusPanel.Action listImagesAction = this.myStatusPanel.progress("Listing Docker images...");
        this.myDockerImageCombo.setEnabled(false);
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            try {
                List<String[]> images = editorLanguageContribution.getImages((DockerCloudConfiguration)account.getConfiguration());
                ArrayList<String> collectedImages = new ArrayList<String>();
                for (String[] repoTags : images) {
                    collectedImages.addAll(Arrays.asList(repoTags));
                }
                listImagesAction.done();
                LOG.debug("Docker images collected: " + collectedImages);
                ApplicationManager.getApplication().invokeLater(() -> {
                    LOG.debug("Populating Docker images combo box: " + collectedImages);
                    this.myDockerImageCombo.setModel((ComboBoxModel)new CollectionComboBoxModel(collectedImages));
                    if (this.myDockerImageNameToBeSelected != null) {
                        this.myDockerImageCombo.setSelectedItem((Object)this.myDockerImageNameToBeSelected);
                        this.myDockerImageNameToBeSelected = null;
                    } else if (collectedImages.isEmpty()) {
                        this.myDockerImageCombo.setSelectedItem((Object)editorLanguageContribution.getDefaultImageName());
                    }
                    this.myDockerImageCombo.setEnabled(true);
                }, ModalityState.stateForComponent((Component)this.getMainPanel()));
            }
            catch (DockerMachineNotStartedException e) {
                LOG.debug("Docker Machine stopped: " + e.getMachineName());
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (DockerCredentialsEditor.userAcceptedStartDockerMachineDialog(e.getMachineName())) {
                        boolean machineStarted = false;
                        try {
                            LOG.debug("Starting Docker Machine: " + e.getMachineName());
                            DockerMachineUtil.startMachineWithProgressIndicator(null, (String)e.getMachineName());
                            machineStarted = true;
                            listImagesAction.done();
                        }
                        catch (RuntimeException ex) {
                            listImagesAction.failed(ex.getMessage());
                        }
                        if (machineStarted) {
                            this.updateDockerImagesCombo(editorLanguageContribution);
                        }
                    } else {
                        listImagesAction.failed(e.getMessage());
                    }
                }, ModalityState.stateForComponent((Component)this.getMainPanel()), o -> !this.getMainPanel().isShowing());
            }
            catch (ServerRuntimeException e) {
                listImagesAction.failed(e.getMessage());
            }
        });
    }

    private static boolean userAcceptedStartDockerMachineDialog(@NotNull String machineName) {
        if (machineName == null) {
            DockerCredentialsEditor.$$$reportNull$$$0(5);
        }
        return Messages.showYesNoDialog((Project)null, (String)("Do you want to start Docker Machine '" + machineName + "'?"), (String)"Docker Machine Not Running", (Icon)Messages.getQuestionIcon()) == 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageContribution";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statusPanel";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorLanguageContribution";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "machineName";
                break;
            }
        }
        objectArray2[1] = "com/intellij/docker/remote/DockerCredentialsEditor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "findEditorContribution";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "updateDockerImagesCombo";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "doUpdateImageList";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "userAcceptedStartDockerMachineDialog";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        ComboBox comboBox;
        JBLabel jBLabel;
        JPanel jPanel;
        JPanel jPanel2;
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myDockerAccountSelectionPlaceHolder = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myImageLabel = jBLabel = new JBLabel();
        jBLabel.setText("Image name:");
        jPanel2.add((Component)jBLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDockerImageCombo = comboBox = new ComboBox();
        comboBox.setEditable(true);
        jPanel2.add((Component)comboBox, new GridConstraints(1, 1, 1, 1, 0, 1, 2, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Server:");
        jPanel2.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

