/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.ui;

import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.panel.ComponentPanelBuilder;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ContextHelpLabel;
import com.intellij.ui.EnumComboBoxModel;
import com.intellij.ui.HideableTitledPanel;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.config.GroupedServersConfigManager;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerGroupingWrap;
import com.jetbrains.plugins.webDeployment.ui.PermissionsDialog;
import com.jetbrains.plugins.webDeployment.ui.SftpAdvancedOptionsPanel;
import com.jetbrains.plugins.webDeployment.ui.Util;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

public class PublishOptionsConfigForm {
    private JPanel myContentPane;
    private JCheckBox myStopOnFirstError;
    private JCheckBox myOverwriteCheckBox;
    private JCheckBox myPreserveTimestamps;
    private JCheckBox myDeleteMissingItems;
    private JCheckBox myCreateEmptyDirectories;
    private JCheckBox myPromptOnLocalOverwrite;
    private JTextField myExcludeTextField;
    private JLabel myExcludeDescriptionLabel;
    private JCheckBox myOverwriteFilesPermissionsCheckBox;
    private JCheckBox myOverwriteFoldersPermissionsCheckBox;
    private TextFieldWithBrowseButton myFilesPermissionsField;
    private TextFieldWithBrowseButton myFoldersPermissionsField;
    private JComboBox<PublishConfig.AutoUploadState> myAutoUploadComboBox;
    private ComboBox<PublishConfig.TraceLevel> myTraceLevelCombo;
    private JLabel myTraceLevelLabel;
    private JCheckBox mySkipExternalChangesCheckBox;
    private JBLabel myExternalChangesContextLabel;
    private JCheckBox myNotifyRemoteChangesCheckBox;
    private JComboBox<PublishConfig.PromptOnRemoteOverwrite> myPromptOnRemoteOverwriteCombo;
    private JLabel myMessageLabel;
    private JBLabel myAutoUploadMessageLabel;
    private HideableTitledPanel mySftpAdvancedPanel;
    private JCheckBox myDialogOnRemoteDnDCheckBox;
    private String myAutoUploadMessageLabelText;
    private JBRadioButton myNoPreservePermissions;
    private JBRadioButton myYesPreservePermissions;
    private JLabel myPreserveFilePermissionsLabel;
    private int myFilePermissions;
    private int myFolderPermissions;
    private PublishConfig.PromptOnRemoteOverwrite myPromptOnRemoteOverwriteOriginal;
    private SftpAdvancedOptionsPanel mySftpAdvancedOptionsPanel;
    private boolean myShowMessage;
    private PublishConfig myConfig;

    public PublishOptionsConfigForm() {
        this.$$$setupUI$$$();
        this.myOverwriteFilesPermissionsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PublishOptionsConfigForm.this.myFilePermissions = PublishOptionsConfigForm.this.myOverwriteFilesPermissionsCheckBox.isSelected() ? 420 : -1;
                PublishOptionsConfigForm.this.updateFilesPermissionsControls();
            }
        });
        this.myFilesPermissionsField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PermissionsDialog.Single d = new PermissionsDialog.Single(PublishOptionsConfigForm.this.myContentPane, WDBundle.message("change.default.file.permissions.dialog.title", new Object[0]), PublishOptionsConfigForm.this.myFilePermissions);
                if (d.showAndGet()) {
                    PublishOptionsConfigForm.this.myFilePermissions = d.getPermissions();
                    PublishOptionsConfigForm.this.updateFilesPermissionsControls();
                }
            }
        });
        this.myOverwriteFoldersPermissionsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PublishOptionsConfigForm.this.myFolderPermissions = PublishOptionsConfigForm.this.myOverwriteFoldersPermissionsCheckBox.isSelected() ? 493 : -1;
                PublishOptionsConfigForm.this.updateFoldersPermissionsControls();
            }
        });
        this.myFoldersPermissionsField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PermissionsDialog.Single d = new PermissionsDialog.Single(PublishOptionsConfigForm.this.myContentPane, WDBundle.message("change.default.folder.permissions.dialog.title", new Object[0]), PublishOptionsConfigForm.this.myFolderPermissions);
                if (d.showAndGet()) {
                    PublishOptionsConfigForm.this.myFolderPermissions = d.getPermissions();
                    PublishOptionsConfigForm.this.updateFoldersPermissionsControls();
                }
            }
        });
        this.myTraceLevelCombo.setModel((ComboBoxModel)new EnumComboBoxModel(PublishConfig.TraceLevel.class));
        this.myTraceLevelCombo.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((String)"", value -> WDBundle.message("trace.level." + value.name(), new Object[0])));
        this.myTraceLevelLabel.setLabelFor((Component)this.myTraceLevelCombo);
        this.myAutoUploadComboBox.setModel((ComboBoxModel<PublishConfig.AutoUploadState>)new EnumComboBoxModel(PublishConfig.AutoUploadState.class));
        this.myAutoUploadComboBox.setRenderer((ListCellRenderer<PublishConfig.AutoUploadState>)SimpleListCellRenderer.create((String)"", value -> value.getPresentableName()));
        this.myAutoUploadComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PublishOptionsConfigForm.this.updateUploadExternalChangesCombo();
                Object item = PublishOptionsConfigForm.this.myAutoUploadComboBox.getSelectedItem();
                PublishOptionsConfigForm.this.myAutoUploadMessageLabel.setVisible(item != PublishConfig.AutoUploadState.NEVER && PublishOptionsConfigForm.this.myAutoUploadMessageLabelText != null);
                PublishConfig.AutoUploadState state = item instanceof PublishConfig.AutoUploadState ? (PublishConfig.AutoUploadState)((Object)item) : null;
                PublishOptionsConfigForm.this.myConfig.setTempAutoUploadState(state);
            }
        });
        this.myPromptOnRemoteOverwriteCombo.setModel((ComboBoxModel<PublishConfig.PromptOnRemoteOverwrite>)new EnumComboBoxModel(PublishConfig.PromptOnRemoteOverwrite.class));
        this.myPromptOnRemoteOverwriteCombo.setRenderer((ListCellRenderer<PublishConfig.PromptOnRemoteOverwrite>)SimpleListCellRenderer.create((String)"", value -> WDBundle.message("propmt.on.remote.overwrite." + (Object)value, new Object[0])));
        this.myMessageLabel.setIcon(UIUtil.getBalloonWarningIcon());
        this.myAutoUploadMessageLabel.setIcon(UIUtil.getBalloonWarningIcon());
        this.myPromptOnRemoteOverwriteCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PublishOptionsConfigForm.this.updateMessage();
            }
        });
        if (SystemInfo.isWindows) {
            this.myPreserveFilePermissionsLabel.setVisible(false);
            this.myNoPreservePermissions.setVisible(false);
            this.myYesPreservePermissions.setVisible(false);
        } else {
            ActionListener listener = e -> this.enableCustomPermissionComponents(this.myNoPreservePermissions.isSelected());
            this.myNoPreservePermissions.addActionListener(listener);
            this.myYesPreservePermissions.addActionListener(listener);
        }
    }

    public void setPublishConfig(@NotNull PublishConfig config) {
        if (config == null) {
            PublishOptionsConfigForm.$$$reportNull$$$0(0);
        }
        this.myConfig = config;
    }

    public void setShowMessage(boolean showMessage) {
        this.myShowMessage = showMessage;
    }

    private void updateMessage() {
        if (this.myPromptOnRemoteOverwriteCombo.getSelectedItem() == PublishConfig.PromptOnRemoteOverwrite.NONE) {
            this.myNotifyRemoteChangesCheckBox.setSelected(false);
            this.myNotifyRemoteChangesCheckBox.setEnabled(false);
        } else {
            this.myNotifyRemoteChangesCheckBox.setEnabled(true);
        }
        if (!this.myShowMessage) {
            this.myMessageLabel.setVisible(false);
            return;
        }
        if (this.myPromptOnRemoteOverwriteOriginal == PublishConfig.PromptOnRemoteOverwrite.NONE && this.myPromptOnRemoteOverwriteCombo.getSelectedItem() != PublishConfig.PromptOnRemoteOverwrite.NONE) {
            this.myMessageLabel.setIcon(UIUtil.getBalloonInformationIcon());
            this.myMessageLabel.setText(WDBundle.message("merge.on.upload.option.on", new Object[0]));
            this.myMessageLabel.setVisible(true);
        } else if (this.myPromptOnRemoteOverwriteOriginal != PublishConfig.PromptOnRemoteOverwrite.NONE && this.myPromptOnRemoteOverwriteCombo.getSelectedItem() == PublishConfig.PromptOnRemoteOverwrite.NONE) {
            this.myMessageLabel.setIcon(UIUtil.getBalloonWarningIcon());
            this.myMessageLabel.setText(WDBundle.message("merge.on.upload.option.off", new Object[0]));
            this.myMessageLabel.setVisible(true);
        } else {
            this.myMessageLabel.setVisible(false);
        }
    }

    private void updateUploadExternalChangesCombo() {
        if (this.myAutoUploadComboBox.getSelectedItem() != PublishConfig.AutoUploadState.NEVER) {
            this.mySkipExternalChangesCheckBox.setEnabled(true);
        } else {
            this.mySkipExternalChangesCheckBox.setEnabled(false);
            this.mySkipExternalChangesCheckBox.setSelected(false);
        }
    }

    private void updateFilesPermissionsControls() {
        this.myFilesPermissionsField.setEnabled(this.myOverwriteFilesPermissionsCheckBox.isSelected());
        this.myFilesPermissionsField.setText(this.myFilePermissions == -1 ? WDBundle.message("permissions.none", new Object[0]) : PublishOptionsConfigForm.toString(this.myFilePermissions));
    }

    private void updateFoldersPermissionsControls() {
        this.myFoldersPermissionsField.setEnabled(this.myOverwriteFoldersPermissionsCheckBox.isSelected());
        this.myFoldersPermissionsField.setText(this.myFolderPermissions == -1 ? WDBundle.message("permissions.none", new Object[0]) : PublishOptionsConfigForm.toString(this.myFolderPermissions));
    }

    public boolean isModified() {
        if (this.myConfig.isStopOnFirstError() != this.myStopOnFirstError.isSelected()) {
            return true;
        }
        if (this.myConfig.isOverwriteAll() != this.myOverwriteCheckBox.isSelected()) {
            return true;
        }
        if (this.myConfig.isPreserveTimestamps() != this.myPreserveTimestamps.isSelected()) {
            return true;
        }
        if (this.myConfig.isDeleteMissingItems() != this.myDeleteMissingItems.isSelected()) {
            return true;
        }
        if (this.myConfig.isCreateEmptyDirectories() != this.myCreateEmptyDirectories.isSelected()) {
            return true;
        }
        if (this.myConfig.getTraceLevel() != this.myTraceLevelCombo.getSelectedItem()) {
            return true;
        }
        if (this.myConfig.isPromptOnLocalOverwrite() != this.myPromptOnLocalOverwrite.isSelected()) {
            return true;
        }
        if (!Comparing.strEqual((String)this.myConfig.getExcludeMask(), (String)this.myExcludeTextField.getText())) {
            return true;
        }
        if (this.myConfig.preserveOriginalFilePermissions() != this.preserveOriginalFilePermissions()) {
            return true;
        }
        if (this.myConfig.getFilePermissions() != this.myFilePermissions) {
            return true;
        }
        if (this.myConfig.getFolderPermissions() != this.myFolderPermissions) {
            return true;
        }
        if (this.myConfig.getAutoUploadState() != this.myAutoUploadComboBox.getSelectedItem()) {
            return true;
        }
        if (this.myConfig.getAutoUploadState() != PublishConfig.AutoUploadState.NEVER && this.myConfig.isAutoUploadExternalChanges() == this.mySkipExternalChangesCheckBox.isSelected()) {
            return true;
        }
        if (this.myConfig.getPromptOnRemoteOverwrite() != this.myPromptOnRemoteOverwriteCombo.getSelectedItem()) {
            return true;
        }
        if (this.myNotifyRemoteChangesCheckBox.isSelected() != this.myConfig.isNotifyRemoteChanges()) {
            return true;
        }
        if (this.myDialogOnRemoteDnDCheckBox.isSelected() != this.myConfig.isShowDialogOnRemoteDnD()) {
            return true;
        }
        return this.mySftpAdvancedOptionsPanel.isModified(GroupedServersConfigManager.getInstance(null));
    }

    public void apply() {
        this.myConfig.setTempAutoUploadState(null);
        this.myConfig.setStopOnFirstError(this.myStopOnFirstError.isSelected());
        this.myConfig.setOverwriteAll(this.myOverwriteCheckBox.isSelected());
        this.myConfig.setPreserveTimestamps(this.myPreserveTimestamps.isSelected());
        this.myConfig.setDeleteMissingItems(this.myDeleteMissingItems.isSelected());
        this.myConfig.setCreateEmptyDirectories(this.myCreateEmptyDirectories.isSelected());
        Object value = this.myTraceLevelCombo.getSelectedItem();
        this.myConfig.setTraceLevel(value instanceof PublishConfig.TraceLevel ? (PublishConfig.TraceLevel)((Object)value) : PublishConfig.DEFAULT_TRACE_LEVEL);
        this.myConfig.setPromptOnLocalOverwrite(this.myPromptOnLocalOverwrite.isSelected());
        this.myConfig.setExcludeMask(this.myExcludeTextField.getText());
        this.myConfig.setPreserveOriginalFilePermissions(this.preserveOriginalFilePermissions());
        this.myConfig.setFilePermissions(this.myFilePermissions);
        this.myConfig.setFolderPermissions(this.myFolderPermissions);
        Object autoUploadState = this.myAutoUploadComboBox.getSelectedItem();
        PublishConfig.AutoUploadState uploadState = autoUploadState instanceof PublishConfig.AutoUploadState ? (PublishConfig.AutoUploadState)((Object)autoUploadState) : PublishConfig.AutoUploadState.NEVER;
        this.myConfig.setAutoUploadState(uploadState);
        this.myConfig.setAutoUploadExternalChanges(uploadState != PublishConfig.AutoUploadState.NEVER && !this.mySkipExternalChangesCheckBox.isSelected());
        this.myConfig.setPromptOnRemoteOverwrite((PublishConfig.PromptOnRemoteOverwrite)((Object)this.myPromptOnRemoteOverwriteCombo.getSelectedItem()));
        this.myPromptOnRemoteOverwriteOriginal = (PublishConfig.PromptOnRemoteOverwrite)((Object)this.myPromptOnRemoteOverwriteCombo.getSelectedItem());
        this.myConfig.setNotifyRemoteChanges(this.myPromptOnRemoteOverwriteCombo.getSelectedItem() != PublishConfig.PromptOnRemoteOverwrite.NONE && this.myNotifyRemoteChangesCheckBox.isSelected());
        this.myConfig.setShowDialogOnRemoteDnD(this.myDialogOnRemoteDnDCheckBox.isSelected());
        this.mySftpAdvancedOptionsPanel.applyTo(GroupedServersConfigManager.getInstance(null));
        this.updateMessage();
    }

    public void reset() {
        this.myConfig.setTempAutoUploadState(null);
        this.myStopOnFirstError.setSelected(this.myConfig.isStopOnFirstError());
        this.myOverwriteCheckBox.setSelected(this.myConfig.isOverwriteAll());
        this.myPreserveTimestamps.setSelected(this.myConfig.isPreserveTimestamps());
        this.myDeleteMissingItems.setSelected(this.myConfig.isDeleteMissingItems());
        this.myCreateEmptyDirectories.setSelected(this.myConfig.isCreateEmptyDirectories());
        this.myTraceLevelCombo.setSelectedItem((Object)this.myConfig.getTraceLevel());
        this.myPromptOnLocalOverwrite.setSelected(this.myConfig.isPromptOnLocalOverwrite());
        this.myExcludeTextField.setText(this.myConfig.getExcludeMask());
        this.myOverwriteFilesPermissionsCheckBox.setSelected(this.myConfig.getFilePermissions() != -1);
        this.myOverwriteFoldersPermissionsCheckBox.setSelected(this.myConfig.getFolderPermissions() != -1);
        this.myFilePermissions = this.myConfig.getFilePermissions();
        this.myFolderPermissions = this.myConfig.getFolderPermissions();
        this.updateFilesPermissionsControls();
        this.updateFoldersPermissionsControls();
        boolean preserveOriginalFilePermissions = this.myConfig.preserveOriginalFilePermissions();
        this.myNoPreservePermissions.setSelected(!preserveOriginalFilePermissions);
        this.myYesPreservePermissions.setSelected(preserveOriginalFilePermissions);
        this.enableCustomPermissionComponents(!preserveOriginalFilePermissions);
        this.myAutoUploadComboBox.setSelectedItem((Object)this.myConfig.getAutoUploadState());
        this.updateUploadExternalChangesCombo();
        WebServerGroupingWrap defaultWrap = this.myConfig.findDefaultServerOrGroupAsWrap();
        this.myAutoUploadMessageLabelText = null;
        if (defaultWrap == null) {
            if (this.myShowMessage) {
                this.myAutoUploadMessageLabelText = WDBundle.message("default.server.is.not.configured", new Object[0]);
            }
        } else if (defaultWrap.getServers().stream().noneMatch(serverConfig -> serverConfig.needsTransfer())) {
            this.myAutoUploadMessageLabelText = WDBundle.message("default.server.0.does.n.t.need.automatic.upload", defaultWrap.getName(), defaultWrap.getPresentableName());
        } else {
            String validationMessage = defaultWrap.validateFileTransferFast();
            if (validationMessage != null) {
                this.myAutoUploadMessageLabelText = WDBundle.message("automatic.upload.will.not.work.because.default.server.0.is.invalid.1", defaultWrap.getName(), StringUtil.decapitalize((String)validationMessage), defaultWrap.getPresentableName());
            } else if (!this.myConfig.hasValidMapping(defaultWrap)) {
                this.myAutoUploadMessageLabelText = WDBundle.message("automatic.upload.will.not.work.because.default.server.0.has.no.valid.mappings", defaultWrap.getName(), defaultWrap.getPresentableName());
            }
        }
        this.myAutoUploadMessageLabel.setText(this.myAutoUploadMessageLabelText);
        this.myAutoUploadMessageLabel.setVisible(this.myConfig.getAutoUploadState() != PublishConfig.AutoUploadState.NEVER && this.myAutoUploadMessageLabelText != null);
        this.mySkipExternalChangesCheckBox.setSelected(this.myConfig.getAutoUploadState() != PublishConfig.AutoUploadState.NEVER && !this.myConfig.isAutoUploadExternalChanges());
        this.myNotifyRemoteChangesCheckBox.setSelected(this.myConfig.getPromptOnRemoteOverwrite() != PublishConfig.PromptOnRemoteOverwrite.NONE && this.myConfig.isNotifyRemoteChanges());
        this.myPromptOnRemoteOverwriteCombo.setSelectedItem((Object)this.myConfig.getPromptOnRemoteOverwrite());
        this.myPromptOnRemoteOverwriteOriginal = this.myConfig.getPromptOnRemoteOverwrite();
        this.myDialogOnRemoteDnDCheckBox.setSelected(this.myConfig.isShowDialogOnRemoteDnD());
        this.mySftpAdvancedOptionsPanel.resetFrom(GroupedServersConfigManager.getInstance(null));
        this.updateMessage();
    }

    private boolean preserveOriginalFilePermissions() {
        return this.myYesPreservePermissions.isSelected();
    }

    private void enableCustomPermissionComponents(boolean isEnabled) {
        this.myOverwriteFilesPermissionsCheckBox.setEnabled(isEnabled);
        this.myOverwriteFoldersPermissionsCheckBox.setEnabled(isEnabled);
        this.myFilesPermissionsField.setEnabled(isEnabled && this.myOverwriteFilesPermissionsCheckBox.isSelected());
        this.myFoldersPermissionsField.setEnabled(isEnabled && this.myOverwriteFoldersPermissionsCheckBox.isSelected());
    }

    private static String toString(int permissions) {
        return MessageFormat.format("{0} ({1})", Util.getPermissionsAsString(permissions), Util.toOctalString(permissions));
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myExcludeTextField;
    }

    private void createUIComponents() {
        this.mySftpAdvancedOptionsPanel = new SftpAdvancedOptionsPanel();
        this.mySftpAdvancedPanel = new HideableTitledPanel(WDBundle.message("configurable.panel.title.sftp.advanced.options", new Object[0]), false, (JComponent)this.mySftpAdvancedOptionsPanel.getMainPanel(), false);
        this.myExcludeDescriptionLabel = ComponentPanelBuilder.createCommentComponent((String)"", (boolean)true);
        this.myExternalChangesContextLabel = ContextHelpLabel.create((String)"Do not automatically upload files changed outside the editor (by VCS, scripts, tools)");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/jetbrains/plugins/webDeployment/ui/PublishOptionsConfigForm", "setPublishConfig"));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBRadioButton jBRadioButton;
        JBRadioButton jBRadioButton2;
        JLabel jLabel;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JTextField jTextField;
        JBLabel jBLabel;
        JCheckBox jCheckBox3;
        JLabel jLabel2;
        ComboBox comboBox;
        JCheckBox jCheckBox4;
        JLabel jLabel3;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        TextFieldWithBrowseButton textFieldWithBrowseButton2;
        JCheckBox jCheckBox5;
        JCheckBox jCheckBox6;
        JCheckBox jCheckBox7;
        JCheckBox jCheckBox8;
        JCheckBox jCheckBox9;
        JCheckBox jCheckBox10;
        JCheckBox jCheckBox11;
        JPanel jPanel;
        this.createUIComponents();
        this.myContentPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(21, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myOverwriteCheckBox = jCheckBox11 = new JCheckBox();
        jCheckBox11.setMargin(new Insets(2, 0, 2, 3));
        jCheckBox11.setText("Overwrite up-to-date files");
        jCheckBox11.setMnemonic('W');
        jCheckBox11.setDisplayedMnemonicIndex(4);
        jPanel.add((Component)jCheckBox11, new GridConstraints(4, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        this.myPreserveTimestamps = jCheckBox10 = new JCheckBox();
        jCheckBox10.setMargin(new Insets(2, 0, 2, 3));
        jCheckBox10.setText("Preserve files timestamps");
        jCheckBox10.setMnemonic('P');
        jCheckBox10.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jCheckBox10, new GridConstraints(5, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        this.myDeleteMissingItems = jCheckBox9 = new JCheckBox();
        jCheckBox9.setMargin(new Insets(2, 0, 2, 3));
        jCheckBox9.setText("Delete target items when source ones do not exist (when transferring from Project view or Remote Host view)");
        jCheckBox9.setMnemonic('D');
        jCheckBox9.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jCheckBox9, new GridConstraints(6, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        this.myCreateEmptyDirectories = jCheckBox8 = new JCheckBox();
        jCheckBox8.setMargin(new Insets(2, 0, 2, 3));
        jCheckBox8.setText("Create empty directories");
        jCheckBox8.setMnemonic('C');
        jCheckBox8.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jCheckBox8, new GridConstraints(7, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        this.myPromptOnLocalOverwrite = jCheckBox7 = new JCheckBox();
        jCheckBox7.setMargin(new Insets(2, 0, 2, 3));
        jCheckBox7.setText("Prompt when overwriting or deleting local items");
        jCheckBox7.setMnemonic('R');
        jCheckBox7.setDisplayedMnemonicIndex(1);
        jPanel.add((Component)jCheckBox7, new GridConstraints(8, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        this.myOverwriteFilesPermissionsCheckBox = jCheckBox6 = new JCheckBox();
        jCheckBox6.setMargin(new Insets(2, 0, 2, 3));
        jCheckBox6.setText("Override default permissions on files:");
        jCheckBox6.setMnemonic('V');
        jCheckBox6.setDisplayedMnemonicIndex(1);
        jPanel.add((Component)jCheckBox6, new GridConstraints(12, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myOverwriteFoldersPermissionsCheckBox = jCheckBox5 = new JCheckBox();
        jCheckBox5.setMargin(new Insets(2, 0, 2, 3));
        jCheckBox5.setText("Override default permissions on folders:");
        jCheckBox5.setMnemonic('I');
        jCheckBox5.setDisplayedMnemonicIndex(5);
        jPanel.add((Component)jCheckBox5, new GridConstraints(13, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myFilesPermissionsField = textFieldWithBrowseButton2 = new TextFieldWithBrowseButton();
        textFieldWithBrowseButton2.setEditable(false);
        jPanel.add((Component)textFieldWithBrowseButton2, new GridConstraints(12, 2, 1, 1, 8, 0, 2, 0, null, new Dimension(180, -1), null));
        this.myFoldersPermissionsField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        textFieldWithBrowseButton.setEditable(false);
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(13, 2, 1, 1, 8, 0, 6, 0, null, new Dimension(180, -1), null));
        this.myTraceLevelLabel = jLabel3 = new JLabel();
        jLabel3.setText("Operations logging:");
        jLabel3.setDisplayedMnemonic('O');
        jLabel3.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel3, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myStopOnFirstError = jCheckBox4 = new JCheckBox();
        jCheckBox4.setMargin(new Insets(2, 0, 2, 3));
        jCheckBox4.setText("Stop operation on the first error");
        jCheckBox4.setMnemonic('S');
        jCheckBox4.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jCheckBox4, new GridConstraints(3, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        this.myTraceLevelCombo = comboBox = new ComboBox();
        jPanel.add((Component)comboBox, new GridConstraints(2, 1, 1, 1, 8, 0, 3, 3, null, new Dimension(100, 22), null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(18, 2, 1, 1, 0, 2, 5, 6, null, null, null));
        JLabel jLabel4 = new JLabel();
        jLabel4.setText("Warn when uploading over newer file:");
        jLabel4.setDisplayedMnemonic('N');
        jLabel4.setDisplayedMnemonicIndex(25);
        jPanel.add((Component)jLabel4, new GridConstraints(14, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        JComboBox jComboBox = new JComboBox();
        this.myPromptOnRemoteOverwriteCombo = jComboBox;
        jPanel.add(jComboBox, new GridConstraints(14, 2, 1, 1, 8, 0, 2, 0, null, null, null));
        this.myMessageLabel = jLabel2 = new JLabel();
        jLabel2.setText("Label");
        jPanel.add((Component)jLabel2, new GridConstraints(19, 0, 1, 3, 8, 0, 0, 0, null, null, null));
        this.myNotifyRemoteChangesCheckBox = jCheckBox3 = new JCheckBox();
        jCheckBox3.setText("Notify of remote changes");
        jCheckBox3.setMnemonic('H');
        jCheckBox3.setDisplayedMnemonicIndex(18);
        jPanel.add((Component)jCheckBox3, new GridConstraints(15, 0, 1, 3, 8, 0, 3, 0, null, null, null, 1));
        this.myAutoUploadMessageLabel = jBLabel = new JBLabel();
        jBLabel.setText("Label");
        jPanel.add((Component)jBLabel, new GridConstraints(20, 0, 1, 3, 8, 0, 0, 0, null, null, null));
        JLabel jLabel5 = new JLabel();
        jLabel5.setText("<html><u>E</u>xclude items by name:</html>");
        jLabel5.setDisplayedMnemonic('E');
        jLabel5.setDisplayedMnemonicIndex(9);
        jPanel.add((Component)jLabel5, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 8, 0), -1, 0, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 1, 2, 2, 0, 3, 3, 3, null, null, null, 0, true));
        JLabel jLabel6 = this.myExcludeDescriptionLabel;
        jLabel6.setText("<html>use <b>;</b> as delimiter, <b>*</b> and <b>?</b> as wildcards</html>");
        jPanel2.add((Component)jLabel6, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null, 1));
        this.myExcludeTextField = jTextField = new JTextField();
        jPanel2.add((Component)jTextField, new GridConstraints(0, 0, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JComboBox jComboBox2 = new JComboBox();
        this.myAutoUploadComboBox = jComboBox2;
        jPanel.add(jComboBox2, new GridConstraints(9, 2, 1, 1, 8, 0, 2, 0, null, null, null));
        JLabel jLabel7 = new JLabel();
        this.$$$loadLabelText$$$(jLabel7, ResourceBundle.getBundle("messages/WDBundle").getString("upload.changed.files.option.description"));
        jPanel.add((Component)jLabel7, new GridConstraints(9, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        HideableTitledPanel hideableTitledPanel = this.mySftpAdvancedPanel;
        jPanel.add((Component)hideableTitledPanel, new GridConstraints(17, 0, 1, 3, 0, 1, 7, 3, null, null, null));
        this.myDialogOnRemoteDnDCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setMargin(new Insets(2, 0, 2, 3));
        jCheckBox2.setText("Show warning dialog on moving on Remote Host");
        jPanel.add((Component)jCheckBox2, new GridConstraints(16, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel3, new GridConstraints(10, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        this.mySkipExternalChangesCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setMargin(new Insets(2, 15, 2, 3));
        jCheckBox.setText("Skip external changes");
        jCheckBox.setMnemonic('X');
        jCheckBox.setDisplayedMnemonicIndex(6);
        ((Component)jCheckBox).setVisible(true);
        jPanel3.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JBLabel jBLabel2 = this.myExternalChangesContextLabel;
        jPanel3.add((Component)jBLabel2, new GridConstraints(0, 1, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel3.add((Component)spacer2, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myPreserveFilePermissionsLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/WDBundle").getString("upload.preserve.original.file.permissions"));
        jPanel.add((Component)jLabel, new GridConstraints(11, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel4, new GridConstraints(11, 2, 1, 1, 8, 2, 3, 3, null, null, null));
        this.myNoPreservePermissions = jBRadioButton2 = new JBRadioButton();
        jBRadioButton2.setEnabled(true);
        jBRadioButton2.setSelected(true);
        jBRadioButton2.setText("No");
        jPanel4.add((Component)jBRadioButton2, new GridConstraints(0, 0, 1, 1, 0, 0, 3, 0, null, null, null));
        this.myYesPreservePermissions = jBRadioButton = new JBRadioButton();
        jBRadioButton.setText("Yes");
        jPanel4.add((Component)jBRadioButton, new GridConstraints(0, 1, 1, 1, 0, 0, 3, 0, null, null, null));
        jLabel4.setLabelFor(jComboBox);
        jLabel5.setLabelFor(jTextField);
        jLabel7.setLabelFor(jComboBox2);
        jLabel.setLabelFor(jComboBox2);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add((AbstractButton)jBRadioButton2);
        buttonGroup.add((AbstractButton)jBRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

