/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.components;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.PaintingParent;
import com.intellij.uml.components.UmlGraphZoomableViewport;
import com.intellij.uml.dnd.UmlDnDSupport;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.dnd.DropTarget;
import javax.swing.JComponent;
import javax.swing.border.AbstractBorder;
import org.jetbrains.annotations.NotNull;

public class UmlGraphComponent
implements Disposable {
    private final JComponent myComponent;
    private final DiagramBuilder myBuilder;

    public UmlGraphComponent(@NotNull DiagramBuilder builder, ActionToolbar toolbar) {
        if (builder == null) {
            UmlGraphComponent.$$$reportNull$$$0(0);
        }
        this.myBuilder = builder;
        ((ActionToolbarImpl)toolbar).setForceUseMacEnhancements(true);
        JComponent jToolbar = toolbar.getComponent();
        jToolbar.setBackground(builder.getProvider().getColorManager().getToolbarBackground());
        jToolbar.setBorder(new AbstractBorder(){

            @Override
            public Insets getBorderInsets(Component c) {
                return JBUI.insets((int)1, (int)2, (int)1, (int)0);
            }

            @Override
            public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                Color color = g.getColor();
                g.setColor((Color)new JBColor((Color)JBColor.gray, (Color)Gray._85));
                g.drawLine(0, height - 1, width, height - 1);
                g.setColor(color);
            }

            @Override
            public Insets getBorderInsets(Component c, Insets insets) {
                insets.top = 0;
                insets.right = 0;
                insets.left = 0;
                insets.bottom = 1;
                return insets;
            }
        });
        builder.initialize();
        this.addDnDSupport();
        Disposer.register((Disposable)this, (Disposable)builder);
        this.myComponent = new PaintingParent.Wrapper((Component)JBUI.Panels.simplePanel((Component)((Object)new UmlGraphZoomableViewport(builder))).addToTop((Component)jToolbar));
    }

    public static ActionToolbar createToolbarPanel(DefaultActionGroup actionsGroup) {
        DefaultActionGroup actions = new DefaultActionGroup();
        actions.add((AnAction)actionsGroup);
        return ActionManager.getInstance().createActionToolbar("Diagrams", (ActionGroup)actions, true);
    }

    private void addDnDSupport() {
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            return;
        }
        new DropTarget(this.myBuilder.getView().getCanvasComponent(), new UmlDnDSupport(this.myBuilder));
    }

    public void dispose() {
    }

    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myComponent;
        if (jComponent == null) {
            UmlGraphComponent.$$$reportNull$$$0(1);
        }
        return jComponent;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uml/components/UmlGraphComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uml/components/UmlGraphComponent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

