/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.sourcemap.visualizer.actions;

import com.intellij.javascript.debugger.sourcemap.visualizer.actions.BaseSourceMapAction;
import com.intellij.javascript.debugger.sourcemap.visualizer.actions.VisualizeSourceMapActionKt;
import com.intellij.lang.javascript.JavaScriptFileType;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.debugger.sourcemap.SourceMap;
import org.jetbrains.io.LocalFileFinder;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014\u00a8\u0006\u000b"}, d2={"Lcom/intellij/javascript/debugger/sourcemap/visualizer/actions/VisualizeSourceMapAction;", "Lcom/intellij/javascript/debugger/sourcemap/visualizer/actions/BaseSourceMapAction;", "()V", "perform", "", "sourceMap", "Lorg/jetbrains/debugger/sourcemap/SourceMap;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.javascript.debugger"})
public final class VisualizeSourceMapAction
extends BaseSourceMapAction {
    @Override
    protected void perform(@NotNull SourceMap sourceMap, @NotNull VirtualFile file, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)sourceMap, (String)"sourceMap");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        VirtualFile generatedFile = null;
        if (sourceMap.getOutFile() == null) {
            String string = file.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.name");
            String fileName = string;
            if (StringsKt.endsWith$default((String)fileName, (String)".map", (boolean)false, (int)2, null)) {
                generatedFile = file.getParent().findChild(StringsKt.removeSuffix((String)fileName, (CharSequence)".map"));
            }
        } else {
            VirtualFile virtualFile;
            VirtualFile virtualFile2 = file.getParent();
            String string = sourceMap.getOutFile();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            if ((virtualFile = virtualFile2.findFileByRelativePath(string)) == null) {
                String string2 = sourceMap.getOutFile();
                if (string2 == null) {
                    Intrinsics.throwNpe();
                }
                virtualFile = generatedFile = LocalFileFinder.findFile((String)string2);
            }
        }
        if (generatedFile == null) {
            FileChooserDescriptor descriptor;
            FileChooserDescriptor fileChooserDescriptor = descriptor = FileChooserDescriptorFactory.createSingleFileDescriptor((FileType)((FileType)JavaScriptFileType.INSTANCE));
            Intrinsics.checkExpressionValueIsNotNull((Object)fileChooserDescriptor, (String)"descriptor");
            fileChooserDescriptor.setTitle("Select Generated File");
            FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Project)project, (VirtualFile)file.getParent(), (Consumer)((Consumer)new Consumer<VirtualFile>(sourceMap, project){
                final /* synthetic */ SourceMap $sourceMap;
                final /* synthetic */ Project $project;

                public final void consume(VirtualFile it) {
                    VirtualFile virtualFile = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"it");
                    VisualizeSourceMapActionKt.visualizeMap$default(this.$sourceMap, virtualFile, null, this.$project, null, 16, null);
                }
                {
                    this.$sourceMap = sourceMap;
                    this.$project = project;
                }
            }));
        } else {
            VisualizeSourceMapActionKt.visualizeMap$default(sourceMap, generatedFile, null, project, null, 16, null);
        }
    }
}

