/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.console;

import com.intellij.javascript.debugger.JSDebuggerBundle;
import com.intellij.javascript.debugger.console.WebConsoleViewSettings;
import com.intellij.ui.HoverHyperlinkLabel;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;

public class WebConsoleFilterForm {
    private JPanel mainPanel;
    private JBCheckBox errorCheckBox;
    private JBCheckBox warningCheckBox;
    private JBCheckBox infoCheckBox;
    private JBCheckBox logCheckBox;
    private JBCheckBox debugCheckBox;
    private HoverHyperlinkLabel resetFilterHyperlink;
    private final List<FilterListener> listeners;

    public WebConsoleFilterForm() {
        this.$$$setupUI$$$();
        this.listeners = new ArrayList<FilterListener>();
    }

    private void createUIComponents() {
        this.resetFilterHyperlink = new HoverHyperlinkLabel(JSDebuggerBundle.message("js.console.filter.reset", new Object[0]));
        this.resetFilterHyperlink.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

            protected void hyperlinkActivated(HyperlinkEvent e) {
                WebConsoleFilterForm.this.listeners.forEach(FilterListener::filtersResetRequested);
            }
        });
    }

    public void reset(WebConsoleViewSettings settings) {
        this.errorCheckBox.setSelected(settings.getShowErrors());
        this.warningCheckBox.setSelected(settings.getShowWarnings());
        this.infoCheckBox.setSelected(settings.getShowInfo());
        this.logCheckBox.setSelected(settings.getShowLog());
        this.debugCheckBox.setSelected(settings.getShowDebug());
    }

    public void addListener(@NotNull FilterListener filterListener) {
        if (filterListener == null) {
            WebConsoleFilterForm.$$$reportNull$$$0(0);
        }
        this.listeners.add(filterListener);
        ActionListener listener2 = e -> filterListener.filtersChanged();
        this.errorCheckBox.addActionListener(listener2);
        this.warningCheckBox.addActionListener(listener2);
        this.infoCheckBox.addActionListener(listener2);
        this.logCheckBox.addActionListener(listener2);
        this.debugCheckBox.addActionListener(listener2);
    }

    public JPanel getMainPanel() {
        return this.mainPanel;
    }

    public boolean isShowErrors() {
        return this.errorCheckBox.isSelected();
    }

    public boolean isShowWarnings() {
        return this.warningCheckBox.isSelected();
    }

    public boolean isShowInfo() {
        return this.infoCheckBox.isSelected();
    }

    public boolean isShowLog() {
        return this.logCheckBox.isSelected();
    }

    public boolean isShowDebug() {
        return this.debugCheckBox.isSelected();
    }

    public boolean isShowNetwork() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filterListener", "com/intellij/javascript/debugger/console/WebConsoleFilterForm", "addListener"));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JBCheckBox jBCheckBox2;
        JBCheckBox jBCheckBox3;
        JBCheckBox jBCheckBox4;
        JBCheckBox jBCheckBox5;
        JPanel jPanel;
        this.createUIComponents();
        this.mainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(9, 3, new Insets(5, 10, 10, 5), -1, -1, false, false));
        HoverHyperlinkLabel hoverHyperlinkLabel = this.resetFilterHyperlink;
        hoverHyperlinkLabel.setText("Reset filter");
        jPanel.add((Component)hoverHyperlinkLabel, new GridConstraints(7, 0, 1, 1, 8, 0, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(6, 0, 1, 1, 0, 2, 1, 0, new Dimension(-1, 15), new Dimension(-1, 15), new Dimension(-1, 15)));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(1, 1, 1, 1, 0, 1, 0, 1, new Dimension(15, -1), new Dimension(15, -1), new Dimension(15, -1)));
        Spacer spacer3 = new Spacer();
        jPanel.add((Component)spacer3, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.errorCheckBox = jBCheckBox5 = new JBCheckBox();
        jBCheckBox5.setText("Error");
        jBCheckBox5.setMnemonic('E');
        jBCheckBox5.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jBCheckBox5, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.warningCheckBox = jBCheckBox4 = new JBCheckBox();
        jBCheckBox4.setText("Warning");
        jBCheckBox4.setMnemonic('W');
        jBCheckBox4.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jBCheckBox4, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(82, 18), null));
        this.infoCheckBox = jBCheckBox3 = new JBCheckBox();
        jBCheckBox3.setText("Info");
        jPanel.add((Component)jBCheckBox3, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel.add((Component)spacer4, new GridConstraints(8, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.debugCheckBox = jBCheckBox2 = new JBCheckBox();
        jBCheckBox2.setText("Debug");
        jPanel.add((Component)jBCheckBox2, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.logCheckBox = jBCheckBox = new JBCheckBox();
        jBCheckBox.setText("Log");
        jPanel.add((Component)jBCheckBox, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("Severity");
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }

    static interface FilterListener {
        public void filtersChanged();

        public void filtersResetRequested();
    }
}

