/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger;

import com.google.common.base.Joiner;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.intellij.javascript.debugger.DebuggableFileFinderImpl;
import com.intellij.javascript.debugger.EvalScriptVirtualFile;
import com.intellij.javascript.debugger.JSFileFinderBase;
import com.intellij.javascript.debugger.JsFileUtil;
import com.intellij.javascript.debugger.RemoteDebuggingFileFinderKt;
import com.intellij.javascript.debugger.execution.RemoteUrlMappingBean;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.http.HttpVirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.util.PathUtilRt;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.Script;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B'\u0012\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001c\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00032\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J6\u0010\u0013\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u000e2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00042\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00150\u001b2\u0006\u0010\u000f\u001a\u00020\u0005H\u0016J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J$\u0010\u0016\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002J6\u0010\u001d\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u000e2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00042\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J\u001a\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0016\u0010 \u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0011J\b\u0010!\u001a\u00020\u0004H\u0016J\u0014\u0010\"\u001a\u00020\u000e2\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020#0\u001bR6\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00032\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006$"}, d2={"Lcom/intellij/javascript/debugger/RemoteDebuggingFileFinder;", "Lcom/intellij/javascript/debugger/JSFileFinderBase;", "mappings", "Lcom/google/common/collect/BiMap;", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "parent", "(Lcom/google/common/collect/BiMap;Lcom/intellij/javascript/debugger/JSFileFinderBase;)V", "<set-?>", "getMappings$intellij_javascript_debugger", "()Lcom/google/common/collect/BiMap;", "getParent$intellij_javascript_debugger", "()Lcom/intellij/javascript/debugger/JSFileFinderBase;", "canSetRemoteUrl", "", "file", "project", "Lcom/intellij/openapi/project/Project;", "createPredefinedMappings", "doFindFile", "url", "Lcom/intellij/util/Url;", "findByName", "sourceContent", "script", "Lorg/jetbrains/debugger/Script;", "doFindUrls", "", "filename", "findFile", "findNavigatable", "Lcom/intellij/pom/Navigatable;", "isDebuggable", "toString", "updateRemoteUrlMapping", "Lcom/intellij/javascript/debugger/execution/RemoteUrlMappingBean;", "intellij.javascript.debugger"})
public final class RemoteDebuggingFileFinder
extends JSFileFinderBase {
    @NotNull
    private BiMap<String, VirtualFile> mappings;
    @Nullable
    private final JSFileFinderBase parent;

    @NotNull
    public final BiMap<String, VirtualFile> getMappings$intellij_javascript_debugger() {
        return this.mappings;
    }

    @Override
    @Nullable
    public Navigatable findNavigatable(@NotNull Url url, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        VirtualFile virtualFile = RemoteDebuggingFileFinderKt.access$findByMappings(url, this.mappings);
        if (virtualFile != null) {
            VirtualFile virtualFile2 = virtualFile;
            boolean bl = false;
            boolean bl2 = false;
            VirtualFile it = virtualFile2;
            boolean bl3 = false;
            return (Navigatable)JsFileUtil.createNavigatable(project, it);
        }
        JSFileFinderBase jSFileFinderBase = this.parent;
        if (jSFileFinderBase != null && (jSFileFinderBase = jSFileFinderBase.findNavigatable(url, project)) != null) {
            JSFileFinderBase jSFileFinderBase2 = jSFileFinderBase;
            boolean bl = false;
            boolean bl4 = false;
            JSFileFinderBase it = jSFileFinderBase2;
            boolean bl5 = false;
            return it;
        }
        return (Navigatable)JsFileUtil.createNavigatable(project, this.findByName(url, project));
    }

    @Override
    @Nullable
    public VirtualFile findFile(@NotNull Url url, @NotNull Project project, boolean findByName2, @Nullable String sourceContent, @Nullable Script script) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Object object = super.findFile(url, project, findByName2, sourceContent, script);
        if (object == null) {
            object = findByName2 ? this.findByName(url, project) : null;
        }
        return object;
    }

    @Override
    @Nullable
    public VirtualFile doFindFile(@NotNull Url url, @NotNull Project project, boolean findByName2, @Nullable String sourceContent, @Nullable Script script) {
        BiMap<String, VirtualFile> predefinedMappings;
        JSFileFinderBase jSFileFinderBase;
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        VirtualFile virtualFile = RemoteDebuggingFileFinderKt.access$findByMappings(url, this.mappings);
        if (virtualFile != null) {
            VirtualFile virtualFile2 = virtualFile;
            boolean bl = false;
            boolean bl2 = false;
            VirtualFile it = virtualFile2;
            boolean bl3 = false;
            return it;
        }
        if (sourceContent != null) {
            VirtualFile virtualFile3 = super.doFindFile(url, project, findByName2, sourceContent, script);
            if (virtualFile3 != null) {
                VirtualFile virtualFile4 = virtualFile3;
                boolean bl = false;
                boolean bl4 = false;
                VirtualFile it = virtualFile4;
                boolean bl5 = false;
                return it;
            }
        }
        if ((jSFileFinderBase = this.parent) != null && (jSFileFinderBase = jSFileFinderBase.doFindFile(url, project, findByName2, sourceContent, script)) != null) {
            JSFileFinderBase jSFileFinderBase2 = jSFileFinderBase;
            boolean bl = false;
            boolean bl6 = false;
            JSFileFinderBase it = jSFileFinderBase2;
            boolean bl7 = false;
            return it;
        }
        if (sourceContent == null) {
            VirtualFile virtualFile5 = super.doFindFile(url, project, findByName2, sourceContent, script);
            if (virtualFile5 != null) {
                VirtualFile virtualFile6 = virtualFile5;
                boolean bl = false;
                boolean bl8 = false;
                VirtualFile it = virtualFile6;
                boolean bl9 = false;
                return it;
            }
        }
        if ((predefinedMappings = (BiMap<String, VirtualFile>)project.getUserData(RemoteDebuggingFileFinderKt.access$getPREDEFINED_MAPPINGS_KEY$p())) == null) {
            predefinedMappings = this.createPredefinedMappings(project);
            project.putUserData(RemoteDebuggingFileFinderKt.access$getPREDEFINED_MAPPINGS_KEY$p(), predefinedMappings);
        }
        return RemoteDebuggingFileFinderKt.access$findByMappings(url, (BiMap)predefinedMappings);
    }

    private final BiMap<String, VirtualFile> createPredefinedMappings(Project project) {
        BiMap biMap;
        VirtualFile projectDir = ProjectUtil.guessProjectDir((Project)project);
        if (projectDir != null) {
            ImmutableBiMap immutableBiMap = ImmutableBiMap.of((Object)"webpack:///.", (Object)projectDir);
            Intrinsics.checkExpressionValueIsNotNull((Object)immutableBiMap, (String)"ImmutableBiMap.of(\"webpack:///.\", projectDir)");
            biMap = (BiMap)immutableBiMap;
        } else {
            ImmutableBiMap immutableBiMap = ImmutableBiMap.of();
            Intrinsics.checkExpressionValueIsNotNull((Object)immutableBiMap, (String)"ImmutableBiMap.of()");
            biMap = (BiMap)immutableBiMap;
        }
        return biMap;
    }

    private final VirtualFile findByName(Url url, Project project) {
        String string;
        String string2 = url.getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"url.path");
        if (StringsKt.endsWith$default((CharSequence)string2, (char)'/', (boolean)false, (int)2, null)) {
            string = "";
        } else {
            String string3 = PathUtilRt.getFileName((String)url.getPath());
            string = string3;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"PathUtilRt.getFileName(url.path)");
        }
        return this.findByName(string, project, url);
    }

    private final VirtualFile findByName(String filename, Project project, Url url) {
        List<VirtualFile> files2 = RemoteDebuggingFileFinderKt.findByName(filename, project);
        if (files2 == null || files2.isEmpty()) {
            return null;
        }
        if (files2.size() == 1) {
            return files2.get(0);
        }
        VirtualFile virtualFile = files2.get(0).getCanonicalFile();
        if (virtualFile == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"files[0].canonicalFile ?: return null");
        VirtualFile canonicalFile = virtualFile;
        int size = files2.size();
        for (int i = 1; i < size; ++i) {
            if (!(Intrinsics.areEqual((Object)canonicalFile, (Object)files2.get(i).getCanonicalFile()) ^ true)) continue;
            return null;
        }
        if (url == null) {
            return files2.get(0);
        }
        String string = url.getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"url.path");
        String path = string;
        int offset = 0;
        do {
            for (VirtualFile file : files2) {
                String filePath;
                Intrinsics.checkExpressionValueIsNotNull((Object)file.getPath(), (String)"file.path");
                int length = path.length() - offset;
                if (!StringsKt.regionMatches((String)filePath, (int)(filePath.length() - length), (String)path, (int)offset, (int)length, (boolean)true)) continue;
                return file;
            }
        } while ((offset = StringsKt.indexOf$default((CharSequence)path, (char)'/', (int)(offset + 1), (boolean)false, (int)4, null)) >= 0);
        return null;
    }

    public final boolean isDebuggable(@NotNull VirtualFile file, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        if (file instanceof HttpVirtualFile || file instanceof EvalScriptVirtualFile) {
            return true;
        }
        if (!this.mappings.isEmpty()) {
            for (VirtualFile current = file; current != null; current = current.getParent()) {
                if (!this.mappings.containsValue((Object)current)) continue;
                return true;
            }
        }
        if (this.parent instanceof DebuggableFileFinderImpl && ((DebuggableFileFinderImpl)this.parent).isDebuggable(file, project)) {
            return true;
        }
        String string = file.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.name");
        return this.findByName(string, project, null) != null;
    }

    @Override
    public boolean canSetRemoteUrl(@NotNull VirtualFile file, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)project);
        Intrinsics.checkExpressionValueIsNotNull((Object)projectRootManager, (String)"ProjectRootManager.getInstance(project)");
        return projectRootManager.getFileIndex().isInContent(file);
    }

    @Override
    @NotNull
    public List<Url> doFindUrls(@NotNull VirtualFile file) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        if (!(file instanceof HttpVirtualFile) && !this.mappings.isEmpty()) {
            BiMap map = this.mappings.inverse();
            for (VirtualFile current = file; current != null; current = current.getParent()) {
                String url = (String)map.get((Object)current);
                if (url == null) continue;
                if (Intrinsics.areEqual((Object)current, (Object)file)) {
                    return CollectionsKt.listOf((Object)Urls.newFromIdea((CharSequence)url));
                }
                return CollectionsKt.listOf((Object)Urls.newFromIdea((CharSequence)(url + '/' + VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)current, (char)'/'))));
            }
        }
        if ((object = this.parent) == null || (object = ((JSFileFinderBase)object).getRemoteUrls(file)) == null) {
            object = CollectionsKt.listOf((Object)Urls.newFromVirtualFile((VirtualFile)file));
        }
        return object;
    }

    public final boolean updateRemoteUrlMapping(@NotNull List<? extends RemoteUrlMappingBean> mappings) {
        Intrinsics.checkParameterIsNotNull(mappings, (String)"mappings");
        BiMap<String, VirtualFile> newMap = RemoteDebuggingFileFinderKt.createUrlToLocalMap(mappings);
        if (Intrinsics.areEqual(newMap, this.mappings) ^ true) {
            this.mappings = newMap;
            return true;
        }
        return false;
    }

    @NotNull
    public String toString() {
        String string = Joiner.on((String)"\n ").withKeyValueSeparator("->").join((Map)this.mappings);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Joiner.on(\"\\n \").withKey\u2026ator(\"->\").join(mappings)");
        return string;
    }

    @Nullable
    public final JSFileFinderBase getParent$intellij_javascript_debugger() {
        return this.parent;
    }

    public RemoteDebuggingFileFinder(@NotNull BiMap<String, VirtualFile> mappings, @Nullable JSFileFinderBase parent) {
        Intrinsics.checkParameterIsNotNull(mappings, (String)"mappings");
        this.parent = parent;
        this.mappings = mappings;
    }

    public /* synthetic */ RemoteDebuggingFileFinder(BiMap biMap, JSFileFinderBase jSFileFinderBase, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            ImmutableBiMap immutableBiMap = ImmutableBiMap.of();
            Intrinsics.checkExpressionValueIsNotNull((Object)immutableBiMap, (String)"ImmutableBiMap.of()");
            biMap = (BiMap)immutableBiMap;
        }
        if ((n & 2) != 0) {
            jSFileFinderBase = null;
        }
        this((BiMap<String, VirtualFile>)biMap, jSFileFinderBase);
    }

    public RemoteDebuggingFileFinder() {
        this(null, null, 3, null);
    }
}

