/*
 * Decompiled with CFR 0.152.
 */
package org.jrubyparser.lexer;

import java.io.IOException;
import java.io.Reader;
import org.jrubyparser.SourcePosition;
import org.jrubyparser.lexer.ReaderLexerSource;
import org.jrubyparser.parser.ParserConfiguration;

public abstract class LexerSource {
    private SourcePosition lastPosition;
    private final String sourceName;
    protected int line = 0;
    protected int offset = 0;

    protected LexerSource(String sourceName, int line) {
        this.sourceName = sourceName;
        this.lastPosition = new SourcePosition("", line, line);
        this.line = line;
    }

    public String getFilename() {
        return this.sourceName;
    }

    public int getLine() {
        return this.line;
    }

    public int getOffset() {
        return this.offset <= 0 ? 0 : this.offset;
    }

    public SourcePosition getPosition(SourcePosition startPosition, boolean inclusive) {
        this.lastPosition = startPosition == null ? new SourcePosition(this.getFilename(), this.lastPosition.getEndLine(), this.getLine(), this.lastPosition.getEndOffset(), this.getOffset()) : (inclusive ? new SourcePosition(this.getFilename(), startPosition.getStartLine(), this.getLine(), startPosition.getStartOffset(), this.getOffset()) : new SourcePosition(this.getFilename(), startPosition.getEndLine(), this.getLine(), startPosition.getEndOffset(), this.getOffset()));
        return this.lastPosition;
    }

    public SourcePosition getPosition() {
        return new SourcePosition(this.getFilename(), this.lastPosition.getEndLine(), this.getLine(), this.lastPosition.getEndOffset(), this.getOffset());
    }

    public static LexerSource getSource(String name, Reader content, ParserConfiguration configuration) {
        return new ReaderLexerSource(name, content, configuration.getLineNumber());
    }

    public abstract boolean matchMarker(String var1, boolean var2, boolean var3) throws IOException;

    public abstract int read() throws IOException;

    public abstract String readUntil(char var1) throws IOException;

    public abstract String readLineBytes() throws IOException;

    public abstract int skipUntil(int var1) throws IOException;

    public abstract void unread(int var1);

    public abstract void unreadMany(CharSequence var1);

    public abstract boolean peek(int var1) throws IOException;

    public abstract boolean lastWasBeginOfLine();

    public abstract boolean wasBeginOfLine();

    public abstract int chompReadAhead();

    public abstract boolean isANewLine();

    public abstract void setIsANewLine(boolean var1);

    public abstract void setOffset(int var1);
}

