/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util.editor;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.Indent;
import com.intellij.lang.ASTNode;
import com.intellij.lang.css.CSSLanguage;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.css.CssAtRule;
import com.intellij.psi.css.CssBlock;
import com.intellij.psi.css.CssCustomMixin;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssElement;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssImport;
import com.intellij.psi.css.CssKeyframesSelector;
import com.intellij.psi.css.CssLineNames;
import com.intellij.psi.css.CssMediaFeature;
import com.intellij.psi.css.CssNamespace;
import com.intellij.psi.css.CssNamespaceList;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.CssSelector;
import com.intellij.psi.css.CssSimpleSelector;
import com.intellij.psi.css.CssString;
import com.intellij.psi.css.CssStylesheet;
import com.intellij.psi.css.CssSupportsCondition;
import com.intellij.psi.css.CssTermList;
import com.intellij.psi.css.codeStyle.CssCodeStyleSettings;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.CssRulesetWrappingElement;
import com.intellij.psi.css.impl.CssTokenImpl;
import com.intellij.psi.css.impl.util.editor.CssFormattingModelBuilder;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.tree.IElementType;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CssFormattingElementVisitor
extends CssElementVisitor {
    private boolean mySeenRuleset;
    protected final List<Block> mySubBlocks;
    private final CssCodeStyleSettings mySettings;
    private final CssFormattingModelBuilder.CssFormattingExtension myExtension;
    private final Alignment myAlignment;
    private final Alignment myChildAlignment;
    private final IElementType myType;
    private final boolean shouldIndentContent;

    public CssFormattingElementVisitor(List<Block> blocks, CssCodeStyleSettings settings, CssFormattingModelBuilder.CssFormattingExtension extension, Alignment alignment, Alignment childAlignment, IElementType type, boolean content) {
        this.mySubBlocks = blocks;
        this.mySettings = settings;
        this.myExtension = extension;
        this.myAlignment = alignment;
        this.myChildAlignment = childAlignment;
        this.myType = type;
        this.shouldIndentContent = content;
    }

    public void visitCssString(CssString _string) {
        this.mySubBlocks.add((Block)new CssFormattingModelBuilder.CssSimpleBlock(_string.getNode(), Indent.getNoneIndent(), this.myExtension));
    }

    public void visitNamespace(CssNamespace namespace) {
        this.mySubBlocks.add((Block)this.myExtension.createPropertyBlock(namespace.getNode(), this.myExtension, null, null));
    }

    public void visitCssImport(CssImport _import) {
        this.mySubBlocks.add((Block)this.myExtension.createPropertyBlock(_import.getNode(), this.myExtension, null, null));
    }

    public void visitCustomMixin(@NotNull CssCustomMixin customMixin) {
        if (customMixin == null) {
            CssFormattingElementVisitor.$$$reportNull$$$0(0);
        }
        Indent indent = this.shouldIndentContent ? Indent.getNormalIndent() : Indent.getNoneIndent();
        this.mySubBlocks.add((Block)this.myExtension.createRulesetBlock(customMixin.getNode(), indent, this.myExtension, null));
    }

    public void visitCssRuleset(CssRuleset ruleset) {
        Indent indent = this.shouldIndentContent ? Indent.getNormalIndent() : Indent.getNoneIndent();
        this.mySubBlocks.add((Block)this.myExtension.createRulesetBlock(ruleset.getNode(), indent, this.myExtension, (Alignment)(this.mySeenRuleset ? Alignment.createAlignment() : null)));
        this.mySeenRuleset = true;
    }

    public void visitCssSelector(CssSelector selector) {
        boolean containsOuterLangElements = false;
        for (PsiElement child = selector.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof OuterLanguageElement)) continue;
            containsOuterLangElements = true;
            break;
        }
        if (containsOuterLangElements) {
            selector.acceptChildren((PsiElementVisitor)this);
        } else if (selector.getNode().getTextRange().getLength() != 0) {
            this.mySubBlocks.add((Block)this.myExtension.createSelectorBlock(selector.getNode(), this.myExtension));
        }
    }

    public void visitCssSimpleSelector(CssSimpleSelector selector) {
        if (selector != null && !(selector instanceof CssKeyframesSelector) && !FormatterUtil.containsWhiteSpacesOnly((ASTNode)selector.getNode())) {
            this.mySubBlocks.add((Block)new CssFormattingModelBuilder.CssSimpleBlock(selector.getNode(), Indent.getNoneIndent(), this.myExtension));
        }
    }

    public void visitCssTermList(CssTermList _termList) {
        boolean errorsOnly = true;
        for (PsiElement child = _termList.getFirstChild(); child != null && !(errorsOnly = child instanceof PsiErrorElement); child = child.getNextSibling()) {
        }
        if (errorsOnly) {
            _termList.acceptChildren((PsiElementVisitor)this);
        } else {
            Indent indent = this.shouldIndentContent ? Indent.getContinuationIndent() : Indent.getNoneIndent();
            this.mySubBlocks.add((Block)this.myExtension.createTermListBlock(_termList.getNode(), indent, this.mySettings.VALUE_ALIGNMENT == 2 ? this.myChildAlignment : null, true));
        }
    }

    public void visitCssDeclaration(CssDeclaration declaration) {
        this.mySubBlocks.add((Block)this.myExtension.createPropertyBlock(declaration.getNode(), this.myExtension, null, this.myAlignment));
    }

    public void visitMediaFeature(@NotNull CssMediaFeature mediaFeature) {
        if (mediaFeature == null) {
            CssFormattingElementVisitor.$$$reportNull$$$0(1);
        }
        this.mySubBlocks.add((Block)this.myExtension.createPropertyBlock(mediaFeature.getNode(), this.myExtension, null, null));
    }

    private void visitMediaGroup(PsiElement mediaGroup) {
        Indent indent = this.shouldIndentContent ? Indent.getNormalIndent() : Indent.getNoneIndent();
        this.mySubBlocks.add((Block)this.myExtension.createMediaBlock(mediaGroup.getNode(), indent, this.myExtension));
    }

    private void visitPageDeclaration(PsiElement page) {
        Indent indent = this.shouldIndentContent ? Indent.getNormalIndent() : Indent.getNoneIndent();
        this.mySubBlocks.add((Block)new CssFormattingModelBuilder.CssPageBlock(page.getNode(), indent, this.myExtension));
    }

    private void visitSupportsDeclaration(PsiElement supports) {
        Indent indent = this.shouldIndentContent ? Indent.getNormalIndent() : Indent.getNoneIndent();
        this.mySubBlocks.add((Block)this.myExtension.createSupportsBlock(supports.getNode(), indent, this.myExtension));
    }

    private void visitSupportsCondition(PsiElement condition) {
        this.mySubBlocks.add((Block)new CssFormattingModelBuilder.CssSimpleBlock(condition.getNode(), Indent.getNoneIndent(), this.myExtension));
    }

    private void visitCssOperationBlock(PsiElement operation) {
        this.mySubBlocks.add((Block)new CssFormattingModelBuilder.CssOperationBlock(operation.getNode(), this.myExtension));
    }

    public void visitNamespaceList(CssNamespaceList namespaceList) {
        this.mySubBlocks.add((Block)new CssFormattingModelBuilder.NamespaceListBlock(namespaceList.getNode(), this.myExtension));
    }

    private void visitCssImportList(@NotNull PsiElement importList) {
        if (importList == null) {
            CssFormattingElementVisitor.$$$reportNull$$$0(2);
        }
        this.mySubBlocks.add((Block)new CssFormattingModelBuilder.ImportListBlock(importList.getNode(), this.myExtension));
    }

    private void visitBadAtRule(@NotNull PsiElement badAtRule) {
        if (badAtRule == null) {
            CssFormattingElementVisitor.$$$reportNull$$$0(3);
        }
        Indent indent = this.shouldIndentContent ? Indent.getNormalIndent() : Indent.getNoneIndent();
        this.mySubBlocks.add((Block)new CssFormattingModelBuilder.CssBadAtRuleBlock(badAtRule.getNode(), indent, this.myExtension));
        this.mySeenRuleset = true;
    }

    private void visitCssExpression(@NotNull PsiElement expression) {
        if (expression == null) {
            CssFormattingElementVisitor.$$$reportNull$$$0(4);
        }
        this.mySubBlocks.add((Block)new CssFormattingModelBuilder.CssSimpleBlock(expression.getNode(), Indent.getNoneIndent(), this.myExtension));
    }

    private void visitCssFontFace(@NotNull PsiElement fontFace) {
        if (fontFace == null) {
            CssFormattingElementVisitor.$$$reportNull$$$0(5);
        }
        Indent indent = this.shouldIndentContent ? Indent.getNormalIndent() : Indent.getNoneIndent();
        this.mySubBlocks.add((Block)new CssFormattingModelBuilder.CssFontFaceBlock(fontFace.getNode(), indent, this.myExtension));
    }

    private void visitCssViewPort(@NotNull PsiElement viewPort) {
        if (viewPort == null) {
            CssFormattingElementVisitor.$$$reportNull$$$0(6);
        }
        Indent indent = this.shouldIndentContent ? Indent.getNormalIndent() : Indent.getNoneIndent();
        this.mySubBlocks.add((Block)new CssFormattingModelBuilder.CssViewPortBlock(viewPort.getNode(), indent, this.myExtension));
    }

    private void visitAtRuleWithNestedRulesets(@NotNull PsiElement atRule) {
        if (atRule == null) {
            CssFormattingElementVisitor.$$$reportNull$$$0(7);
        }
        Indent indent = this.shouldIndentContent ? Indent.getNormalIndent() : Indent.getNoneIndent();
        this.mySubBlocks.add((Block)this.myExtension.createRulesetBlock(atRule.getNode(), indent, this.myExtension, Alignment.createAlignment()));
        this.mySeenRuleset = true;
    }

    private void visitCharset(@NotNull PsiElement charset) {
        if (charset == null) {
            CssFormattingElementVisitor.$$$reportNull$$$0(8);
        }
        this.mySubBlocks.add((Block)this.myExtension.createPropertyBlock(charset.getNode(), this.myExtension, null, null));
    }

    public void visitComment(@NotNull PsiComment comment) {
        if (comment == null) {
            CssFormattingElementVisitor.$$$reportNull$$$0(9);
        }
        this.mySubBlocks.add((Block)new CssFormattingModelBuilder.CssSimpleBlock(comment.getNode(), this.myExtension.getCommentIndent(comment.getTokenType(), this.myType), this.myExtension, null));
    }

    public void visitLineNames(@NotNull CssLineNames lineNames) {
        if (lineNames == null) {
            CssFormattingElementVisitor.$$$reportNull$$$0(10);
        }
        this.mySubBlocks.add((Block)new CssFormattingModelBuilder.CssSimpleBlock(lineNames.getNode(), Indent.getNoneIndent(), this.myExtension));
    }

    public void visitElement(PsiElement element) {
        if (element instanceof CssTokenImpl) {
            CssTokenImpl token = (CssTokenImpl)element;
            if (!this.myExtension.addLeaf(token)) {
                Indent indent = this.myExtension.getTokenIndent(token);
                Alignment alignment = this.mySettings.VALUE_ALIGNMENT == 1 && token.getElementType() == CssElementTypes.CSS_COLON ? this.myChildAlignment : null;
                this.mySubBlocks.add((Block)new CssFormattingModelBuilder.CssSimpleBlock((ASTNode)token, indent, this.myExtension, alignment));
            }
        } else if (element instanceof CssElement) {
            ASTNode node = element.getNode();
            if (node != null && CssElementTypes.CSS_MEDIA == node.getElementType()) {
                this.visitMediaGroup(element);
            } else if (node != null && CssElementTypes.CSS_PAGE == node.getElementType()) {
                this.visitPageDeclaration(element);
            } else if (node != null && CssElementTypes.CSS_SUPPORTS == node.getElementType()) {
                this.visitSupportsDeclaration(element);
            } else if (node instanceof CssSupportsCondition) {
                this.visitSupportsCondition(element);
            } else if (node != null && CssElementTypes.CSS_PAGE_MARGIN_RULE == node.getElementType()) {
                this.visitBadAtRule(element);
            } else if (node != null && CssElementTypes.CSS_IMPORT_LIST == node.getElementType()) {
                this.visitCssImportList(element);
            } else if (element instanceof CssTermList) {
                this.visitCssTermList((CssTermList)element);
            } else if (node != null && CssElementTypes.CSS_EXPRESSION == node.getElementType()) {
                this.visitCssExpression(element);
            } else if (node != null && CssElementTypes.CSS_FONTFACE == node.getElementType()) {
                this.visitCssFontFace(element);
            } else if (node != null && CssElementTypes.CSS_VIEWPORT == node.getElementType()) {
                this.visitCssViewPort(element);
            } else if (node != null && CssElementTypes.CSS_ATTRIBUTE == node.getElementType()) {
                this.mySubBlocks.add((Block)new CssFormattingModelBuilder.CssSimpleBlock(node, Indent.getNoneIndent(), this.myExtension));
            } else if (node != null && (CssElementTypes.CSS_BINARY_OPERATION == node.getElementType() || CssElementTypes.CSS_UNARY_OPERATION == node.getElementType())) {
                this.visitCssOperationBlock(element);
            } else if (node != null && CssElementTypes.CSS_KEYFRAMES_RULE == node.getElementType() || node != null && CssElementTypes.CSS_REGION_RULE == node.getElementType() || node != null && CssElementTypes.CSS_SCOPE_RULE == node.getElementType() || node != null && CssElementTypes.CSS_DOCUMENT_RULE == node.getElementType()) {
                this.visitAtRuleWithNestedRulesets(element);
            } else if (node != null && CssElementTypes.CSS_CHARSET == node.getElementType()) {
                this.visitCharset(element);
            } else if (node != null && CssElementTypes.CSS_APPLY == node.getElementType()) {
                this.mySubBlocks.add((Block)this.myExtension.createPropertyBlock(node, this.myExtension, null, this.myAlignment));
            } else if (node != null && (CssElementTypes.CSS_BAD_AT_RULE == node.getElementType() || element instanceof CssAtRule)) {
                this.visitBadAtRule(element);
            } else if (!FormatterUtil.containsWhiteSpacesOnly((ASTNode)node) && !this.myExtension.addSubBlocks(element, this.mySubBlocks)) {
                if (element.getLanguage() == CSSLanguage.INSTANCE || element instanceof CssStylesheet || element instanceof CssBlock || element instanceof CssRulesetWrappingElement) {
                    element.acceptChildren((PsiElementVisitor)this);
                } else if (!this.myExtension.addSubBlocksOfExtendedLanguage(element, this.myAlignment, this.mySubBlocks)) {
                    Indent indent = this.shouldIndentContent ? Indent.getNormalIndent() : Indent.getNoneIndent();
                    this.mySubBlocks.add((Block)new CssFormattingModelBuilder.LeafBlock(node, indent));
                }
            }
        } else if (element instanceof PsiErrorElement) {
            element.acceptChildren((PsiElementVisitor)this);
        } else if (element instanceof OuterLanguageElement || element.getNode() != null && element.getNode().getElementType() == CssElementTypes.CSS_BAD_CHARACTER) {
            this.mySubBlocks.add((Block)new CssFormattingModelBuilder.CssSimpleBlock(element.getNode(), Indent.getNoneIndent(), this.myExtension));
        } else {
            ASTNode node = element.getNode();
            if (!FormatterUtil.containsWhiteSpacesOnly((ASTNode)node) && !this.myExtension.addSubBlocksOfExtendedLanguage(element, this.myAlignment, this.mySubBlocks)) {
                this.mySubBlocks.add((Block)new CssFormattingModelBuilder.LeafBlock(node, this.shouldIndentContent ? Indent.getNormalIndent() : Indent.getNoneIndent()));
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customMixin";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mediaFeature";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importList";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "badAtRule";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fontFace";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewPort";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "atRule";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charset";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineNames";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/css/impl/util/editor/CssFormattingElementVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "visitCustomMixin";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitMediaFeature";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "visitCssImportList";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "visitBadAtRule";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "visitCssExpression";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "visitCssFontFace";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "visitCssViewPort";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "visitAtRuleWithNestedRulesets";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "visitCharset";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "visitComment";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "visitLineNames";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

