/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.pico;

import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FList;
import com.intellij.util.pico.AssignableToComponentAdapter;
import com.intellij.util.pico.CachingConstructorInjectionComponentAdapter;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.ComponentMonitor;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.Parameter;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoInitializationException;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.PicoVisitor;
import org.picocontainer.defaults.AmbiguousComponentResolutionException;
import org.picocontainer.defaults.DefaultLifecycleStrategy;
import org.picocontainer.defaults.DelegatingComponentMonitor;
import org.picocontainer.defaults.DuplicateComponentKeyRegistrationException;
import org.picocontainer.defaults.InstanceComponentAdapter;
import org.picocontainer.defaults.LifecycleStrategy;
import org.picocontainer.defaults.VerifyingVisitor;

public class DefaultPicoContainer
implements MutablePicoContainer {
    static final DelegatingComponentMonitor DEFAULT_DELEGATING_COMPONENT_MONITOR = new DelegatingComponentMonitor();
    static final DefaultLifecycleStrategy DEFAULT_LIFECYCLE_STRATEGY = new DefaultLifecycleStrategy((ComponentMonitor)DEFAULT_DELEGATING_COMPONENT_MONITOR);
    private final PicoContainer parent;
    private final Set<PicoContainer> children = new THashSet();
    private final Map<Object, ComponentAdapter> componentKeyToAdapterCache = ContainerUtil.newConcurrentMap();
    private final LinkedHashSetWrapper<ComponentAdapter> componentAdapters = new LinkedHashSetWrapper();
    private final Map<String, ComponentAdapter> classNameToAdapter = ContainerUtil.newConcurrentMap();
    private final AtomicReference<FList<ComponentAdapter>> nonAssignableComponentAdapters = new AtomicReference<FList>(FList.emptyList());

    public DefaultPicoContainer(@Nullable PicoContainer parent) {
        this.parent = parent;
    }

    public DefaultPicoContainer() {
        this(null);
    }

    public Collection<ComponentAdapter> getComponentAdapters() {
        return this.componentAdapters.getImmutableSet();
    }

    private void appendNonAssignableAdaptersOfType(@NotNull Class componentType, @NotNull List<? super ComponentAdapter> result) {
        if (componentType == null) {
            DefaultPicoContainer.$$$reportNull$$$0(0);
        }
        if (result == null) {
            DefaultPicoContainer.$$$reportNull$$$0(1);
        }
        ArrayList<ComponentAdapter> comp = new ArrayList<ComponentAdapter>();
        for (ComponentAdapter componentAdapter : this.nonAssignableComponentAdapters.get()) {
            if (!ReflectionUtil.isAssignable((Class)componentType, (Class)componentAdapter.getComponentImplementation())) continue;
            comp.add(componentAdapter);
        }
        for (int i = comp.size() - 1; i >= 0; --i) {
            result.add((ComponentAdapter)comp.get(i));
        }
    }

    @Nullable
    public final ComponentAdapter getComponentAdapter(Object componentKey) {
        ComponentAdapter adapter = this.getFromCache(componentKey);
        if (adapter == null && this.parent != null) {
            return this.parent.getComponentAdapter(componentKey);
        }
        return adapter;
    }

    @Nullable
    private ComponentAdapter getFromCache(Object componentKey) {
        ComponentAdapter adapter = this.componentKeyToAdapterCache.get(componentKey);
        if (adapter != null) {
            return adapter;
        }
        if (componentKey instanceof Class) {
            return this.componentKeyToAdapterCache.get(((Class)componentKey).getName());
        }
        return null;
    }

    @Nullable
    public ComponentAdapter getComponentAdapterOfType(@NotNull Class componentType) {
        ComponentAdapter adapterByKey;
        if (componentType == null) {
            DefaultPicoContainer.$$$reportNull$$$0(2);
        }
        if ((adapterByKey = this.getComponentAdapter(componentType)) != null) {
            return adapterByKey;
        }
        List<ComponentAdapter> found = this.getComponentAdaptersOfType(componentType);
        if (found.size() == 1) {
            return found.get(0);
        }
        if (found.isEmpty()) {
            return this.parent == null ? null : this.parent.getComponentAdapterOfType(componentType);
        }
        Object[] foundClasses = new Class[found.size()];
        for (int i = 0; i < foundClasses.length; ++i) {
            foundClasses[i] = found.get(i).getComponentImplementation();
        }
        throw new AmbiguousComponentResolutionException(componentType, foundClasses);
    }

    public List<ComponentAdapter> getComponentAdaptersOfType(Class componentType) {
        if (componentType == null || componentType == String.class) {
            return Collections.emptyList();
        }
        SmartList result = new SmartList();
        ComponentAdapter cacheHit = this.classNameToAdapter.get(componentType.getName());
        if (cacheHit != null) {
            result.add(cacheHit);
        }
        this.appendNonAssignableAdaptersOfType(componentType, (List<? super ComponentAdapter>)result);
        return result;
    }

    public ComponentAdapter registerComponent(@NotNull ComponentAdapter componentAdapter) {
        Object componentKey;
        if (componentAdapter == null) {
            DefaultPicoContainer.$$$reportNull$$$0(3);
        }
        if (this.componentKeyToAdapterCache.containsKey(componentKey = componentAdapter.getComponentKey())) {
            throw new DuplicateComponentKeyRegistrationException(componentKey);
        }
        if (componentAdapter instanceof AssignableToComponentAdapter) {
            String classKey = ((AssignableToComponentAdapter)componentAdapter).getAssignableToClassName();
            this.classNameToAdapter.put(classKey, componentAdapter);
        } else {
            FList newList;
            FList<ComponentAdapter> oldList;
            while (!this.nonAssignableComponentAdapters.compareAndSet(oldList = this.nonAssignableComponentAdapters.get(), (FList<ComponentAdapter>)(newList = oldList.prepend((Object)componentAdapter)))) {
            }
        }
        this.componentAdapters.add(componentAdapter);
        this.componentKeyToAdapterCache.put(componentKey, componentAdapter);
        return componentAdapter;
    }

    public ComponentAdapter unregisterComponent(@NotNull Object componentKey) {
        if (componentKey == null) {
            DefaultPicoContainer.$$$reportNull$$$0(4);
        }
        ComponentAdapter adapter = this.componentKeyToAdapterCache.remove(componentKey);
        this.componentAdapters.remove(adapter);
        if (adapter instanceof AssignableToComponentAdapter) {
            this.classNameToAdapter.remove(((AssignableToComponentAdapter)adapter).getAssignableToClassName());
        } else {
            FList newList;
            FList<ComponentAdapter> oldList;
            while (!this.nonAssignableComponentAdapters.compareAndSet(oldList = this.nonAssignableComponentAdapters.get(), (FList<ComponentAdapter>)(newList = oldList.without((Object)adapter)))) {
            }
        }
        return adapter;
    }

    public List getComponentInstances() {
        return this.getComponentInstancesOfType(Object.class);
    }

    public List<Object> getComponentInstancesOfType(@Nullable Class componentType) {
        if (componentType == null) {
            return Collections.emptyList();
        }
        ArrayList<Object> result = new ArrayList<Object>();
        for (ComponentAdapter componentAdapter : this.getComponentAdapters()) {
            if (!ReflectionUtil.isAssignable((Class)componentType, (Class)componentAdapter.getComponentImplementation())) continue;
            ContainerUtil.addIfNotNull(result, (Object)this.getInstance(componentAdapter));
        }
        return result;
    }

    @Nullable
    public <T> T getComponentInstanceIfInstantiated(@NotNull String componentKey) {
        ComponentAdapter adapter;
        if (componentKey == null) {
            DefaultPicoContainer.$$$reportNull$$$0(5);
        }
        if (!((adapter = this.getFromCache(componentKey)) instanceof LazyComponentAdapter)) {
            return (T)this.getComponentInstance(componentKey);
        }
        if (((LazyComponentAdapter)adapter).isComponentInstantiated()) {
            return (T)this.getLocalInstance(adapter);
        }
        return null;
    }

    @Nullable
    public Object getComponentInstance(Object componentKey) {
        ComponentAdapter adapter = this.getFromCache(componentKey);
        if (adapter != null) {
            return this.getLocalInstance(adapter);
        }
        if (this.parent != null && (adapter = this.parent.getComponentAdapter(componentKey)) != null) {
            return this.parent.getComponentInstance(adapter.getComponentKey());
        }
        return null;
    }

    @Nullable
    public Object getComponentInstanceOfType(Class componentType) {
        ComponentAdapter componentAdapter = this.getComponentAdapterOfType(componentType);
        return componentAdapter == null ? null : this.getInstance(componentAdapter);
    }

    @Nullable
    private Object getInstance(@NotNull ComponentAdapter componentAdapter) {
        if (componentAdapter == null) {
            DefaultPicoContainer.$$$reportNull$$$0(6);
        }
        if (this.getComponentAdapters().contains(componentAdapter)) {
            return this.getLocalInstance(componentAdapter);
        }
        if (this.parent != null) {
            return this.parent.getComponentInstance(componentAdapter.getComponentKey());
        }
        return null;
    }

    private Object getLocalInstance(@NotNull ComponentAdapter componentAdapter) {
        if (componentAdapter == null) {
            DefaultPicoContainer.$$$reportNull$$$0(7);
        }
        try {
            return componentAdapter.getComponentInstance((PicoContainer)this);
        }
        catch (PicoInitializationException | PicoIntrospectionException e) {
            Object instance;
            Throwable firstLevelException = e;
            if (this.parent != null && (instance = this.parent.getComponentInstance(componentAdapter.getComponentKey())) != null) {
                return instance;
            }
            throw firstLevelException;
        }
    }

    @Nullable
    public ComponentAdapter unregisterComponentByInstance(@NotNull Object componentInstance) {
        if (componentInstance == null) {
            DefaultPicoContainer.$$$reportNull$$$0(8);
        }
        for (ComponentAdapter adapter : this.getComponentAdapters()) {
            Object o = this.getInstance(adapter);
            if (!componentInstance.equals(o)) continue;
            return this.unregisterComponent(adapter.getComponentKey());
        }
        return null;
    }

    public void verify() {
        new VerifyingVisitor().traverse((Object)this);
    }

    public void start() {
        throw new UnsupportedOperationException();
    }

    public void stop() {
        throw new UnsupportedOperationException();
    }

    public void dispose() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public MutablePicoContainer makeChildContainer() {
        DefaultPicoContainer pc = new DefaultPicoContainer((PicoContainer)this);
        this.addChildContainer((PicoContainer)pc);
        DefaultPicoContainer defaultPicoContainer = pc;
        if (defaultPicoContainer == null) {
            DefaultPicoContainer.$$$reportNull$$$0(9);
        }
        return defaultPicoContainer;
    }

    public boolean addChildContainer(@NotNull PicoContainer child) {
        if (child == null) {
            DefaultPicoContainer.$$$reportNull$$$0(10);
        }
        return this.children.add(child);
    }

    public boolean removeChildContainer(@NotNull PicoContainer child) {
        if (child == null) {
            DefaultPicoContainer.$$$reportNull$$$0(11);
        }
        return this.children.remove(child);
    }

    public void accept(PicoVisitor visitor) {
        visitor.visitContainer((PicoContainer)this);
        for (ComponentAdapter adapter : this.getComponentAdapters()) {
            adapter.accept(visitor);
        }
        for (PicoContainer child : new SmartList(this.children)) {
            child.accept(visitor);
        }
    }

    public ComponentAdapter registerComponentInstance(@NotNull Object component) {
        if (component == null) {
            DefaultPicoContainer.$$$reportNull$$$0(12);
        }
        return this.registerComponentInstance(component.getClass(), component);
    }

    public ComponentAdapter registerComponentInstance(@NotNull Object componentKey, @NotNull Object componentInstance) {
        if (componentKey == null) {
            DefaultPicoContainer.$$$reportNull$$$0(13);
        }
        if (componentInstance == null) {
            DefaultPicoContainer.$$$reportNull$$$0(14);
        }
        return this.registerComponent((ComponentAdapter)new InstanceComponentAdapter(componentKey, componentInstance, (LifecycleStrategy)DEFAULT_LIFECYCLE_STRATEGY));
    }

    public ComponentAdapter registerComponentImplementation(@NotNull Class componentImplementation) {
        if (componentImplementation == null) {
            DefaultPicoContainer.$$$reportNull$$$0(15);
        }
        return this.registerComponentImplementation(componentImplementation, componentImplementation);
    }

    public ComponentAdapter registerComponentImplementation(@NotNull Object componentKey, @NotNull Class componentImplementation) {
        if (componentKey == null) {
            DefaultPicoContainer.$$$reportNull$$$0(16);
        }
        if (componentImplementation == null) {
            DefaultPicoContainer.$$$reportNull$$$0(17);
        }
        return this.registerComponentImplementation(componentKey, componentImplementation, null);
    }

    public ComponentAdapter registerComponentImplementation(@NotNull Object componentKey, @NotNull Class componentImplementation, Parameter[] parameters) {
        if (componentKey == null) {
            DefaultPicoContainer.$$$reportNull$$$0(18);
        }
        if (componentImplementation == null) {
            DefaultPicoContainer.$$$reportNull$$$0(19);
        }
        CachingConstructorInjectionComponentAdapter componentAdapter = new CachingConstructorInjectionComponentAdapter(componentKey, componentImplementation, parameters, true);
        return this.registerComponent((ComponentAdapter)componentAdapter);
    }

    public PicoContainer getParent() {
        return this.parent;
    }

    public String toString() {
        return "DefaultPicoContainer" + (this.getParent() == null ? " (root)" : " (parent=" + this.getParent() + ")");
    }

    @NotNull
    public static StartUpMeasurer.Level getActivityLevel(@NotNull PicoContainer picoContainer) {
        PicoContainer parent;
        if (picoContainer == null) {
            DefaultPicoContainer.$$$reportNull$$$0(20);
        }
        if ((parent = picoContainer.getParent()) == null) {
            StartUpMeasurer.Level level = StartUpMeasurer.Level.APPLICATION;
            if (level == null) {
                DefaultPicoContainer.$$$reportNull$$$0(21);
            }
            return level;
        }
        if (parent.getParent() == null) {
            StartUpMeasurer.Level level = StartUpMeasurer.Level.PROJECT;
            if (level == null) {
                DefaultPicoContainer.$$$reportNull$$$0(22);
            }
            return level;
        }
        StartUpMeasurer.Level level = StartUpMeasurer.Level.MODULE;
        if (level == null) {
            DefaultPicoContainer.$$$reportNull$$$0(23);
        }
        return level;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 21: 
            case 22: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 21: 
            case 22: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentAdapter";
                break;
            }
            case 4: 
            case 5: 
            case 13: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentKey";
                break;
            }
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentInstance";
                break;
            }
            case 9: 
            case 21: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/pico/DefaultPicoContainer";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 15: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentImplementation";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "picoContainer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/pico/DefaultPicoContainer";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "makeChildContainer";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getActivityLevel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "appendNonAssignableAdaptersOfType";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getComponentAdapterOfType";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "registerComponent";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "unregisterComponent";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getComponentInstanceIfInstantiated";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getLocalInstance";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "unregisterComponentByInstance";
                break;
            }
            case 9: 
            case 21: 
            case 22: 
            case 23: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addChildContainer";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "removeChildContainer";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "registerComponentInstance";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "registerComponentImplementation";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getActivityLevel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 21: 
            case 22: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class LinkedHashSetWrapper<T> {
        private final Object lock = new Object();
        private volatile Set<T> immutableSet;
        private LinkedHashSet<T> synchronizedSet = new LinkedHashSet();

        private LinkedHashSetWrapper() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(@NotNull T element) {
            if (element == null) {
                LinkedHashSetWrapper.$$$reportNull$$$0(0);
            }
            Object object = this.lock;
            synchronized (object) {
                if (!this.synchronizedSet.contains(element)) {
                    this.copySyncSetIfExposedAsImmutable().add(element);
                }
            }
        }

        private LinkedHashSet<T> copySyncSetIfExposedAsImmutable() {
            if (this.immutableSet != null) {
                this.immutableSet = null;
                this.synchronizedSet = new LinkedHashSet<T>(this.synchronizedSet);
            }
            return this.synchronizedSet;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove(@Nullable T element) {
            Object object = this.lock;
            synchronized (object) {
                this.copySyncSetIfExposedAsImmutable().remove(element);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public Set<T> getImmutableSet() {
            Set<T> res = this.immutableSet;
            if (res == null) {
                Object object = this.lock;
                synchronized (object) {
                    res = this.immutableSet;
                    if (res == null) {
                        this.immutableSet = res = Collections.unmodifiableSet(this.synchronizedSet);
                    }
                }
            }
            Set<T> set = res;
            if (set == null) {
                LinkedHashSetWrapper.$$$reportNull$$$0(1);
            }
            return set;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/pico/DefaultPicoContainer$LinkedHashSetWrapper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/pico/DefaultPicoContainer$LinkedHashSetWrapper";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getImmutableSet";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "add";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    @FunctionalInterface
    public static interface LazyComponentAdapter {
        public boolean isComponentInstantiated();
    }
}

