/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;

public class VfsTestUtil {
    public static final Key<String> TEST_DATA_FILE_PATH = Key.create((String)"TEST_DATA_FILE_PATH");

    private VfsTestUtil() {
    }

    @NotNull
    public static VirtualFile createFile(@NotNull VirtualFile root, @NotNull String relativePath) {
        if (root == null) {
            VfsTestUtil.$$$reportNull$$$0(0);
        }
        if (relativePath == null) {
            VfsTestUtil.$$$reportNull$$$0(1);
        }
        VirtualFile virtualFile = VfsTestUtil.createFile(root, relativePath, "");
        if (virtualFile == null) {
            VfsTestUtil.$$$reportNull$$$0(2);
        }
        return virtualFile;
    }

    @NotNull
    public static VirtualFile createFile(@NotNull VirtualFile root, @NotNull String relativePath, @NotNull String text) {
        VirtualFile virtualFile;
        if (root == null) {
            VfsTestUtil.$$$reportNull$$$0(3);
        }
        if (relativePath == null) {
            VfsTestUtil.$$$reportNull$$$0(4);
        }
        if (text == null) {
            VfsTestUtil.$$$reportNull$$$0(5);
        }
        try {
            virtualFile = VfsTestUtil.createFileOrDir(root, relativePath, VfsUtil.toByteArray((VirtualFile)root, (String)text), false);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (virtualFile == null) {
            VfsTestUtil.$$$reportNull$$$0(6);
        }
        return virtualFile;
    }

    @NotNull
    public static VirtualFile createFile(@NotNull VirtualFile root, @NotNull String relativePath, @NotNull byte[] data) {
        if (root == null) {
            VfsTestUtil.$$$reportNull$$$0(7);
        }
        if (relativePath == null) {
            VfsTestUtil.$$$reportNull$$$0(8);
        }
        if (data == null) {
            VfsTestUtil.$$$reportNull$$$0(9);
        }
        VirtualFile virtualFile = VfsTestUtil.createFileOrDir(root, relativePath, data, false);
        if (virtualFile == null) {
            VfsTestUtil.$$$reportNull$$$0(10);
        }
        return virtualFile;
    }

    @NotNull
    public static VirtualFile createDir(@NotNull VirtualFile root, @NotNull String relativePath) {
        if (root == null) {
            VfsTestUtil.$$$reportNull$$$0(11);
        }
        if (relativePath == null) {
            VfsTestUtil.$$$reportNull$$$0(12);
        }
        VirtualFile virtualFile = VfsTestUtil.createFileOrDir(root, relativePath, ArrayUtilRt.EMPTY_BYTE_ARRAY, true);
        if (virtualFile == null) {
            VfsTestUtil.$$$reportNull$$$0(13);
        }
        return virtualFile;
    }

    @NotNull
    private static VirtualFile createFileOrDir(VirtualFile root, String relativePath, @NotNull byte[] data, boolean dir) {
        VirtualFile virtualFile;
        if (data == null) {
            VfsTestUtil.$$$reportNull$$$0(14);
        }
        try {
            virtualFile = (VirtualFile)WriteAction.computeAndWait(() -> {
                VirtualFile file;
                VirtualFile parent = root;
                for (String name : StringUtil.tokenize((String)PathUtil.getParentPath((String)relativePath), (String)"/")) {
                    VirtualFile child = parent.findChild(name);
                    if (child == null || !child.isValid()) {
                        child = parent.createChildDirectory(VfsTestUtil.class, name);
                    }
                    parent = child;
                }
                parent.getChildren();
                String name = PathUtil.getFileName((String)relativePath);
                if (dir) {
                    file = parent.createChildDirectory(VfsTestUtil.class, name);
                } else {
                    file = parent.findChild(name);
                    if (file == null) {
                        file = parent.createChildData(VfsTestUtil.class, name);
                    }
                    file.setBinaryContent(data);
                    FileDocumentManager.getInstance().reloadFiles(new VirtualFile[]{file});
                }
                return file;
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (virtualFile == null) {
            VfsTestUtil.$$$reportNull$$$0(15);
        }
        return virtualFile;
    }

    public static void deleteFile(@NotNull VirtualFile file) {
        if (file == null) {
            VfsTestUtil.$$$reportNull$$$0(16);
        }
        try {
            WriteAction.runAndWait(() -> file.delete(null));
        }
        catch (Throwable throwable) {
            ExceptionUtil.rethrow((Throwable)throwable);
        }
    }

    public static void clearContent(@NotNull VirtualFile file) {
        if (file == null) {
            VfsTestUtil.$$$reportNull$$$0(17);
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            try {
                VfsUtil.saveText((VirtualFile)file, (String)"");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public static void overwriteTestData(@NotNull String filePath2, @NotNull String actual) {
        if (filePath2 == null) {
            VfsTestUtil.$$$reportNull$$$0(18);
        }
        if (actual == null) {
            VfsTestUtil.$$$reportNull$$$0(19);
        }
        try {
            FileUtil.writeToFile((File)new File(filePath2), (String)actual);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    @NotNull
    public static VirtualFile findFileByCaseSensitivePath(@NotNull String absolutePath) {
        if (absolutePath == null) {
            VfsTestUtil.$$$reportNull$$$0(20);
        }
        String vfsPath = FileUtil.toSystemIndependentName((String)absolutePath);
        VirtualFile vFile = LocalFileSystem.getInstance().findFileByPath(vfsPath);
        Assert.assertNotNull((String)("file " + absolutePath + " not found"), (Object)vFile);
        String realVfsPath = vFile.getPath();
        if (!SystemInfo.isFileSystemCaseSensitive && !vfsPath.equals(realVfsPath) && vfsPath.equalsIgnoreCase(realVfsPath)) {
            Assert.fail((String)("Please correct case-sensitivity of path to prevent test failure on case-sensitive file systems:\n     path " + vfsPath + "\nreal path " + realVfsPath));
        }
        VirtualFile virtualFile = vFile;
        if (virtualFile == null) {
            VfsTestUtil.$$$reportNull$$$0(21);
        }
        return virtualFile;
    }

    public static void assertFilePathEndsWithCaseSensitivePath(@NotNull VirtualFile file, @NotNull String suffixPath) {
        if (file == null) {
            VfsTestUtil.$$$reportNull$$$0(22);
        }
        if (suffixPath == null) {
            VfsTestUtil.$$$reportNull$$$0(23);
        }
        String vfsSuffixPath = FileUtil.toSystemIndependentName((String)suffixPath);
        String vfsPath = file.getPath();
        if (!SystemInfo.isFileSystemCaseSensitive && !vfsPath.endsWith(vfsSuffixPath) && StringUtil.endsWithIgnoreCase((String)vfsPath, (String)vfsSuffixPath)) {
            String realSuffixPath = vfsPath.substring(vfsPath.length() - vfsSuffixPath.length());
            Assert.fail((String)("Please correct case-sensitivity of path to prevent test failure on case-sensitive file systems:\n     path " + suffixPath + "\nreal path " + realSuffixPath));
        }
    }

    @NotNull
    public static List<VFileEvent> getEvents(@NotNull Runnable action) {
        if (action == null) {
            VfsTestUtil.$$$reportNull$$$0(24);
        }
        final ArrayList<VFileEvent> allEvents = new ArrayList<VFileEvent>();
        MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect();
        connection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void after(@NotNull List<? extends VFileEvent> events) {
                if (events == null) {
                    1.$$$reportNull$$$0(0);
                }
                allEvents.addAll(events);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/testFramework/VfsTestUtil$1", "after"));
            }
        });
        try {
            action.run();
        }
        finally {
            connection.disconnect();
        }
        ArrayList<VFileEvent> arrayList = allEvents;
        if (arrayList == null) {
            VfsTestUtil.$$$reportNull$$$0(25);
        }
        return arrayList;
    }

    @NotNull
    public static List<String> print(@NotNull List<? extends VFileEvent> events) {
        if (events == null) {
            VfsTestUtil.$$$reportNull$$$0(26);
        }
        List list = ContainerUtil.map(events, VfsTestUtil::print);
        if (list == null) {
            VfsTestUtil.$$$reportNull$$$0(27);
        }
        return list;
    }

    private static String print(VFileEvent e) {
        int type = 63;
        if (e instanceof VFileCreateEvent) {
            type = 67;
        } else if (e instanceof VFileDeleteEvent) {
            type = 68;
        } else if (e instanceof VFileContentChangeEvent) {
            type = 85;
        } else if (e instanceof VFilePropertyChangeEvent) {
            type = 80;
        }
        return (char)type + " : " + e.getPath();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: 
            case 10: 
            case 13: 
            case 15: 
            case 21: 
            case 25: 
            case 27: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 6: 
            case 10: 
            case 13: 
            case 15: 
            case 21: 
            case 25: 
            case 27: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 2: 
            case 6: 
            case 10: 
            case 13: 
            case 15: 
            case 21: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/VfsTestUtil";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 16: 
            case 17: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actual";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "absolutePath";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffixPath";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "events";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/VfsTestUtil";
                break;
            }
            case 2: 
            case 6: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createFile";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createDir";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createFileOrDir";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "findFileByCaseSensitivePath";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getEvents";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "print";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createFile";
                break;
            }
            case 2: 
            case 6: 
            case 10: 
            case 13: 
            case 15: 
            case 21: 
            case 25: 
            case 27: {
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createDir";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createFileOrDir";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "deleteFile";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "clearContent";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "overwriteTestData";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findFileByCaseSensitivePath";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "assertFilePathEndsWithCaseSensitivePath";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getEvents";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "print";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 6: 
            case 10: 
            case 13: 
            case 15: 
            case 21: 
            case 25: 
            case 27: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

