/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk;

import com.intellij.internal.statistic.beans.ConvertUsagesUtil;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.ApplicationUsagesCollector;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.project.Project;
import com.intellij.remote.CredentialsType;
import com.jetbrains.plugins.remotesdk.RemoteSdkUsagesProvider;
import gnu.trove.THashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteSdkTypeUsagesCollector {
    @NotNull
    private static Set<UsageDescriptor> collectUsages(@Nullable Project project) {
        RemoteSdkUsagesProvider[] providers;
        THashSet usages = new THashSet();
        for (RemoteSdkUsagesProvider provider : providers = RemoteSdkUsagesProvider.getInstances()) {
            Map<CredentialsType, Long> collected = provider.getRemoteSdks(project).stream().map(sdk -> sdk.getRemoteConnectionType()).collect(Collectors.groupingBy(type -> type, Collectors.counting()));
            FeatureUsageData data = new FeatureUsageData().addLanguage(provider.getLanguage()).addData("level", project == null ? "ide" : "project");
            for (Map.Entry<CredentialsType, Long> entry : collected.entrySet()) {
                CredentialsType key = entry.getKey();
                String typeName = PluginInfoDetectorKt.getPluginInfo(key.getClass()).isDevelopedByJetBrains() ? ConvertUsagesUtil.escapeDescriptorName((String)key.getName()) : "third.party";
                int count = entry.getValue() > Integer.MAX_VALUE ? Integer.MAX_VALUE : entry.getValue().intValue();
                usages.add(new UsageDescriptor(typeName, count, data));
            }
        }
        THashSet tHashSet = usages;
        if (tHashSet == null) {
            RemoteSdkTypeUsagesCollector.$$$reportNull$$$0(0);
        }
        return tHashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/remotesdk/RemoteSdkTypeUsagesCollector", "collectUsages"));
    }

    public static class ProjectCollector
    extends ProjectUsagesCollector {
        @NotNull
        public String getGroupId() {
            if ("remote.sdk.type" == null) {
                ProjectCollector.$$$reportNull$$$0(0);
            }
            return "remote.sdk.type";
        }

        @NotNull
        public Set<UsageDescriptor> getUsages(@NotNull Project project) {
            if (project == null) {
                ProjectCollector.$$$reportNull$$$0(1);
            }
            Set set = RemoteSdkTypeUsagesCollector.collectUsages(project);
            if (set == null) {
                ProjectCollector.$$$reportNull$$$0(2);
            }
            return set;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/plugins/remotesdk/RemoteSdkTypeUsagesCollector$ProjectCollector";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGroupId";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/plugins/remotesdk/RemoteSdkTypeUsagesCollector$ProjectCollector";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUsages";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getUsages";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class AppCollector
    extends ApplicationUsagesCollector {
        @NotNull
        public String getGroupId() {
            if ("remote.sdk.type" == null) {
                AppCollector.$$$reportNull$$$0(0);
            }
            return "remote.sdk.type";
        }

        @NotNull
        public Set<UsageDescriptor> getUsages() {
            Set set = RemoteSdkTypeUsagesCollector.collectUsages(null);
            if (set == null) {
                AppCollector.$$$reportNull$$$0(1);
            }
            return set;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/jetbrains/plugins/remotesdk/RemoteSdkTypeUsagesCollector$AppCollector";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGroupId";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUsages";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

