/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.utils;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.util.ConcurrencyUtil;
import com.jetbrains.performancePlugin.CommandLogger;
import com.jetbrains.performancePlugin.MessagesBundle;
import com.jetbrains.performancePlugin.PlaybackRunnerExtended;
import com.jetbrains.performancePlugin.Timer;
import com.jetbrains.performancePlugin.profilers.ProfilersController;
import com.jetbrains.performancePlugin.ui.FinishScriptDialog;
import java.io.File;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScriptRunner {
    private boolean isCanceled = false;

    public void doRunScript(final @NotNull Project project, @NotNull String text, @Nullable File workingDir) {
        if (project == null) {
            ScriptRunner.$$$reportNull$$$0(0);
        }
        if (text == null) {
            ScriptRunner.$$$reportNull$$$0(1);
        }
        final PlaybackRunnerExtended runner = new PlaybackRunnerExtended(text, new CommandLogger(), project);
        runner.setScriptDir(workingDir);
        final Timer timer = new Timer();
        timer.start();
        Task.Backgroundable task = new Task.Backgroundable(project, "Executing Performance Script"){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                CountDownLatch countDownLatch = new CountDownLatch(1);
                runner.run().doWhenDone(() -> countDownLatch.countDown()).doWhenRejected(() -> {
                    countDownLatch.countDown();
                    ScriptRunner.this.isCanceled = true;
                });
                ScheduledThreadPoolExecutor myExecutor = ConcurrencyUtil.newSingleScheduledThreadExecutor((String)"Performance plugin script runner");
                myExecutor.scheduleWithFixedDelay(() -> {
                    if (indicator.isCanceled()) {
                        runner.stop();
                    }
                }, 0L, 100L, TimeUnit.MILLISECONDS);
                try {
                    countDownLatch.await();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                myExecutor.shutdownNow();
                timer.stop();
                ApplicationManager.getApplication().invokeLater(() -> {
                    Notifications.Bus.notify((Notification)ScriptRunner.getDelayNotification(timer.getTotalTime(), timer.getAverageDelay(), timer.getLongestDelay()), (Project)project);
                    if (!ScriptRunner.this.isCanceled && ProfilersController.getInstance().isStoppedByScript()) {
                        new FinishScriptDialog(project).show();
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/performancePlugin/utils/ScriptRunner$1", "run"));
            }
        };
        ProgressManager.getInstance().run((Task)task);
    }

    @NotNull
    private static Notification getDelayNotification(long totalTime, long averageDelay, long maxDelay) {
        Notification notification = new Notification("PerformancePlugin", MessagesBundle.message("delay.notification.title", new Object[0]), MessagesBundle.message("delay.notification.message", totalTime, averageDelay, maxDelay), NotificationType.INFORMATION);
        if (notification == null) {
            ScriptRunner.$$$reportNull$$$0(2);
        }
        return notification;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/performancePlugin/utils/ScriptRunner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/performancePlugin/utils/ScriptRunner";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDelayNotification";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doRunScript";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

