/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.intellij.datalore.actions.publishing;

import com.intellij.ide.BrowserUtil;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.ui.AnimatedIcon;
import com.jetbrains.intellij.datalore.DataloreBundle;
import com.jetbrains.intellij.datalore.actions.publishing.AuthorizedPublishingAction;
import com.jetbrains.intellij.datalore.api.DataloreViewRequests;
import com.jetbrains.intellij.datalore.forms.PublishingSignInDialog;
import com.jetbrains.intellij.datalore.models.DatalorePublishingTokenResponse;
import com.jetbrains.intellij.datalore.services.AuthService;
import com.jetbrains.intellij.datalore.statistics.DataloreActionsCounterCollector;
import com.jetbrains.intellij.datalore.statistics.LoggedActionWithResult;
import com.jetbrains.intellij.datalore.util.BackgroundableCancellableTaskWithTimer;
import com.jetbrains.intellij.datalore.util.DataloreIconsKt;
import com.jetbrains.intellij.datalore.util.NotificationUtil;
import java.net.URI;
import java.util.Timer;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u00002\u00020\u0001:\u0002\u0018\u0019B3\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0016\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0003H\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/intellij/datalore/actions/publishing/AuthorizedPublishingAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "text", "", "description", "icon", "Ljavax/swing/Icon;", "showDialog", "", "(Ljava/lang/String;Ljava/lang/String;Ljavax/swing/Icon;Z)V", "myAuthService", "Lcom/jetbrains/intellij/datalore/services/AuthService;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "doAction", "onCancelSignIn", "project", "Lcom/intellij/openapi/project/Project;", "onErrorSignIn", "onSuccessSignIn", "signIn", "confirmationToken", "CancelAction", "TryAgainAction", "datalore-intellij-plugin"})
public abstract class AuthorizedPublishingAction
extends AnAction {
    private final AuthService myAuthService;
    private final boolean showDialog;

    /*
     * WARNING - void declaration
     */
    public void actionPerformed(@NotNull AnActionEvent e) {
        void canceled;
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"e.project ?: return");
        Project project2 = project;
        boolean wasSignedIn = this.myAuthService.isPublishedSignedIn();
        Presentation presentation = e.getPresentation();
        Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"e.presentation");
        presentation.setEnabled(false);
        CloseableHttpClient client = HttpClients.createDefault();
        Ref.BooleanRef booleanRef = new Ref.BooleanRef();
        booleanRef.element = false;
        BackgroundableCancellableTaskWithTimer checkTokenTask2 = new BackgroundableCancellableTaskWithTimer(this, client, (Ref.BooleanRef)canceled, project2, e, wasSignedIn, project2, DataloreBundle.INSTANCE.message("datalore.publishing.sign_in.check_token_progress", new Object[0])){
            final /* synthetic */ AuthorizedPublishingAction this$0;
            final /* synthetic */ CloseableHttpClient $client;
            final /* synthetic */ Ref.BooleanRef $canceled;
            final /* synthetic */ Project $project;
            final /* synthetic */ AnActionEvent $e;
            final /* synthetic */ boolean $wasSignedIn;

            protected void doRun(@NotNull ProgressIndicator indicator) {
                DatalorePublishingTokenResponse status;
                DatalorePublishingTokenResponse datalorePublishingTokenResponse;
                Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
                indicator.setIndeterminate(true);
                if (!AuthorizedPublishingAction.access$getMyAuthService$p(this.this$0).hasPublishingToken()) {
                    AuthService authService = AuthorizedPublishingAction.access$getMyAuthService$p(this.this$0);
                    CloseableHttpClient closeableHttpClient = this.$client;
                    Intrinsics.checkExpressionValueIsNotNull((Object)closeableHttpClient, (String)"client");
                    datalorePublishingTokenResponse = authService.receivePublishingToken((HttpClient)closeableHttpClient);
                } else {
                    AuthService authService = AuthorizedPublishingAction.access$getMyAuthService$p(this.this$0);
                    CloseableHttpClient closeableHttpClient = this.$client;
                    Intrinsics.checkExpressionValueIsNotNull((Object)closeableHttpClient, (String)"client");
                    datalorePublishingTokenResponse = status = authService.validatePublishingToken((HttpClient)closeableHttpClient);
                }
                if (!this.$canceled.element) {
                    ApplicationManager.getApplication().invokeLater(new Runnable(this, status){
                        final /* synthetic */ actionPerformed.checkTokenTask.1 this$0;
                        final /* synthetic */ DatalorePublishingTokenResponse $status;

                        public final void run() {
                            if (this.$status == null) {
                                AuthorizedPublishingAction.access$onErrorSignIn(this.this$0.this$0, this.this$0.$project);
                                Presentation presentation = this.this$0.$e.getPresentation();
                                Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"e.presentation");
                                presentation.setEnabled(true);
                                return;
                            }
                            if (this.$status.getConfirmationToken() != null) {
                                AuthorizedPublishingAction.access$signIn(this.this$0.this$0, this.this$0.$e, this.$status.getConfirmationToken());
                            } else {
                                if (!this.this$0.$wasSignedIn) {
                                    AuthorizedPublishingAction.access$onSuccessSignIn(this.this$0.this$0, this.this$0.$project);
                                }
                                this.this$0.this$0.doAction(this.this$0.$e);
                                Presentation presentation = this.this$0.$e.getPresentation();
                                Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"e.presentation");
                                presentation.setEnabled(true);
                            }
                        }
                        {
                            this.this$0 = var1_1;
                            this.$status = datalorePublishingTokenResponse;
                        }
                    });
                }
            }

            protected void doOnCancel() {
                this.$canceled.element = true;
                this.$client.close();
                DataloreActionsCounterCollector.INSTANCE.countCancel(LoggedActionWithResult.SIGN_IN);
                Presentation presentation = this.$e.getPresentation();
                Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"e.presentation");
                presentation.setEnabled(true);
            }
            {
                this.this$0 = $outer;
                this.$client = $captured_local_variable$1;
                this.$canceled = $captured_local_variable$2;
                this.$project = $captured_local_variable$3;
                this.$e = $captured_local_variable$4;
                this.$wasSignedIn = $captured_local_variable$5;
                super($super_call_param$6, $super_call_param$7, 0L, 0L, false, 28, null);
            }
        };
        checkTokenTask2.queue();
    }

    private final void signIn(AnActionEvent e, String confirmationToken) {
        PublishingSignInDialog signInDialog;
        boolean ok;
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"e.project ?: return");
        Project project2 = project;
        if (this.showDialog && !(ok = (signInDialog = new PublishingSignInDialog(project2, confirmationToken)).showAndGet())) {
            this.onCancelSignIn(project2);
            Presentation presentation = e.getPresentation();
            Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"e.presentation");
            presentation.setEnabled(true);
            return;
        }
        BrowserUtil.browse((URI)DataloreViewRequests.INSTANCE.getConfirmTokenUrl(confirmationToken));
        Notification notification = new Notification(NotificationUtil.INSTANCE.getSTICKY_DATALORE_NOTIFICATION_GROUP().getDisplayId(), (Icon)new AnimatedIcon.Default(), DataloreBundle.INSTANCE.message("datalore.publishing.sign_in.text.waiting.title", new Object[0]), null, DataloreBundle.INSTANCE.message("datalore.publishing.sign_in.text.waiting.description", new Object[0]), NotificationType.INFORMATION, null);
        notification.addAction((AnAction)new TryAgainAction(confirmationToken));
        Timer timer = new Timer();
        notification.addAction((AnAction)new CancelAction(notification, timer));
        notification.whenExpired(new Runnable(this, timer, e, project2){
            final /* synthetic */ AuthorizedPublishingAction this$0;
            final /* synthetic */ Timer $timer;
            final /* synthetic */ AnActionEvent $e;
            final /* synthetic */ Project $project;

            public final void run() {
                this.$timer.cancel();
                this.$timer.purge();
                AuthorizedPublishingAction.access$getMyAuthService$p(this.this$0).getTimerTask().cancel();
                Presentation presentation = this.$e.getPresentation();
                Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"e.presentation");
                presentation.setEnabled(true);
                if (AuthorizedPublishingAction.access$getMyAuthService$p(this.this$0).isPublishedSignedIn()) {
                    AuthorizedPublishingAction.access$onSuccessSignIn(this.this$0, this.$project);
                } else {
                    AuthorizedPublishingAction.access$onCancelSignIn(this.this$0, this.$project);
                }
            }
            {
                this.this$0 = authorizedPublishingAction;
                this.$timer = timer;
                this.$e = anActionEvent;
                this.$project = project;
            }
        });
        notification.notify(project2);
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(this, timer, notification, e){
            final /* synthetic */ AuthorizedPublishingAction this$0;
            final /* synthetic */ Timer $timer;
            final /* synthetic */ Notification $notification;
            final /* synthetic */ AnActionEvent $e;

            public final void run() {
                AuthorizedPublishingAction.access$getMyAuthService$p(this.this$0).waitForValidation(this.$timer);
                ApplicationManager.getApplication().invokeLater(new Runnable(this){
                    final /* synthetic */ signIn.2 this$0;

                    public final void run() {
                        this.this$0.$notification.expire();
                        if (AuthorizedPublishingAction.access$getMyAuthService$p(this.this$0.this$0).isPublishedSignedIn()) {
                            this.this$0.this$0.doAction(this.this$0.$e);
                        }
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.this$0 = authorizedPublishingAction;
                this.$timer = timer;
                this.$notification = notification;
                this.$e = anActionEvent;
            }
        });
    }

    private final void onSuccessSignIn(Project project) {
        DataloreActionsCounterCollector.INSTANCE.countSuccess(LoggedActionWithResult.SIGN_IN);
        Notification notification = new Notification(NotificationUtil.INSTANCE.getDATALORE_NOTIFICATION_GROUP().getDisplayId(), DataloreIconsKt.getSUCCESS_ICON(), DataloreBundle.INSTANCE.message("datalore.publishing.sign_in.notification.ok.title", new Object[0]), null, DataloreBundle.INSTANCE.message("datalore.publishing.sign_in.notification.ok.description", new Object[0]), NotificationType.INFORMATION, null);
        notification.notify(project);
    }

    private final void onCancelSignIn(Project project) {
        DataloreActionsCounterCollector.INSTANCE.countCancel(LoggedActionWithResult.SIGN_IN);
        Notification notification = new Notification(NotificationUtil.INSTANCE.getDATALORE_NOTIFICATION_GROUP().getDisplayId(), DataloreIconsKt.getFAIL_ICON(), DataloreBundle.INSTANCE.message("datalore.publishing.sign_in.notification.cancel.title", new Object[0]), null, DataloreBundle.INSTANCE.message("datalore.publishing.sign_in.notification.cancel.description", new Object[0]), NotificationType.WARNING, null);
        notification.notify(project);
    }

    private final void onErrorSignIn(Project project) {
        DataloreActionsCounterCollector.INSTANCE.countError(LoggedActionWithResult.SIGN_IN);
        Notification notification = new Notification(NotificationUtil.INSTANCE.getDATALORE_NOTIFICATION_GROUP().getDisplayId(), DataloreIconsKt.getFAIL_ICON(), DataloreBundle.INSTANCE.message("datalore.publishing.sign_in.notification.error.title", new Object[0]), null, DataloreBundle.INSTANCE.message("datalore.publishing.sign_in.notification.error.description", new Object[0]), NotificationType.ERROR, null);
        notification.notify(project);
    }

    protected void doAction(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
    }

    public AuthorizedPublishingAction(@Nullable String text, @Nullable String description, @Nullable Icon icon, boolean showDialog) {
        super(text, description, icon);
        this.showDialog = showDialog;
        this.myAuthService = AuthService.Companion.getInstance();
    }

    public /* synthetic */ AuthorizedPublishingAction(String string, String string2, Icon icon, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            icon = null;
        }
        if ((n & 8) != 0) {
            bl = true;
        }
        this(string, string2, icon, bl);
    }

    public AuthorizedPublishingAction() {
        this(null, null, null, false, 15, null);
    }

    public static final /* synthetic */ void access$onErrorSignIn(AuthorizedPublishingAction $this, Project project) {
        $this.onErrorSignIn(project);
    }

    public static final /* synthetic */ void access$signIn(AuthorizedPublishingAction $this, AnActionEvent e, String confirmationToken) {
        $this.signIn(e, confirmationToken);
    }

    public static final /* synthetic */ void access$onSuccessSignIn(AuthorizedPublishingAction $this, Project project) {
        $this.onSuccessSignIn(project);
    }

    public static final /* synthetic */ void access$onCancelSignIn(AuthorizedPublishingAction $this, Project project) {
        $this.onCancelSignIn(project);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/intellij/datalore/actions/publishing/AuthorizedPublishingAction$TryAgainAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "confirmationToken", "", "(Ljava/lang/String;)V", "myUrl", "Ljava/net/URI;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "datalore-intellij-plugin"})
    private static final class TryAgainAction
    extends AnAction {
        private final URI myUrl;

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            BrowserUtil.browse((URI)this.myUrl);
        }

        public TryAgainAction(@NotNull String confirmationToken) {
            Intrinsics.checkParameterIsNotNull((Object)confirmationToken, (String)"confirmationToken");
            super("Try again");
            this.myUrl = DataloreViewRequests.INSTANCE.getConfirmTokenUrl(confirmationToken);
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/intellij/datalore/actions/publishing/AuthorizedPublishingAction$CancelAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "myNotification", "Lcom/intellij/notification/Notification;", "myTimer", "Ljava/util/Timer;", "(Lcom/jetbrains/intellij/datalore/actions/publishing/AuthorizedPublishingAction;Lcom/intellij/notification/Notification;Ljava/util/Timer;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "datalore-intellij-plugin"})
    private final class CancelAction
    extends AnAction {
        private final Notification myNotification;
        private final Timer myTimer;

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            this.myTimer.cancel();
            this.myTimer.purge();
            AuthorizedPublishingAction.this.myAuthService.getTimerTask().cancel();
            this.myNotification.expire();
        }

        public CancelAction(@NotNull Notification myNotification, Timer myTimer) {
            Intrinsics.checkParameterIsNotNull((Object)myNotification, (String)"myNotification");
            Intrinsics.checkParameterIsNotNull((Object)myTimer, (String)"myTimer");
            super("Cancel");
            this.myNotification = myNotification;
            this.myTimer = myTimer;
        }
    }
}

