/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.Url;
import com.intellij.util.io.CountingGZIPInputStream;
import com.intellij.util.io.HttpUrlConnectionUtil;
import com.intellij.util.io.ProgressMonitorInputStream;
import com.intellij.util.io.RequestBuilder;
import com.intellij.util.net.HttpConfigurable;
import com.intellij.util.net.NetUtils;
import com.intellij.util.net.ssl.CertificateManager;
import com.intellij.util.net.ssl.UntrustedCertificateStrategy;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSocketFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HttpRequests {
    private static final Logger LOG = Logger.getInstance(HttpRequests.class);
    public static final String JSON_CONTENT_TYPE = "application/json; charset=utf-8";
    public static final int CONNECTION_TIMEOUT = SystemProperties.getIntProperty((String)"idea.connection.timeout", (int)10000);
    public static final int READ_TIMEOUT = SystemProperties.getIntProperty((String)"idea.read.timeout", (int)60000);
    public static final int REDIRECT_LIMIT = SystemProperties.getIntProperty((String)"idea.redirect.limit", (int)10);
    private static final int[] REDIRECTS = new int[]{302, 307, 301, 303, 308};

    private HttpRequests() {
    }

    @NotNull
    public static RequestBuilder request(@NotNull Url url) {
        if (url == null) {
            HttpRequests.$$$reportNull$$$0(0);
        }
        RequestBuilder requestBuilder = HttpRequests.request(url.toExternalForm());
        if (requestBuilder == null) {
            HttpRequests.$$$reportNull$$$0(1);
        }
        return requestBuilder;
    }

    @NotNull
    public static RequestBuilder request(@NotNull String url) {
        if (url == null) {
            HttpRequests.$$$reportNull$$$0(2);
        }
        RequestBuilderImpl requestBuilderImpl = new RequestBuilderImpl(url, null);
        if (requestBuilderImpl == null) {
            HttpRequests.$$$reportNull$$$0(3);
        }
        return requestBuilderImpl;
    }

    @NotNull
    public static RequestBuilder head(@NotNull String url) {
        if (url == null) {
            HttpRequests.$$$reportNull$$$0(4);
        }
        RequestBuilderImpl requestBuilderImpl = new RequestBuilderImpl(url, connection -> ((HttpURLConnection)connection).setRequestMethod("HEAD"));
        if (requestBuilderImpl == null) {
            HttpRequests.$$$reportNull$$$0(5);
        }
        return requestBuilderImpl;
    }

    @NotNull
    public static RequestBuilder delete(@NotNull String url) {
        if (url == null) {
            HttpRequests.$$$reportNull$$$0(6);
        }
        RequestBuilderImpl requestBuilderImpl = new RequestBuilderImpl(url, connection -> ((HttpURLConnection)connection).setRequestMethod("DELETE"));
        if (requestBuilderImpl == null) {
            HttpRequests.$$$reportNull$$$0(7);
        }
        return requestBuilderImpl;
    }

    @NotNull
    public static RequestBuilder delete(@NotNull String url, @Nullable String contentType) {
        if (url == null) {
            HttpRequests.$$$reportNull$$$0(8);
        }
        RequestBuilder requestBuilder = HttpRequests.requestWithBody(url, "DELETE", contentType, null);
        if (requestBuilder == null) {
            HttpRequests.$$$reportNull$$$0(9);
        }
        return requestBuilder;
    }

    @NotNull
    public static RequestBuilder post(@NotNull String url, @Nullable String contentType) {
        if (url == null) {
            HttpRequests.$$$reportNull$$$0(10);
        }
        RequestBuilder requestBuilder = HttpRequests.requestWithBody(url, "POST", contentType, null);
        if (requestBuilder == null) {
            HttpRequests.$$$reportNull$$$0(11);
        }
        return requestBuilder;
    }

    @NotNull
    public static RequestBuilder put(@NotNull String url, @Nullable String contentType) {
        if (url == null) {
            HttpRequests.$$$reportNull$$$0(12);
        }
        RequestBuilder requestBuilder = HttpRequests.requestWithBody(url, "PUT", contentType, null);
        if (requestBuilder == null) {
            HttpRequests.$$$reportNull$$$0(13);
        }
        return requestBuilder;
    }

    @NotNull
    public static RequestBuilder patch(@NotNull String url, @Nullable String contentType) {
        if (url == null) {
            HttpRequests.$$$reportNull$$$0(14);
        }
        RequestBuilder requestBuilder = HttpRequests.requestWithBody(url, "POST", contentType, connection -> connection.setRequestProperty("X-HTTP-Method-Override", "PATCH"));
        if (requestBuilder == null) {
            HttpRequests.$$$reportNull$$$0(15);
        }
        return requestBuilder;
    }

    @NotNull
    private static RequestBuilder requestWithBody(@NotNull String url, @NotNull String requestMethod, @Nullable String contentType, @Nullable ConnectionTuner tuner) {
        if (url == null) {
            HttpRequests.$$$reportNull$$$0(16);
        }
        if (requestMethod == null) {
            HttpRequests.$$$reportNull$$$0(17);
        }
        RequestBuilderImpl requestBuilderImpl = new RequestBuilderImpl(url, rawConnection -> {
            HttpURLConnection connection = (HttpURLConnection)rawConnection;
            connection.setRequestMethod(requestMethod);
            connection.setDoOutput(true);
            if (contentType != null) {
                connection.setRequestProperty("Content-Type", contentType);
            }
            if (tuner != null) {
                tuner.tune(connection);
            }
        });
        if (requestBuilderImpl == null) {
            HttpRequests.$$$reportNull$$$0(18);
        }
        return requestBuilderImpl;
    }

    @NotNull
    public static String createErrorMessage(@NotNull IOException e, @NotNull Request request, boolean includeHeaders) {
        if (e == null) {
            HttpRequests.$$$reportNull$$$0(19);
        }
        if (request == null) {
            HttpRequests.$$$reportNull$$$0(20);
        }
        StringBuilder builder = new StringBuilder();
        builder.append("Cannot download '").append(request.getURL()).append("': ").append(e.getMessage());
        try {
            URLConnection connection = request.getConnection();
            if (includeHeaders) {
                builder.append("\n, headers: ").append(connection.getHeaderFields());
            }
            if (connection instanceof HttpURLConnection) {
                HttpURLConnection httpConnection = (HttpURLConnection)connection;
                builder.append("\n, response: ").append(httpConnection.getResponseCode()).append(' ').append(httpConnection.getResponseMessage());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        String string = builder.toString();
        if (string == null) {
            HttpRequests.$$$reportNull$$$0(21);
        }
        return string;
    }

    /*
     * Loose catch block
     */
    private static <T> T process(RequestBuilderImpl builder, RequestProcessor<T> processor) throws IOException {
        Application app = ApplicationManager.getApplication();
        LOG.assertTrue(app == null || app.isUnitTestMode() || app.isHeadlessEnvironment() || !app.isReadAccessAllowed(), (Object)"Network shouldn't be accessed in EDT or inside read action");
        ClassLoader contextLoader = Thread.currentThread().getContextClassLoader();
        if (contextLoader != null && HttpRequests.shouldOverrideContextClassLoader()) {
            try {
                T t;
                try (URLClassLoader cl = new URLClassLoader(new URL[0], contextLoader);){
                    Thread.currentThread().setContextClassLoader(cl);
                    t = HttpRequests.doProcess(builder, processor);
                }
                return t;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(contextLoader);
            }
        }
        return HttpRequests.doProcess(builder, processor);
    }

    private static boolean shouldOverrideContextClassLoader() {
        return SystemProperties.getBooleanProperty((String)"http.requests.override.context.classloader", (boolean)true);
    }

    private static <T> T doProcess(RequestBuilderImpl builder, RequestProcessor<T> processor) throws IOException {
        CertificateManager manager = builder.myUntrustedCertificateStrategy == null || ApplicationManager.getApplication() == null ? null : CertificateManager.getInstance();
        try (RequestImpl request = new RequestImpl(builder);){
            HttpURLConnection urlConnection;
            int responseCode;
            URLConnection connection;
            T result = manager != null ? manager.runWithUntrustedCertificateStrategy(() -> processor.process(request), builder.myUntrustedCertificateStrategy) : processor.process(request);
            if (builder.myThrowStatusCodeException && (connection = request.myConnection) != null && connection.getDoOutput() && (responseCode = (urlConnection = (HttpURLConnection)connection).getResponseCode()) >= 400) {
                HttpRequests.throwHttpStatusError(urlConnection, request, builder, responseCode);
            }
            T t = result;
            return t;
        }
    }

    private static URLConnection openConnection(RequestBuilderImpl builder, RequestImpl request) throws IOException {
        if (builder.myForceHttps && StringUtil.startsWith((CharSequence)request.myUrl, (CharSequence)"http:")) {
            request.myUrl = "https:" + request.myUrl.substring(5);
        }
        for (int i = 0; i < builder.myRedirectLimit; ++i) {
            String url;
            block22: {
                URLConnection connection;
                block20: {
                    int responseCode;
                    HttpURLConnection httpURLConnection;
                    block21: {
                        url = request.myUrl;
                        connection = !builder.myUseProxy ? new URL(url).openConnection(Proxy.NO_PROXY) : (ApplicationManager.getApplication() == null ? new URL(url).openConnection() : HttpConfigurable.getInstance().openConnection(url));
                        if (connection instanceof HttpsURLConnection) {
                            HttpRequests.configureSslConnection(url, (HttpsURLConnection)connection);
                        }
                        connection.setConnectTimeout(builder.myConnectTimeout);
                        connection.setReadTimeout(builder.myTimeout);
                        if (builder.myUserAgent != null) {
                            connection.setRequestProperty("User-Agent", builder.myUserAgent);
                        }
                        if (builder.myHostnameVerifier != null && connection instanceof HttpsURLConnection) {
                            ((HttpsURLConnection)connection).setHostnameVerifier(builder.myHostnameVerifier);
                        }
                        if (builder.myGzip) {
                            connection.setRequestProperty("Accept-Encoding", "gzip");
                        }
                        if (builder.myAccept != null) {
                            connection.setRequestProperty("Accept", builder.myAccept);
                        }
                        connection.setUseCaches(false);
                        if (builder.myInternalTuner != null) {
                            builder.myInternalTuner.tune(connection);
                        }
                        if (builder.myTuner != null) {
                            builder.myTuner.tune(connection);
                        }
                        HttpRequests.checkRequestHeadersForNulBytes(connection);
                        if (!(connection instanceof HttpURLConnection)) {
                            return connection;
                        }
                        if (connection.getDoOutput()) {
                            return connection;
                        }
                        httpURLConnection = (HttpURLConnection)connection;
                        String method = httpURLConnection.getRequestMethod();
                        LOG.assertTrue(method.equals("GET") || method.equals("HEAD") || method.equals("DELETE"), (Object)("'" + method + "' not supported; please use GET, HEAD, DELETE, PUT or POST"));
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("connecting to " + url);
                        }
                        try {
                            responseCode = httpURLConnection.getResponseCode();
                        }
                        catch (SSLHandshakeException e) {
                            throw !NetUtils.isSniEnabled() ? new SSLException("SSL error probably caused by disabled SNI", e) : e;
                        }
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("response from " + url + ": " + responseCode);
                        }
                        if (responseCode >= 200 && (responseCode < 300 || responseCode == 304)) break block20;
                        if (ArrayUtil.indexOf((int[])REDIRECTS, (int)responseCode) < 0) break block21;
                        httpURLConnection.disconnect();
                        url = connection.getHeaderField("Location");
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("redirect from " + url + ": " + url);
                        }
                        if (url != null) break block22;
                    }
                    if (builder.myThrowStatusCodeException) {
                        HttpRequests.throwHttpStatusError(httpURLConnection, request, builder, responseCode);
                    }
                }
                return connection;
            }
            request.myUrl = url;
        }
        throw new IOException(IdeBundle.message("error.connection.failed.redirects", new Object[0]));
    }

    private static void throwHttpStatusError(HttpURLConnection connection, RequestImpl request, RequestBuilderImpl builder, int responseCode) throws IOException {
        String message = null;
        if (builder.myIsReadResponseOnError) {
            message = HttpUrlConnectionUtil.readString(connection.getErrorStream(), connection);
        }
        if (StringUtil.isEmpty(message)) {
            message = "Request failed with status code " + responseCode;
        }
        connection.disconnect();
        throw new HttpStatusException(message, responseCode, StringUtil.notNullize((String)request.myUrl, (String)"Empty URL"));
    }

    private static void configureSslConnection(@NotNull String url, @NotNull HttpsURLConnection connection) {
        if (url == null) {
            HttpRequests.$$$reportNull$$$0(22);
        }
        if (connection == null) {
            HttpRequests.$$$reportNull$$$0(23);
        }
        if (ApplicationManager.getApplication() == null) {
            LOG.info("Application is not initialized yet; Using default SSL configuration to connect to " + url);
            return;
        }
        try {
            SSLSocketFactory factory = CertificateManager.getInstance().getSslContext().getSocketFactory();
            if (factory == null) {
                LOG.info("SSLSocketFactory is not defined by IDE CertificateManager; Using default SSL configuration to connect to " + url);
            } else {
                connection.setSSLSocketFactory(factory);
            }
        }
        catch (Throwable e) {
            LOG.info("Problems configuring SSL connection to " + url, e);
        }
    }

    private static void checkRequestHeadersForNulBytes(URLConnection connection) {
        block0: for (Map.Entry<String, List<String>> header : connection.getRequestProperties().entrySet()) {
            for (String headerValue : header.getValue()) {
                if (headerValue.indexOf(0) < 0) continue;
                connection.setRequestProperty(header.getKey(), null);
                LOG.error(String.format("Problem during request to '%s'. Header's '%s' value contains NUL bytes: '%s'. Omitting this header.", connection.getURL().toString(), header.getKey(), headerValue));
                continue block0;
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 18: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 18: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/io/HttpRequests";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestMethod";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/io/HttpRequests";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "request";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "head";
                break;
            }
            case 7: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "delete";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "post";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "put";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "patch";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "requestWithBody";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "createErrorMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "request";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 18: 
            case 21: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "head";
                break;
            }
            case 6: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "delete";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "post";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "put";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "patch";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "requestWithBody";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createErrorMessage";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "configureSslConnection";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 18: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class RequestImpl
    implements Request,
    AutoCloseable {
        private final RequestBuilderImpl myBuilder;
        private String myUrl;
        private URLConnection myConnection;
        private InputStream myInputStream;
        private BufferedReader myReader;

        private RequestImpl(RequestBuilderImpl builder) {
            this.myBuilder = builder;
            this.myUrl = this.myBuilder.myUrl;
        }

        @Override
        @NotNull
        public String getURL() {
            String string = this.myUrl;
            if (string == null) {
                RequestImpl.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @NotNull
        public URLConnection getConnection() throws IOException {
            if (this.myConnection == null) {
                this.myConnection = HttpRequests.openConnection(this.myBuilder, this);
            }
            URLConnection uRLConnection = this.myConnection;
            if (uRLConnection == null) {
                RequestImpl.$$$reportNull$$$0(1);
            }
            return uRLConnection;
        }

        @Override
        @NotNull
        public InputStream getInputStream() throws IOException {
            if (this.myInputStream == null) {
                this.myInputStream = this.getConnection().getInputStream();
                if (this.myBuilder.myGzip && "gzip".equalsIgnoreCase(this.getConnection().getContentEncoding())) {
                    this.myInputStream = CountingGZIPInputStream.create((InputStream)this.myInputStream);
                }
            }
            InputStream inputStream = this.myInputStream;
            if (inputStream == null) {
                RequestImpl.$$$reportNull$$$0(2);
            }
            return inputStream;
        }

        @Override
        @NotNull
        public BufferedReader getReader() throws IOException {
            BufferedReader bufferedReader = this.getReader(null);
            if (bufferedReader == null) {
                RequestImpl.$$$reportNull$$$0(3);
            }
            return bufferedReader;
        }

        @Override
        @NotNull
        public BufferedReader getReader(@Nullable ProgressIndicator indicator) throws IOException {
            if (this.myReader == null) {
                int contentLength;
                InputStream inputStream = this.getInputStream();
                if (indicator != null && (contentLength = this.getConnection().getContentLength()) > 0) {
                    inputStream = new ProgressMonitorInputStream(indicator, inputStream, contentLength);
                }
                this.myReader = new BufferedReader(new InputStreamReader(inputStream, this.getCharset()));
            }
            BufferedReader bufferedReader = this.myReader;
            if (bufferedReader == null) {
                RequestImpl.$$$reportNull$$$0(4);
            }
            return bufferedReader;
        }

        @NotNull
        private Charset getCharset() throws IOException {
            Charset charset = HttpUrlConnectionUtil.getCharset(this.getConnection());
            if (charset == null) {
                RequestImpl.$$$reportNull$$$0(5);
            }
            return charset;
        }

        @Override
        public boolean isSuccessful() throws IOException {
            URLConnection connection = this.getConnection();
            return !(connection instanceof HttpURLConnection) || ((HttpURLConnection)connection).getResponseCode() == 200;
        }

        @Override
        @NotNull
        public byte[] readBytes(@Nullable ProgressIndicator indicator) throws IOException {
            byte[] byArray = this.doReadBytes(indicator).toByteArray();
            if (byArray == null) {
                RequestImpl.$$$reportNull$$$0(6);
            }
            return byArray;
        }

        @NotNull
        private BufferExposingByteArrayOutputStream doReadBytes(@Nullable ProgressIndicator indicator) throws IOException {
            BufferExposingByteArrayOutputStream bufferExposingByteArrayOutputStream = HttpUrlConnectionUtil.readBytes(this.getInputStream(), this.getConnection(), indicator);
            if (bufferExposingByteArrayOutputStream == null) {
                RequestImpl.$$$reportNull$$$0(7);
            }
            return bufferExposingByteArrayOutputStream;
        }

        @Override
        @NotNull
        public String readString(@Nullable ProgressIndicator indicator) throws IOException {
            String string = HttpUrlConnectionUtil.readString(this.getInputStream(), this.getConnection(), indicator);
            if (string == null) {
                RequestImpl.$$$reportNull$$$0(8);
            }
            return string;
        }

        @Override
        @NotNull
        public CharSequence readChars(@Nullable ProgressIndicator indicator) throws IOException {
            BufferExposingByteArrayOutputStream byteStream = this.doReadBytes(indicator);
            if (byteStream.size() == 0) {
                CharSequence charSequence = ArrayUtil.EMPTY_CHAR_SEQUENCE;
                if (charSequence == null) {
                    RequestImpl.$$$reportNull$$$0(9);
                }
                return charSequence;
            }
            CharBuffer charBuffer = this.getCharset().decode(ByteBuffer.wrap(byteStream.getInternalBuffer(), 0, byteStream.size()));
            if (charBuffer == null) {
                RequestImpl.$$$reportNull$$$0(10);
            }
            return charBuffer;
        }

        @Override
        @NotNull
        public File saveToFile(@NotNull File file, @Nullable ProgressIndicator indicator) throws IOException {
            if (file == null) {
                RequestImpl.$$$reportNull$$$0(11);
            }
            FileUtilRt.createParentDirs((File)file);
            boolean deleteFile = true;
            try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));){
                NetUtils.copyStreamContent((ProgressIndicator)indicator, (InputStream)this.getInputStream(), (OutputStream)out, (int)this.getConnection().getContentLength());
                deleteFile = false;
            }
            catch (HttpStatusException e) {
                throw e;
            }
            catch (IOException e) {
                throw new IOException(HttpRequests.createErrorMessage(e, this, false), e);
            }
            finally {
                if (deleteFile) {
                    FileUtilRt.delete((File)file);
                }
            }
            File file2 = file;
            if (file2 == null) {
                RequestImpl.$$$reportNull$$$0(12);
            }
            return file2;
        }

        @Override
        public void close() {
            StreamUtil.closeStream((Closeable)this.myInputStream);
            StreamUtil.closeStream((Closeable)this.myReader);
            if (this.myConnection instanceof HttpURLConnection) {
                ((HttpURLConnection)this.myConnection).disconnect();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 11: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 11: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/io/HttpRequests$RequestImpl";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getURL";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getConnection";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInputStream";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReader";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCharset";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "readBytes";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doReadBytes";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "readString";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "readChars";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/io/HttpRequests$RequestImpl";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "saveToFile";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "saveToFile";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 11: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class RequestBuilderImpl
    extends RequestBuilder {
        private final String myUrl;
        private int myConnectTimeout;
        private int myTimeout;
        private int myRedirectLimit;
        private boolean myGzip;
        private boolean myForceHttps;
        private boolean myUseProxy;
        private boolean myIsReadResponseOnError;
        private HostnameVerifier myHostnameVerifier;
        private String myUserAgent;
        private String myAccept;
        private ConnectionTuner myTuner;
        private final ConnectionTuner myInternalTuner;
        private UntrustedCertificateStrategy myUntrustedCertificateStrategy;
        public boolean myThrowStatusCodeException;

        private RequestBuilderImpl(@NotNull String url, @Nullable ConnectionTuner internalTuner) {
            if (url == null) {
                RequestBuilderImpl.$$$reportNull$$$0(0);
            }
            this.myConnectTimeout = CONNECTION_TIMEOUT;
            this.myTimeout = READ_TIMEOUT;
            this.myRedirectLimit = REDIRECT_LIMIT;
            this.myGzip = true;
            this.myUseProxy = true;
            this.myUntrustedCertificateStrategy = null;
            this.myThrowStatusCodeException = true;
            this.myUrl = url;
            this.myInternalTuner = internalTuner;
        }

        @Override
        public RequestBuilder connectTimeout(int value) {
            this.myConnectTimeout = value;
            return this;
        }

        @Override
        public RequestBuilder readTimeout(int value) {
            this.myTimeout = value;
            return this;
        }

        @Override
        public RequestBuilder redirectLimit(int redirectLimit) {
            this.myRedirectLimit = redirectLimit;
            return this;
        }

        @Override
        public RequestBuilder gzip(boolean value) {
            this.myGzip = value;
            return this;
        }

        @Override
        public RequestBuilder forceHttps(boolean forceHttps) {
            this.myForceHttps = forceHttps;
            return this;
        }

        @Override
        public RequestBuilder useProxy(boolean useProxy) {
            this.myUseProxy = useProxy;
            return this;
        }

        @Override
        public RequestBuilder isReadResponseOnError(boolean isReadResponseOnError) {
            this.myIsReadResponseOnError = isReadResponseOnError;
            return this;
        }

        @Override
        public RequestBuilder hostNameVerifier(@Nullable HostnameVerifier hostnameVerifier) {
            this.myHostnameVerifier = hostnameVerifier;
            return this;
        }

        @Override
        public RequestBuilder userAgent(@Nullable String userAgent) {
            this.myUserAgent = userAgent;
            return this;
        }

        @Override
        public RequestBuilder productNameAsUserAgent() {
            Application app = ApplicationManager.getApplication();
            if (app != null && !app.isDisposed()) {
                String productName = ApplicationNamesInfo.getInstance().getFullProductName();
                String version = ApplicationInfo.getInstance().getBuild().asStringWithoutProductCode();
                return this.userAgent(productName + '/' + version);
            }
            return this.userAgent("IntelliJ");
        }

        @Override
        public RequestBuilder accept(@Nullable String mimeType) {
            this.myAccept = mimeType;
            return this;
        }

        @Override
        public RequestBuilder tuner(@Nullable ConnectionTuner tuner) {
            this.myTuner = tuner;
            return this;
        }

        @Override
        @NotNull
        public RequestBuilder untrustedCertificateStrategy(@NotNull UntrustedCertificateStrategy strategy) {
            if (strategy == null) {
                RequestBuilderImpl.$$$reportNull$$$0(1);
            }
            this.myUntrustedCertificateStrategy = strategy;
            RequestBuilderImpl requestBuilderImpl = this;
            if (requestBuilderImpl == null) {
                RequestBuilderImpl.$$$reportNull$$$0(2);
            }
            return requestBuilderImpl;
        }

        @Override
        @NotNull
        public RequestBuilder throwStatusCodeException(boolean shouldThrow) {
            this.myThrowStatusCodeException = shouldThrow;
            RequestBuilderImpl requestBuilderImpl = this;
            if (requestBuilderImpl == null) {
                RequestBuilderImpl.$$$reportNull$$$0(3);
            }
            return requestBuilderImpl;
        }

        @Override
        public <T> T connect(@NotNull RequestProcessor<T> processor) throws IOException {
            if (processor == null) {
                RequestBuilderImpl.$$$reportNull$$$0(4);
            }
            return (T)HttpRequests.process(this, processor);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "url";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "strategy";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/io/HttpRequests$RequestBuilderImpl";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/io/HttpRequests$RequestBuilderImpl";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "untrustedCertificateStrategy";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "throwStatusCodeException";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "untrustedCertificateStrategy";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "connect";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class HttpStatusException
    extends IOException {
        private final int myStatusCode;
        private final String myUrl;

        public HttpStatusException(@NotNull String message, int statusCode, @NotNull String url) {
            if (message == null) {
                HttpStatusException.$$$reportNull$$$0(0);
            }
            if (url == null) {
                HttpStatusException.$$$reportNull$$$0(1);
            }
            super(message);
            this.myStatusCode = statusCode;
            this.myUrl = url;
        }

        public int getStatusCode() {
            return this.myStatusCode;
        }

        @NotNull
        public String getUrl() {
            String string = this.myUrl;
            if (string == null) {
                HttpStatusException.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        public String toString() {
            return super.toString() + ". Status=" + this.myStatusCode + ", Url=" + this.myUrl;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "url";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/io/HttpRequests$HttpStatusException";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/io/HttpRequests$HttpStatusException";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUrl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static interface ConnectionTuner {
        public void tune(@NotNull URLConnection var1) throws IOException;
    }

    public static interface RequestProcessor<T> {
        public T process(@NotNull Request var1) throws IOException;
    }

    public static interface Request {
        @NotNull
        public String getURL();

        @NotNull
        public URLConnection getConnection() throws IOException;

        @NotNull
        public InputStream getInputStream() throws IOException;

        @NotNull
        public BufferedReader getReader() throws IOException;

        @NotNull
        public BufferedReader getReader(@Nullable ProgressIndicator var1) throws IOException;

        @Deprecated
        public boolean isSuccessful() throws IOException;

        @NotNull
        public File saveToFile(@NotNull File var1, @Nullable ProgressIndicator var2) throws IOException;

        @NotNull
        public byte[] readBytes(@Nullable ProgressIndicator var1) throws IOException;

        @NotNull
        public String readString(@Nullable ProgressIndicator var1) throws IOException;

        @NotNull
        default public String readString() throws IOException {
            String string = this.readString(null);
            if (string == null) {
                Request.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public CharSequence readChars(@Nullable ProgressIndicator var1) throws IOException;

        default public void write(@NotNull String data) throws IOException {
            if (data == null) {
                Request.$$$reportNull$$$0(1);
            }
            this.write(data.getBytes(StandardCharsets.UTF_8));
        }

        default public void write(@NotNull byte[] data) throws IOException {
            if (data == null) {
                Request.$$$reportNull$$$0(2);
            }
            HttpURLConnection connection = (HttpURLConnection)this.getConnection();
            connection.setFixedLengthStreamingMode(data.length);
            try (OutputStream stream = connection.getOutputStream();){
                stream.write(data);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/io/HttpRequests$Request";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "readString";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/io/HttpRequests$Request";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "write";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

